/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.main;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.Portfolio;
import fpml.consolidated.doc.Trade;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.main.DataDocument;
import fpml.consolidated.main.meta.ValuationDocumentMeta;
import fpml.consolidated.riskdef.Market;
import fpml.consolidated.shared.OnBehalfOf;
import fpml.consolidated.shared.OriginatingEvent;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import fpml.consolidated.valuation.ValuationSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ValuationDocument", builder=ValuationDocumentBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ValuationDocument", model="fpml", builder=ValuationDocumentBuilderImpl.class, version="1.1.0")
public interface ValuationDocument
extends DataDocument {
    public static final ValuationDocumentMeta metaData = new ValuationDocumentMeta();

    public List<? extends Market> getMarket();

    public List<? extends ValuationSet> getValuationSet();

    @Override
    public ValuationDocument build();

    @Override
    public ValuationDocumentBuilder toBuilder();

    public static ValuationDocumentBuilder builder() {
        return new ValuationDocumentBuilderImpl();
    }

    default public RosettaMetaData<? extends ValuationDocument> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ValuationDocument> getType() {
        return ValuationDocument.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOf"), processor, OnBehalfOf.class, this.getOnBehalfOf(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("originatingEvent"), processor, OriginatingEvent.class, this.getOriginatingEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trade"), processor, Trade.class, this.getTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolio"), processor, Portfolio.class, this.getPortfolio(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("market"), processor, Market.class, this.getMarket(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationSet"), processor, ValuationSet.class, this.getValuationSet(), new AttributeMeta[0]);
    }

    public static class ValuationDocumentBuilderImpl
    extends DataDocument.DataDocumentBuilderImpl
    implements ValuationDocumentBuilder {
        protected List<Market.MarketBuilder> market = new ArrayList<Market.MarketBuilder>();
        protected List<ValuationSet.ValuationSetBuilder> valuationSet = new ArrayList<ValuationSet.ValuationSetBuilder>();

        @Override
        @RosettaAttribute(value="market")
        @RuneAttribute(value="market")
        public List<? extends Market.MarketBuilder> getMarket() {
            return this.market;
        }

        @Override
        public Market.MarketBuilder getOrCreateMarket(int index) {
            if (this.market == null) {
                this.market = new ArrayList<Market.MarketBuilder>();
            }
            return (Market.MarketBuilder)this.getIndex(this.market, index, () -> {
                Market.MarketBuilder newMarket = Market.builder();
                return newMarket;
            });
        }

        @Override
        @RosettaAttribute(value="valuationSet")
        @RuneAttribute(value="valuationSet")
        public List<? extends ValuationSet.ValuationSetBuilder> getValuationSet() {
            return this.valuationSet;
        }

        @Override
        public ValuationSet.ValuationSetBuilder getOrCreateValuationSet(int index) {
            if (this.valuationSet == null) {
                this.valuationSet = new ArrayList<ValuationSet.ValuationSetBuilder>();
            }
            return (ValuationSet.ValuationSetBuilder)this.getIndex(this.valuationSet, index, () -> {
                ValuationSet.ValuationSetBuilder newValuationSet = ValuationSet.builder();
                return newValuationSet;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ValuationDocumentBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ValuationDocumentBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ValuationDocumentBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ValuationDocumentBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOf")
        @RuneAttribute(value="onBehalfOf")
        public ValuationDocumentBuilder setOnBehalfOf(OnBehalfOf _onBehalfOf) {
            this.onBehalfOf = _onBehalfOf == null ? null : _onBehalfOf.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="originatingEvent")
        @RuneAttribute(value="originatingEvent")
        public ValuationDocumentBuilder setOriginatingEvent(OriginatingEvent _originatingEvent) {
            this.originatingEvent = _originatingEvent == null ? null : _originatingEvent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public ValuationDocumentBuilder addTrade(Trade _trade) {
            if (_trade != null) {
                this.trade.add(_trade.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationDocumentBuilder addTrade(Trade _trade, int idx) {
            this.getIndex(this.trade, idx, () -> _trade.toBuilder());
            return this;
        }

        @Override
        public ValuationDocumentBuilder addTrade(List<? extends Trade> trades) {
            if (trades != null) {
                for (Trade trade : trades) {
                    this.trade.add(trade.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="trade")
        public ValuationDocumentBuilder setTrade(List<? extends Trade> trades) {
            this.trade = trades == null ? new ArrayList() : (List)trades.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public ValuationDocumentBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolio")
        @RuneAttribute(value="portfolio")
        public ValuationDocumentBuilder addPortfolio(Portfolio _portfolio) {
            if (_portfolio != null) {
                this.portfolio.add(_portfolio.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationDocumentBuilder addPortfolio(Portfolio _portfolio, int idx) {
            this.getIndex(this.portfolio, idx, () -> _portfolio.toBuilder());
            return this;
        }

        @Override
        public ValuationDocumentBuilder addPortfolio(List<? extends Portfolio> portfolios) {
            if (portfolios != null) {
                for (Portfolio portfolio : portfolios) {
                    this.portfolio.add(portfolio.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="portfolio")
        public ValuationDocumentBuilder setPortfolio(List<? extends Portfolio> portfolios) {
            this.portfolio = portfolios == null ? new ArrayList() : (List)portfolios.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="market")
        @RuneAttribute(value="market")
        public ValuationDocumentBuilder addMarket(Market _market) {
            if (_market != null) {
                this.market.add(_market.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationDocumentBuilder addMarket(Market _market, int idx) {
            this.getIndex(this.market, idx, () -> _market.toBuilder());
            return this;
        }

        @Override
        public ValuationDocumentBuilder addMarket(List<? extends Market> markets) {
            if (markets != null) {
                for (Market market : markets) {
                    this.market.add(market.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="market")
        public ValuationDocumentBuilder setMarket(List<? extends Market> markets) {
            this.market = markets == null ? new ArrayList<Market.MarketBuilder>() : (List)markets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationSet")
        @RuneAttribute(value="valuationSet")
        public ValuationDocumentBuilder addValuationSet(ValuationSet _valuationSet) {
            if (_valuationSet != null) {
                this.valuationSet.add(_valuationSet.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationDocumentBuilder addValuationSet(ValuationSet _valuationSet, int idx) {
            this.getIndex(this.valuationSet, idx, () -> _valuationSet.toBuilder());
            return this;
        }

        @Override
        public ValuationDocumentBuilder addValuationSet(List<? extends ValuationSet> valuationSets) {
            if (valuationSets != null) {
                for (ValuationSet valuationSet : valuationSets) {
                    this.valuationSet.add(valuationSet.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="valuationSet")
        public ValuationDocumentBuilder setValuationSet(List<? extends ValuationSet> valuationSets) {
            this.valuationSet = valuationSets == null ? new ArrayList<ValuationSet.ValuationSetBuilder>() : (List)valuationSets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ValuationDocument build() {
            return new ValuationDocumentImpl(this);
        }

        @Override
        public ValuationDocumentBuilder toBuilder() {
            return this;
        }

        @Override
        public ValuationDocumentBuilder prune() {
            super.prune();
            this.market = this.market.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.valuationSet = this.valuationSet.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getMarket() != null && this.getMarket().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getValuationSet() != null && this.getValuationSet().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public ValuationDocumentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ValuationDocumentBuilder o = (ValuationDocumentBuilder)other;
            merger.mergeRosetta(this.getMarket(), o.getMarket(), this::getOrCreateMarket);
            merger.mergeRosetta(this.getValuationSet(), o.getValuationSet(), this::getOrCreateValuationSet);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValuationDocument _that = (ValuationDocument)this.getType().cast(o);
            if (!ListEquals.listEquals(this.market, _that.getMarket())) {
                return false;
            }
            return ListEquals.listEquals(this.valuationSet, _that.getValuationSet());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.market != null ? this.market.hashCode() : 0);
            _result = 31 * _result + (this.valuationSet != null ? this.valuationSet.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ValuationDocumentBuilder {market=" + this.market + ", valuationSet=" + this.valuationSet + '}' + " " + super.toString();
        }
    }

    public static interface ValuationDocumentBuilder
    extends ValuationDocument,
    DataDocument.DataDocumentBuilder {
        public Market.MarketBuilder getOrCreateMarket(int var1);

        public List<? extends Market.MarketBuilder> getMarket();

        public ValuationSet.ValuationSetBuilder getOrCreateValuationSet(int var1);

        public List<? extends ValuationSet.ValuationSetBuilder> getValuationSet();

        @Override
        public ValuationDocumentBuilder setFpmlVersion(String var1);

        @Override
        public ValuationDocumentBuilder setExpectedBuild(Integer var1);

        @Override
        public ValuationDocumentBuilder setActualBuild(Integer var1);

        @Override
        public ValuationDocumentBuilder setValidationModel(ValidationModel var1);

        @Override
        public ValuationDocumentBuilder setOnBehalfOf(OnBehalfOf var1);

        @Override
        public ValuationDocumentBuilder setOriginatingEvent(OriginatingEvent var1);

        @Override
        public ValuationDocumentBuilder addTrade(Trade var1);

        @Override
        public ValuationDocumentBuilder addTrade(Trade var1, int var2);

        @Override
        public ValuationDocumentBuilder addTrade(List<? extends Trade> var1);

        @Override
        public ValuationDocumentBuilder setTrade(List<? extends Trade> var1);

        @Override
        public ValuationDocumentBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        public ValuationDocumentBuilder addPortfolio(Portfolio var1);

        @Override
        public ValuationDocumentBuilder addPortfolio(Portfolio var1, int var2);

        @Override
        public ValuationDocumentBuilder addPortfolio(List<? extends Portfolio> var1);

        @Override
        public ValuationDocumentBuilder setPortfolio(List<? extends Portfolio> var1);

        public ValuationDocumentBuilder addMarket(Market var1);

        public ValuationDocumentBuilder addMarket(Market var1, int var2);

        public ValuationDocumentBuilder addMarket(List<? extends Market> var1);

        public ValuationDocumentBuilder setMarket(List<? extends Market> var1);

        public ValuationDocumentBuilder addValuationSet(ValuationSet var1);

        public ValuationDocumentBuilder addValuationSet(ValuationSet var1, int var2);

        public ValuationDocumentBuilder addValuationSet(List<? extends ValuationSet> var1);

        public ValuationDocumentBuilder setValuationSet(List<? extends ValuationSet> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOf"), processor, OnBehalfOf.OnBehalfOfBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOf(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("originatingEvent"), processor, OriginatingEvent.OriginatingEventBuilder.class, (RosettaModelObjectBuilder)this.getOriginatingEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trade"), processor, Trade.TradeBuilder.class, this.getTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, (RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolio"), processor, Portfolio.PortfolioBuilder.class, this.getPortfolio(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("market"), processor, Market.MarketBuilder.class, this.getMarket(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationSet"), processor, ValuationSet.ValuationSetBuilder.class, this.getValuationSet(), new AttributeMeta[0]);
        }

        @Override
        public ValuationDocumentBuilder prune();
    }

    public static class ValuationDocumentImpl
    extends DataDocument.DataDocumentImpl
    implements ValuationDocument {
        private final List<? extends Market> market;
        private final List<? extends ValuationSet> valuationSet;

        protected ValuationDocumentImpl(ValuationDocumentBuilder builder) {
            super(builder);
            this.market = Optional.ofNullable(builder.getMarket()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.valuationSet = Optional.ofNullable(builder.getValuationSet()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="market")
        @RuneAttribute(value="market")
        public List<? extends Market> getMarket() {
            return this.market;
        }

        @Override
        @RosettaAttribute(value="valuationSet")
        @RuneAttribute(value="valuationSet")
        public List<? extends ValuationSet> getValuationSet() {
            return this.valuationSet;
        }

        @Override
        public ValuationDocument build() {
            return this;
        }

        @Override
        public ValuationDocumentBuilder toBuilder() {
            ValuationDocumentBuilder builder = ValuationDocument.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ValuationDocumentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getMarket()).ifPresent(builder::setMarket);
            Optional.ofNullable(this.getValuationSet()).ifPresent(builder::setValuationSet);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValuationDocument _that = (ValuationDocument)this.getType().cast(o);
            if (!ListEquals.listEquals(this.market, _that.getMarket())) {
                return false;
            }
            return ListEquals.listEquals(this.valuationSet, _that.getValuationSet());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.market != null ? this.market.hashCode() : 0);
            _result = 31 * _result + (this.valuationSet != null ? this.valuationSet.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ValuationDocument {market=" + this.market + ", valuationSet=" + this.valuationSet + '}' + " " + super.toString();
        }
    }
}

