/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.TradeIdentifierSequence;
import fpml.consolidated.fpmlenum.BuySellEnum;
import fpml.consolidated.fpmlenum.LoanTradingTypeEnum;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LoanTradeSequence;
import fpml.consolidated.loan.LoanTradeSummary;
import fpml.consolidated.loan.LoanTradingSettlementTermsModel;
import fpml.consolidated.loan.meta.LoanTradeTypeMeta;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.IssuerTradeIdModel;
import fpml.consolidated.shared.NonNegativeMoney;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanTradeType", builder=LoanTradeTypeBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanTradeType", model="fpml", builder=LoanTradeTypeBuilderImpl.class, version="1.1.0")
public interface LoanTradeType
extends LoanTradeSummary {
    public static final LoanTradeTypeMeta metaData = new LoanTradeTypeMeta();

    public ZonedDateTime getTradeDate();

    public BuyerSellerModel getBuyerSellerModel();

    public LoanTradingTypeEnum getMarketType();

    public Boolean getWhenIssuedFlag();

    public LoanTradingSettlementTermsModel getLoanTradingSettlementTermsModel();

    public BuySellEnum getRemittedBy();

    public LoanTradeSequence getLoanTradeSequence();

    @Override
    public LoanTradeType build();

    @Override
    public LoanTradeTypeBuilder toBuilder();

    public static LoanTradeTypeBuilder builder() {
        return new LoanTradeTypeBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradeType> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradeType> getType() {
        return LoanTradeType.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("issuerTradeIdModel"), processor, IssuerTradeIdModel.class, this.getIssuerTradeIdModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifierSequence"), processor, TradeIdentifierSequence.class, this.getTradeIdentifierSequence(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeDate"), ZonedDateTime.class, (Object)this.getTradeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("marketType"), LoanTradingTypeEnum.class, (Object)this.getMarketType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("whenIssuedFlag"), Boolean.class, (Object)this.getWhenIssuedFlag(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanTradingSettlementTermsModel"), processor, LoanTradingSettlementTermsModel.class, this.getLoanTradingSettlementTermsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remittedBy"), BuySellEnum.class, (Object)this.getRemittedBy(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanTradeSequence"), processor, LoanTradeSequence.class, this.getLoanTradeSequence(), new AttributeMeta[0]);
    }

    public static class LoanTradeTypeBuilderImpl
    extends LoanTradeSummary.LoanTradeSummaryBuilderImpl
    implements LoanTradeTypeBuilder {
        protected ZonedDateTime tradeDate;
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;
        protected LoanTradingTypeEnum marketType;
        protected Boolean whenIssuedFlag;
        protected LoanTradingSettlementTermsModel.LoanTradingSettlementTermsModelBuilder loanTradingSettlementTermsModel;
        protected BuySellEnum remittedBy;
        protected LoanTradeSequence.LoanTradeSequenceBuilder loanTradeSequence;

        @Override
        @RosettaAttribute(value="tradeDate", isRequired=true)
        @RuneAttribute(value="tradeDate", isRequired=true)
        public ZonedDateTime getTradeDate() {
            return this.tradeDate;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="marketType", isRequired=true)
        @RuneAttribute(value="marketType", isRequired=true)
        public LoanTradingTypeEnum getMarketType() {
            return this.marketType;
        }

        @Override
        @RosettaAttribute(value="whenIssuedFlag", isRequired=true)
        @RuneAttribute(value="whenIssuedFlag", isRequired=true)
        public Boolean getWhenIssuedFlag() {
            return this.whenIssuedFlag;
        }

        @Override
        @RosettaAttribute(value="loanTradingSettlementTermsModel", isRequired=true)
        @RuneAttribute(value="loanTradingSettlementTermsModel", isRequired=true)
        public LoanTradingSettlementTermsModel.LoanTradingSettlementTermsModelBuilder getLoanTradingSettlementTermsModel() {
            return this.loanTradingSettlementTermsModel;
        }

        @Override
        public LoanTradingSettlementTermsModel.LoanTradingSettlementTermsModelBuilder getOrCreateLoanTradingSettlementTermsModel() {
            LoanTradingSettlementTermsModel.LoanTradingSettlementTermsModelBuilder result = this.loanTradingSettlementTermsModel != null ? this.loanTradingSettlementTermsModel : (this.loanTradingSettlementTermsModel = LoanTradingSettlementTermsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="remittedBy", isRequired=true)
        @RuneAttribute(value="remittedBy", isRequired=true)
        public BuySellEnum getRemittedBy() {
            return this.remittedBy;
        }

        @Override
        @RosettaAttribute(value="loanTradeSequence")
        @RuneAttribute(value="loanTradeSequence")
        public LoanTradeSequence.LoanTradeSequenceBuilder getLoanTradeSequence() {
            return this.loanTradeSequence;
        }

        @Override
        public LoanTradeSequence.LoanTradeSequenceBuilder getOrCreateLoanTradeSequence() {
            LoanTradeSequence.LoanTradeSequenceBuilder result = this.loanTradeSequence != null ? this.loanTradeSequence : (this.loanTradeSequence = LoanTradeSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="issuerTradeIdModel")
        @RuneAttribute(value="issuerTradeIdModel")
        public LoanTradeTypeBuilder setIssuerTradeIdModel(IssuerTradeIdModel _issuerTradeIdModel) {
            this.issuerTradeIdModel = _issuerTradeIdModel == null ? null : _issuerTradeIdModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifierSequence")
        @RuneAttribute(value="tradeIdentifierSequence")
        public LoanTradeTypeBuilder setTradeIdentifierSequence(TradeIdentifierSequence _tradeIdentifierSequence) {
            this.tradeIdentifierSequence = _tradeIdentifierSequence == null ? null : _tradeIdentifierSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanTradeTypeBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public LoanTradeTypeBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LoanTradeTypeBuilder setAmount(NonNegativeMoney _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LoanTradeTypeBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeDate", isRequired=true)
        @RuneAttribute(value="tradeDate", isRequired=true)
        public LoanTradeTypeBuilder setTradeDate(ZonedDateTime _tradeDate) {
            this.tradeDate = _tradeDate == null ? null : _tradeDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public LoanTradeTypeBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="marketType", isRequired=true)
        @RuneAttribute(value="marketType", isRequired=true)
        public LoanTradeTypeBuilder setMarketType(LoanTradingTypeEnum _marketType) {
            this.marketType = _marketType == null ? null : _marketType;
            return this;
        }

        @Override
        @RosettaAttribute(value="whenIssuedFlag", isRequired=true)
        @RuneAttribute(value="whenIssuedFlag", isRequired=true)
        public LoanTradeTypeBuilder setWhenIssuedFlag(Boolean _whenIssuedFlag) {
            this.whenIssuedFlag = _whenIssuedFlag == null ? null : _whenIssuedFlag;
            return this;
        }

        @Override
        @RosettaAttribute(value="loanTradingSettlementTermsModel", isRequired=true)
        @RuneAttribute(value="loanTradingSettlementTermsModel", isRequired=true)
        public LoanTradeTypeBuilder setLoanTradingSettlementTermsModel(LoanTradingSettlementTermsModel _loanTradingSettlementTermsModel) {
            this.loanTradingSettlementTermsModel = _loanTradingSettlementTermsModel == null ? null : _loanTradingSettlementTermsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="remittedBy", isRequired=true)
        @RuneAttribute(value="remittedBy", isRequired=true)
        public LoanTradeTypeBuilder setRemittedBy(BuySellEnum _remittedBy) {
            this.remittedBy = _remittedBy == null ? null : _remittedBy;
            return this;
        }

        @Override
        @RosettaAttribute(value="loanTradeSequence")
        @RuneAttribute(value="loanTradeSequence")
        public LoanTradeTypeBuilder setLoanTradeSequence(LoanTradeSequence _loanTradeSequence) {
            this.loanTradeSequence = _loanTradeSequence == null ? null : _loanTradeSequence.toBuilder();
            return this;
        }

        @Override
        public LoanTradeType build() {
            return new LoanTradeTypeImpl(this);
        }

        @Override
        public LoanTradeTypeBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradeTypeBuilder prune() {
            super.prune();
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            if (this.loanTradingSettlementTermsModel != null && !this.loanTradingSettlementTermsModel.prune().hasData()) {
                this.loanTradingSettlementTermsModel = null;
            }
            if (this.loanTradeSequence != null && !this.loanTradeSequence.prune().hasData()) {
                this.loanTradeSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradeDate() != null) {
                return true;
            }
            if (this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData()) {
                return true;
            }
            if (this.getMarketType() != null) {
                return true;
            }
            if (this.getWhenIssuedFlag() != null) {
                return true;
            }
            if (this.getLoanTradingSettlementTermsModel() != null && this.getLoanTradingSettlementTermsModel().hasData()) {
                return true;
            }
            if (this.getRemittedBy() != null) {
                return true;
            }
            return this.getLoanTradeSequence() != null && this.getLoanTradeSequence().hasData();
        }

        @Override
        public LoanTradeTypeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanTradeTypeBuilder o = (LoanTradeTypeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanTradingSettlementTermsModel(), (RosettaModelObjectBuilder)o.getLoanTradingSettlementTermsModel(), this::setLoanTradingSettlementTermsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanTradeSequence(), (RosettaModelObjectBuilder)o.getLoanTradeSequence(), this::setLoanTradeSequence);
            merger.mergeBasic((Object)this.getTradeDate(), (Object)o.getTradeDate(), this::setTradeDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMarketType(), (Object)o.getMarketType(), this::setMarketType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getWhenIssuedFlag(), (Object)o.getWhenIssuedFlag(), this::setWhenIssuedFlag, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemittedBy(), (Object)o.getRemittedBy(), this::setRemittedBy, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanTradeType _that = (LoanTradeType)this.getType().cast(o);
            if (!Objects.equals(this.tradeDate, _that.getTradeDate())) {
                return false;
            }
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.marketType, (Object)_that.getMarketType())) {
                return false;
            }
            if (!Objects.equals(this.whenIssuedFlag, _that.getWhenIssuedFlag())) {
                return false;
            }
            if (!Objects.equals(this.loanTradingSettlementTermsModel, _that.getLoanTradingSettlementTermsModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.remittedBy, (Object)_that.getRemittedBy())) {
                return false;
            }
            return Objects.equals(this.loanTradeSequence, _that.getLoanTradeSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeDate != null ? this.tradeDate.hashCode() : 0);
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.marketType != null ? ((Object)((Object)this.marketType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.whenIssuedFlag != null ? this.whenIssuedFlag.hashCode() : 0);
            _result = 31 * _result + (this.loanTradingSettlementTermsModel != null ? this.loanTradingSettlementTermsModel.hashCode() : 0);
            _result = 31 * _result + (this.remittedBy != null ? ((Object)((Object)this.remittedBy)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.loanTradeSequence != null ? this.loanTradeSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradeTypeBuilder {tradeDate=" + this.tradeDate + ", buyerSellerModel=" + this.buyerSellerModel + ", marketType=" + (Object)((Object)this.marketType) + ", whenIssuedFlag=" + this.whenIssuedFlag + ", loanTradingSettlementTermsModel=" + this.loanTradingSettlementTermsModel + ", remittedBy=" + (Object)((Object)this.remittedBy) + ", loanTradeSequence=" + this.loanTradeSequence + '}' + " " + super.toString();
        }
    }

    public static interface LoanTradeTypeBuilder
    extends LoanTradeType,
    LoanTradeSummary.LoanTradeSummaryBuilder {
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        public LoanTradingSettlementTermsModel.LoanTradingSettlementTermsModelBuilder getOrCreateLoanTradingSettlementTermsModel();

        @Override
        public LoanTradingSettlementTermsModel.LoanTradingSettlementTermsModelBuilder getLoanTradingSettlementTermsModel();

        public LoanTradeSequence.LoanTradeSequenceBuilder getOrCreateLoanTradeSequence();

        @Override
        public LoanTradeSequence.LoanTradeSequenceBuilder getLoanTradeSequence();

        @Override
        public LoanTradeTypeBuilder setIssuerTradeIdModel(IssuerTradeIdModel var1);

        @Override
        public LoanTradeTypeBuilder setTradeIdentifierSequence(TradeIdentifierSequence var1);

        @Override
        public LoanTradeTypeBuilder setId(String var1);

        @Override
        public LoanTradeTypeBuilder setFacilityReference(FacilityReference var1);

        @Override
        public LoanTradeTypeBuilder setAmount(NonNegativeMoney var1);

        @Override
        public LoanTradeTypeBuilder setComment(String var1);

        public LoanTradeTypeBuilder setTradeDate(ZonedDateTime var1);

        public LoanTradeTypeBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public LoanTradeTypeBuilder setMarketType(LoanTradingTypeEnum var1);

        public LoanTradeTypeBuilder setWhenIssuedFlag(Boolean var1);

        public LoanTradeTypeBuilder setLoanTradingSettlementTermsModel(LoanTradingSettlementTermsModel var1);

        public LoanTradeTypeBuilder setRemittedBy(BuySellEnum var1);

        public LoanTradeTypeBuilder setLoanTradeSequence(LoanTradeSequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("issuerTradeIdModel"), processor, IssuerTradeIdModel.IssuerTradeIdModelBuilder.class, (RosettaModelObjectBuilder)this.getIssuerTradeIdModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifierSequence"), processor, TradeIdentifierSequence.TradeIdentifierSequenceBuilder.class, (RosettaModelObjectBuilder)this.getTradeIdentifierSequence(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, (RosettaModelObjectBuilder)this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeDate"), ZonedDateTime.class, (Object)this.getTradeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("marketType"), LoanTradingTypeEnum.class, (Object)this.getMarketType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("whenIssuedFlag"), Boolean.class, (Object)this.getWhenIssuedFlag(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanTradingSettlementTermsModel"), processor, LoanTradingSettlementTermsModel.LoanTradingSettlementTermsModelBuilder.class, this.getLoanTradingSettlementTermsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remittedBy"), BuySellEnum.class, (Object)this.getRemittedBy(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanTradeSequence"), processor, LoanTradeSequence.LoanTradeSequenceBuilder.class, this.getLoanTradeSequence(), new AttributeMeta[0]);
        }

        @Override
        public LoanTradeTypeBuilder prune();
    }

    public static class LoanTradeTypeImpl
    extends LoanTradeSummary.LoanTradeSummaryImpl
    implements LoanTradeType {
        private final ZonedDateTime tradeDate;
        private final BuyerSellerModel buyerSellerModel;
        private final LoanTradingTypeEnum marketType;
        private final Boolean whenIssuedFlag;
        private final LoanTradingSettlementTermsModel loanTradingSettlementTermsModel;
        private final BuySellEnum remittedBy;
        private final LoanTradeSequence loanTradeSequence;

        protected LoanTradeTypeImpl(LoanTradeTypeBuilder builder) {
            super(builder);
            this.tradeDate = builder.getTradeDate();
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
            this.marketType = builder.getMarketType();
            this.whenIssuedFlag = builder.getWhenIssuedFlag();
            this.loanTradingSettlementTermsModel = Optional.ofNullable(builder.getLoanTradingSettlementTermsModel()).map(f -> f.build()).orElse(null);
            this.remittedBy = builder.getRemittedBy();
            this.loanTradeSequence = Optional.ofNullable(builder.getLoanTradeSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeDate", isRequired=true)
        @RuneAttribute(value="tradeDate", isRequired=true)
        public ZonedDateTime getTradeDate() {
            return this.tradeDate;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        @RosettaAttribute(value="marketType", isRequired=true)
        @RuneAttribute(value="marketType", isRequired=true)
        public LoanTradingTypeEnum getMarketType() {
            return this.marketType;
        }

        @Override
        @RosettaAttribute(value="whenIssuedFlag", isRequired=true)
        @RuneAttribute(value="whenIssuedFlag", isRequired=true)
        public Boolean getWhenIssuedFlag() {
            return this.whenIssuedFlag;
        }

        @Override
        @RosettaAttribute(value="loanTradingSettlementTermsModel", isRequired=true)
        @RuneAttribute(value="loanTradingSettlementTermsModel", isRequired=true)
        public LoanTradingSettlementTermsModel getLoanTradingSettlementTermsModel() {
            return this.loanTradingSettlementTermsModel;
        }

        @Override
        @RosettaAttribute(value="remittedBy", isRequired=true)
        @RuneAttribute(value="remittedBy", isRequired=true)
        public BuySellEnum getRemittedBy() {
            return this.remittedBy;
        }

        @Override
        @RosettaAttribute(value="loanTradeSequence")
        @RuneAttribute(value="loanTradeSequence")
        public LoanTradeSequence getLoanTradeSequence() {
            return this.loanTradeSequence;
        }

        @Override
        public LoanTradeType build() {
            return this;
        }

        @Override
        public LoanTradeTypeBuilder toBuilder() {
            LoanTradeTypeBuilder builder = LoanTradeType.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradeTypeBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradeDate()).ifPresent(builder::setTradeDate);
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
            Optional.ofNullable(this.getMarketType()).ifPresent(builder::setMarketType);
            Optional.ofNullable(this.getWhenIssuedFlag()).ifPresent(builder::setWhenIssuedFlag);
            Optional.ofNullable(this.getLoanTradingSettlementTermsModel()).ifPresent(builder::setLoanTradingSettlementTermsModel);
            Optional.ofNullable(this.getRemittedBy()).ifPresent(builder::setRemittedBy);
            Optional.ofNullable(this.getLoanTradeSequence()).ifPresent(builder::setLoanTradeSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanTradeType _that = (LoanTradeType)this.getType().cast(o);
            if (!Objects.equals(this.tradeDate, _that.getTradeDate())) {
                return false;
            }
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.marketType, (Object)_that.getMarketType())) {
                return false;
            }
            if (!Objects.equals(this.whenIssuedFlag, _that.getWhenIssuedFlag())) {
                return false;
            }
            if (!Objects.equals(this.loanTradingSettlementTermsModel, _that.getLoanTradingSettlementTermsModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.remittedBy, (Object)_that.getRemittedBy())) {
                return false;
            }
            return Objects.equals(this.loanTradeSequence, _that.getLoanTradeSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeDate != null ? this.tradeDate.hashCode() : 0);
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.marketType != null ? ((Object)((Object)this.marketType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.whenIssuedFlag != null ? this.whenIssuedFlag.hashCode() : 0);
            _result = 31 * _result + (this.loanTradingSettlementTermsModel != null ? this.loanTradingSettlementTermsModel.hashCode() : 0);
            _result = 31 * _result + (this.remittedBy != null ? ((Object)((Object)this.remittedBy)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.loanTradeSequence != null ? this.loanTradeSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradeType {tradeDate=" + this.tradeDate + ", buyerSellerModel=" + this.buyerSellerModel + ", marketType=" + (Object)((Object)this.marketType) + ", whenIssuedFlag=" + this.whenIssuedFlag + ", loanTradingSettlementTermsModel=" + this.loanTradingSettlementTermsModel + ", remittedBy=" + (Object)((Object)this.remittedBy) + ", loanTradeSequence=" + this.loanTradeSequence + '}' + " " + super.toString();
        }
    }
}

