/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.AbstractContractNotification;
import fpml.consolidated.loan.AbstractLoanServicingEvent;
import fpml.consolidated.loan.DealDetailsModel;
import fpml.consolidated.loan.EventPayment;
import fpml.consolidated.loan.FacilityDetailsModel;
import fpml.consolidated.loan.FacilityPosition;
import fpml.consolidated.loan.LoanContractDetailsModel;
import fpml.consolidated.loan.meta.LoanContractNotificationMeta;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.Party;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanContractNotification", builder=LoanContractNotificationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanContractNotification", model="fpml", builder=LoanContractNotificationBuilderImpl.class, version="1.1.0")
public interface LoanContractNotification
extends AbstractContractNotification {
    public static final LoanContractNotificationMeta metaData = new LoanContractNotificationMeta();

    public AbstractLoanServicingEvent getLoanContractEventGroup();

    public DealDetailsModel getDealDetailsModel();

    public FacilityDetailsModel getFacilityDetailsModel();

    public List<? extends LoanContractDetailsModel> getLoanContractDetailsModel();

    public List<? extends Party> getParty();

    @Override
    public LoanContractNotification build();

    @Override
    public LoanContractNotificationBuilder toBuilder();

    public static LoanContractNotificationBuilder builder() {
        return new LoanContractNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanContractNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanContractNotification> getType() {
        return LoanContractNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.class, this.getEventPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.class, this.getFacilityPosition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractEventGroup"), processor, AbstractLoanServicingEvent.class, this.getLoanContractEventGroup(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.class, this.getDealDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractDetailsModel"), processor, LoanContractDetailsModel.class, this.getLoanContractDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class LoanContractNotificationBuilderImpl
    extends AbstractContractNotification.AbstractContractNotificationBuilderImpl
    implements LoanContractNotificationBuilder {
        protected AbstractLoanServicingEvent.AbstractLoanServicingEventBuilder loanContractEventGroup;
        protected DealDetailsModel.DealDetailsModelBuilder dealDetailsModel;
        protected FacilityDetailsModel.FacilityDetailsModelBuilder facilityDetailsModel;
        protected List<LoanContractDetailsModel.LoanContractDetailsModelBuilder> loanContractDetailsModel = new ArrayList<LoanContractDetailsModel.LoanContractDetailsModelBuilder>();
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="loanContractEventGroup", isRequired=true)
        @RuneAttribute(value="loanContractEventGroup", isRequired=true)
        public AbstractLoanServicingEvent.AbstractLoanServicingEventBuilder getLoanContractEventGroup() {
            return this.loanContractEventGroup;
        }

        @Override
        public AbstractLoanServicingEvent.AbstractLoanServicingEventBuilder getOrCreateLoanContractEventGroup() {
            AbstractLoanServicingEvent.AbstractLoanServicingEventBuilder result = this.loanContractEventGroup != null ? this.loanContractEventGroup : (this.loanContractEventGroup = AbstractLoanServicingEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel() {
            DealDetailsModel.DealDetailsModelBuilder result = this.dealDetailsModel != null ? this.dealDetailsModel : (this.dealDetailsModel = DealDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityDetailsModel.FacilityDetailsModelBuilder getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel() {
            FacilityDetailsModel.FacilityDetailsModelBuilder result = this.facilityDetailsModel != null ? this.facilityDetailsModel : (this.facilityDetailsModel = FacilityDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanContractDetailsModel", isRequired=true)
        @RuneAttribute(value="loanContractDetailsModel", isRequired=true)
        public List<? extends LoanContractDetailsModel.LoanContractDetailsModelBuilder> getLoanContractDetailsModel() {
            return this.loanContractDetailsModel;
        }

        @Override
        public LoanContractDetailsModel.LoanContractDetailsModelBuilder getOrCreateLoanContractDetailsModel(int index) {
            if (this.loanContractDetailsModel == null) {
                this.loanContractDetailsModel = new ArrayList<LoanContractDetailsModel.LoanContractDetailsModelBuilder>();
            }
            return (LoanContractDetailsModel.LoanContractDetailsModelBuilder)this.getIndex(this.loanContractDetailsModel, index, () -> {
                LoanContractDetailsModel.LoanContractDetailsModelBuilder newLoanContractDetailsModel = LoanContractDetailsModel.builder();
                return newLoanContractDetailsModel;
            });
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public LoanContractNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public LoanContractNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public LoanContractNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public LoanContractNotificationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public LoanContractNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public LoanContractNotificationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public LoanContractNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public LoanContractNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public LoanContractNotificationBuilder setNoticeDate(ZonedDateTime _noticeDate) {
            this.noticeDate = _noticeDate == null ? null : _noticeDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="isGlobalOnly", isRequired=true)
        @RuneAttribute(value="isGlobalOnly", isRequired=true)
        public LoanContractNotificationBuilder setIsGlobalOnly(Boolean _isGlobalOnly) {
            this.isGlobalOnly = _isGlobalOnly == null ? null : _isGlobalOnly;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventPayment")
        @RuneAttribute(value="eventPayment")
        public LoanContractNotificationBuilder addEventPayment(EventPayment _eventPayment) {
            if (_eventPayment != null) {
                this.eventPayment.add(_eventPayment.toBuilder());
            }
            return this;
        }

        @Override
        public LoanContractNotificationBuilder addEventPayment(EventPayment _eventPayment, int idx) {
            this.getIndex(this.eventPayment, idx, () -> _eventPayment.toBuilder());
            return this;
        }

        @Override
        public LoanContractNotificationBuilder addEventPayment(List<? extends EventPayment> eventPayments) {
            if (eventPayments != null) {
                for (EventPayment eventPayment : eventPayments) {
                    this.eventPayment.add(eventPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventPayment")
        public LoanContractNotificationBuilder setEventPayment(List<? extends EventPayment> eventPayments) {
            this.eventPayment = eventPayments == null ? new ArrayList() : (List)eventPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityPosition")
        @RuneAttribute(value="facilityPosition")
        public LoanContractNotificationBuilder addFacilityPosition(FacilityPosition _facilityPosition) {
            if (_facilityPosition != null) {
                this.facilityPosition.add(_facilityPosition.toBuilder());
            }
            return this;
        }

        @Override
        public LoanContractNotificationBuilder addFacilityPosition(FacilityPosition _facilityPosition, int idx) {
            this.getIndex(this.facilityPosition, idx, () -> _facilityPosition.toBuilder());
            return this;
        }

        @Override
        public LoanContractNotificationBuilder addFacilityPosition(List<? extends FacilityPosition> facilityPositions) {
            if (facilityPositions != null) {
                for (FacilityPosition facilityPosition : facilityPositions) {
                    this.facilityPosition.add(facilityPosition.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="facilityPosition")
        public LoanContractNotificationBuilder setFacilityPosition(List<? extends FacilityPosition> facilityPositions) {
            this.facilityPosition = facilityPositions == null ? new ArrayList() : (List)facilityPositions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractEventGroup", isRequired=true)
        @RuneAttribute(value="loanContractEventGroup", isRequired=true)
        public LoanContractNotificationBuilder setLoanContractEventGroup(AbstractLoanServicingEvent _loanContractEventGroup) {
            this.loanContractEventGroup = _loanContractEventGroup == null ? null : _loanContractEventGroup.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public LoanContractNotificationBuilder setDealDetailsModel(DealDetailsModel _dealDetailsModel) {
            this.dealDetailsModel = _dealDetailsModel == null ? null : _dealDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public LoanContractNotificationBuilder setFacilityDetailsModel(FacilityDetailsModel _facilityDetailsModel) {
            this.facilityDetailsModel = _facilityDetailsModel == null ? null : _facilityDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractDetailsModel", isRequired=true)
        @RuneAttribute(value="loanContractDetailsModel", isRequired=true)
        public LoanContractNotificationBuilder addLoanContractDetailsModel(LoanContractDetailsModel _loanContractDetailsModel) {
            if (_loanContractDetailsModel != null) {
                this.loanContractDetailsModel.add(_loanContractDetailsModel.toBuilder());
            }
            return this;
        }

        @Override
        public LoanContractNotificationBuilder addLoanContractDetailsModel(LoanContractDetailsModel _loanContractDetailsModel, int idx) {
            this.getIndex(this.loanContractDetailsModel, idx, () -> _loanContractDetailsModel.toBuilder());
            return this;
        }

        @Override
        public LoanContractNotificationBuilder addLoanContractDetailsModel(List<? extends LoanContractDetailsModel> loanContractDetailsModels) {
            if (loanContractDetailsModels != null) {
                for (LoanContractDetailsModel loanContractDetailsModel : loanContractDetailsModels) {
                    this.loanContractDetailsModel.add(loanContractDetailsModel.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanContractDetailsModel")
        public LoanContractNotificationBuilder setLoanContractDetailsModel(List<? extends LoanContractDetailsModel> loanContractDetailsModels) {
            this.loanContractDetailsModel = loanContractDetailsModels == null ? new ArrayList<LoanContractDetailsModel.LoanContractDetailsModelBuilder>() : (List)loanContractDetailsModels.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public LoanContractNotificationBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public LoanContractNotificationBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public LoanContractNotificationBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public LoanContractNotificationBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanContractNotification build() {
            return new LoanContractNotificationImpl(this);
        }

        @Override
        public LoanContractNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanContractNotificationBuilder prune() {
            super.prune();
            if (this.loanContractEventGroup != null && !this.loanContractEventGroup.prune().hasData()) {
                this.loanContractEventGroup = null;
            }
            if (this.dealDetailsModel != null && !this.dealDetailsModel.prune().hasData()) {
                this.dealDetailsModel = null;
            }
            if (this.facilityDetailsModel != null && !this.facilityDetailsModel.prune().hasData()) {
                this.facilityDetailsModel = null;
            }
            this.loanContractDetailsModel = this.loanContractDetailsModel.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLoanContractEventGroup() != null && this.getLoanContractEventGroup().hasData()) {
                return true;
            }
            if (this.getDealDetailsModel() != null && this.getDealDetailsModel().hasData()) {
                return true;
            }
            if (this.getFacilityDetailsModel() != null && this.getFacilityDetailsModel().hasData()) {
                return true;
            }
            if (this.getLoanContractDetailsModel() != null && this.getLoanContractDetailsModel().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public LoanContractNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanContractNotificationBuilder o = (LoanContractNotificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanContractEventGroup(), (RosettaModelObjectBuilder)o.getLoanContractEventGroup(), this::setLoanContractEventGroup);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealDetailsModel(), (RosettaModelObjectBuilder)o.getDealDetailsModel(), this::setDealDetailsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityDetailsModel(), (RosettaModelObjectBuilder)o.getFacilityDetailsModel(), this::setFacilityDetailsModel);
            merger.mergeRosetta(this.getLoanContractDetailsModel(), o.getLoanContractDetailsModel(), this::getOrCreateLoanContractDetailsModel);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanContractNotification _that = (LoanContractNotification)this.getType().cast(o);
            if (!Objects.equals(this.loanContractEventGroup, _that.getLoanContractEventGroup())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanContractDetailsModel, _that.getLoanContractDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanContractEventGroup != null ? this.loanContractEventGroup.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.loanContractDetailsModel != null ? this.loanContractDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanContractNotificationBuilder {loanContractEventGroup=" + this.loanContractEventGroup + ", dealDetailsModel=" + this.dealDetailsModel + ", facilityDetailsModel=" + this.facilityDetailsModel + ", loanContractDetailsModel=" + this.loanContractDetailsModel + ", party=" + this.party + '}' + " " + super.toString();
        }
    }

    public static interface LoanContractNotificationBuilder
    extends LoanContractNotification,
    AbstractContractNotification.AbstractContractNotificationBuilder {
        public AbstractLoanServicingEvent.AbstractLoanServicingEventBuilder getOrCreateLoanContractEventGroup();

        @Override
        public AbstractLoanServicingEvent.AbstractLoanServicingEventBuilder getLoanContractEventGroup();

        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel();

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel();

        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel();

        @Override
        public FacilityDetailsModel.FacilityDetailsModelBuilder getFacilityDetailsModel();

        public LoanContractDetailsModel.LoanContractDetailsModelBuilder getOrCreateLoanContractDetailsModel(int var1);

        public List<? extends LoanContractDetailsModel.LoanContractDetailsModelBuilder> getLoanContractDetailsModel();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public LoanContractNotificationBuilder setFpmlVersion(String var1);

        @Override
        public LoanContractNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public LoanContractNotificationBuilder setActualBuild(Integer var1);

        @Override
        public LoanContractNotificationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public LoanContractNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public LoanContractNotificationBuilder setIsCorrection(Boolean var1);

        @Override
        public LoanContractNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public LoanContractNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        @Override
        public LoanContractNotificationBuilder setNoticeDate(ZonedDateTime var1);

        @Override
        public LoanContractNotificationBuilder setIsGlobalOnly(Boolean var1);

        @Override
        public LoanContractNotificationBuilder addEventPayment(EventPayment var1);

        @Override
        public LoanContractNotificationBuilder addEventPayment(EventPayment var1, int var2);

        @Override
        public LoanContractNotificationBuilder addEventPayment(List<? extends EventPayment> var1);

        @Override
        public LoanContractNotificationBuilder setEventPayment(List<? extends EventPayment> var1);

        @Override
        public LoanContractNotificationBuilder addFacilityPosition(FacilityPosition var1);

        @Override
        public LoanContractNotificationBuilder addFacilityPosition(FacilityPosition var1, int var2);

        @Override
        public LoanContractNotificationBuilder addFacilityPosition(List<? extends FacilityPosition> var1);

        @Override
        public LoanContractNotificationBuilder setFacilityPosition(List<? extends FacilityPosition> var1);

        public LoanContractNotificationBuilder setLoanContractEventGroup(AbstractLoanServicingEvent var1);

        public LoanContractNotificationBuilder setDealDetailsModel(DealDetailsModel var1);

        public LoanContractNotificationBuilder setFacilityDetailsModel(FacilityDetailsModel var1);

        public LoanContractNotificationBuilder addLoanContractDetailsModel(LoanContractDetailsModel var1);

        public LoanContractNotificationBuilder addLoanContractDetailsModel(LoanContractDetailsModel var1, int var2);

        public LoanContractNotificationBuilder addLoanContractDetailsModel(List<? extends LoanContractDetailsModel> var1);

        public LoanContractNotificationBuilder setLoanContractDetailsModel(List<? extends LoanContractDetailsModel> var1);

        public LoanContractNotificationBuilder addParty(Party var1);

        public LoanContractNotificationBuilder addParty(Party var1, int var2);

        public LoanContractNotificationBuilder addParty(List<? extends Party> var1);

        public LoanContractNotificationBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.EventPaymentBuilder.class, this.getEventPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.FacilityPositionBuilder.class, this.getFacilityPosition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractEventGroup"), processor, AbstractLoanServicingEvent.AbstractLoanServicingEventBuilder.class, this.getLoanContractEventGroup(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.DealDetailsModelBuilder.class, this.getDealDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.FacilityDetailsModelBuilder.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractDetailsModel"), processor, LoanContractDetailsModel.LoanContractDetailsModelBuilder.class, this.getLoanContractDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public LoanContractNotificationBuilder prune();
    }

    public static class LoanContractNotificationImpl
    extends AbstractContractNotification.AbstractContractNotificationImpl
    implements LoanContractNotification {
        private final AbstractLoanServicingEvent loanContractEventGroup;
        private final DealDetailsModel dealDetailsModel;
        private final FacilityDetailsModel facilityDetailsModel;
        private final List<? extends LoanContractDetailsModel> loanContractDetailsModel;
        private final List<? extends Party> party;

        protected LoanContractNotificationImpl(LoanContractNotificationBuilder builder) {
            super(builder);
            this.loanContractEventGroup = Optional.ofNullable(builder.getLoanContractEventGroup()).map(f -> f.build()).orElse(null);
            this.dealDetailsModel = Optional.ofNullable(builder.getDealDetailsModel()).map(f -> f.build()).orElse(null);
            this.facilityDetailsModel = Optional.ofNullable(builder.getFacilityDetailsModel()).map(f -> f.build()).orElse(null);
            this.loanContractDetailsModel = Optional.ofNullable(builder.getLoanContractDetailsModel()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="loanContractEventGroup", isRequired=true)
        @RuneAttribute(value="loanContractEventGroup", isRequired=true)
        public AbstractLoanServicingEvent getLoanContractEventGroup() {
            return this.loanContractEventGroup;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityDetailsModel getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        @RosettaAttribute(value="loanContractDetailsModel", isRequired=true)
        @RuneAttribute(value="loanContractDetailsModel", isRequired=true)
        public List<? extends LoanContractDetailsModel> getLoanContractDetailsModel() {
            return this.loanContractDetailsModel;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public LoanContractNotification build() {
            return this;
        }

        @Override
        public LoanContractNotificationBuilder toBuilder() {
            LoanContractNotificationBuilder builder = LoanContractNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanContractNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLoanContractEventGroup()).ifPresent(builder::setLoanContractEventGroup);
            Optional.ofNullable(this.getDealDetailsModel()).ifPresent(builder::setDealDetailsModel);
            Optional.ofNullable(this.getFacilityDetailsModel()).ifPresent(builder::setFacilityDetailsModel);
            Optional.ofNullable(this.getLoanContractDetailsModel()).ifPresent(builder::setLoanContractDetailsModel);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanContractNotification _that = (LoanContractNotification)this.getType().cast(o);
            if (!Objects.equals(this.loanContractEventGroup, _that.getLoanContractEventGroup())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanContractDetailsModel, _that.getLoanContractDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanContractEventGroup != null ? this.loanContractEventGroup.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.loanContractDetailsModel != null ? this.loanContractDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanContractNotification {loanContractEventGroup=" + this.loanContractEventGroup + ", dealDetailsModel=" + this.dealDetailsModel + ", facilityDetailsModel=" + this.facilityDetailsModel + ", loanContractDetailsModel=" + this.loanContractDetailsModel + ", party=" + this.party + '}' + " " + super.toString();
        }
    }
}

