/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.AccrualPeriod;
import fpml.consolidated.loan.meta.AbstractTradingAccrualMeta;
import fpml.consolidated.shared.Money;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractTradingAccrual", builder=AbstractTradingAccrualBuilderImpl.class, version="1.1.0")
@RuneDataType(value="AbstractTradingAccrual", model="fpml", builder=AbstractTradingAccrualBuilderImpl.class, version="1.1.0")
public interface AbstractTradingAccrual
extends RosettaModelObject {
    public static final AbstractTradingAccrualMeta metaData = new AbstractTradingAccrualMeta();

    public Money getAmount();

    public List<? extends AccrualPeriod> getAccrualPeriod();

    public AbstractTradingAccrual build();

    public AbstractTradingAccrualBuilder toBuilder();

    public static AbstractTradingAccrualBuilder builder() {
        return new AbstractTradingAccrualBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractTradingAccrual> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractTradingAccrual> getType() {
        return AbstractTradingAccrual.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("amount"), processor, Money.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrualPeriod"), processor, AccrualPeriod.class, this.getAccrualPeriod(), new AttributeMeta[0]);
    }

    public static class AbstractTradingAccrualBuilderImpl
    implements AbstractTradingAccrualBuilder {
        protected Money.MoneyBuilder amount;
        protected List<AccrualPeriod.AccrualPeriodBuilder> accrualPeriod = new ArrayList<AccrualPeriod.AccrualPeriodBuilder>();

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public Money.MoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAmount() {
            Money.MoneyBuilder result = this.amount != null ? this.amount : (this.amount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualPeriod")
        @RuneAttribute(value="accrualPeriod")
        public List<? extends AccrualPeriod.AccrualPeriodBuilder> getAccrualPeriod() {
            return this.accrualPeriod;
        }

        @Override
        public AccrualPeriod.AccrualPeriodBuilder getOrCreateAccrualPeriod(int index) {
            if (this.accrualPeriod == null) {
                this.accrualPeriod = new ArrayList<AccrualPeriod.AccrualPeriodBuilder>();
            }
            return (AccrualPeriod.AccrualPeriodBuilder)this.getIndex(this.accrualPeriod, index, () -> {
                AccrualPeriod.AccrualPeriodBuilder newAccrualPeriod = AccrualPeriod.builder();
                return newAccrualPeriod;
            });
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public AbstractTradingAccrualBuilder setAmount(Money _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accrualPeriod")
        @RuneAttribute(value="accrualPeriod")
        public AbstractTradingAccrualBuilder addAccrualPeriod(AccrualPeriod _accrualPeriod) {
            if (_accrualPeriod != null) {
                this.accrualPeriod.add(_accrualPeriod.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractTradingAccrualBuilder addAccrualPeriod(AccrualPeriod _accrualPeriod, int idx) {
            this.getIndex(this.accrualPeriod, idx, () -> _accrualPeriod.toBuilder());
            return this;
        }

        @Override
        public AbstractTradingAccrualBuilder addAccrualPeriod(List<? extends AccrualPeriod> accrualPeriods) {
            if (accrualPeriods != null) {
                for (AccrualPeriod accrualPeriod : accrualPeriods) {
                    this.accrualPeriod.add(accrualPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="accrualPeriod")
        public AbstractTradingAccrualBuilder setAccrualPeriod(List<? extends AccrualPeriod> accrualPeriods) {
            this.accrualPeriod = accrualPeriods == null ? new ArrayList<AccrualPeriod.AccrualPeriodBuilder>() : (List)accrualPeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AbstractTradingAccrual build() {
            return new AbstractTradingAccrualImpl(this);
        }

        @Override
        public AbstractTradingAccrualBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractTradingAccrualBuilder prune() {
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            this.accrualPeriod = this.accrualPeriod.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getAccrualPeriod() != null && this.getAccrualPeriod().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public AbstractTradingAccrualBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AbstractTradingAccrualBuilder o = (AbstractTradingAccrualBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta(this.getAccrualPeriod(), o.getAccrualPeriod(), this::getOrCreateAccrualPeriod);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbstractTradingAccrual _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.accrualPeriod, _that.getAccrualPeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.accrualPeriod != null ? this.accrualPeriod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbstractTradingAccrualBuilder {amount=" + this.amount + ", accrualPeriod=" + this.accrualPeriod + '}';
        }
    }

    public static interface AbstractTradingAccrualBuilder
    extends AbstractTradingAccrual,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateAmount();

        @Override
        public Money.MoneyBuilder getAmount();

        public AccrualPeriod.AccrualPeriodBuilder getOrCreateAccrualPeriod(int var1);

        public List<? extends AccrualPeriod.AccrualPeriodBuilder> getAccrualPeriod();

        public AbstractTradingAccrualBuilder setAmount(Money var1);

        public AbstractTradingAccrualBuilder addAccrualPeriod(AccrualPeriod var1);

        public AbstractTradingAccrualBuilder addAccrualPeriod(AccrualPeriod var1, int var2);

        public AbstractTradingAccrualBuilder addAccrualPeriod(List<? extends AccrualPeriod> var1);

        public AbstractTradingAccrualBuilder setAccrualPeriod(List<? extends AccrualPeriod> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("amount"), processor, Money.MoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrualPeriod"), processor, AccrualPeriod.AccrualPeriodBuilder.class, this.getAccrualPeriod(), new AttributeMeta[0]);
        }

        public AbstractTradingAccrualBuilder prune();
    }

    public static class AbstractTradingAccrualImpl
    implements AbstractTradingAccrual {
        private final Money amount;
        private final List<? extends AccrualPeriod> accrualPeriod;

        protected AbstractTradingAccrualImpl(AbstractTradingAccrualBuilder builder) {
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.accrualPeriod = Optional.ofNullable(builder.getAccrualPeriod()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public Money getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="accrualPeriod")
        @RuneAttribute(value="accrualPeriod")
        public List<? extends AccrualPeriod> getAccrualPeriod() {
            return this.accrualPeriod;
        }

        @Override
        public AbstractTradingAccrual build() {
            return this;
        }

        @Override
        public AbstractTradingAccrualBuilder toBuilder() {
            AbstractTradingAccrualBuilder builder = AbstractTradingAccrual.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractTradingAccrualBuilder builder) {
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getAccrualPeriod()).ifPresent(builder::setAccrualPeriod);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbstractTradingAccrual _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.accrualPeriod, _that.getAccrualPeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.accrualPeriod != null ? this.accrualPeriod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbstractTradingAccrual {amount=" + this.amount + ", accrualPeriod=" + this.accrualPeriod + '}';
        }
    }
}

