/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.ird;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.ird.CancelableProvisionAdjustedDates;
import fpml.consolidated.ird.FinalCalculationPeriodDateAdjustment;
import fpml.consolidated.ird.meta.CancelableProvisionMeta;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.Exercise;
import fpml.consolidated.shared.ExerciseNotice;
import fpml.consolidated.shared.SimplePayment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CancelableProvision", builder=CancelableProvisionBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CancelableProvision", model="fpml", builder=CancelableProvisionBuilderImpl.class, version="1.1.0")
public interface CancelableProvision
extends RosettaModelObject {
    public static final CancelableProvisionMeta metaData = new CancelableProvisionMeta();

    public BuyerSellerModel getBuyerSellerModel();

    public Exercise getExercise();

    public ExerciseNotice getExerciseNotice();

    public Boolean getFollowUpConfirmation();

    public CancelableProvisionAdjustedDates getCancelableProvisionAdjustedDates();

    public List<? extends FinalCalculationPeriodDateAdjustment> getFinalCalculationPeriodDateAdjustment();

    public SimplePayment getInitialFee();

    public CancelableProvision build();

    public CancelableProvisionBuilder toBuilder();

    public static CancelableProvisionBuilder builder() {
        return new CancelableProvisionBuilderImpl();
    }

    default public RosettaMetaData<? extends CancelableProvision> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CancelableProvision> getType() {
        return CancelableProvision.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exercise"), processor, Exercise.class, this.getExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseNotice"), processor, ExerciseNotice.class, this.getExerciseNotice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("followUpConfirmation"), Boolean.class, (Object)this.getFollowUpConfirmation(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cancelableProvisionAdjustedDates"), processor, CancelableProvisionAdjustedDates.class, this.getCancelableProvisionAdjustedDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalCalculationPeriodDateAdjustment"), processor, FinalCalculationPeriodDateAdjustment.class, this.getFinalCalculationPeriodDateAdjustment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("initialFee"), processor, SimplePayment.class, this.getInitialFee(), new AttributeMeta[0]);
    }

    public static class CancelableProvisionBuilderImpl
    implements CancelableProvisionBuilder {
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;
        protected Exercise.ExerciseBuilder exercise;
        protected ExerciseNotice.ExerciseNoticeBuilder exerciseNotice;
        protected Boolean followUpConfirmation;
        protected CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder cancelableProvisionAdjustedDates;
        protected List<FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder> finalCalculationPeriodDateAdjustment = new ArrayList<FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder>();
        protected SimplePayment.SimplePaymentBuilder initialFee;

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exercise")
        @RuneAttribute(value="exercise")
        public Exercise.ExerciseBuilder getExercise() {
            return this.exercise;
        }

        @Override
        public Exercise.ExerciseBuilder getOrCreateExercise() {
            Exercise.ExerciseBuilder result = this.exercise != null ? this.exercise : (this.exercise = Exercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseNotice")
        @RuneAttribute(value="exerciseNotice")
        public ExerciseNotice.ExerciseNoticeBuilder getExerciseNotice() {
            return this.exerciseNotice;
        }

        @Override
        public ExerciseNotice.ExerciseNoticeBuilder getOrCreateExerciseNotice() {
            ExerciseNotice.ExerciseNoticeBuilder result = this.exerciseNotice != null ? this.exerciseNotice : (this.exerciseNotice = ExerciseNotice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="followUpConfirmation")
        @RuneAttribute(value="followUpConfirmation")
        public Boolean getFollowUpConfirmation() {
            return this.followUpConfirmation;
        }

        @Override
        @RosettaAttribute(value="cancelableProvisionAdjustedDates")
        @RuneAttribute(value="cancelableProvisionAdjustedDates")
        public CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder getCancelableProvisionAdjustedDates() {
            return this.cancelableProvisionAdjustedDates;
        }

        @Override
        public CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder getOrCreateCancelableProvisionAdjustedDates() {
            CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder result = this.cancelableProvisionAdjustedDates != null ? this.cancelableProvisionAdjustedDates : (this.cancelableProvisionAdjustedDates = CancelableProvisionAdjustedDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="finalCalculationPeriodDateAdjustment")
        @RuneAttribute(value="finalCalculationPeriodDateAdjustment")
        public List<? extends FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder> getFinalCalculationPeriodDateAdjustment() {
            return this.finalCalculationPeriodDateAdjustment;
        }

        @Override
        public FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder getOrCreateFinalCalculationPeriodDateAdjustment(int index) {
            if (this.finalCalculationPeriodDateAdjustment == null) {
                this.finalCalculationPeriodDateAdjustment = new ArrayList<FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder>();
            }
            return (FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder)this.getIndex(this.finalCalculationPeriodDateAdjustment, index, () -> {
                FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder newFinalCalculationPeriodDateAdjustment = FinalCalculationPeriodDateAdjustment.builder();
                return newFinalCalculationPeriodDateAdjustment;
            });
        }

        @Override
        @RosettaAttribute(value="initialFee")
        @RuneAttribute(value="initialFee")
        public SimplePayment.SimplePaymentBuilder getInitialFee() {
            return this.initialFee;
        }

        @Override
        public SimplePayment.SimplePaymentBuilder getOrCreateInitialFee() {
            SimplePayment.SimplePaymentBuilder result = this.initialFee != null ? this.initialFee : (this.initialFee = SimplePayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public CancelableProvisionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exercise")
        @RuneAttribute(value="exercise")
        public CancelableProvisionBuilder setExercise(Exercise _exercise) {
            this.exercise = _exercise == null ? null : _exercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseNotice")
        @RuneAttribute(value="exerciseNotice")
        public CancelableProvisionBuilder setExerciseNotice(ExerciseNotice _exerciseNotice) {
            this.exerciseNotice = _exerciseNotice == null ? null : _exerciseNotice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="followUpConfirmation")
        @RuneAttribute(value="followUpConfirmation")
        public CancelableProvisionBuilder setFollowUpConfirmation(Boolean _followUpConfirmation) {
            this.followUpConfirmation = _followUpConfirmation == null ? null : _followUpConfirmation;
            return this;
        }

        @Override
        @RosettaAttribute(value="cancelableProvisionAdjustedDates")
        @RuneAttribute(value="cancelableProvisionAdjustedDates")
        public CancelableProvisionBuilder setCancelableProvisionAdjustedDates(CancelableProvisionAdjustedDates _cancelableProvisionAdjustedDates) {
            this.cancelableProvisionAdjustedDates = _cancelableProvisionAdjustedDates == null ? null : _cancelableProvisionAdjustedDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="finalCalculationPeriodDateAdjustment")
        @RuneAttribute(value="finalCalculationPeriodDateAdjustment")
        public CancelableProvisionBuilder addFinalCalculationPeriodDateAdjustment(FinalCalculationPeriodDateAdjustment _finalCalculationPeriodDateAdjustment) {
            if (_finalCalculationPeriodDateAdjustment != null) {
                this.finalCalculationPeriodDateAdjustment.add(_finalCalculationPeriodDateAdjustment.toBuilder());
            }
            return this;
        }

        @Override
        public CancelableProvisionBuilder addFinalCalculationPeriodDateAdjustment(FinalCalculationPeriodDateAdjustment _finalCalculationPeriodDateAdjustment, int idx) {
            this.getIndex(this.finalCalculationPeriodDateAdjustment, idx, () -> _finalCalculationPeriodDateAdjustment.toBuilder());
            return this;
        }

        @Override
        public CancelableProvisionBuilder addFinalCalculationPeriodDateAdjustment(List<? extends FinalCalculationPeriodDateAdjustment> finalCalculationPeriodDateAdjustments) {
            if (finalCalculationPeriodDateAdjustments != null) {
                for (FinalCalculationPeriodDateAdjustment finalCalculationPeriodDateAdjustment : finalCalculationPeriodDateAdjustments) {
                    this.finalCalculationPeriodDateAdjustment.add(finalCalculationPeriodDateAdjustment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="finalCalculationPeriodDateAdjustment")
        public CancelableProvisionBuilder setFinalCalculationPeriodDateAdjustment(List<? extends FinalCalculationPeriodDateAdjustment> finalCalculationPeriodDateAdjustments) {
            this.finalCalculationPeriodDateAdjustment = finalCalculationPeriodDateAdjustments == null ? new ArrayList<FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder>() : (List)finalCalculationPeriodDateAdjustments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="initialFee")
        @RuneAttribute(value="initialFee")
        public CancelableProvisionBuilder setInitialFee(SimplePayment _initialFee) {
            this.initialFee = _initialFee == null ? null : _initialFee.toBuilder();
            return this;
        }

        @Override
        public CancelableProvision build() {
            return new CancelableProvisionImpl(this);
        }

        @Override
        public CancelableProvisionBuilder toBuilder() {
            return this;
        }

        @Override
        public CancelableProvisionBuilder prune() {
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            if (this.exercise != null && !this.exercise.prune().hasData()) {
                this.exercise = null;
            }
            if (this.exerciseNotice != null && !this.exerciseNotice.prune().hasData()) {
                this.exerciseNotice = null;
            }
            if (this.cancelableProvisionAdjustedDates != null && !this.cancelableProvisionAdjustedDates.prune().hasData()) {
                this.cancelableProvisionAdjustedDates = null;
            }
            this.finalCalculationPeriodDateAdjustment = this.finalCalculationPeriodDateAdjustment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.initialFee != null && !this.initialFee.prune().hasData()) {
                this.initialFee = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData()) {
                return true;
            }
            if (this.getExercise() != null && this.getExercise().hasData()) {
                return true;
            }
            if (this.getExerciseNotice() != null && this.getExerciseNotice().hasData()) {
                return true;
            }
            if (this.getFollowUpConfirmation() != null) {
                return true;
            }
            if (this.getCancelableProvisionAdjustedDates() != null && this.getCancelableProvisionAdjustedDates().hasData()) {
                return true;
            }
            if (this.getFinalCalculationPeriodDateAdjustment() != null && this.getFinalCalculationPeriodDateAdjustment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getInitialFee() != null && this.getInitialFee().hasData();
        }

        public CancelableProvisionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CancelableProvisionBuilder o = (CancelableProvisionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExercise(), (RosettaModelObjectBuilder)o.getExercise(), this::setExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseNotice(), (RosettaModelObjectBuilder)o.getExerciseNotice(), this::setExerciseNotice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCancelableProvisionAdjustedDates(), (RosettaModelObjectBuilder)o.getCancelableProvisionAdjustedDates(), this::setCancelableProvisionAdjustedDates);
            merger.mergeRosetta(this.getFinalCalculationPeriodDateAdjustment(), o.getFinalCalculationPeriodDateAdjustment(), this::getOrCreateFinalCalculationPeriodDateAdjustment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInitialFee(), (RosettaModelObjectBuilder)o.getInitialFee(), this::setInitialFee);
            merger.mergeBasic((Object)this.getFollowUpConfirmation(), (Object)o.getFollowUpConfirmation(), this::setFollowUpConfirmation, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CancelableProvision _that = this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.exercise, _that.getExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseNotice, _that.getExerciseNotice())) {
                return false;
            }
            if (!Objects.equals(this.followUpConfirmation, _that.getFollowUpConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.cancelableProvisionAdjustedDates, _that.getCancelableProvisionAdjustedDates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.finalCalculationPeriodDateAdjustment, _that.getFinalCalculationPeriodDateAdjustment())) {
                return false;
            }
            return Objects.equals(this.initialFee, _that.getInitialFee());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.exercise != null ? this.exercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseNotice != null ? this.exerciseNotice.hashCode() : 0);
            _result = 31 * _result + (this.followUpConfirmation != null ? this.followUpConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.cancelableProvisionAdjustedDates != null ? this.cancelableProvisionAdjustedDates.hashCode() : 0);
            _result = 31 * _result + (this.finalCalculationPeriodDateAdjustment != null ? this.finalCalculationPeriodDateAdjustment.hashCode() : 0);
            _result = 31 * _result + (this.initialFee != null ? this.initialFee.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CancelableProvisionBuilder {buyerSellerModel=" + this.buyerSellerModel + ", exercise=" + this.exercise + ", exerciseNotice=" + this.exerciseNotice + ", followUpConfirmation=" + this.followUpConfirmation + ", cancelableProvisionAdjustedDates=" + this.cancelableProvisionAdjustedDates + ", finalCalculationPeriodDateAdjustment=" + this.finalCalculationPeriodDateAdjustment + ", initialFee=" + this.initialFee + '}';
        }
    }

    public static interface CancelableProvisionBuilder
    extends CancelableProvision,
    RosettaModelObjectBuilder {
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        public Exercise.ExerciseBuilder getOrCreateExercise();

        @Override
        public Exercise.ExerciseBuilder getExercise();

        public ExerciseNotice.ExerciseNoticeBuilder getOrCreateExerciseNotice();

        @Override
        public ExerciseNotice.ExerciseNoticeBuilder getExerciseNotice();

        public CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder getOrCreateCancelableProvisionAdjustedDates();

        @Override
        public CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder getCancelableProvisionAdjustedDates();

        public FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder getOrCreateFinalCalculationPeriodDateAdjustment(int var1);

        public List<? extends FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder> getFinalCalculationPeriodDateAdjustment();

        public SimplePayment.SimplePaymentBuilder getOrCreateInitialFee();

        @Override
        public SimplePayment.SimplePaymentBuilder getInitialFee();

        public CancelableProvisionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public CancelableProvisionBuilder setExercise(Exercise var1);

        public CancelableProvisionBuilder setExerciseNotice(ExerciseNotice var1);

        public CancelableProvisionBuilder setFollowUpConfirmation(Boolean var1);

        public CancelableProvisionBuilder setCancelableProvisionAdjustedDates(CancelableProvisionAdjustedDates var1);

        public CancelableProvisionBuilder addFinalCalculationPeriodDateAdjustment(FinalCalculationPeriodDateAdjustment var1);

        public CancelableProvisionBuilder addFinalCalculationPeriodDateAdjustment(FinalCalculationPeriodDateAdjustment var1, int var2);

        public CancelableProvisionBuilder addFinalCalculationPeriodDateAdjustment(List<? extends FinalCalculationPeriodDateAdjustment> var1);

        public CancelableProvisionBuilder setFinalCalculationPeriodDateAdjustment(List<? extends FinalCalculationPeriodDateAdjustment> var1);

        public CancelableProvisionBuilder setInitialFee(SimplePayment var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exercise"), processor, Exercise.ExerciseBuilder.class, this.getExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseNotice"), processor, ExerciseNotice.ExerciseNoticeBuilder.class, this.getExerciseNotice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("followUpConfirmation"), Boolean.class, (Object)this.getFollowUpConfirmation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cancelableProvisionAdjustedDates"), processor, CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder.class, this.getCancelableProvisionAdjustedDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalCalculationPeriodDateAdjustment"), processor, FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder.class, this.getFinalCalculationPeriodDateAdjustment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("initialFee"), processor, SimplePayment.SimplePaymentBuilder.class, this.getInitialFee(), new AttributeMeta[0]);
        }

        public CancelableProvisionBuilder prune();
    }

    public static class CancelableProvisionImpl
    implements CancelableProvision {
        private final BuyerSellerModel buyerSellerModel;
        private final Exercise exercise;
        private final ExerciseNotice exerciseNotice;
        private final Boolean followUpConfirmation;
        private final CancelableProvisionAdjustedDates cancelableProvisionAdjustedDates;
        private final List<? extends FinalCalculationPeriodDateAdjustment> finalCalculationPeriodDateAdjustment;
        private final SimplePayment initialFee;

        protected CancelableProvisionImpl(CancelableProvisionBuilder builder) {
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
            this.exercise = Optional.ofNullable(builder.getExercise()).map(f -> f.build()).orElse(null);
            this.exerciseNotice = Optional.ofNullable(builder.getExerciseNotice()).map(f -> f.build()).orElse(null);
            this.followUpConfirmation = builder.getFollowUpConfirmation();
            this.cancelableProvisionAdjustedDates = Optional.ofNullable(builder.getCancelableProvisionAdjustedDates()).map(f -> f.build()).orElse(null);
            this.finalCalculationPeriodDateAdjustment = Optional.ofNullable(builder.getFinalCalculationPeriodDateAdjustment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.initialFee = Optional.ofNullable(builder.getInitialFee()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        @RosettaAttribute(value="exercise")
        @RuneAttribute(value="exercise")
        public Exercise getExercise() {
            return this.exercise;
        }

        @Override
        @RosettaAttribute(value="exerciseNotice")
        @RuneAttribute(value="exerciseNotice")
        public ExerciseNotice getExerciseNotice() {
            return this.exerciseNotice;
        }

        @Override
        @RosettaAttribute(value="followUpConfirmation")
        @RuneAttribute(value="followUpConfirmation")
        public Boolean getFollowUpConfirmation() {
            return this.followUpConfirmation;
        }

        @Override
        @RosettaAttribute(value="cancelableProvisionAdjustedDates")
        @RuneAttribute(value="cancelableProvisionAdjustedDates")
        public CancelableProvisionAdjustedDates getCancelableProvisionAdjustedDates() {
            return this.cancelableProvisionAdjustedDates;
        }

        @Override
        @RosettaAttribute(value="finalCalculationPeriodDateAdjustment")
        @RuneAttribute(value="finalCalculationPeriodDateAdjustment")
        public List<? extends FinalCalculationPeriodDateAdjustment> getFinalCalculationPeriodDateAdjustment() {
            return this.finalCalculationPeriodDateAdjustment;
        }

        @Override
        @RosettaAttribute(value="initialFee")
        @RuneAttribute(value="initialFee")
        public SimplePayment getInitialFee() {
            return this.initialFee;
        }

        @Override
        public CancelableProvision build() {
            return this;
        }

        @Override
        public CancelableProvisionBuilder toBuilder() {
            CancelableProvisionBuilder builder = CancelableProvision.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CancelableProvisionBuilder builder) {
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
            Optional.ofNullable(this.getExercise()).ifPresent(builder::setExercise);
            Optional.ofNullable(this.getExerciseNotice()).ifPresent(builder::setExerciseNotice);
            Optional.ofNullable(this.getFollowUpConfirmation()).ifPresent(builder::setFollowUpConfirmation);
            Optional.ofNullable(this.getCancelableProvisionAdjustedDates()).ifPresent(builder::setCancelableProvisionAdjustedDates);
            Optional.ofNullable(this.getFinalCalculationPeriodDateAdjustment()).ifPresent(builder::setFinalCalculationPeriodDateAdjustment);
            Optional.ofNullable(this.getInitialFee()).ifPresent(builder::setInitialFee);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CancelableProvision _that = this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.exercise, _that.getExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseNotice, _that.getExerciseNotice())) {
                return false;
            }
            if (!Objects.equals(this.followUpConfirmation, _that.getFollowUpConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.cancelableProvisionAdjustedDates, _that.getCancelableProvisionAdjustedDates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.finalCalculationPeriodDateAdjustment, _that.getFinalCalculationPeriodDateAdjustment())) {
                return false;
            }
            return Objects.equals(this.initialFee, _that.getInitialFee());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.exercise != null ? this.exercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseNotice != null ? this.exerciseNotice.hashCode() : 0);
            _result = 31 * _result + (this.followUpConfirmation != null ? this.followUpConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.cancelableProvisionAdjustedDates != null ? this.cancelableProvisionAdjustedDates.hashCode() : 0);
            _result = 31 * _result + (this.finalCalculationPeriodDateAdjustment != null ? this.finalCalculationPeriodDateAdjustment.hashCode() : 0);
            _result = 31 * _result + (this.initialFee != null ? this.initialFee.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CancelableProvision {buyerSellerModel=" + this.buyerSellerModel + ", exercise=" + this.exercise + ", exerciseNotice=" + this.exerciseNotice + ", followUpConfirmation=" + this.followUpConfirmation + ", cancelableProvisionAdjustedDates=" + this.cancelableProvisionAdjustedDates + ", finalCalculationPeriodDateAdjustment=" + this.finalCalculationPeriodDateAdjustment + ", initialFee=" + this.initialFee + '}';
        }
    }
}

