/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.generic.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.generic.GenericProduct;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="GenericProductChoice")
@ImplementedBy(value=Default.class)
public interface GenericProductChoice
extends Validator<GenericProduct> {
    public static final String NAME = "GenericProductChoice";
    public static final String DEFINITION = "optional choice buyerSellerModel, counterpartyReference";

    public static class NoOp
    implements GenericProductChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, GenericProduct genericProduct) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements GenericProductChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, GenericProduct genericProduct) {
            ComparisonResult result = this.executeDataRule(genericProduct);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)GenericProductChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"GenericProduct", (RosettaPath)path, (String)GenericProductChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)GenericProductChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"GenericProduct", (RosettaPath)path, (String)GenericProductChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(GenericProduct genericProduct) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)genericProduct), Arrays.asList("buyerSellerModel", "counterpartyReference"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

