/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.generic;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fpmlenum.SettlementTypeEnum;
import fpml.consolidated.generic.GenericCommodityAttributesModel;
import fpml.consolidated.generic.GenericEquityAttributesModel;
import fpml.consolidated.generic.GenericFrequency;
import fpml.consolidated.generic.GenericOptionAttributesModel;
import fpml.consolidated.generic.GenericResetFrequency;
import fpml.consolidated.generic.TradeUnderlyer2;
import fpml.consolidated.generic.meta.GenericProductMeta;
import fpml.consolidated.shared.AdjustableDate2;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.CashflowNotional;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.PartyReference;
import fpml.consolidated.shared.Payment;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import fpml.consolidated.shared.SimplePayment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="GenericProduct", builder=GenericProductBuilderImpl.class, version="1.1.0")
@RuneDataType(value="GenericProduct", model="fpml", builder=GenericProductBuilderImpl.class, version="1.1.0")
public interface GenericProduct
extends Product {
    public static final GenericProductMeta metaData = new GenericProductMeta();

    public Boolean getMultiLeg();

    public BuyerSellerModel getBuyerSellerModel();

    public List<? extends PartyReference> getCounterpartyReference();

    public SimplePayment getPremium();

    public AdjustableDate2 getEffectiveDate();

    public AdjustableDate2 getExpirationDate();

    public AdjustableDate2 getTerminationDate();

    public List<? extends TradeUnderlyer2> getUnderlyer();

    public List<? extends CashflowNotional> getNotional();

    public GenericCommodityAttributesModel getGenericCommodityAttributesModel();

    public GenericEquityAttributesModel getGenericEquityAttributesModel();

    public GenericOptionAttributesModel getGenericOptionAttributesModel();

    public List<? extends GenericFrequency> getPaymentFrequency();

    public List<? extends GenericResetFrequency> getResetFrequency();

    public List<? extends IdentifiedCurrency> getSettlementCurrency();

    public SettlementTypeEnum getSettlementType();

    public List<? extends Payment> getAdditionalPayment();

    @Override
    public GenericProduct build();

    @Override
    public GenericProductBuilder toBuilder();

    public static GenericProductBuilder builder() {
        return new GenericProductBuilderImpl();
    }

    default public RosettaMetaData<? extends GenericProduct> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends GenericProduct> getType() {
        return GenericProduct.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("multiLeg"), Boolean.class, (Object)this.getMultiLeg(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterpartyReference"), processor, PartyReference.class, this.getCounterpartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, SimplePayment.class, this.getPremium(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableDate2.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableDate2.class, this.getExpirationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableDate2.class, this.getTerminationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, TradeUnderlyer2.class, this.getUnderlyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notional"), processor, CashflowNotional.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("genericCommodityAttributesModel"), processor, GenericCommodityAttributesModel.class, this.getGenericCommodityAttributesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("genericEquityAttributesModel"), processor, GenericEquityAttributesModel.class, this.getGenericEquityAttributesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("genericOptionAttributesModel"), processor, GenericOptionAttributesModel.class, this.getGenericOptionAttributesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, GenericFrequency.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("resetFrequency"), processor, GenericResetFrequency.class, this.getResetFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementCurrency"), processor, IdentifiedCurrency.class, this.getSettlementCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalPayment"), processor, Payment.class, this.getAdditionalPayment(), new AttributeMeta[0]);
    }

    public static class GenericProductBuilderImpl
    extends Product.ProductBuilderImpl
    implements GenericProductBuilder {
        protected Boolean multiLeg;
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;
        protected List<PartyReference.PartyReferenceBuilder> counterpartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
        protected SimplePayment.SimplePaymentBuilder premium;
        protected AdjustableDate2.AdjustableDate2Builder effectiveDate;
        protected AdjustableDate2.AdjustableDate2Builder expirationDate;
        protected AdjustableDate2.AdjustableDate2Builder terminationDate;
        protected List<TradeUnderlyer2.TradeUnderlyer2Builder> underlyer = new ArrayList<TradeUnderlyer2.TradeUnderlyer2Builder>();
        protected List<CashflowNotional.CashflowNotionalBuilder> notional = new ArrayList<CashflowNotional.CashflowNotionalBuilder>();
        protected GenericCommodityAttributesModel.GenericCommodityAttributesModelBuilder genericCommodityAttributesModel;
        protected GenericEquityAttributesModel.GenericEquityAttributesModelBuilder genericEquityAttributesModel;
        protected GenericOptionAttributesModel.GenericOptionAttributesModelBuilder genericOptionAttributesModel;
        protected List<GenericFrequency.GenericFrequencyBuilder> paymentFrequency = new ArrayList<GenericFrequency.GenericFrequencyBuilder>();
        protected List<GenericResetFrequency.GenericResetFrequencyBuilder> resetFrequency = new ArrayList<GenericResetFrequency.GenericResetFrequencyBuilder>();
        protected List<IdentifiedCurrency.IdentifiedCurrencyBuilder> settlementCurrency = new ArrayList<IdentifiedCurrency.IdentifiedCurrencyBuilder>();
        protected SettlementTypeEnum settlementType;
        protected List<Payment.PaymentBuilder> additionalPayment = new ArrayList<Payment.PaymentBuilder>();

        @Override
        @RosettaAttribute(value="multiLeg")
        @RuneAttribute(value="multiLeg")
        public Boolean getMultiLeg() {
            return this.multiLeg;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel")
        @RuneAttribute(value="buyerSellerModel")
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="counterpartyReference")
        @RuneAttribute(value="counterpartyReference")
        public List<? extends PartyReference.PartyReferenceBuilder> getCounterpartyReference() {
            return this.counterpartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateCounterpartyReference(int index) {
            if (this.counterpartyReference == null) {
                this.counterpartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
            }
            return (PartyReference.PartyReferenceBuilder)this.getIndex(this.counterpartyReference, index, () -> {
                PartyReference.PartyReferenceBuilder newCounterpartyReference = PartyReference.builder();
                return newCounterpartyReference;
            });
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public SimplePayment.SimplePaymentBuilder getPremium() {
            return this.premium;
        }

        @Override
        public SimplePayment.SimplePaymentBuilder getOrCreatePremium() {
            SimplePayment.SimplePaymentBuilder result = this.premium != null ? this.premium : (this.premium = SimplePayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableDate2.AdjustableDate2Builder getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public AdjustableDate2.AdjustableDate2Builder getOrCreateEffectiveDate() {
            AdjustableDate2.AdjustableDate2Builder result = this.effectiveDate != null ? this.effectiveDate : (this.effectiveDate = AdjustableDate2.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public AdjustableDate2.AdjustableDate2Builder getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public AdjustableDate2.AdjustableDate2Builder getOrCreateExpirationDate() {
            AdjustableDate2.AdjustableDate2Builder result = this.expirationDate != null ? this.expirationDate : (this.expirationDate = AdjustableDate2.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public AdjustableDate2.AdjustableDate2Builder getTerminationDate() {
            return this.terminationDate;
        }

        @Override
        public AdjustableDate2.AdjustableDate2Builder getOrCreateTerminationDate() {
            AdjustableDate2.AdjustableDate2Builder result = this.terminationDate != null ? this.terminationDate : (this.terminationDate = AdjustableDate2.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public List<? extends TradeUnderlyer2.TradeUnderlyer2Builder> getUnderlyer() {
            return this.underlyer;
        }

        @Override
        public TradeUnderlyer2.TradeUnderlyer2Builder getOrCreateUnderlyer(int index) {
            if (this.underlyer == null) {
                this.underlyer = new ArrayList<TradeUnderlyer2.TradeUnderlyer2Builder>();
            }
            return (TradeUnderlyer2.TradeUnderlyer2Builder)this.getIndex(this.underlyer, index, () -> {
                TradeUnderlyer2.TradeUnderlyer2Builder newUnderlyer = TradeUnderlyer2.builder();
                return newUnderlyer;
            });
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public List<? extends CashflowNotional.CashflowNotionalBuilder> getNotional() {
            return this.notional;
        }

        @Override
        public CashflowNotional.CashflowNotionalBuilder getOrCreateNotional(int index) {
            if (this.notional == null) {
                this.notional = new ArrayList<CashflowNotional.CashflowNotionalBuilder>();
            }
            return (CashflowNotional.CashflowNotionalBuilder)this.getIndex(this.notional, index, () -> {
                CashflowNotional.CashflowNotionalBuilder newNotional = CashflowNotional.builder();
                return newNotional;
            });
        }

        @Override
        @RosettaAttribute(value="genericCommodityAttributesModel")
        @RuneAttribute(value="genericCommodityAttributesModel")
        public GenericCommodityAttributesModel.GenericCommodityAttributesModelBuilder getGenericCommodityAttributesModel() {
            return this.genericCommodityAttributesModel;
        }

        @Override
        public GenericCommodityAttributesModel.GenericCommodityAttributesModelBuilder getOrCreateGenericCommodityAttributesModel() {
            GenericCommodityAttributesModel.GenericCommodityAttributesModelBuilder result = this.genericCommodityAttributesModel != null ? this.genericCommodityAttributesModel : (this.genericCommodityAttributesModel = GenericCommodityAttributesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="genericEquityAttributesModel")
        @RuneAttribute(value="genericEquityAttributesModel")
        public GenericEquityAttributesModel.GenericEquityAttributesModelBuilder getGenericEquityAttributesModel() {
            return this.genericEquityAttributesModel;
        }

        @Override
        public GenericEquityAttributesModel.GenericEquityAttributesModelBuilder getOrCreateGenericEquityAttributesModel() {
            GenericEquityAttributesModel.GenericEquityAttributesModelBuilder result = this.genericEquityAttributesModel != null ? this.genericEquityAttributesModel : (this.genericEquityAttributesModel = GenericEquityAttributesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="genericOptionAttributesModel")
        @RuneAttribute(value="genericOptionAttributesModel")
        public GenericOptionAttributesModel.GenericOptionAttributesModelBuilder getGenericOptionAttributesModel() {
            return this.genericOptionAttributesModel;
        }

        @Override
        public GenericOptionAttributesModel.GenericOptionAttributesModelBuilder getOrCreateGenericOptionAttributesModel() {
            GenericOptionAttributesModel.GenericOptionAttributesModelBuilder result = this.genericOptionAttributesModel != null ? this.genericOptionAttributesModel : (this.genericOptionAttributesModel = GenericOptionAttributesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public List<? extends GenericFrequency.GenericFrequencyBuilder> getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        public GenericFrequency.GenericFrequencyBuilder getOrCreatePaymentFrequency(int index) {
            if (this.paymentFrequency == null) {
                this.paymentFrequency = new ArrayList<GenericFrequency.GenericFrequencyBuilder>();
            }
            return (GenericFrequency.GenericFrequencyBuilder)this.getIndex(this.paymentFrequency, index, () -> {
                GenericFrequency.GenericFrequencyBuilder newPaymentFrequency = GenericFrequency.builder();
                return newPaymentFrequency;
            });
        }

        @Override
        @RosettaAttribute(value="resetFrequency")
        @RuneAttribute(value="resetFrequency")
        public List<? extends GenericResetFrequency.GenericResetFrequencyBuilder> getResetFrequency() {
            return this.resetFrequency;
        }

        @Override
        public GenericResetFrequency.GenericResetFrequencyBuilder getOrCreateResetFrequency(int index) {
            if (this.resetFrequency == null) {
                this.resetFrequency = new ArrayList<GenericResetFrequency.GenericResetFrequencyBuilder>();
            }
            return (GenericResetFrequency.GenericResetFrequencyBuilder)this.getIndex(this.resetFrequency, index, () -> {
                GenericResetFrequency.GenericResetFrequencyBuilder newResetFrequency = GenericResetFrequency.builder();
                return newResetFrequency;
            });
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public List<? extends IdentifiedCurrency.IdentifiedCurrencyBuilder> getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreateSettlementCurrency(int index) {
            if (this.settlementCurrency == null) {
                this.settlementCurrency = new ArrayList<IdentifiedCurrency.IdentifiedCurrencyBuilder>();
            }
            return (IdentifiedCurrency.IdentifiedCurrencyBuilder)this.getIndex(this.settlementCurrency, index, () -> {
                IdentifiedCurrency.IdentifiedCurrencyBuilder newSettlementCurrency = IdentifiedCurrency.builder();
                return newSettlementCurrency;
            });
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends Payment.PaymentBuilder> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        public Payment.PaymentBuilder getOrCreateAdditionalPayment(int index) {
            if (this.additionalPayment == null) {
                this.additionalPayment = new ArrayList<Payment.PaymentBuilder>();
            }
            return (Payment.PaymentBuilder)this.getIndex(this.additionalPayment, index, () -> {
                Payment.PaymentBuilder newAdditionalPayment = Payment.builder();
                return newAdditionalPayment;
            });
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public GenericProductBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public GenericProductBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="multiLeg")
        @RuneAttribute(value="multiLeg")
        public GenericProductBuilder setMultiLeg(Boolean _multiLeg) {
            this.multiLeg = _multiLeg == null ? null : _multiLeg;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel")
        @RuneAttribute(value="buyerSellerModel")
        public GenericProductBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="counterpartyReference")
        @RuneAttribute(value="counterpartyReference")
        public GenericProductBuilder addCounterpartyReference(PartyReference _counterpartyReference) {
            if (_counterpartyReference != null) {
                this.counterpartyReference.add(_counterpartyReference.toBuilder());
            }
            return this;
        }

        @Override
        public GenericProductBuilder addCounterpartyReference(PartyReference _counterpartyReference, int idx) {
            this.getIndex(this.counterpartyReference, idx, () -> _counterpartyReference.toBuilder());
            return this;
        }

        @Override
        public GenericProductBuilder addCounterpartyReference(List<? extends PartyReference> counterpartyReferences) {
            if (counterpartyReferences != null) {
                for (PartyReference partyReference : counterpartyReferences) {
                    this.counterpartyReference.add(partyReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="counterpartyReference")
        public GenericProductBuilder setCounterpartyReference(List<? extends PartyReference> counterpartyReferences) {
            this.counterpartyReference = counterpartyReferences == null ? new ArrayList<PartyReference.PartyReferenceBuilder>() : (List)counterpartyReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public GenericProductBuilder setPremium(SimplePayment _premium) {
            this.premium = _premium == null ? null : _premium.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public GenericProductBuilder setEffectiveDate(AdjustableDate2 _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public GenericProductBuilder setExpirationDate(AdjustableDate2 _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public GenericProductBuilder setTerminationDate(AdjustableDate2 _terminationDate) {
            this.terminationDate = _terminationDate == null ? null : _terminationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public GenericProductBuilder addUnderlyer(TradeUnderlyer2 _underlyer) {
            if (_underlyer != null) {
                this.underlyer.add(_underlyer.toBuilder());
            }
            return this;
        }

        @Override
        public GenericProductBuilder addUnderlyer(TradeUnderlyer2 _underlyer, int idx) {
            this.getIndex(this.underlyer, idx, () -> _underlyer.toBuilder());
            return this;
        }

        @Override
        public GenericProductBuilder addUnderlyer(List<? extends TradeUnderlyer2> underlyers) {
            if (underlyers != null) {
                for (TradeUnderlyer2 tradeUnderlyer2 : underlyers) {
                    this.underlyer.add(tradeUnderlyer2.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="underlyer")
        public GenericProductBuilder setUnderlyer(List<? extends TradeUnderlyer2> underlyers) {
            this.underlyer = underlyers == null ? new ArrayList<TradeUnderlyer2.TradeUnderlyer2Builder>() : (List)underlyers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public GenericProductBuilder addNotional(CashflowNotional _notional) {
            if (_notional != null) {
                this.notional.add(_notional.toBuilder());
            }
            return this;
        }

        @Override
        public GenericProductBuilder addNotional(CashflowNotional _notional, int idx) {
            this.getIndex(this.notional, idx, () -> _notional.toBuilder());
            return this;
        }

        @Override
        public GenericProductBuilder addNotional(List<? extends CashflowNotional> notionals) {
            if (notionals != null) {
                for (CashflowNotional cashflowNotional : notionals) {
                    this.notional.add(cashflowNotional.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notional")
        public GenericProductBuilder setNotional(List<? extends CashflowNotional> notionals) {
            this.notional = notionals == null ? new ArrayList<CashflowNotional.CashflowNotionalBuilder>() : (List)notionals.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="genericCommodityAttributesModel")
        @RuneAttribute(value="genericCommodityAttributesModel")
        public GenericProductBuilder setGenericCommodityAttributesModel(GenericCommodityAttributesModel _genericCommodityAttributesModel) {
            this.genericCommodityAttributesModel = _genericCommodityAttributesModel == null ? null : _genericCommodityAttributesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="genericEquityAttributesModel")
        @RuneAttribute(value="genericEquityAttributesModel")
        public GenericProductBuilder setGenericEquityAttributesModel(GenericEquityAttributesModel _genericEquityAttributesModel) {
            this.genericEquityAttributesModel = _genericEquityAttributesModel == null ? null : _genericEquityAttributesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="genericOptionAttributesModel")
        @RuneAttribute(value="genericOptionAttributesModel")
        public GenericProductBuilder setGenericOptionAttributesModel(GenericOptionAttributesModel _genericOptionAttributesModel) {
            this.genericOptionAttributesModel = _genericOptionAttributesModel == null ? null : _genericOptionAttributesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public GenericProductBuilder addPaymentFrequency(GenericFrequency _paymentFrequency) {
            if (_paymentFrequency != null) {
                this.paymentFrequency.add(_paymentFrequency.toBuilder());
            }
            return this;
        }

        @Override
        public GenericProductBuilder addPaymentFrequency(GenericFrequency _paymentFrequency, int idx) {
            this.getIndex(this.paymentFrequency, idx, () -> _paymentFrequency.toBuilder());
            return this;
        }

        @Override
        public GenericProductBuilder addPaymentFrequency(List<? extends GenericFrequency> paymentFrequencys) {
            if (paymentFrequencys != null) {
                for (GenericFrequency genericFrequency : paymentFrequencys) {
                    this.paymentFrequency.add(genericFrequency.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="paymentFrequency")
        public GenericProductBuilder setPaymentFrequency(List<? extends GenericFrequency> paymentFrequencys) {
            this.paymentFrequency = paymentFrequencys == null ? new ArrayList<GenericFrequency.GenericFrequencyBuilder>() : (List)paymentFrequencys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="resetFrequency")
        @RuneAttribute(value="resetFrequency")
        public GenericProductBuilder addResetFrequency(GenericResetFrequency _resetFrequency) {
            if (_resetFrequency != null) {
                this.resetFrequency.add(_resetFrequency.toBuilder());
            }
            return this;
        }

        @Override
        public GenericProductBuilder addResetFrequency(GenericResetFrequency _resetFrequency, int idx) {
            this.getIndex(this.resetFrequency, idx, () -> _resetFrequency.toBuilder());
            return this;
        }

        @Override
        public GenericProductBuilder addResetFrequency(List<? extends GenericResetFrequency> resetFrequencys) {
            if (resetFrequencys != null) {
                for (GenericResetFrequency genericResetFrequency : resetFrequencys) {
                    this.resetFrequency.add(genericResetFrequency.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="resetFrequency")
        public GenericProductBuilder setResetFrequency(List<? extends GenericResetFrequency> resetFrequencys) {
            this.resetFrequency = resetFrequencys == null ? new ArrayList<GenericResetFrequency.GenericResetFrequencyBuilder>() : (List)resetFrequencys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public GenericProductBuilder addSettlementCurrency(IdentifiedCurrency _settlementCurrency) {
            if (_settlementCurrency != null) {
                this.settlementCurrency.add(_settlementCurrency.toBuilder());
            }
            return this;
        }

        @Override
        public GenericProductBuilder addSettlementCurrency(IdentifiedCurrency _settlementCurrency, int idx) {
            this.getIndex(this.settlementCurrency, idx, () -> _settlementCurrency.toBuilder());
            return this;
        }

        @Override
        public GenericProductBuilder addSettlementCurrency(List<? extends IdentifiedCurrency> settlementCurrencys) {
            if (settlementCurrencys != null) {
                for (IdentifiedCurrency identifiedCurrency : settlementCurrencys) {
                    this.settlementCurrency.add(identifiedCurrency.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="settlementCurrency")
        public GenericProductBuilder setSettlementCurrency(List<? extends IdentifiedCurrency> settlementCurrencys) {
            this.settlementCurrency = settlementCurrencys == null ? new ArrayList<IdentifiedCurrency.IdentifiedCurrencyBuilder>() : (List)settlementCurrencys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public GenericProductBuilder setSettlementType(SettlementTypeEnum _settlementType) {
            this.settlementType = _settlementType == null ? null : _settlementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public GenericProductBuilder addAdditionalPayment(Payment _additionalPayment) {
            if (_additionalPayment != null) {
                this.additionalPayment.add(_additionalPayment.toBuilder());
            }
            return this;
        }

        @Override
        public GenericProductBuilder addAdditionalPayment(Payment _additionalPayment, int idx) {
            this.getIndex(this.additionalPayment, idx, () -> _additionalPayment.toBuilder());
            return this;
        }

        @Override
        public GenericProductBuilder addAdditionalPayment(List<? extends Payment> additionalPayments) {
            if (additionalPayments != null) {
                for (Payment payment : additionalPayments) {
                    this.additionalPayment.add(payment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalPayment")
        public GenericProductBuilder setAdditionalPayment(List<? extends Payment> additionalPayments) {
            this.additionalPayment = additionalPayments == null ? new ArrayList<Payment.PaymentBuilder>() : (List)additionalPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public GenericProduct build() {
            return new GenericProductImpl(this);
        }

        @Override
        public GenericProductBuilder toBuilder() {
            return this;
        }

        @Override
        public GenericProductBuilder prune() {
            super.prune();
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            this.counterpartyReference = this.counterpartyReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.premium != null && !this.premium.prune().hasData()) {
                this.premium = null;
            }
            if (this.effectiveDate != null && !this.effectiveDate.prune().hasData()) {
                this.effectiveDate = null;
            }
            if (this.expirationDate != null && !this.expirationDate.prune().hasData()) {
                this.expirationDate = null;
            }
            if (this.terminationDate != null && !this.terminationDate.prune().hasData()) {
                this.terminationDate = null;
            }
            this.underlyer = this.underlyer.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.notional = this.notional.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.genericCommodityAttributesModel != null && !this.genericCommodityAttributesModel.prune().hasData()) {
                this.genericCommodityAttributesModel = null;
            }
            if (this.genericEquityAttributesModel != null && !this.genericEquityAttributesModel.prune().hasData()) {
                this.genericEquityAttributesModel = null;
            }
            if (this.genericOptionAttributesModel != null && !this.genericOptionAttributesModel.prune().hasData()) {
                this.genericOptionAttributesModel = null;
            }
            this.paymentFrequency = this.paymentFrequency.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.resetFrequency = this.resetFrequency.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.settlementCurrency = this.settlementCurrency.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.additionalPayment = this.additionalPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getMultiLeg() != null) {
                return true;
            }
            if (this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData()) {
                return true;
            }
            if (this.getCounterpartyReference() != null && this.getCounterpartyReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPremium() != null && this.getPremium().hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null && this.getEffectiveDate().hasData()) {
                return true;
            }
            if (this.getExpirationDate() != null && this.getExpirationDate().hasData()) {
                return true;
            }
            if (this.getTerminationDate() != null && this.getTerminationDate().hasData()) {
                return true;
            }
            if (this.getUnderlyer() != null && this.getUnderlyer().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getNotional() != null && this.getNotional().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getGenericCommodityAttributesModel() != null && this.getGenericCommodityAttributesModel().hasData()) {
                return true;
            }
            if (this.getGenericEquityAttributesModel() != null && this.getGenericEquityAttributesModel().hasData()) {
                return true;
            }
            if (this.getGenericOptionAttributesModel() != null && this.getGenericOptionAttributesModel().hasData()) {
                return true;
            }
            if (this.getPaymentFrequency() != null && this.getPaymentFrequency().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getResetFrequency() != null && this.getResetFrequency().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSettlementCurrency() != null && this.getSettlementCurrency().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSettlementType() != null) {
                return true;
            }
            return this.getAdditionalPayment() != null && this.getAdditionalPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public GenericProductBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            GenericProductBuilder o = (GenericProductBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            merger.mergeRosetta(this.getCounterpartyReference(), o.getCounterpartyReference(), this::getOrCreateCounterpartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPremium(), (RosettaModelObjectBuilder)o.getPremium(), this::setPremium);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectiveDate(), (RosettaModelObjectBuilder)o.getEffectiveDate(), this::setEffectiveDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExpirationDate(), (RosettaModelObjectBuilder)o.getExpirationDate(), this::setExpirationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTerminationDate(), (RosettaModelObjectBuilder)o.getTerminationDate(), this::setTerminationDate);
            merger.mergeRosetta(this.getUnderlyer(), o.getUnderlyer(), this::getOrCreateUnderlyer);
            merger.mergeRosetta(this.getNotional(), o.getNotional(), this::getOrCreateNotional);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGenericCommodityAttributesModel(), (RosettaModelObjectBuilder)o.getGenericCommodityAttributesModel(), this::setGenericCommodityAttributesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGenericEquityAttributesModel(), (RosettaModelObjectBuilder)o.getGenericEquityAttributesModel(), this::setGenericEquityAttributesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGenericOptionAttributesModel(), (RosettaModelObjectBuilder)o.getGenericOptionAttributesModel(), this::setGenericOptionAttributesModel);
            merger.mergeRosetta(this.getPaymentFrequency(), o.getPaymentFrequency(), this::getOrCreatePaymentFrequency);
            merger.mergeRosetta(this.getResetFrequency(), o.getResetFrequency(), this::getOrCreateResetFrequency);
            merger.mergeRosetta(this.getSettlementCurrency(), o.getSettlementCurrency(), this::getOrCreateSettlementCurrency);
            merger.mergeRosetta(this.getAdditionalPayment(), o.getAdditionalPayment(), this::getOrCreateAdditionalPayment);
            merger.mergeBasic((Object)this.getMultiLeg(), (Object)o.getMultiLeg(), this::setMultiLeg, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementType(), (Object)o.getSettlementType(), this::setSettlementType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GenericProduct _that = (GenericProduct)this.getType().cast(o);
            if (!Objects.equals(this.multiLeg, _that.getMultiLeg())) {
                return false;
            }
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterpartyReference, _that.getCounterpartyReference())) {
                return false;
            }
            if (!Objects.equals(this.premium, _that.getPremium())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.terminationDate, _that.getTerminationDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.underlyer, _that.getUnderlyer())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.genericCommodityAttributesModel, _that.getGenericCommodityAttributesModel())) {
                return false;
            }
            if (!Objects.equals(this.genericEquityAttributesModel, _that.getGenericEquityAttributesModel())) {
                return false;
            }
            if (!Objects.equals(this.genericOptionAttributesModel, _that.getGenericOptionAttributesModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.resetFrequency, _that.getResetFrequency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            return ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.multiLeg != null ? this.multiLeg.hashCode() : 0);
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.counterpartyReference != null ? this.counterpartyReference.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.terminationDate != null ? this.terminationDate.hashCode() : 0);
            _result = 31 * _result + (this.underlyer != null ? this.underlyer.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.genericCommodityAttributesModel != null ? this.genericCommodityAttributesModel.hashCode() : 0);
            _result = 31 * _result + (this.genericEquityAttributesModel != null ? this.genericEquityAttributesModel.hashCode() : 0);
            _result = 31 * _result + (this.genericOptionAttributesModel != null ? this.genericOptionAttributesModel.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.resetFrequency != null ? this.resetFrequency.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "GenericProductBuilder {multiLeg=" + this.multiLeg + ", buyerSellerModel=" + this.buyerSellerModel + ", counterpartyReference=" + this.counterpartyReference + ", premium=" + this.premium + ", effectiveDate=" + this.effectiveDate + ", expirationDate=" + this.expirationDate + ", terminationDate=" + this.terminationDate + ", underlyer=" + this.underlyer + ", notional=" + this.notional + ", genericCommodityAttributesModel=" + this.genericCommodityAttributesModel + ", genericEquityAttributesModel=" + this.genericEquityAttributesModel + ", genericOptionAttributesModel=" + this.genericOptionAttributesModel + ", paymentFrequency=" + this.paymentFrequency + ", resetFrequency=" + this.resetFrequency + ", settlementCurrency=" + this.settlementCurrency + ", settlementType=" + (Object)((Object)this.settlementType) + ", additionalPayment=" + this.additionalPayment + '}' + " " + super.toString();
        }
    }

    public static interface GenericProductBuilder
    extends GenericProduct,
    Product.ProductBuilder {
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        public PartyReference.PartyReferenceBuilder getOrCreateCounterpartyReference(int var1);

        public List<? extends PartyReference.PartyReferenceBuilder> getCounterpartyReference();

        public SimplePayment.SimplePaymentBuilder getOrCreatePremium();

        @Override
        public SimplePayment.SimplePaymentBuilder getPremium();

        public AdjustableDate2.AdjustableDate2Builder getOrCreateEffectiveDate();

        @Override
        public AdjustableDate2.AdjustableDate2Builder getEffectiveDate();

        public AdjustableDate2.AdjustableDate2Builder getOrCreateExpirationDate();

        @Override
        public AdjustableDate2.AdjustableDate2Builder getExpirationDate();

        public AdjustableDate2.AdjustableDate2Builder getOrCreateTerminationDate();

        @Override
        public AdjustableDate2.AdjustableDate2Builder getTerminationDate();

        public TradeUnderlyer2.TradeUnderlyer2Builder getOrCreateUnderlyer(int var1);

        public List<? extends TradeUnderlyer2.TradeUnderlyer2Builder> getUnderlyer();

        public CashflowNotional.CashflowNotionalBuilder getOrCreateNotional(int var1);

        public List<? extends CashflowNotional.CashflowNotionalBuilder> getNotional();

        public GenericCommodityAttributesModel.GenericCommodityAttributesModelBuilder getOrCreateGenericCommodityAttributesModel();

        @Override
        public GenericCommodityAttributesModel.GenericCommodityAttributesModelBuilder getGenericCommodityAttributesModel();

        public GenericEquityAttributesModel.GenericEquityAttributesModelBuilder getOrCreateGenericEquityAttributesModel();

        @Override
        public GenericEquityAttributesModel.GenericEquityAttributesModelBuilder getGenericEquityAttributesModel();

        public GenericOptionAttributesModel.GenericOptionAttributesModelBuilder getOrCreateGenericOptionAttributesModel();

        @Override
        public GenericOptionAttributesModel.GenericOptionAttributesModelBuilder getGenericOptionAttributesModel();

        public GenericFrequency.GenericFrequencyBuilder getOrCreatePaymentFrequency(int var1);

        public List<? extends GenericFrequency.GenericFrequencyBuilder> getPaymentFrequency();

        public GenericResetFrequency.GenericResetFrequencyBuilder getOrCreateResetFrequency(int var1);

        public List<? extends GenericResetFrequency.GenericResetFrequencyBuilder> getResetFrequency();

        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreateSettlementCurrency(int var1);

        public List<? extends IdentifiedCurrency.IdentifiedCurrencyBuilder> getSettlementCurrency();

        public Payment.PaymentBuilder getOrCreateAdditionalPayment(int var1);

        public List<? extends Payment.PaymentBuilder> getAdditionalPayment();

        @Override
        public GenericProductBuilder setProductModel(ProductModel var1);

        @Override
        public GenericProductBuilder setId(String var1);

        public GenericProductBuilder setMultiLeg(Boolean var1);

        public GenericProductBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public GenericProductBuilder addCounterpartyReference(PartyReference var1);

        public GenericProductBuilder addCounterpartyReference(PartyReference var1, int var2);

        public GenericProductBuilder addCounterpartyReference(List<? extends PartyReference> var1);

        public GenericProductBuilder setCounterpartyReference(List<? extends PartyReference> var1);

        public GenericProductBuilder setPremium(SimplePayment var1);

        public GenericProductBuilder setEffectiveDate(AdjustableDate2 var1);

        public GenericProductBuilder setExpirationDate(AdjustableDate2 var1);

        public GenericProductBuilder setTerminationDate(AdjustableDate2 var1);

        public GenericProductBuilder addUnderlyer(TradeUnderlyer2 var1);

        public GenericProductBuilder addUnderlyer(TradeUnderlyer2 var1, int var2);

        public GenericProductBuilder addUnderlyer(List<? extends TradeUnderlyer2> var1);

        public GenericProductBuilder setUnderlyer(List<? extends TradeUnderlyer2> var1);

        public GenericProductBuilder addNotional(CashflowNotional var1);

        public GenericProductBuilder addNotional(CashflowNotional var1, int var2);

        public GenericProductBuilder addNotional(List<? extends CashflowNotional> var1);

        public GenericProductBuilder setNotional(List<? extends CashflowNotional> var1);

        public GenericProductBuilder setGenericCommodityAttributesModel(GenericCommodityAttributesModel var1);

        public GenericProductBuilder setGenericEquityAttributesModel(GenericEquityAttributesModel var1);

        public GenericProductBuilder setGenericOptionAttributesModel(GenericOptionAttributesModel var1);

        public GenericProductBuilder addPaymentFrequency(GenericFrequency var1);

        public GenericProductBuilder addPaymentFrequency(GenericFrequency var1, int var2);

        public GenericProductBuilder addPaymentFrequency(List<? extends GenericFrequency> var1);

        public GenericProductBuilder setPaymentFrequency(List<? extends GenericFrequency> var1);

        public GenericProductBuilder addResetFrequency(GenericResetFrequency var1);

        public GenericProductBuilder addResetFrequency(GenericResetFrequency var1, int var2);

        public GenericProductBuilder addResetFrequency(List<? extends GenericResetFrequency> var1);

        public GenericProductBuilder setResetFrequency(List<? extends GenericResetFrequency> var1);

        public GenericProductBuilder addSettlementCurrency(IdentifiedCurrency var1);

        public GenericProductBuilder addSettlementCurrency(IdentifiedCurrency var1, int var2);

        public GenericProductBuilder addSettlementCurrency(List<? extends IdentifiedCurrency> var1);

        public GenericProductBuilder setSettlementCurrency(List<? extends IdentifiedCurrency> var1);

        public GenericProductBuilder setSettlementType(SettlementTypeEnum var1);

        public GenericProductBuilder addAdditionalPayment(Payment var1);

        public GenericProductBuilder addAdditionalPayment(Payment var1, int var2);

        public GenericProductBuilder addAdditionalPayment(List<? extends Payment> var1);

        public GenericProductBuilder setAdditionalPayment(List<? extends Payment> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("multiLeg"), Boolean.class, (Object)this.getMultiLeg(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterpartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getCounterpartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, SimplePayment.SimplePaymentBuilder.class, this.getPremium(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableDate2.AdjustableDate2Builder.class, this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableDate2.AdjustableDate2Builder.class, this.getExpirationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableDate2.AdjustableDate2Builder.class, this.getTerminationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, TradeUnderlyer2.TradeUnderlyer2Builder.class, this.getUnderlyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notional"), processor, CashflowNotional.CashflowNotionalBuilder.class, this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("genericCommodityAttributesModel"), processor, GenericCommodityAttributesModel.GenericCommodityAttributesModelBuilder.class, this.getGenericCommodityAttributesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("genericEquityAttributesModel"), processor, GenericEquityAttributesModel.GenericEquityAttributesModelBuilder.class, this.getGenericEquityAttributesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("genericOptionAttributesModel"), processor, GenericOptionAttributesModel.GenericOptionAttributesModelBuilder.class, this.getGenericOptionAttributesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, GenericFrequency.GenericFrequencyBuilder.class, this.getPaymentFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("resetFrequency"), processor, GenericResetFrequency.GenericResetFrequencyBuilder.class, this.getResetFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementCurrency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, this.getSettlementCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalPayment"), processor, Payment.PaymentBuilder.class, this.getAdditionalPayment(), new AttributeMeta[0]);
        }

        @Override
        public GenericProductBuilder prune();
    }

    public static class GenericProductImpl
    extends Product.ProductImpl
    implements GenericProduct {
        private final Boolean multiLeg;
        private final BuyerSellerModel buyerSellerModel;
        private final List<? extends PartyReference> counterpartyReference;
        private final SimplePayment premium;
        private final AdjustableDate2 effectiveDate;
        private final AdjustableDate2 expirationDate;
        private final AdjustableDate2 terminationDate;
        private final List<? extends TradeUnderlyer2> underlyer;
        private final List<? extends CashflowNotional> notional;
        private final GenericCommodityAttributesModel genericCommodityAttributesModel;
        private final GenericEquityAttributesModel genericEquityAttributesModel;
        private final GenericOptionAttributesModel genericOptionAttributesModel;
        private final List<? extends GenericFrequency> paymentFrequency;
        private final List<? extends GenericResetFrequency> resetFrequency;
        private final List<? extends IdentifiedCurrency> settlementCurrency;
        private final SettlementTypeEnum settlementType;
        private final List<? extends Payment> additionalPayment;

        protected GenericProductImpl(GenericProductBuilder builder) {
            super(builder);
            this.multiLeg = builder.getMultiLeg();
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
            this.counterpartyReference = Optional.ofNullable(builder.getCounterpartyReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.premium = Optional.ofNullable(builder.getPremium()).map(f -> f.build()).orElse(null);
            this.effectiveDate = Optional.ofNullable(builder.getEffectiveDate()).map(f -> f.build()).orElse(null);
            this.expirationDate = Optional.ofNullable(builder.getExpirationDate()).map(f -> f.build()).orElse(null);
            this.terminationDate = Optional.ofNullable(builder.getTerminationDate()).map(f -> f.build()).orElse(null);
            this.underlyer = Optional.ofNullable(builder.getUnderlyer()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.notional = Optional.ofNullable(builder.getNotional()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.genericCommodityAttributesModel = Optional.ofNullable(builder.getGenericCommodityAttributesModel()).map(f -> f.build()).orElse(null);
            this.genericEquityAttributesModel = Optional.ofNullable(builder.getGenericEquityAttributesModel()).map(f -> f.build()).orElse(null);
            this.genericOptionAttributesModel = Optional.ofNullable(builder.getGenericOptionAttributesModel()).map(f -> f.build()).orElse(null);
            this.paymentFrequency = Optional.ofNullable(builder.getPaymentFrequency()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.resetFrequency = Optional.ofNullable(builder.getResetFrequency()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.settlementCurrency = Optional.ofNullable(builder.getSettlementCurrency()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.settlementType = builder.getSettlementType();
            this.additionalPayment = Optional.ofNullable(builder.getAdditionalPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="multiLeg")
        @RuneAttribute(value="multiLeg")
        public Boolean getMultiLeg() {
            return this.multiLeg;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel")
        @RuneAttribute(value="buyerSellerModel")
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        @RosettaAttribute(value="counterpartyReference")
        @RuneAttribute(value="counterpartyReference")
        public List<? extends PartyReference> getCounterpartyReference() {
            return this.counterpartyReference;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public SimplePayment getPremium() {
            return this.premium;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableDate2 getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public AdjustableDate2 getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public AdjustableDate2 getTerminationDate() {
            return this.terminationDate;
        }

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public List<? extends TradeUnderlyer2> getUnderlyer() {
            return this.underlyer;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public List<? extends CashflowNotional> getNotional() {
            return this.notional;
        }

        @Override
        @RosettaAttribute(value="genericCommodityAttributesModel")
        @RuneAttribute(value="genericCommodityAttributesModel")
        public GenericCommodityAttributesModel getGenericCommodityAttributesModel() {
            return this.genericCommodityAttributesModel;
        }

        @Override
        @RosettaAttribute(value="genericEquityAttributesModel")
        @RuneAttribute(value="genericEquityAttributesModel")
        public GenericEquityAttributesModel getGenericEquityAttributesModel() {
            return this.genericEquityAttributesModel;
        }

        @Override
        @RosettaAttribute(value="genericOptionAttributesModel")
        @RuneAttribute(value="genericOptionAttributesModel")
        public GenericOptionAttributesModel getGenericOptionAttributesModel() {
            return this.genericOptionAttributesModel;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public List<? extends GenericFrequency> getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        @RosettaAttribute(value="resetFrequency")
        @RuneAttribute(value="resetFrequency")
        public List<? extends GenericResetFrequency> getResetFrequency() {
            return this.resetFrequency;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public List<? extends IdentifiedCurrency> getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends Payment> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        public GenericProduct build() {
            return this;
        }

        @Override
        public GenericProductBuilder toBuilder() {
            GenericProductBuilder builder = GenericProduct.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(GenericProductBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getMultiLeg()).ifPresent(builder::setMultiLeg);
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
            Optional.ofNullable(this.getCounterpartyReference()).ifPresent(builder::setCounterpartyReference);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
            Optional.ofNullable(this.getTerminationDate()).ifPresent(builder::setTerminationDate);
            Optional.ofNullable(this.getUnderlyer()).ifPresent(builder::setUnderlyer);
            Optional.ofNullable(this.getNotional()).ifPresent(builder::setNotional);
            Optional.ofNullable(this.getGenericCommodityAttributesModel()).ifPresent(builder::setGenericCommodityAttributesModel);
            Optional.ofNullable(this.getGenericEquityAttributesModel()).ifPresent(builder::setGenericEquityAttributesModel);
            Optional.ofNullable(this.getGenericOptionAttributesModel()).ifPresent(builder::setGenericOptionAttributesModel);
            Optional.ofNullable(this.getPaymentFrequency()).ifPresent(builder::setPaymentFrequency);
            Optional.ofNullable(this.getResetFrequency()).ifPresent(builder::setResetFrequency);
            Optional.ofNullable(this.getSettlementCurrency()).ifPresent(builder::setSettlementCurrency);
            Optional.ofNullable(this.getSettlementType()).ifPresent(builder::setSettlementType);
            Optional.ofNullable(this.getAdditionalPayment()).ifPresent(builder::setAdditionalPayment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GenericProduct _that = (GenericProduct)this.getType().cast(o);
            if (!Objects.equals(this.multiLeg, _that.getMultiLeg())) {
                return false;
            }
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterpartyReference, _that.getCounterpartyReference())) {
                return false;
            }
            if (!Objects.equals(this.premium, _that.getPremium())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.terminationDate, _that.getTerminationDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.underlyer, _that.getUnderlyer())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.genericCommodityAttributesModel, _that.getGenericCommodityAttributesModel())) {
                return false;
            }
            if (!Objects.equals(this.genericEquityAttributesModel, _that.getGenericEquityAttributesModel())) {
                return false;
            }
            if (!Objects.equals(this.genericOptionAttributesModel, _that.getGenericOptionAttributesModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.resetFrequency, _that.getResetFrequency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            return ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.multiLeg != null ? this.multiLeg.hashCode() : 0);
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.counterpartyReference != null ? this.counterpartyReference.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.terminationDate != null ? this.terminationDate.hashCode() : 0);
            _result = 31 * _result + (this.underlyer != null ? this.underlyer.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.genericCommodityAttributesModel != null ? this.genericCommodityAttributesModel.hashCode() : 0);
            _result = 31 * _result + (this.genericEquityAttributesModel != null ? this.genericEquityAttributesModel.hashCode() : 0);
            _result = 31 * _result + (this.genericOptionAttributesModel != null ? this.genericOptionAttributesModel.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.resetFrequency != null ? this.resetFrequency.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "GenericProduct {multiLeg=" + this.multiLeg + ", buyerSellerModel=" + this.buyerSellerModel + ", counterpartyReference=" + this.counterpartyReference + ", premium=" + this.premium + ", effectiveDate=" + this.effectiveDate + ", expirationDate=" + this.expirationDate + ", terminationDate=" + this.terminationDate + ", underlyer=" + this.underlyer + ", notional=" + this.notional + ", genericCommodityAttributesModel=" + this.genericCommodityAttributesModel + ", genericEquityAttributesModel=" + this.genericEquityAttributesModel + ", genericOptionAttributesModel=" + this.genericOptionAttributesModel + ", paymentFrequency=" + this.paymentFrequency + ", resetFrequency=" + this.resetFrequency + ", settlementCurrency=" + this.settlementCurrency + ", settlementType=" + (Object)((Object)this.settlementType) + ", additionalPayment=" + this.additionalPayment + '}' + " " + super.toString();
        }
    }
}

