/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.targets;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fx.targets.FxSchedule;
import fpml.consolidated.fx.targets.FxScheduleSequence0;
import fpml.consolidated.fx.targets.FxScheduleSequence1;
import fpml.consolidated.fx.targets.meta.FxExpiryScheduleMeta;
import fpml.consolidated.shared.BusinessCenterTime;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxExpirySchedule", builder=FxExpiryScheduleBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FxExpirySchedule", model="fpml", builder=FxExpiryScheduleBuilderImpl.class, version="1.1.0")
public interface FxExpirySchedule
extends FxSchedule {
    public static final FxExpiryScheduleMeta metaData = new FxExpiryScheduleMeta();

    public ZonedDateTime getFinalExpiryDate();

    public BusinessCenterTime getExpiryTime();

    @Override
    public FxExpirySchedule build();

    @Override
    public FxExpiryScheduleBuilder toBuilder();

    public static FxExpiryScheduleBuilder builder() {
        return new FxExpiryScheduleBuilderImpl();
    }

    default public RosettaMetaData<? extends FxExpirySchedule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxExpirySchedule> getType() {
        return FxExpirySchedule.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("fxScheduleSequence0"), processor, FxScheduleSequence0.class, this.getFxScheduleSequence0(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxScheduleSequence1"), processor, FxScheduleSequence1.class, this.getFxScheduleSequence1(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalExpiryDate"), ZonedDateTime.class, (Object)this.getFinalExpiryDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expiryTime"), processor, BusinessCenterTime.class, this.getExpiryTime(), new AttributeMeta[0]);
    }

    public static class FxExpiryScheduleBuilderImpl
    extends FxSchedule.FxScheduleBuilderImpl
    implements FxExpiryScheduleBuilder {
        protected ZonedDateTime finalExpiryDate;
        protected BusinessCenterTime.BusinessCenterTimeBuilder expiryTime;

        @Override
        @RosettaAttribute(value="finalExpiryDate")
        @RuneAttribute(value="finalExpiryDate")
        public ZonedDateTime getFinalExpiryDate() {
            return this.finalExpiryDate;
        }

        @Override
        @RosettaAttribute(value="expiryTime")
        @RuneAttribute(value="expiryTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getExpiryTime() {
            return this.expiryTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExpiryTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.expiryTime != null ? this.expiryTime : (this.expiryTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxScheduleSequence0")
        @RuneAttribute(value="fxScheduleSequence0")
        public FxExpiryScheduleBuilder setFxScheduleSequence0(FxScheduleSequence0 _fxScheduleSequence0) {
            this.fxScheduleSequence0 = _fxScheduleSequence0 == null ? null : _fxScheduleSequence0.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxScheduleSequence1")
        @RuneAttribute(value="fxScheduleSequence1")
        public FxExpiryScheduleBuilder setFxScheduleSequence1(FxScheduleSequence1 _fxScheduleSequence1) {
            this.fxScheduleSequence1 = _fxScheduleSequence1 == null ? null : _fxScheduleSequence1.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxExpiryScheduleBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalExpiryDate")
        @RuneAttribute(value="finalExpiryDate")
        public FxExpiryScheduleBuilder setFinalExpiryDate(ZonedDateTime _finalExpiryDate) {
            this.finalExpiryDate = _finalExpiryDate == null ? null : _finalExpiryDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="expiryTime")
        @RuneAttribute(value="expiryTime")
        public FxExpiryScheduleBuilder setExpiryTime(BusinessCenterTime _expiryTime) {
            this.expiryTime = _expiryTime == null ? null : _expiryTime.toBuilder();
            return this;
        }

        @Override
        public FxExpirySchedule build() {
            return new FxExpiryScheduleImpl(this);
        }

        @Override
        public FxExpiryScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public FxExpiryScheduleBuilder prune() {
            super.prune();
            if (this.expiryTime != null && !this.expiryTime.prune().hasData()) {
                this.expiryTime = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFinalExpiryDate() != null) {
                return true;
            }
            return this.getExpiryTime() != null && this.getExpiryTime().hasData();
        }

        @Override
        public FxExpiryScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxExpiryScheduleBuilder o = (FxExpiryScheduleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExpiryTime(), (RosettaModelObjectBuilder)o.getExpiryTime(), this::setExpiryTime);
            merger.mergeBasic((Object)this.getFinalExpiryDate(), (Object)o.getFinalExpiryDate(), this::setFinalExpiryDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxExpirySchedule _that = (FxExpirySchedule)this.getType().cast(o);
            if (!Objects.equals(this.finalExpiryDate, _that.getFinalExpiryDate())) {
                return false;
            }
            return Objects.equals(this.expiryTime, _that.getExpiryTime());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.finalExpiryDate != null ? this.finalExpiryDate.hashCode() : 0);
            _result = 31 * _result + (this.expiryTime != null ? this.expiryTime.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxExpiryScheduleBuilder {finalExpiryDate=" + this.finalExpiryDate + ", expiryTime=" + this.expiryTime + '}' + " " + super.toString();
        }
    }

    public static interface FxExpiryScheduleBuilder
    extends FxExpirySchedule,
    FxSchedule.FxScheduleBuilder {
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExpiryTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getExpiryTime();

        @Override
        public FxExpiryScheduleBuilder setFxScheduleSequence0(FxScheduleSequence0 var1);

        @Override
        public FxExpiryScheduleBuilder setFxScheduleSequence1(FxScheduleSequence1 var1);

        @Override
        public FxExpiryScheduleBuilder setId(String var1);

        public FxExpiryScheduleBuilder setFinalExpiryDate(ZonedDateTime var1);

        public FxExpiryScheduleBuilder setExpiryTime(BusinessCenterTime var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("fxScheduleSequence0"), processor, FxScheduleSequence0.FxScheduleSequence0Builder.class, (RosettaModelObjectBuilder)this.getFxScheduleSequence0(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxScheduleSequence1"), processor, FxScheduleSequence1.FxScheduleSequence1Builder.class, (RosettaModelObjectBuilder)this.getFxScheduleSequence1(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalExpiryDate"), ZonedDateTime.class, (Object)this.getFinalExpiryDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expiryTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getExpiryTime(), new AttributeMeta[0]);
        }

        @Override
        public FxExpiryScheduleBuilder prune();
    }

    public static class FxExpiryScheduleImpl
    extends FxSchedule.FxScheduleImpl
    implements FxExpirySchedule {
        private final ZonedDateTime finalExpiryDate;
        private final BusinessCenterTime expiryTime;

        protected FxExpiryScheduleImpl(FxExpiryScheduleBuilder builder) {
            super(builder);
            this.finalExpiryDate = builder.getFinalExpiryDate();
            this.expiryTime = Optional.ofNullable(builder.getExpiryTime()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="finalExpiryDate")
        @RuneAttribute(value="finalExpiryDate")
        public ZonedDateTime getFinalExpiryDate() {
            return this.finalExpiryDate;
        }

        @Override
        @RosettaAttribute(value="expiryTime")
        @RuneAttribute(value="expiryTime")
        public BusinessCenterTime getExpiryTime() {
            return this.expiryTime;
        }

        @Override
        public FxExpirySchedule build() {
            return this;
        }

        @Override
        public FxExpiryScheduleBuilder toBuilder() {
            FxExpiryScheduleBuilder builder = FxExpirySchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxExpiryScheduleBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFinalExpiryDate()).ifPresent(builder::setFinalExpiryDate);
            Optional.ofNullable(this.getExpiryTime()).ifPresent(builder::setExpiryTime);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxExpirySchedule _that = (FxExpirySchedule)this.getType().cast(o);
            if (!Objects.equals(this.finalExpiryDate, _that.getFinalExpiryDate())) {
                return false;
            }
            return Objects.equals(this.expiryTime, _that.getExpiryTime());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.finalExpiryDate != null ? this.finalExpiryDate.hashCode() : 0);
            _result = 31 * _result + (this.expiryTime != null ? this.expiryTime.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxExpirySchedule {finalExpiryDate=" + this.finalExpiryDate + ", expiryTime=" + this.expiryTime + '}' + " " + super.toString();
        }
    }
}

