/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.TriggerConditionEnum;
import fpml.consolidated.fx.meta.FxTriggerBaseMeta;
import fpml.consolidated.shared.QuotedCurrencyPair;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxTriggerBase", builder=FxTriggerBaseBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FxTriggerBase", model="fpml", builder=FxTriggerBaseBuilderImpl.class, version="1.1.0")
public interface FxTriggerBase
extends RosettaModelObject {
    public static final FxTriggerBaseMeta metaData = new FxTriggerBaseMeta();

    public TriggerConditionEnum getTriggerCondition();

    public QuotedCurrencyPair getQuotedCurrencyPair();

    public BigDecimal getTriggerRate();

    public BigDecimal getSpotRate();

    public FxTriggerBase build();

    public FxTriggerBaseBuilder toBuilder();

    public static FxTriggerBaseBuilder builder() {
        return new FxTriggerBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends FxTriggerBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxTriggerBase> getType() {
        return FxTriggerBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("triggerCondition"), TriggerConditionEnum.class, (Object)this.getTriggerCondition(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("triggerRate"), BigDecimal.class, (Object)this.getTriggerRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FxTriggerBaseBuilderImpl
    implements FxTriggerBaseBuilder {
        protected TriggerConditionEnum triggerCondition;
        protected QuotedCurrencyPair.QuotedCurrencyPairBuilder quotedCurrencyPair;
        protected BigDecimal triggerRate;
        protected BigDecimal spotRate;

        @Override
        @RosettaAttribute(value="triggerCondition", isRequired=true)
        @RuneAttribute(value="triggerCondition", isRequired=true)
        public TriggerConditionEnum getTriggerCondition() {
            return this.triggerCondition;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair() {
            QuotedCurrencyPair.QuotedCurrencyPairBuilder result = this.quotedCurrencyPair != null ? this.quotedCurrencyPair : (this.quotedCurrencyPair = QuotedCurrencyPair.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="triggerRate", isRequired=true)
        @RuneAttribute(value="triggerRate", isRequired=true)
        public BigDecimal getTriggerRate() {
            return this.triggerRate;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="triggerCondition", isRequired=true)
        @RuneAttribute(value="triggerCondition", isRequired=true)
        public FxTriggerBaseBuilder setTriggerCondition(TriggerConditionEnum _triggerCondition) {
            this.triggerCondition = _triggerCondition == null ? null : _triggerCondition;
            return this;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public FxTriggerBaseBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="triggerRate", isRequired=true)
        @RuneAttribute(value="triggerRate", isRequired=true)
        public FxTriggerBaseBuilder setTriggerRate(BigDecimal _triggerRate) {
            this.triggerRate = _triggerRate == null ? null : _triggerRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public FxTriggerBaseBuilder setSpotRate(BigDecimal _spotRate) {
            this.spotRate = _spotRate == null ? null : _spotRate;
            return this;
        }

        @Override
        public FxTriggerBase build() {
            return new FxTriggerBaseImpl(this);
        }

        @Override
        public FxTriggerBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public FxTriggerBaseBuilder prune() {
            if (this.quotedCurrencyPair != null && !this.quotedCurrencyPair.prune().hasData()) {
                this.quotedCurrencyPair = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTriggerCondition() != null) {
                return true;
            }
            if (this.getQuotedCurrencyPair() != null && this.getQuotedCurrencyPair().hasData()) {
                return true;
            }
            if (this.getTriggerRate() != null) {
                return true;
            }
            return this.getSpotRate() != null;
        }

        public FxTriggerBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxTriggerBaseBuilder o = (FxTriggerBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), (RosettaModelObjectBuilder)o.getQuotedCurrencyPair(), this::setQuotedCurrencyPair);
            merger.mergeBasic((Object)this.getTriggerCondition(), (Object)o.getTriggerCondition(), this::setTriggerCondition, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTriggerRate(), (Object)o.getTriggerRate(), this::setTriggerRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpotRate(), (Object)o.getSpotRate(), this::setSpotRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxTriggerBase _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.triggerCondition, (Object)_that.getTriggerCondition())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.triggerRate, _that.getTriggerRate())) {
                return false;
            }
            return Objects.equals(this.spotRate, _that.getSpotRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.triggerCondition != null ? ((Object)((Object)this.triggerCondition)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.triggerRate != null ? this.triggerRate.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxTriggerBaseBuilder {triggerCondition=" + (Object)((Object)this.triggerCondition) + ", quotedCurrencyPair=" + this.quotedCurrencyPair + ", triggerRate=" + this.triggerRate + ", spotRate=" + this.spotRate + '}';
        }
    }

    public static interface FxTriggerBaseBuilder
    extends FxTriggerBase,
    RosettaModelObjectBuilder {
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair();

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair();

        public FxTriggerBaseBuilder setTriggerCondition(TriggerConditionEnum var1);

        public FxTriggerBaseBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        public FxTriggerBaseBuilder setTriggerRate(BigDecimal var1);

        public FxTriggerBaseBuilder setSpotRate(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("triggerCondition"), TriggerConditionEnum.class, (Object)this.getTriggerCondition(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("triggerRate"), BigDecimal.class, (Object)this.getTriggerRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FxTriggerBaseBuilder prune();
    }

    public static class FxTriggerBaseImpl
    implements FxTriggerBase {
        private final TriggerConditionEnum triggerCondition;
        private final QuotedCurrencyPair quotedCurrencyPair;
        private final BigDecimal triggerRate;
        private final BigDecimal spotRate;

        protected FxTriggerBaseImpl(FxTriggerBaseBuilder builder) {
            this.triggerCondition = builder.getTriggerCondition();
            this.quotedCurrencyPair = Optional.ofNullable(builder.getQuotedCurrencyPair()).map(f -> f.build()).orElse(null);
            this.triggerRate = builder.getTriggerRate();
            this.spotRate = builder.getSpotRate();
        }

        @Override
        @RosettaAttribute(value="triggerCondition", isRequired=true)
        @RuneAttribute(value="triggerCondition", isRequired=true)
        public TriggerConditionEnum getTriggerCondition() {
            return this.triggerCondition;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        @RosettaAttribute(value="triggerRate", isRequired=true)
        @RuneAttribute(value="triggerRate", isRequired=true)
        public BigDecimal getTriggerRate() {
            return this.triggerRate;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        public FxTriggerBase build() {
            return this;
        }

        @Override
        public FxTriggerBaseBuilder toBuilder() {
            FxTriggerBaseBuilder builder = FxTriggerBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxTriggerBaseBuilder builder) {
            Optional.ofNullable(this.getTriggerCondition()).ifPresent(builder::setTriggerCondition);
            Optional.ofNullable(this.getQuotedCurrencyPair()).ifPresent(builder::setQuotedCurrencyPair);
            Optional.ofNullable(this.getTriggerRate()).ifPresent(builder::setTriggerRate);
            Optional.ofNullable(this.getSpotRate()).ifPresent(builder::setSpotRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxTriggerBase _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.triggerCondition, (Object)_that.getTriggerCondition())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.triggerRate, _that.getTriggerRate())) {
                return false;
            }
            return Objects.equals(this.spotRate, _that.getSpotRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.triggerCondition != null ? ((Object)((Object)this.triggerCondition)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.triggerRate != null ? this.triggerRate.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxTriggerBase {triggerCondition=" + (Object)((Object)this.triggerCondition) + ", quotedCurrencyPair=" + this.quotedCurrencyPair + ", triggerRate=" + this.triggerRate + ", spotRate=" + this.spotRate + '}';
        }
    }
}

