/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eq.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.eq.shared.Compounding;
import fpml.consolidated.eq.shared.InterestCalculationSequence;
import fpml.consolidated.eq.shared.meta.InterestCalculationMeta;
import fpml.consolidated.ird.FloatingRateCalculation;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.InterestAccrualsMethod;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="InterestCalculation", builder=InterestCalculationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="InterestCalculation", model="fpml", builder=InterestCalculationBuilderImpl.class, version="1.1.0")
public interface InterestCalculation
extends InterestAccrualsMethod {
    public static final InterestCalculationMeta metaData = new InterestCalculationMeta();

    public DayCountFraction getDayCountFraction();

    public Compounding getCompounding();

    public InterestCalculationSequence getInterestCalculationSequence();

    public String getId();

    @Override
    public InterestCalculation build();

    @Override
    public InterestCalculationBuilder toBuilder();

    public static InterestCalculationBuilder builder() {
        return new InterestCalculationBuilderImpl();
    }

    default public RosettaMetaData<? extends InterestCalculation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InterestCalculation> getType() {
        return InterestCalculation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("floatingRateCalculation"), processor, FloatingRateCalculation.class, this.getFloatingRateCalculation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("compounding"), processor, Compounding.class, this.getCompounding(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestCalculationSequence"), processor, InterestCalculationSequence.class, this.getInterestCalculationSequence(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class InterestCalculationBuilderImpl
    extends InterestAccrualsMethod.InterestAccrualsMethodBuilderImpl
    implements InterestCalculationBuilder {
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;
        protected Compounding.CompoundingBuilder compounding;
        protected InterestCalculationSequence.InterestCalculationSequenceBuilder interestCalculationSequence;
        protected String id;

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="compounding")
        @RuneAttribute(value="compounding")
        public Compounding.CompoundingBuilder getCompounding() {
            return this.compounding;
        }

        @Override
        public Compounding.CompoundingBuilder getOrCreateCompounding() {
            Compounding.CompoundingBuilder result = this.compounding != null ? this.compounding : (this.compounding = Compounding.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interestCalculationSequence")
        @RuneAttribute(value="interestCalculationSequence")
        public InterestCalculationSequence.InterestCalculationSequenceBuilder getInterestCalculationSequence() {
            return this.interestCalculationSequence;
        }

        @Override
        public InterestCalculationSequence.InterestCalculationSequenceBuilder getOrCreateInterestCalculationSequence() {
            InterestCalculationSequence.InterestCalculationSequenceBuilder result = this.interestCalculationSequence != null ? this.interestCalculationSequence : (this.interestCalculationSequence = InterestCalculationSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="floatingRateCalculation")
        @RuneAttribute(value="floatingRateCalculation")
        public InterestCalculationBuilder setFloatingRateCalculation(FloatingRateCalculation _floatingRateCalculation) {
            this.floatingRateCalculation = _floatingRateCalculation == null ? null : _floatingRateCalculation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public InterestCalculationBuilder setFixedRate(BigDecimal _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public InterestCalculationBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="compounding")
        @RuneAttribute(value="compounding")
        public InterestCalculationBuilder setCompounding(Compounding _compounding) {
            this.compounding = _compounding == null ? null : _compounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interestCalculationSequence")
        @RuneAttribute(value="interestCalculationSequence")
        public InterestCalculationBuilder setInterestCalculationSequence(InterestCalculationSequence _interestCalculationSequence) {
            this.interestCalculationSequence = _interestCalculationSequence == null ? null : _interestCalculationSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public InterestCalculationBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public InterestCalculation build() {
            return new InterestCalculationImpl(this);
        }

        @Override
        public InterestCalculationBuilder toBuilder() {
            return this;
        }

        @Override
        public InterestCalculationBuilder prune() {
            super.prune();
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            if (this.compounding != null && !this.compounding.prune().hasData()) {
                this.compounding = null;
            }
            if (this.interestCalculationSequence != null && !this.interestCalculationSequence.prune().hasData()) {
                this.interestCalculationSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDayCountFraction() != null && this.getDayCountFraction().hasData()) {
                return true;
            }
            if (this.getCompounding() != null && this.getCompounding().hasData()) {
                return true;
            }
            if (this.getInterestCalculationSequence() != null && this.getInterestCalculationSequence().hasData()) {
                return true;
            }
            return this.getId() != null;
        }

        @Override
        public InterestCalculationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            InterestCalculationBuilder o = (InterestCalculationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCompounding(), (RosettaModelObjectBuilder)o.getCompounding(), this::setCompounding);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestCalculationSequence(), (RosettaModelObjectBuilder)o.getInterestCalculationSequence(), this::setInterestCalculationSequence);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InterestCalculation _that = (InterestCalculation)this.getType().cast(o);
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.compounding, _that.getCompounding())) {
                return false;
            }
            if (!Objects.equals(this.interestCalculationSequence, _that.getInterestCalculationSequence())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.compounding != null ? this.compounding.hashCode() : 0);
            _result = 31 * _result + (this.interestCalculationSequence != null ? this.interestCalculationSequence.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InterestCalculationBuilder {dayCountFraction=" + this.dayCountFraction + ", compounding=" + this.compounding + ", interestCalculationSequence=" + this.interestCalculationSequence + ", id=" + this.id + '}' + " " + super.toString();
        }
    }

    public static interface InterestCalculationBuilder
    extends InterestCalculation,
    InterestAccrualsMethod.InterestAccrualsMethodBuilder {
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        public Compounding.CompoundingBuilder getOrCreateCompounding();

        @Override
        public Compounding.CompoundingBuilder getCompounding();

        public InterestCalculationSequence.InterestCalculationSequenceBuilder getOrCreateInterestCalculationSequence();

        @Override
        public InterestCalculationSequence.InterestCalculationSequenceBuilder getInterestCalculationSequence();

        @Override
        public InterestCalculationBuilder setFloatingRateCalculation(FloatingRateCalculation var1);

        @Override
        public InterestCalculationBuilder setFixedRate(BigDecimal var1);

        public InterestCalculationBuilder setDayCountFraction(DayCountFraction var1);

        public InterestCalculationBuilder setCompounding(Compounding var1);

        public InterestCalculationBuilder setInterestCalculationSequence(InterestCalculationSequence var1);

        public InterestCalculationBuilder setId(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("floatingRateCalculation"), processor, FloatingRateCalculation.FloatingRateCalculationBuilder.class, (RosettaModelObjectBuilder)this.getFloatingRateCalculation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("compounding"), processor, Compounding.CompoundingBuilder.class, this.getCompounding(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestCalculationSequence"), processor, InterestCalculationSequence.InterestCalculationSequenceBuilder.class, this.getInterestCalculationSequence(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public InterestCalculationBuilder prune();
    }

    public static class InterestCalculationImpl
    extends InterestAccrualsMethod.InterestAccrualsMethodImpl
    implements InterestCalculation {
        private final DayCountFraction dayCountFraction;
        private final Compounding compounding;
        private final InterestCalculationSequence interestCalculationSequence;
        private final String id;

        protected InterestCalculationImpl(InterestCalculationBuilder builder) {
            super(builder);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
            this.compounding = Optional.ofNullable(builder.getCompounding()).map(f -> f.build()).orElse(null);
            this.interestCalculationSequence = Optional.ofNullable(builder.getInterestCalculationSequence()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="compounding")
        @RuneAttribute(value="compounding")
        public Compounding getCompounding() {
            return this.compounding;
        }

        @Override
        @RosettaAttribute(value="interestCalculationSequence")
        @RuneAttribute(value="interestCalculationSequence")
        public InterestCalculationSequence getInterestCalculationSequence() {
            return this.interestCalculationSequence;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public InterestCalculation build() {
            return this;
        }

        @Override
        public InterestCalculationBuilder toBuilder() {
            InterestCalculationBuilder builder = InterestCalculation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InterestCalculationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getCompounding()).ifPresent(builder::setCompounding);
            Optional.ofNullable(this.getInterestCalculationSequence()).ifPresent(builder::setInterestCalculationSequence);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InterestCalculation _that = (InterestCalculation)this.getType().cast(o);
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.compounding, _that.getCompounding())) {
                return false;
            }
            if (!Objects.equals(this.interestCalculationSequence, _that.getInterestCalculationSequence())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.compounding != null ? this.compounding.hashCode() : 0);
            _result = 31 * _result + (this.interestCalculationSequence != null ? this.interestCalculationSequence.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InterestCalculation {dayCountFraction=" + this.dayCountFraction + ", compounding=" + this.compounding + ", interestCalculationSequence=" + this.interestCalculationSequence + ", id=" + this.id + '}' + " " + super.toString();
        }
    }
}

