/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.AdditionalData;
import fpml.consolidated.doc.ProblemLocation;
import fpml.consolidated.doc.ReasonCode;
import fpml.consolidated.doc.Validation;
import fpml.consolidated.doc.meta.ReasonMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Reason", builder=ReasonBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Reason", model="fpml", builder=ReasonBuilderImpl.class, version="1.1.0")
public interface Reason
extends RosettaModelObject {
    public static final ReasonMeta metaData = new ReasonMeta();

    public ReasonCode getReasonCode();

    public ProblemLocation getLocation();

    public String getDescription();

    public Validation getValidationRuleId();

    public List<? extends AdditionalData> getAdditionalData();

    public Reason build();

    public ReasonBuilder toBuilder();

    public static ReasonBuilder builder() {
        return new ReasonBuilderImpl();
    }

    default public RosettaMetaData<? extends Reason> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Reason> getType() {
        return Reason.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("reasonCode"), processor, ReasonCode.class, this.getReasonCode(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("location"), processor, ProblemLocation.class, this.getLocation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationRuleId"), processor, Validation.class, this.getValidationRuleId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalData"), processor, AdditionalData.class, this.getAdditionalData(), new AttributeMeta[0]);
    }

    public static class ReasonBuilderImpl
    implements ReasonBuilder {
        protected ReasonCode.ReasonCodeBuilder reasonCode;
        protected ProblemLocation.ProblemLocationBuilder location;
        protected String description;
        protected Validation.ValidationBuilder validationRuleId;
        protected List<AdditionalData.AdditionalDataBuilder> additionalData = new ArrayList<AdditionalData.AdditionalDataBuilder>();

        @Override
        @RosettaAttribute(value="reasonCode")
        @RuneAttribute(value="reasonCode")
        public ReasonCode.ReasonCodeBuilder getReasonCode() {
            return this.reasonCode;
        }

        @Override
        public ReasonCode.ReasonCodeBuilder getOrCreateReasonCode() {
            ReasonCode.ReasonCodeBuilder result = this.reasonCode != null ? this.reasonCode : (this.reasonCode = ReasonCode.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="location")
        @RuneAttribute(value="location")
        public ProblemLocation.ProblemLocationBuilder getLocation() {
            return this.location;
        }

        @Override
        public ProblemLocation.ProblemLocationBuilder getOrCreateLocation() {
            ProblemLocation.ProblemLocationBuilder result = this.location != null ? this.location : (this.location = ProblemLocation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        @RosettaAttribute(value="validationRuleId")
        @RuneAttribute(value="validationRuleId")
        public Validation.ValidationBuilder getValidationRuleId() {
            return this.validationRuleId;
        }

        @Override
        public Validation.ValidationBuilder getOrCreateValidationRuleId() {
            Validation.ValidationBuilder result = this.validationRuleId != null ? this.validationRuleId : (this.validationRuleId = Validation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="additionalData")
        @RuneAttribute(value="additionalData")
        public List<? extends AdditionalData.AdditionalDataBuilder> getAdditionalData() {
            return this.additionalData;
        }

        @Override
        public AdditionalData.AdditionalDataBuilder getOrCreateAdditionalData(int index) {
            if (this.additionalData == null) {
                this.additionalData = new ArrayList<AdditionalData.AdditionalDataBuilder>();
            }
            return (AdditionalData.AdditionalDataBuilder)this.getIndex(this.additionalData, index, () -> {
                AdditionalData.AdditionalDataBuilder newAdditionalData = AdditionalData.builder();
                return newAdditionalData;
            });
        }

        @Override
        @RosettaAttribute(value="reasonCode")
        @RuneAttribute(value="reasonCode")
        public ReasonBuilder setReasonCode(ReasonCode _reasonCode) {
            this.reasonCode = _reasonCode == null ? null : _reasonCode.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="location")
        @RuneAttribute(value="location")
        public ReasonBuilder setLocation(ProblemLocation _location) {
            this.location = _location == null ? null : _location.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public ReasonBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="validationRuleId")
        @RuneAttribute(value="validationRuleId")
        public ReasonBuilder setValidationRuleId(Validation _validationRuleId) {
            this.validationRuleId = _validationRuleId == null ? null : _validationRuleId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalData")
        @RuneAttribute(value="additionalData")
        public ReasonBuilder addAdditionalData(AdditionalData _additionalData) {
            if (_additionalData != null) {
                this.additionalData.add(_additionalData.toBuilder());
            }
            return this;
        }

        @Override
        public ReasonBuilder addAdditionalData(AdditionalData _additionalData, int idx) {
            this.getIndex(this.additionalData, idx, () -> _additionalData.toBuilder());
            return this;
        }

        @Override
        public ReasonBuilder addAdditionalData(List<? extends AdditionalData> additionalDatas) {
            if (additionalDatas != null) {
                for (AdditionalData additionalData : additionalDatas) {
                    this.additionalData.add(additionalData.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalData")
        public ReasonBuilder setAdditionalData(List<? extends AdditionalData> additionalDatas) {
            this.additionalData = additionalDatas == null ? new ArrayList<AdditionalData.AdditionalDataBuilder>() : (List)additionalDatas.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Reason build() {
            return new ReasonImpl(this);
        }

        @Override
        public ReasonBuilder toBuilder() {
            return this;
        }

        @Override
        public ReasonBuilder prune() {
            if (this.reasonCode != null && !this.reasonCode.prune().hasData()) {
                this.reasonCode = null;
            }
            if (this.location != null && !this.location.prune().hasData()) {
                this.location = null;
            }
            if (this.validationRuleId != null && !this.validationRuleId.prune().hasData()) {
                this.validationRuleId = null;
            }
            this.additionalData = this.additionalData.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getReasonCode() != null && this.getReasonCode().hasData()) {
                return true;
            }
            if (this.getLocation() != null && this.getLocation().hasData()) {
                return true;
            }
            if (this.getDescription() != null) {
                return true;
            }
            if (this.getValidationRuleId() != null && this.getValidationRuleId().hasData()) {
                return true;
            }
            return this.getAdditionalData() != null && this.getAdditionalData().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ReasonBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReasonBuilder o = (ReasonBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReasonCode(), (RosettaModelObjectBuilder)o.getReasonCode(), this::setReasonCode);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLocation(), (RosettaModelObjectBuilder)o.getLocation(), this::setLocation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValidationRuleId(), (RosettaModelObjectBuilder)o.getValidationRuleId(), this::setValidationRuleId);
            merger.mergeRosetta(this.getAdditionalData(), o.getAdditionalData(), this::getOrCreateAdditionalData);
            merger.mergeBasic((Object)this.getDescription(), (Object)o.getDescription(), this::setDescription, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Reason _that = this.getType().cast(o);
            if (!Objects.equals(this.reasonCode, _that.getReasonCode())) {
                return false;
            }
            if (!Objects.equals(this.location, _that.getLocation())) {
                return false;
            }
            if (!Objects.equals(this.description, _that.getDescription())) {
                return false;
            }
            if (!Objects.equals(this.validationRuleId, _that.getValidationRuleId())) {
                return false;
            }
            return ListEquals.listEquals(this.additionalData, _that.getAdditionalData());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.reasonCode != null ? this.reasonCode.hashCode() : 0);
            _result = 31 * _result + (this.location != null ? this.location.hashCode() : 0);
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            _result = 31 * _result + (this.validationRuleId != null ? this.validationRuleId.hashCode() : 0);
            _result = 31 * _result + (this.additionalData != null ? this.additionalData.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReasonBuilder {reasonCode=" + this.reasonCode + ", location=" + this.location + ", description=" + this.description + ", validationRuleId=" + this.validationRuleId + ", additionalData=" + this.additionalData + '}';
        }
    }

    public static interface ReasonBuilder
    extends Reason,
    RosettaModelObjectBuilder {
        public ReasonCode.ReasonCodeBuilder getOrCreateReasonCode();

        @Override
        public ReasonCode.ReasonCodeBuilder getReasonCode();

        public ProblemLocation.ProblemLocationBuilder getOrCreateLocation();

        @Override
        public ProblemLocation.ProblemLocationBuilder getLocation();

        public Validation.ValidationBuilder getOrCreateValidationRuleId();

        @Override
        public Validation.ValidationBuilder getValidationRuleId();

        public AdditionalData.AdditionalDataBuilder getOrCreateAdditionalData(int var1);

        public List<? extends AdditionalData.AdditionalDataBuilder> getAdditionalData();

        public ReasonBuilder setReasonCode(ReasonCode var1);

        public ReasonBuilder setLocation(ProblemLocation var1);

        public ReasonBuilder setDescription(String var1);

        public ReasonBuilder setValidationRuleId(Validation var1);

        public ReasonBuilder addAdditionalData(AdditionalData var1);

        public ReasonBuilder addAdditionalData(AdditionalData var1, int var2);

        public ReasonBuilder addAdditionalData(List<? extends AdditionalData> var1);

        public ReasonBuilder setAdditionalData(List<? extends AdditionalData> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("reasonCode"), processor, ReasonCode.ReasonCodeBuilder.class, this.getReasonCode(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("location"), processor, ProblemLocation.ProblemLocationBuilder.class, this.getLocation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationRuleId"), processor, Validation.ValidationBuilder.class, this.getValidationRuleId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalData"), processor, AdditionalData.AdditionalDataBuilder.class, this.getAdditionalData(), new AttributeMeta[0]);
        }

        public ReasonBuilder prune();
    }

    public static class ReasonImpl
    implements Reason {
        private final ReasonCode reasonCode;
        private final ProblemLocation location;
        private final String description;
        private final Validation validationRuleId;
        private final List<? extends AdditionalData> additionalData;

        protected ReasonImpl(ReasonBuilder builder) {
            this.reasonCode = Optional.ofNullable(builder.getReasonCode()).map(f -> f.build()).orElse(null);
            this.location = Optional.ofNullable(builder.getLocation()).map(f -> f.build()).orElse(null);
            this.description = builder.getDescription();
            this.validationRuleId = Optional.ofNullable(builder.getValidationRuleId()).map(f -> f.build()).orElse(null);
            this.additionalData = Optional.ofNullable(builder.getAdditionalData()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="reasonCode")
        @RuneAttribute(value="reasonCode")
        public ReasonCode getReasonCode() {
            return this.reasonCode;
        }

        @Override
        @RosettaAttribute(value="location")
        @RuneAttribute(value="location")
        public ProblemLocation getLocation() {
            return this.location;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        @RosettaAttribute(value="validationRuleId")
        @RuneAttribute(value="validationRuleId")
        public Validation getValidationRuleId() {
            return this.validationRuleId;
        }

        @Override
        @RosettaAttribute(value="additionalData")
        @RuneAttribute(value="additionalData")
        public List<? extends AdditionalData> getAdditionalData() {
            return this.additionalData;
        }

        @Override
        public Reason build() {
            return this;
        }

        @Override
        public ReasonBuilder toBuilder() {
            ReasonBuilder builder = Reason.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReasonBuilder builder) {
            Optional.ofNullable(this.getReasonCode()).ifPresent(builder::setReasonCode);
            Optional.ofNullable(this.getLocation()).ifPresent(builder::setLocation);
            Optional.ofNullable(this.getDescription()).ifPresent(builder::setDescription);
            Optional.ofNullable(this.getValidationRuleId()).ifPresent(builder::setValidationRuleId);
            Optional.ofNullable(this.getAdditionalData()).ifPresent(builder::setAdditionalData);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Reason _that = this.getType().cast(o);
            if (!Objects.equals(this.reasonCode, _that.getReasonCode())) {
                return false;
            }
            if (!Objects.equals(this.location, _that.getLocation())) {
                return false;
            }
            if (!Objects.equals(this.description, _that.getDescription())) {
                return false;
            }
            if (!Objects.equals(this.validationRuleId, _that.getValidationRuleId())) {
                return false;
            }
            return ListEquals.listEquals(this.additionalData, _that.getAdditionalData());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.reasonCode != null ? this.reasonCode.hashCode() : 0);
            _result = 31 * _result + (this.location != null ? this.location.hashCode() : 0);
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            _result = 31 * _result + (this.validationRuleId != null ? this.validationRuleId.hashCode() : 0);
            _result = 31 * _result + (this.additionalData != null ? this.additionalData.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Reason {reasonCode=" + this.reasonCode + ", location=" + this.location + ", description=" + this.description + ", validationRuleId=" + this.validationRuleId + ", additionalData=" + this.additionalData + '}';
        }
    }
}

