/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.correlation.swaps;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.correlation.swaps.meta.CorrelationAmountMeta;
import fpml.consolidated.eq.shared.CalculatedAmount;
import fpml.consolidated.eq.shared.Correlation;
import fpml.consolidated.eq.shared.DividendsModel;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.AdjustableRelativeOrPeriodicDates;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CorrelationAmount", builder=CorrelationAmountBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CorrelationAmount", model="fpml", builder=CorrelationAmountBuilderImpl.class, version="1.1.0")
public interface CorrelationAmount
extends CalculatedAmount {
    public static final CorrelationAmountMeta metaData = new CorrelationAmountMeta();

    public Correlation getCorrelation();

    @Override
    public CorrelationAmount build();

    @Override
    public CorrelationAmountBuilder toBuilder();

    public static CorrelationAmountBuilder builder() {
        return new CorrelationAmountBuilderImpl();
    }

    default public RosettaMetaData<? extends CorrelationAmount> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CorrelationAmount> getType() {
        return CorrelationAmount.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("calculationDates"), processor, AdjustableRelativeOrPeriodicDates.class, this.getCalculationDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationStartDate"), processor, AdjustableOrRelativeDate.class, this.getObservationStartDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendsModel"), processor, DividendsModel.class, this.getDividendsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlation"), processor, Correlation.class, this.getCorrelation(), new AttributeMeta[0]);
    }

    public static class CorrelationAmountBuilderImpl
    extends CalculatedAmount.CalculatedAmountBuilderImpl
    implements CorrelationAmountBuilder {
        protected Correlation.CorrelationBuilder correlation;

        @Override
        @RosettaAttribute(value="correlation", isRequired=true)
        @RuneAttribute(value="correlation", isRequired=true)
        public Correlation.CorrelationBuilder getCorrelation() {
            return this.correlation;
        }

        @Override
        public Correlation.CorrelationBuilder getOrCreateCorrelation() {
            Correlation.CorrelationBuilder result = this.correlation != null ? this.correlation : (this.correlation = Correlation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationDates")
        @RuneAttribute(value="calculationDates")
        public CorrelationAmountBuilder setCalculationDates(AdjustableRelativeOrPeriodicDates _calculationDates) {
            this.calculationDates = _calculationDates == null ? null : _calculationDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationStartDate")
        @RuneAttribute(value="observationStartDate")
        public CorrelationAmountBuilder setObservationStartDate(AdjustableOrRelativeDate _observationStartDate) {
            this.observationStartDate = _observationStartDate == null ? null : _observationStartDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendsModel", isRequired=true)
        @RuneAttribute(value="dividendsModel", isRequired=true)
        public CorrelationAmountBuilder setDividendsModel(DividendsModel _dividendsModel) {
            this.dividendsModel = _dividendsModel == null ? null : _dividendsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlation", isRequired=true)
        @RuneAttribute(value="correlation", isRequired=true)
        public CorrelationAmountBuilder setCorrelation(Correlation _correlation) {
            this.correlation = _correlation == null ? null : _correlation.toBuilder();
            return this;
        }

        @Override
        public CorrelationAmount build() {
            return new CorrelationAmountImpl(this);
        }

        @Override
        public CorrelationAmountBuilder toBuilder() {
            return this;
        }

        @Override
        public CorrelationAmountBuilder prune() {
            super.prune();
            if (this.correlation != null && !this.correlation.prune().hasData()) {
                this.correlation = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getCorrelation() != null && this.getCorrelation().hasData();
        }

        @Override
        public CorrelationAmountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CorrelationAmountBuilder o = (CorrelationAmountBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCorrelation(), (RosettaModelObjectBuilder)o.getCorrelation(), this::setCorrelation);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CorrelationAmount _that = (CorrelationAmount)this.getType().cast(o);
            return Objects.equals(this.correlation, _that.getCorrelation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.correlation != null ? this.correlation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CorrelationAmountBuilder {correlation=" + this.correlation + '}' + " " + super.toString();
        }
    }

    public static interface CorrelationAmountBuilder
    extends CorrelationAmount,
    CalculatedAmount.CalculatedAmountBuilder {
        public Correlation.CorrelationBuilder getOrCreateCorrelation();

        @Override
        public Correlation.CorrelationBuilder getCorrelation();

        @Override
        public CorrelationAmountBuilder setCalculationDates(AdjustableRelativeOrPeriodicDates var1);

        @Override
        public CorrelationAmountBuilder setObservationStartDate(AdjustableOrRelativeDate var1);

        @Override
        public CorrelationAmountBuilder setDividendsModel(DividendsModel var1);

        public CorrelationAmountBuilder setCorrelation(Correlation var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("calculationDates"), processor, AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder.class, (RosettaModelObjectBuilder)this.getCalculationDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationStartDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getObservationStartDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendsModel"), processor, DividendsModel.DividendsModelBuilder.class, (RosettaModelObjectBuilder)this.getDividendsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlation"), processor, Correlation.CorrelationBuilder.class, this.getCorrelation(), new AttributeMeta[0]);
        }

        @Override
        public CorrelationAmountBuilder prune();
    }

    public static class CorrelationAmountImpl
    extends CalculatedAmount.CalculatedAmountImpl
    implements CorrelationAmount {
        private final Correlation correlation;

        protected CorrelationAmountImpl(CorrelationAmountBuilder builder) {
            super(builder);
            this.correlation = Optional.ofNullable(builder.getCorrelation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="correlation", isRequired=true)
        @RuneAttribute(value="correlation", isRequired=true)
        public Correlation getCorrelation() {
            return this.correlation;
        }

        @Override
        public CorrelationAmount build() {
            return this;
        }

        @Override
        public CorrelationAmountBuilder toBuilder() {
            CorrelationAmountBuilder builder = CorrelationAmount.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CorrelationAmountBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCorrelation()).ifPresent(builder::setCorrelation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CorrelationAmount _that = (CorrelationAmount)this.getType().cast(o);
            return Objects.equals(this.correlation, _that.getCorrelation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.correlation != null ? this.correlation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CorrelationAmount {correlation=" + this.correlation + '}' + " " + super.toString();
        }
    }
}

