/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.com.CommodityMarketDisruption;
import fpml.consolidated.com.meta.CommodityContentModelMeta;
import fpml.consolidated.fpmlenum.CommodityBullionSettlementDisruptionEnum;
import fpml.consolidated.shared.Rounding;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommodityContentModel", builder=CommodityContentModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CommodityContentModel", model="fpml", builder=CommodityContentModelBuilderImpl.class, version="1.1.0")
public interface CommodityContentModel
extends RosettaModelObject {
    public static final CommodityContentModelMeta metaData = new CommodityContentModelMeta();

    public Boolean getCommonPricing();

    public CommodityMarketDisruption getMarketDisruption();

    public CommodityBullionSettlementDisruptionEnum getSettlementDisruption();

    public Rounding getRounding();

    public CommodityContentModel build();

    public CommodityContentModelBuilder toBuilder();

    public static CommodityContentModelBuilder builder() {
        return new CommodityContentModelBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityContentModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityContentModel> getType() {
        return CommodityContentModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("commonPricing"), Boolean.class, (Object)this.getCommonPricing(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("marketDisruption"), processor, CommodityMarketDisruption.class, this.getMarketDisruption(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementDisruption"), CommodityBullionSettlementDisruptionEnum.class, (Object)this.getSettlementDisruption(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rounding"), processor, Rounding.class, this.getRounding(), new AttributeMeta[0]);
    }

    public static class CommodityContentModelBuilderImpl
    implements CommodityContentModelBuilder {
        protected Boolean commonPricing;
        protected CommodityMarketDisruption.CommodityMarketDisruptionBuilder marketDisruption;
        protected CommodityBullionSettlementDisruptionEnum settlementDisruption;
        protected Rounding.RoundingBuilder rounding;

        @Override
        @RosettaAttribute(value="commonPricing")
        @RuneAttribute(value="commonPricing")
        public Boolean getCommonPricing() {
            return this.commonPricing;
        }

        @Override
        @RosettaAttribute(value="marketDisruption")
        @RuneAttribute(value="marketDisruption")
        public CommodityMarketDisruption.CommodityMarketDisruptionBuilder getMarketDisruption() {
            return this.marketDisruption;
        }

        @Override
        public CommodityMarketDisruption.CommodityMarketDisruptionBuilder getOrCreateMarketDisruption() {
            CommodityMarketDisruption.CommodityMarketDisruptionBuilder result = this.marketDisruption != null ? this.marketDisruption : (this.marketDisruption = CommodityMarketDisruption.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementDisruption")
        @RuneAttribute(value="settlementDisruption")
        public CommodityBullionSettlementDisruptionEnum getSettlementDisruption() {
            return this.settlementDisruption;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding.RoundingBuilder getRounding() {
            return this.rounding;
        }

        @Override
        public Rounding.RoundingBuilder getOrCreateRounding() {
            Rounding.RoundingBuilder result = this.rounding != null ? this.rounding : (this.rounding = Rounding.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commonPricing")
        @RuneAttribute(value="commonPricing")
        public CommodityContentModelBuilder setCommonPricing(Boolean _commonPricing) {
            this.commonPricing = _commonPricing == null ? null : _commonPricing;
            return this;
        }

        @Override
        @RosettaAttribute(value="marketDisruption")
        @RuneAttribute(value="marketDisruption")
        public CommodityContentModelBuilder setMarketDisruption(CommodityMarketDisruption _marketDisruption) {
            this.marketDisruption = _marketDisruption == null ? null : _marketDisruption.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDisruption")
        @RuneAttribute(value="settlementDisruption")
        public CommodityContentModelBuilder setSettlementDisruption(CommodityBullionSettlementDisruptionEnum _settlementDisruption) {
            this.settlementDisruption = _settlementDisruption == null ? null : _settlementDisruption;
            return this;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public CommodityContentModelBuilder setRounding(Rounding _rounding) {
            this.rounding = _rounding == null ? null : _rounding.toBuilder();
            return this;
        }

        @Override
        public CommodityContentModel build() {
            return new CommodityContentModelImpl(this);
        }

        @Override
        public CommodityContentModelBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityContentModelBuilder prune() {
            if (this.marketDisruption != null && !this.marketDisruption.prune().hasData()) {
                this.marketDisruption = null;
            }
            if (this.rounding != null && !this.rounding.prune().hasData()) {
                this.rounding = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCommonPricing() != null) {
                return true;
            }
            if (this.getMarketDisruption() != null && this.getMarketDisruption().hasData()) {
                return true;
            }
            if (this.getSettlementDisruption() != null) {
                return true;
            }
            return this.getRounding() != null && this.getRounding().hasData();
        }

        public CommodityContentModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityContentModelBuilder o = (CommodityContentModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMarketDisruption(), (RosettaModelObjectBuilder)o.getMarketDisruption(), this::setMarketDisruption);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRounding(), (RosettaModelObjectBuilder)o.getRounding(), this::setRounding);
            merger.mergeBasic((Object)this.getCommonPricing(), (Object)o.getCommonPricing(), this::setCommonPricing, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementDisruption(), (Object)o.getSettlementDisruption(), this::setSettlementDisruption, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityContentModel _that = this.getType().cast(o);
            if (!Objects.equals(this.commonPricing, _that.getCommonPricing())) {
                return false;
            }
            if (!Objects.equals(this.marketDisruption, _that.getMarketDisruption())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementDisruption, (Object)_that.getSettlementDisruption())) {
                return false;
            }
            return Objects.equals(this.rounding, _that.getRounding());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.commonPricing != null ? this.commonPricing.hashCode() : 0);
            _result = 31 * _result + (this.marketDisruption != null ? this.marketDisruption.hashCode() : 0);
            _result = 31 * _result + (this.settlementDisruption != null ? ((Object)((Object)this.settlementDisruption)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityContentModelBuilder {commonPricing=" + this.commonPricing + ", marketDisruption=" + this.marketDisruption + ", settlementDisruption=" + (Object)((Object)this.settlementDisruption) + ", rounding=" + this.rounding + '}';
        }
    }

    public static interface CommodityContentModelBuilder
    extends CommodityContentModel,
    RosettaModelObjectBuilder {
        public CommodityMarketDisruption.CommodityMarketDisruptionBuilder getOrCreateMarketDisruption();

        @Override
        public CommodityMarketDisruption.CommodityMarketDisruptionBuilder getMarketDisruption();

        public Rounding.RoundingBuilder getOrCreateRounding();

        @Override
        public Rounding.RoundingBuilder getRounding();

        public CommodityContentModelBuilder setCommonPricing(Boolean var1);

        public CommodityContentModelBuilder setMarketDisruption(CommodityMarketDisruption var1);

        public CommodityContentModelBuilder setSettlementDisruption(CommodityBullionSettlementDisruptionEnum var1);

        public CommodityContentModelBuilder setRounding(Rounding var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("commonPricing"), Boolean.class, (Object)this.getCommonPricing(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("marketDisruption"), processor, CommodityMarketDisruption.CommodityMarketDisruptionBuilder.class, this.getMarketDisruption(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementDisruption"), CommodityBullionSettlementDisruptionEnum.class, (Object)this.getSettlementDisruption(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rounding"), processor, Rounding.RoundingBuilder.class, this.getRounding(), new AttributeMeta[0]);
        }

        public CommodityContentModelBuilder prune();
    }

    public static class CommodityContentModelImpl
    implements CommodityContentModel {
        private final Boolean commonPricing;
        private final CommodityMarketDisruption marketDisruption;
        private final CommodityBullionSettlementDisruptionEnum settlementDisruption;
        private final Rounding rounding;

        protected CommodityContentModelImpl(CommodityContentModelBuilder builder) {
            this.commonPricing = builder.getCommonPricing();
            this.marketDisruption = Optional.ofNullable(builder.getMarketDisruption()).map(f -> f.build()).orElse(null);
            this.settlementDisruption = builder.getSettlementDisruption();
            this.rounding = Optional.ofNullable(builder.getRounding()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="commonPricing")
        @RuneAttribute(value="commonPricing")
        public Boolean getCommonPricing() {
            return this.commonPricing;
        }

        @Override
        @RosettaAttribute(value="marketDisruption")
        @RuneAttribute(value="marketDisruption")
        public CommodityMarketDisruption getMarketDisruption() {
            return this.marketDisruption;
        }

        @Override
        @RosettaAttribute(value="settlementDisruption")
        @RuneAttribute(value="settlementDisruption")
        public CommodityBullionSettlementDisruptionEnum getSettlementDisruption() {
            return this.settlementDisruption;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding getRounding() {
            return this.rounding;
        }

        @Override
        public CommodityContentModel build() {
            return this;
        }

        @Override
        public CommodityContentModelBuilder toBuilder() {
            CommodityContentModelBuilder builder = CommodityContentModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityContentModelBuilder builder) {
            Optional.ofNullable(this.getCommonPricing()).ifPresent(builder::setCommonPricing);
            Optional.ofNullable(this.getMarketDisruption()).ifPresent(builder::setMarketDisruption);
            Optional.ofNullable(this.getSettlementDisruption()).ifPresent(builder::setSettlementDisruption);
            Optional.ofNullable(this.getRounding()).ifPresent(builder::setRounding);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityContentModel _that = this.getType().cast(o);
            if (!Objects.equals(this.commonPricing, _that.getCommonPricing())) {
                return false;
            }
            if (!Objects.equals(this.marketDisruption, _that.getMarketDisruption())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementDisruption, (Object)_that.getSettlementDisruption())) {
                return false;
            }
            return Objects.equals(this.rounding, _that.getRounding());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.commonPricing != null ? this.commonPricing.hashCode() : 0);
            _result = 31 * _result + (this.marketDisruption != null ? this.marketDisruption.hashCode() : 0);
            _result = 31 * _result + (this.settlementDisruption != null ? ((Object)((Object)this.settlementDisruption)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityContentModel {commonPricing=" + this.commonPricing + ", marketDisruption=" + this.marketDisruption + ", settlementDisruption=" + (Object)((Object)this.settlementDisruption) + ", rounding=" + this.rounding + '}';
        }
    }
}

