/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.com.CommodityTrigger;
import fpml.consolidated.com.meta.CommodityBarrierMeta;
import fpml.consolidated.fpmlenum.CommodityKnockEnum;
import fpml.consolidated.shared.PositiveMoney;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommodityBarrier", builder=CommodityBarrierBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CommodityBarrier", model="fpml", builder=CommodityBarrierBuilderImpl.class, version="1.1.0")
public interface CommodityBarrier
extends RosettaModelObject {
    public static final CommodityBarrierMeta metaData = new CommodityBarrierMeta();

    public CommodityKnockEnum getKnock();

    public PositiveMoney getFeaturePaymentAmount();

    public CommodityTrigger getTrigger();

    public CommodityBarrier build();

    public CommodityBarrierBuilder toBuilder();

    public static CommodityBarrierBuilder builder() {
        return new CommodityBarrierBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityBarrier> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityBarrier> getType() {
        return CommodityBarrier.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("knock"), CommodityKnockEnum.class, (Object)this.getKnock(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("featurePaymentAmount"), processor, PositiveMoney.class, this.getFeaturePaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trigger"), processor, CommodityTrigger.class, this.getTrigger(), new AttributeMeta[0]);
    }

    public static class CommodityBarrierBuilderImpl
    implements CommodityBarrierBuilder {
        protected CommodityKnockEnum knock;
        protected PositiveMoney.PositiveMoneyBuilder featurePaymentAmount;
        protected CommodityTrigger.CommodityTriggerBuilder trigger;

        @Override
        @RosettaAttribute(value="knock", isRequired=true)
        @RuneAttribute(value="knock", isRequired=true)
        public CommodityKnockEnum getKnock() {
            return this.knock;
        }

        @Override
        @RosettaAttribute(value="featurePaymentAmount")
        @RuneAttribute(value="featurePaymentAmount")
        public PositiveMoney.PositiveMoneyBuilder getFeaturePaymentAmount() {
            return this.featurePaymentAmount;
        }

        @Override
        public PositiveMoney.PositiveMoneyBuilder getOrCreateFeaturePaymentAmount() {
            PositiveMoney.PositiveMoneyBuilder result = this.featurePaymentAmount != null ? this.featurePaymentAmount : (this.featurePaymentAmount = PositiveMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="trigger", isRequired=true)
        @RuneAttribute(value="trigger", isRequired=true)
        public CommodityTrigger.CommodityTriggerBuilder getTrigger() {
            return this.trigger;
        }

        @Override
        public CommodityTrigger.CommodityTriggerBuilder getOrCreateTrigger() {
            CommodityTrigger.CommodityTriggerBuilder result = this.trigger != null ? this.trigger : (this.trigger = CommodityTrigger.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="knock", isRequired=true)
        @RuneAttribute(value="knock", isRequired=true)
        public CommodityBarrierBuilder setKnock(CommodityKnockEnum _knock) {
            this.knock = _knock == null ? null : _knock;
            return this;
        }

        @Override
        @RosettaAttribute(value="featurePaymentAmount")
        @RuneAttribute(value="featurePaymentAmount")
        public CommodityBarrierBuilder setFeaturePaymentAmount(PositiveMoney _featurePaymentAmount) {
            this.featurePaymentAmount = _featurePaymentAmount == null ? null : _featurePaymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trigger", isRequired=true)
        @RuneAttribute(value="trigger", isRequired=true)
        public CommodityBarrierBuilder setTrigger(CommodityTrigger _trigger) {
            this.trigger = _trigger == null ? null : _trigger.toBuilder();
            return this;
        }

        @Override
        public CommodityBarrier build() {
            return new CommodityBarrierImpl(this);
        }

        @Override
        public CommodityBarrierBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityBarrierBuilder prune() {
            if (this.featurePaymentAmount != null && !this.featurePaymentAmount.prune().hasData()) {
                this.featurePaymentAmount = null;
            }
            if (this.trigger != null && !this.trigger.prune().hasData()) {
                this.trigger = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getKnock() != null) {
                return true;
            }
            if (this.getFeaturePaymentAmount() != null && this.getFeaturePaymentAmount().hasData()) {
                return true;
            }
            return this.getTrigger() != null && this.getTrigger().hasData();
        }

        public CommodityBarrierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityBarrierBuilder o = (CommodityBarrierBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFeaturePaymentAmount(), (RosettaModelObjectBuilder)o.getFeaturePaymentAmount(), this::setFeaturePaymentAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTrigger(), (RosettaModelObjectBuilder)o.getTrigger(), this::setTrigger);
            merger.mergeBasic((Object)this.getKnock(), (Object)o.getKnock(), this::setKnock, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityBarrier _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.knock, (Object)_that.getKnock())) {
                return false;
            }
            if (!Objects.equals(this.featurePaymentAmount, _that.getFeaturePaymentAmount())) {
                return false;
            }
            return Objects.equals(this.trigger, _that.getTrigger());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.knock != null ? ((Object)((Object)this.knock)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.featurePaymentAmount != null ? this.featurePaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.trigger != null ? this.trigger.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityBarrierBuilder {knock=" + (Object)((Object)this.knock) + ", featurePaymentAmount=" + this.featurePaymentAmount + ", trigger=" + this.trigger + '}';
        }
    }

    public static interface CommodityBarrierBuilder
    extends CommodityBarrier,
    RosettaModelObjectBuilder {
        public PositiveMoney.PositiveMoneyBuilder getOrCreateFeaturePaymentAmount();

        @Override
        public PositiveMoney.PositiveMoneyBuilder getFeaturePaymentAmount();

        public CommodityTrigger.CommodityTriggerBuilder getOrCreateTrigger();

        @Override
        public CommodityTrigger.CommodityTriggerBuilder getTrigger();

        public CommodityBarrierBuilder setKnock(CommodityKnockEnum var1);

        public CommodityBarrierBuilder setFeaturePaymentAmount(PositiveMoney var1);

        public CommodityBarrierBuilder setTrigger(CommodityTrigger var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("knock"), CommodityKnockEnum.class, (Object)this.getKnock(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("featurePaymentAmount"), processor, PositiveMoney.PositiveMoneyBuilder.class, this.getFeaturePaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trigger"), processor, CommodityTrigger.CommodityTriggerBuilder.class, this.getTrigger(), new AttributeMeta[0]);
        }

        public CommodityBarrierBuilder prune();
    }

    public static class CommodityBarrierImpl
    implements CommodityBarrier {
        private final CommodityKnockEnum knock;
        private final PositiveMoney featurePaymentAmount;
        private final CommodityTrigger trigger;

        protected CommodityBarrierImpl(CommodityBarrierBuilder builder) {
            this.knock = builder.getKnock();
            this.featurePaymentAmount = Optional.ofNullable(builder.getFeaturePaymentAmount()).map(f -> f.build()).orElse(null);
            this.trigger = Optional.ofNullable(builder.getTrigger()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="knock", isRequired=true)
        @RuneAttribute(value="knock", isRequired=true)
        public CommodityKnockEnum getKnock() {
            return this.knock;
        }

        @Override
        @RosettaAttribute(value="featurePaymentAmount")
        @RuneAttribute(value="featurePaymentAmount")
        public PositiveMoney getFeaturePaymentAmount() {
            return this.featurePaymentAmount;
        }

        @Override
        @RosettaAttribute(value="trigger", isRequired=true)
        @RuneAttribute(value="trigger", isRequired=true)
        public CommodityTrigger getTrigger() {
            return this.trigger;
        }

        @Override
        public CommodityBarrier build() {
            return this;
        }

        @Override
        public CommodityBarrierBuilder toBuilder() {
            CommodityBarrierBuilder builder = CommodityBarrier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityBarrierBuilder builder) {
            Optional.ofNullable(this.getKnock()).ifPresent(builder::setKnock);
            Optional.ofNullable(this.getFeaturePaymentAmount()).ifPresent(builder::setFeaturePaymentAmount);
            Optional.ofNullable(this.getTrigger()).ifPresent(builder::setTrigger);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityBarrier _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.knock, (Object)_that.getKnock())) {
                return false;
            }
            if (!Objects.equals(this.featurePaymentAmount, _that.getFeaturePaymentAmount())) {
                return false;
            }
            return Objects.equals(this.trigger, _that.getTrigger());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.knock != null ? ((Object)((Object)this.knock)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.featurePaymentAmount != null ? this.featurePaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.trigger != null ? this.trigger.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityBarrier {knock=" + (Object)((Object)this.knock) + ", featurePaymentAmount=" + this.featurePaymentAmount + ", trigger=" + this.trigger + '}';
        }
    }
}

