/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.cd.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.cd.ValuationDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ValuationDateChoice")
@ImplementedBy(value=Default.class)
public interface ValuationDateChoice
extends Validator<ValuationDate> {
    public static final String NAME = "ValuationDateChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements ValuationDateChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ValuationDate valuationDate) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ValuationDateChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ValuationDate valuationDate) {
            ComparisonResult result = this.executeDataRule(valuationDate);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ValuationDateChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationDate", (RosettaPath)path, (String)ValuationDateChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ValuationDateChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationDate", (RosettaPath)path, (String)ValuationDateChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ValuationDate valuationDate) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)valuationDate), Arrays.asList("singleValuationDate", "multipleValuationDates"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

