/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.cd;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.cd.AdjustedPaymentDates;
import fpml.consolidated.cd.FixedAmountCalculation;
import fpml.consolidated.cd.FloatingAmountCalculation;
import fpml.consolidated.cd.meta.PeriodicPaymentMeta;
import fpml.consolidated.fpmlenum.RollConventionEnum;
import fpml.consolidated.shared.Money;
import fpml.consolidated.shared.PaymentBase;
import fpml.consolidated.shared.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PeriodicPayment", builder=PeriodicPaymentBuilderImpl.class, version="1.1.0")
@RuneDataType(value="PeriodicPayment", model="fpml", builder=PeriodicPaymentBuilderImpl.class, version="1.1.0")
public interface PeriodicPayment
extends PaymentBase {
    public static final PeriodicPaymentMeta metaData = new PeriodicPaymentMeta();

    public Period getPaymentFrequency();

    public ZonedDateTime getFirstPeriodStartDate();

    public ZonedDateTime getFirstPaymentDate();

    public ZonedDateTime getLastRegularPaymentDate();

    public RollConventionEnum getRollConvention();

    public Money getFixedAmount();

    public FixedAmountCalculation getFixedAmountCalculation();

    public FloatingAmountCalculation getFloatingAmountCalculation();

    public List<? extends AdjustedPaymentDates> getAdjustedPaymentDates();

    @Override
    public PeriodicPayment build();

    @Override
    public PeriodicPaymentBuilder toBuilder();

    public static PeriodicPaymentBuilder builder() {
        return new PeriodicPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends PeriodicPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PeriodicPayment> getType() {
        return PeriodicPayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstPeriodStartDate"), ZonedDateTime.class, (Object)this.getFirstPeriodStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstPaymentDate"), ZonedDateTime.class, (Object)this.getFirstPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastRegularPaymentDate"), ZonedDateTime.class, (Object)this.getLastRegularPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rollConvention"), RollConventionEnum.class, (Object)this.getRollConvention(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedAmount"), processor, Money.class, this.getFixedAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedAmountCalculation"), processor, FixedAmountCalculation.class, this.getFixedAmountCalculation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingAmountCalculation"), processor, FloatingAmountCalculation.class, this.getFloatingAmountCalculation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("adjustedPaymentDates"), processor, AdjustedPaymentDates.class, this.getAdjustedPaymentDates(), new AttributeMeta[0]);
    }

    public static class PeriodicPaymentBuilderImpl
    extends PaymentBase.PaymentBaseBuilderImpl
    implements PeriodicPaymentBuilder {
        protected Period.PeriodBuilder paymentFrequency;
        protected ZonedDateTime firstPeriodStartDate;
        protected ZonedDateTime firstPaymentDate;
        protected ZonedDateTime lastRegularPaymentDate;
        protected RollConventionEnum rollConvention;
        protected Money.MoneyBuilder fixedAmount;
        protected FixedAmountCalculation.FixedAmountCalculationBuilder fixedAmountCalculation;
        protected FloatingAmountCalculation.FloatingAmountCalculationBuilder floatingAmountCalculation;
        protected List<AdjustedPaymentDates.AdjustedPaymentDatesBuilder> adjustedPaymentDates = new ArrayList<AdjustedPaymentDates.AdjustedPaymentDatesBuilder>();

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Period.PeriodBuilder getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        public Period.PeriodBuilder getOrCreatePaymentFrequency() {
            Period.PeriodBuilder result = this.paymentFrequency != null ? this.paymentFrequency : (this.paymentFrequency = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="firstPeriodStartDate")
        @RuneAttribute(value="firstPeriodStartDate")
        public ZonedDateTime getFirstPeriodStartDate() {
            return this.firstPeriodStartDate;
        }

        @Override
        @RosettaAttribute(value="firstPaymentDate")
        @RuneAttribute(value="firstPaymentDate")
        public ZonedDateTime getFirstPaymentDate() {
            return this.firstPaymentDate;
        }

        @Override
        @RosettaAttribute(value="lastRegularPaymentDate")
        @RuneAttribute(value="lastRegularPaymentDate")
        public ZonedDateTime getLastRegularPaymentDate() {
            return this.lastRegularPaymentDate;
        }

        @Override
        @RosettaAttribute(value="rollConvention")
        @RuneAttribute(value="rollConvention")
        public RollConventionEnum getRollConvention() {
            return this.rollConvention;
        }

        @Override
        @RosettaAttribute(value="fixedAmount")
        @RuneAttribute(value="fixedAmount")
        public Money.MoneyBuilder getFixedAmount() {
            return this.fixedAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateFixedAmount() {
            Money.MoneyBuilder result = this.fixedAmount != null ? this.fixedAmount : (this.fixedAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedAmountCalculation")
        @RuneAttribute(value="fixedAmountCalculation")
        public FixedAmountCalculation.FixedAmountCalculationBuilder getFixedAmountCalculation() {
            return this.fixedAmountCalculation;
        }

        @Override
        public FixedAmountCalculation.FixedAmountCalculationBuilder getOrCreateFixedAmountCalculation() {
            FixedAmountCalculation.FixedAmountCalculationBuilder result = this.fixedAmountCalculation != null ? this.fixedAmountCalculation : (this.fixedAmountCalculation = FixedAmountCalculation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="floatingAmountCalculation")
        @RuneAttribute(value="floatingAmountCalculation")
        public FloatingAmountCalculation.FloatingAmountCalculationBuilder getFloatingAmountCalculation() {
            return this.floatingAmountCalculation;
        }

        @Override
        public FloatingAmountCalculation.FloatingAmountCalculationBuilder getOrCreateFloatingAmountCalculation() {
            FloatingAmountCalculation.FloatingAmountCalculationBuilder result = this.floatingAmountCalculation != null ? this.floatingAmountCalculation : (this.floatingAmountCalculation = FloatingAmountCalculation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDates")
        @RuneAttribute(value="adjustedPaymentDates")
        public List<? extends AdjustedPaymentDates.AdjustedPaymentDatesBuilder> getAdjustedPaymentDates() {
            return this.adjustedPaymentDates;
        }

        @Override
        public AdjustedPaymentDates.AdjustedPaymentDatesBuilder getOrCreateAdjustedPaymentDates(int index) {
            if (this.adjustedPaymentDates == null) {
                this.adjustedPaymentDates = new ArrayList<AdjustedPaymentDates.AdjustedPaymentDatesBuilder>();
            }
            return (AdjustedPaymentDates.AdjustedPaymentDatesBuilder)this.getIndex(this.adjustedPaymentDates, index, () -> {
                AdjustedPaymentDates.AdjustedPaymentDatesBuilder newAdjustedPaymentDates = AdjustedPaymentDates.builder();
                return newAdjustedPaymentDates;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public PeriodicPaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public PeriodicPaymentBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="firstPeriodStartDate")
        @RuneAttribute(value="firstPeriodStartDate")
        public PeriodicPaymentBuilder setFirstPeriodStartDate(ZonedDateTime _firstPeriodStartDate) {
            this.firstPeriodStartDate = _firstPeriodStartDate == null ? null : _firstPeriodStartDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="firstPaymentDate")
        @RuneAttribute(value="firstPaymentDate")
        public PeriodicPaymentBuilder setFirstPaymentDate(ZonedDateTime _firstPaymentDate) {
            this.firstPaymentDate = _firstPaymentDate == null ? null : _firstPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastRegularPaymentDate")
        @RuneAttribute(value="lastRegularPaymentDate")
        public PeriodicPaymentBuilder setLastRegularPaymentDate(ZonedDateTime _lastRegularPaymentDate) {
            this.lastRegularPaymentDate = _lastRegularPaymentDate == null ? null : _lastRegularPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="rollConvention")
        @RuneAttribute(value="rollConvention")
        public PeriodicPaymentBuilder setRollConvention(RollConventionEnum _rollConvention) {
            this.rollConvention = _rollConvention == null ? null : _rollConvention;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedAmount")
        @RuneAttribute(value="fixedAmount")
        public PeriodicPaymentBuilder setFixedAmount(Money _fixedAmount) {
            this.fixedAmount = _fixedAmount == null ? null : _fixedAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedAmountCalculation")
        @RuneAttribute(value="fixedAmountCalculation")
        public PeriodicPaymentBuilder setFixedAmountCalculation(FixedAmountCalculation _fixedAmountCalculation) {
            this.fixedAmountCalculation = _fixedAmountCalculation == null ? null : _fixedAmountCalculation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingAmountCalculation")
        @RuneAttribute(value="floatingAmountCalculation")
        public PeriodicPaymentBuilder setFloatingAmountCalculation(FloatingAmountCalculation _floatingAmountCalculation) {
            this.floatingAmountCalculation = _floatingAmountCalculation == null ? null : _floatingAmountCalculation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDates")
        @RuneAttribute(value="adjustedPaymentDates")
        public PeriodicPaymentBuilder addAdjustedPaymentDates(AdjustedPaymentDates _adjustedPaymentDates) {
            if (_adjustedPaymentDates != null) {
                this.adjustedPaymentDates.add(_adjustedPaymentDates.toBuilder());
            }
            return this;
        }

        @Override
        public PeriodicPaymentBuilder addAdjustedPaymentDates(AdjustedPaymentDates _adjustedPaymentDates, int idx) {
            this.getIndex(this.adjustedPaymentDates, idx, () -> _adjustedPaymentDates.toBuilder());
            return this;
        }

        @Override
        public PeriodicPaymentBuilder addAdjustedPaymentDates(List<? extends AdjustedPaymentDates> adjustedPaymentDatess) {
            if (adjustedPaymentDatess != null) {
                for (AdjustedPaymentDates adjustedPaymentDates : adjustedPaymentDatess) {
                    this.adjustedPaymentDates.add(adjustedPaymentDates.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="adjustedPaymentDates")
        public PeriodicPaymentBuilder setAdjustedPaymentDates(List<? extends AdjustedPaymentDates> adjustedPaymentDatess) {
            this.adjustedPaymentDates = adjustedPaymentDatess == null ? new ArrayList<AdjustedPaymentDates.AdjustedPaymentDatesBuilder>() : (List)adjustedPaymentDatess.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PeriodicPayment build() {
            return new PeriodicPaymentImpl(this);
        }

        @Override
        public PeriodicPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public PeriodicPaymentBuilder prune() {
            super.prune();
            if (this.paymentFrequency != null && !this.paymentFrequency.prune().hasData()) {
                this.paymentFrequency = null;
            }
            if (this.fixedAmount != null && !this.fixedAmount.prune().hasData()) {
                this.fixedAmount = null;
            }
            if (this.fixedAmountCalculation != null && !this.fixedAmountCalculation.prune().hasData()) {
                this.fixedAmountCalculation = null;
            }
            if (this.floatingAmountCalculation != null && !this.floatingAmountCalculation.prune().hasData()) {
                this.floatingAmountCalculation = null;
            }
            this.adjustedPaymentDates = this.adjustedPaymentDates.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPaymentFrequency() != null && this.getPaymentFrequency().hasData()) {
                return true;
            }
            if (this.getFirstPeriodStartDate() != null) {
                return true;
            }
            if (this.getFirstPaymentDate() != null) {
                return true;
            }
            if (this.getLastRegularPaymentDate() != null) {
                return true;
            }
            if (this.getRollConvention() != null) {
                return true;
            }
            if (this.getFixedAmount() != null && this.getFixedAmount().hasData()) {
                return true;
            }
            if (this.getFixedAmountCalculation() != null && this.getFixedAmountCalculation().hasData()) {
                return true;
            }
            if (this.getFloatingAmountCalculation() != null && this.getFloatingAmountCalculation().hasData()) {
                return true;
            }
            return this.getAdjustedPaymentDates() != null && this.getAdjustedPaymentDates().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public PeriodicPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PeriodicPaymentBuilder o = (PeriodicPaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentFrequency(), (RosettaModelObjectBuilder)o.getPaymentFrequency(), this::setPaymentFrequency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedAmount(), (RosettaModelObjectBuilder)o.getFixedAmount(), this::setFixedAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedAmountCalculation(), (RosettaModelObjectBuilder)o.getFixedAmountCalculation(), this::setFixedAmountCalculation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingAmountCalculation(), (RosettaModelObjectBuilder)o.getFloatingAmountCalculation(), this::setFloatingAmountCalculation);
            merger.mergeRosetta(this.getAdjustedPaymentDates(), o.getAdjustedPaymentDates(), this::getOrCreateAdjustedPaymentDates);
            merger.mergeBasic((Object)this.getFirstPeriodStartDate(), (Object)o.getFirstPeriodStartDate(), this::setFirstPeriodStartDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFirstPaymentDate(), (Object)o.getFirstPaymentDate(), this::setFirstPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLastRegularPaymentDate(), (Object)o.getLastRegularPaymentDate(), this::setLastRegularPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRollConvention(), (Object)o.getRollConvention(), this::setRollConvention, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PeriodicPayment _that = (PeriodicPayment)this.getType().cast(o);
            if (!Objects.equals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            if (!Objects.equals(this.firstPeriodStartDate, _that.getFirstPeriodStartDate())) {
                return false;
            }
            if (!Objects.equals(this.firstPaymentDate, _that.getFirstPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.lastRegularPaymentDate, _that.getLastRegularPaymentDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.rollConvention, (Object)_that.getRollConvention())) {
                return false;
            }
            if (!Objects.equals(this.fixedAmount, _that.getFixedAmount())) {
                return false;
            }
            if (!Objects.equals(this.fixedAmountCalculation, _that.getFixedAmountCalculation())) {
                return false;
            }
            if (!Objects.equals(this.floatingAmountCalculation, _that.getFloatingAmountCalculation())) {
                return false;
            }
            return ListEquals.listEquals(this.adjustedPaymentDates, _that.getAdjustedPaymentDates());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.firstPeriodStartDate != null ? this.firstPeriodStartDate.hashCode() : 0);
            _result = 31 * _result + (this.firstPaymentDate != null ? this.firstPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.lastRegularPaymentDate != null ? this.lastRegularPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.rollConvention != null ? ((Object)((Object)this.rollConvention)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedAmount != null ? this.fixedAmount.hashCode() : 0);
            _result = 31 * _result + (this.fixedAmountCalculation != null ? this.fixedAmountCalculation.hashCode() : 0);
            _result = 31 * _result + (this.floatingAmountCalculation != null ? this.floatingAmountCalculation.hashCode() : 0);
            _result = 31 * _result + (this.adjustedPaymentDates != null ? this.adjustedPaymentDates.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PeriodicPaymentBuilder {paymentFrequency=" + this.paymentFrequency + ", firstPeriodStartDate=" + this.firstPeriodStartDate + ", firstPaymentDate=" + this.firstPaymentDate + ", lastRegularPaymentDate=" + this.lastRegularPaymentDate + ", rollConvention=" + (Object)((Object)this.rollConvention) + ", fixedAmount=" + this.fixedAmount + ", fixedAmountCalculation=" + this.fixedAmountCalculation + ", floatingAmountCalculation=" + this.floatingAmountCalculation + ", adjustedPaymentDates=" + this.adjustedPaymentDates + '}' + " " + super.toString();
        }
    }

    public static interface PeriodicPaymentBuilder
    extends PeriodicPayment,
    PaymentBase.PaymentBaseBuilder {
        public Period.PeriodBuilder getOrCreatePaymentFrequency();

        @Override
        public Period.PeriodBuilder getPaymentFrequency();

        public Money.MoneyBuilder getOrCreateFixedAmount();

        @Override
        public Money.MoneyBuilder getFixedAmount();

        public FixedAmountCalculation.FixedAmountCalculationBuilder getOrCreateFixedAmountCalculation();

        @Override
        public FixedAmountCalculation.FixedAmountCalculationBuilder getFixedAmountCalculation();

        public FloatingAmountCalculation.FloatingAmountCalculationBuilder getOrCreateFloatingAmountCalculation();

        @Override
        public FloatingAmountCalculation.FloatingAmountCalculationBuilder getFloatingAmountCalculation();

        public AdjustedPaymentDates.AdjustedPaymentDatesBuilder getOrCreateAdjustedPaymentDates(int var1);

        public List<? extends AdjustedPaymentDates.AdjustedPaymentDatesBuilder> getAdjustedPaymentDates();

        @Override
        public PeriodicPaymentBuilder setId(String var1);

        public PeriodicPaymentBuilder setPaymentFrequency(Period var1);

        public PeriodicPaymentBuilder setFirstPeriodStartDate(ZonedDateTime var1);

        public PeriodicPaymentBuilder setFirstPaymentDate(ZonedDateTime var1);

        public PeriodicPaymentBuilder setLastRegularPaymentDate(ZonedDateTime var1);

        public PeriodicPaymentBuilder setRollConvention(RollConventionEnum var1);

        public PeriodicPaymentBuilder setFixedAmount(Money var1);

        public PeriodicPaymentBuilder setFixedAmountCalculation(FixedAmountCalculation var1);

        public PeriodicPaymentBuilder setFloatingAmountCalculation(FloatingAmountCalculation var1);

        public PeriodicPaymentBuilder addAdjustedPaymentDates(AdjustedPaymentDates var1);

        public PeriodicPaymentBuilder addAdjustedPaymentDates(AdjustedPaymentDates var1, int var2);

        public PeriodicPaymentBuilder addAdjustedPaymentDates(List<? extends AdjustedPaymentDates> var1);

        public PeriodicPaymentBuilder setAdjustedPaymentDates(List<? extends AdjustedPaymentDates> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, this.getPaymentFrequency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstPeriodStartDate"), ZonedDateTime.class, (Object)this.getFirstPeriodStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstPaymentDate"), ZonedDateTime.class, (Object)this.getFirstPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastRegularPaymentDate"), ZonedDateTime.class, (Object)this.getLastRegularPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rollConvention"), RollConventionEnum.class, (Object)this.getRollConvention(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedAmount"), processor, Money.MoneyBuilder.class, this.getFixedAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedAmountCalculation"), processor, FixedAmountCalculation.FixedAmountCalculationBuilder.class, this.getFixedAmountCalculation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingAmountCalculation"), processor, FloatingAmountCalculation.FloatingAmountCalculationBuilder.class, this.getFloatingAmountCalculation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("adjustedPaymentDates"), processor, AdjustedPaymentDates.AdjustedPaymentDatesBuilder.class, this.getAdjustedPaymentDates(), new AttributeMeta[0]);
        }

        @Override
        public PeriodicPaymentBuilder prune();
    }

    public static class PeriodicPaymentImpl
    extends PaymentBase.PaymentBaseImpl
    implements PeriodicPayment {
        private final Period paymentFrequency;
        private final ZonedDateTime firstPeriodStartDate;
        private final ZonedDateTime firstPaymentDate;
        private final ZonedDateTime lastRegularPaymentDate;
        private final RollConventionEnum rollConvention;
        private final Money fixedAmount;
        private final FixedAmountCalculation fixedAmountCalculation;
        private final FloatingAmountCalculation floatingAmountCalculation;
        private final List<? extends AdjustedPaymentDates> adjustedPaymentDates;

        protected PeriodicPaymentImpl(PeriodicPaymentBuilder builder) {
            super(builder);
            this.paymentFrequency = Optional.ofNullable(builder.getPaymentFrequency()).map(f -> f.build()).orElse(null);
            this.firstPeriodStartDate = builder.getFirstPeriodStartDate();
            this.firstPaymentDate = builder.getFirstPaymentDate();
            this.lastRegularPaymentDate = builder.getLastRegularPaymentDate();
            this.rollConvention = builder.getRollConvention();
            this.fixedAmount = Optional.ofNullable(builder.getFixedAmount()).map(f -> f.build()).orElse(null);
            this.fixedAmountCalculation = Optional.ofNullable(builder.getFixedAmountCalculation()).map(f -> f.build()).orElse(null);
            this.floatingAmountCalculation = Optional.ofNullable(builder.getFloatingAmountCalculation()).map(f -> f.build()).orElse(null);
            this.adjustedPaymentDates = Optional.ofNullable(builder.getAdjustedPaymentDates()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Period getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        @RosettaAttribute(value="firstPeriodStartDate")
        @RuneAttribute(value="firstPeriodStartDate")
        public ZonedDateTime getFirstPeriodStartDate() {
            return this.firstPeriodStartDate;
        }

        @Override
        @RosettaAttribute(value="firstPaymentDate")
        @RuneAttribute(value="firstPaymentDate")
        public ZonedDateTime getFirstPaymentDate() {
            return this.firstPaymentDate;
        }

        @Override
        @RosettaAttribute(value="lastRegularPaymentDate")
        @RuneAttribute(value="lastRegularPaymentDate")
        public ZonedDateTime getLastRegularPaymentDate() {
            return this.lastRegularPaymentDate;
        }

        @Override
        @RosettaAttribute(value="rollConvention")
        @RuneAttribute(value="rollConvention")
        public RollConventionEnum getRollConvention() {
            return this.rollConvention;
        }

        @Override
        @RosettaAttribute(value="fixedAmount")
        @RuneAttribute(value="fixedAmount")
        public Money getFixedAmount() {
            return this.fixedAmount;
        }

        @Override
        @RosettaAttribute(value="fixedAmountCalculation")
        @RuneAttribute(value="fixedAmountCalculation")
        public FixedAmountCalculation getFixedAmountCalculation() {
            return this.fixedAmountCalculation;
        }

        @Override
        @RosettaAttribute(value="floatingAmountCalculation")
        @RuneAttribute(value="floatingAmountCalculation")
        public FloatingAmountCalculation getFloatingAmountCalculation() {
            return this.floatingAmountCalculation;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDates")
        @RuneAttribute(value="adjustedPaymentDates")
        public List<? extends AdjustedPaymentDates> getAdjustedPaymentDates() {
            return this.adjustedPaymentDates;
        }

        @Override
        public PeriodicPayment build() {
            return this;
        }

        @Override
        public PeriodicPaymentBuilder toBuilder() {
            PeriodicPaymentBuilder builder = PeriodicPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PeriodicPaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPaymentFrequency()).ifPresent(builder::setPaymentFrequency);
            Optional.ofNullable(this.getFirstPeriodStartDate()).ifPresent(builder::setFirstPeriodStartDate);
            Optional.ofNullable(this.getFirstPaymentDate()).ifPresent(builder::setFirstPaymentDate);
            Optional.ofNullable(this.getLastRegularPaymentDate()).ifPresent(builder::setLastRegularPaymentDate);
            Optional.ofNullable(this.getRollConvention()).ifPresent(builder::setRollConvention);
            Optional.ofNullable(this.getFixedAmount()).ifPresent(builder::setFixedAmount);
            Optional.ofNullable(this.getFixedAmountCalculation()).ifPresent(builder::setFixedAmountCalculation);
            Optional.ofNullable(this.getFloatingAmountCalculation()).ifPresent(builder::setFloatingAmountCalculation);
            Optional.ofNullable(this.getAdjustedPaymentDates()).ifPresent(builder::setAdjustedPaymentDates);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PeriodicPayment _that = (PeriodicPayment)this.getType().cast(o);
            if (!Objects.equals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            if (!Objects.equals(this.firstPeriodStartDate, _that.getFirstPeriodStartDate())) {
                return false;
            }
            if (!Objects.equals(this.firstPaymentDate, _that.getFirstPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.lastRegularPaymentDate, _that.getLastRegularPaymentDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.rollConvention, (Object)_that.getRollConvention())) {
                return false;
            }
            if (!Objects.equals(this.fixedAmount, _that.getFixedAmount())) {
                return false;
            }
            if (!Objects.equals(this.fixedAmountCalculation, _that.getFixedAmountCalculation())) {
                return false;
            }
            if (!Objects.equals(this.floatingAmountCalculation, _that.getFloatingAmountCalculation())) {
                return false;
            }
            return ListEquals.listEquals(this.adjustedPaymentDates, _that.getAdjustedPaymentDates());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.firstPeriodStartDate != null ? this.firstPeriodStartDate.hashCode() : 0);
            _result = 31 * _result + (this.firstPaymentDate != null ? this.firstPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.lastRegularPaymentDate != null ? this.lastRegularPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.rollConvention != null ? ((Object)((Object)this.rollConvention)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedAmount != null ? this.fixedAmount.hashCode() : 0);
            _result = 31 * _result + (this.fixedAmountCalculation != null ? this.fixedAmountCalculation.hashCode() : 0);
            _result = 31 * _result + (this.floatingAmountCalculation != null ? this.floatingAmountCalculation.hashCode() : 0);
            _result = 31 * _result + (this.adjustedPaymentDates != null ? this.adjustedPaymentDates.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PeriodicPayment {paymentFrequency=" + this.paymentFrequency + ", firstPeriodStartDate=" + this.firstPeriodStartDate + ", firstPaymentDate=" + this.firstPaymentDate + ", lastRegularPaymentDate=" + this.lastRegularPaymentDate + ", rollConvention=" + (Object)((Object)this.rollConvention) + ", fixedAmount=" + this.fixedAmount + ", fixedAmountCalculation=" + this.fixedAmountCalculation + ", floatingAmountCalculation=" + this.floatingAmountCalculation + ", adjustedPaymentDates=" + this.adjustedPaymentDates + '}' + " " + super.toString();
        }
    }
}

