/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.meta.PackageHeaderMeta;
import fpml.consolidated.doc.OrderIdentifier;
import fpml.consolidated.doc.PackageInformation;
import fpml.consolidated.doc.PackageType;
import fpml.consolidated.shared.IssuerTradeId;
import fpml.consolidated.shared.OriginatingEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PackageHeader", builder=PackageHeaderBuilderImpl.class, version="1.1.0")
@RuneDataType(value="PackageHeader", model="fpml", builder=PackageHeaderBuilderImpl.class, version="1.1.0")
public interface PackageHeader
extends RosettaModelObject {
    public static final PackageHeaderMeta metaData = new PackageHeaderMeta();

    public IssuerTradeId getPackageIdentifier();

    public OrderIdentifier getOrderIdentifier();

    public List<? extends PackageType> getPackageType();

    public BigDecimal getSize();

    public OriginatingEvent getOriginatingEvent();

    public PackageInformation getPackageInformation();

    public PackageHeader build();

    public PackageHeaderBuilder toBuilder();

    public static PackageHeaderBuilder builder() {
        return new PackageHeaderBuilderImpl();
    }

    default public RosettaMetaData<? extends PackageHeader> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PackageHeader> getType() {
        return PackageHeader.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("packageIdentifier"), processor, IssuerTradeId.class, this.getPackageIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("orderIdentifier"), processor, OrderIdentifier.class, this.getOrderIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageType"), processor, PackageType.class, this.getPackageType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("size"), BigDecimal.class, (Object)this.getSize(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("originatingEvent"), processor, OriginatingEvent.class, this.getOriginatingEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageInformation"), processor, PackageInformation.class, this.getPackageInformation(), new AttributeMeta[0]);
    }

    public static class PackageHeaderBuilderImpl
    implements PackageHeaderBuilder {
        protected IssuerTradeId.IssuerTradeIdBuilder packageIdentifier;
        protected OrderIdentifier.OrderIdentifierBuilder orderIdentifier;
        protected List<PackageType.PackageTypeBuilder> packageType = new ArrayList<PackageType.PackageTypeBuilder>();
        protected BigDecimal size;
        protected OriginatingEvent.OriginatingEventBuilder originatingEvent;
        protected PackageInformation.PackageInformationBuilder packageInformation;

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public IssuerTradeId.IssuerTradeIdBuilder getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        public IssuerTradeId.IssuerTradeIdBuilder getOrCreatePackageIdentifier() {
            IssuerTradeId.IssuerTradeIdBuilder result = this.packageIdentifier != null ? this.packageIdentifier : (this.packageIdentifier = IssuerTradeId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="orderIdentifier")
        @RuneAttribute(value="orderIdentifier")
        public OrderIdentifier.OrderIdentifierBuilder getOrderIdentifier() {
            return this.orderIdentifier;
        }

        @Override
        public OrderIdentifier.OrderIdentifierBuilder getOrCreateOrderIdentifier() {
            OrderIdentifier.OrderIdentifierBuilder result = this.orderIdentifier != null ? this.orderIdentifier : (this.orderIdentifier = OrderIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageType")
        @RuneAttribute(value="packageType")
        public List<? extends PackageType.PackageTypeBuilder> getPackageType() {
            return this.packageType;
        }

        @Override
        public PackageType.PackageTypeBuilder getOrCreatePackageType(int index) {
            if (this.packageType == null) {
                this.packageType = new ArrayList<PackageType.PackageTypeBuilder>();
            }
            return (PackageType.PackageTypeBuilder)this.getIndex(this.packageType, index, () -> {
                PackageType.PackageTypeBuilder newPackageType = PackageType.builder();
                return newPackageType;
            });
        }

        @Override
        @RosettaAttribute(value="size")
        @RuneAttribute(value="size")
        public BigDecimal getSize() {
            return this.size;
        }

        @Override
        @RosettaAttribute(value="originatingEvent")
        @RuneAttribute(value="originatingEvent")
        public OriginatingEvent.OriginatingEventBuilder getOriginatingEvent() {
            return this.originatingEvent;
        }

        @Override
        public OriginatingEvent.OriginatingEventBuilder getOrCreateOriginatingEvent() {
            OriginatingEvent.OriginatingEventBuilder result = this.originatingEvent != null ? this.originatingEvent : (this.originatingEvent = OriginatingEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageInformation")
        @RuneAttribute(value="packageInformation")
        public PackageInformation.PackageInformationBuilder getPackageInformation() {
            return this.packageInformation;
        }

        @Override
        public PackageInformation.PackageInformationBuilder getOrCreatePackageInformation() {
            PackageInformation.PackageInformationBuilder result = this.packageInformation != null ? this.packageInformation : (this.packageInformation = PackageInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public PackageHeaderBuilder setPackageIdentifier(IssuerTradeId _packageIdentifier) {
            this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="orderIdentifier")
        @RuneAttribute(value="orderIdentifier")
        public PackageHeaderBuilder setOrderIdentifier(OrderIdentifier _orderIdentifier) {
            this.orderIdentifier = _orderIdentifier == null ? null : _orderIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageType")
        @RuneAttribute(value="packageType")
        public PackageHeaderBuilder addPackageType(PackageType _packageType) {
            if (_packageType != null) {
                this.packageType.add(_packageType.toBuilder());
            }
            return this;
        }

        @Override
        public PackageHeaderBuilder addPackageType(PackageType _packageType, int idx) {
            this.getIndex(this.packageType, idx, () -> _packageType.toBuilder());
            return this;
        }

        @Override
        public PackageHeaderBuilder addPackageType(List<? extends PackageType> packageTypes) {
            if (packageTypes != null) {
                for (PackageType packageType : packageTypes) {
                    this.packageType.add(packageType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="packageType")
        public PackageHeaderBuilder setPackageType(List<? extends PackageType> packageTypes) {
            this.packageType = packageTypes == null ? new ArrayList<PackageType.PackageTypeBuilder>() : (List)packageTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="size")
        @RuneAttribute(value="size")
        public PackageHeaderBuilder setSize(BigDecimal _size) {
            this.size = _size == null ? null : _size;
            return this;
        }

        @Override
        @RosettaAttribute(value="originatingEvent")
        @RuneAttribute(value="originatingEvent")
        public PackageHeaderBuilder setOriginatingEvent(OriginatingEvent _originatingEvent) {
            this.originatingEvent = _originatingEvent == null ? null : _originatingEvent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageInformation")
        @RuneAttribute(value="packageInformation")
        public PackageHeaderBuilder setPackageInformation(PackageInformation _packageInformation) {
            this.packageInformation = _packageInformation == null ? null : _packageInformation.toBuilder();
            return this;
        }

        @Override
        public PackageHeader build() {
            return new PackageHeaderImpl(this);
        }

        @Override
        public PackageHeaderBuilder toBuilder() {
            return this;
        }

        @Override
        public PackageHeaderBuilder prune() {
            if (this.packageIdentifier != null && !this.packageIdentifier.prune().hasData()) {
                this.packageIdentifier = null;
            }
            if (this.orderIdentifier != null && !this.orderIdentifier.prune().hasData()) {
                this.orderIdentifier = null;
            }
            this.packageType = this.packageType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.originatingEvent != null && !this.originatingEvent.prune().hasData()) {
                this.originatingEvent = null;
            }
            if (this.packageInformation != null && !this.packageInformation.prune().hasData()) {
                this.packageInformation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPackageIdentifier() != null && this.getPackageIdentifier().hasData()) {
                return true;
            }
            if (this.getOrderIdentifier() != null && this.getOrderIdentifier().hasData()) {
                return true;
            }
            if (this.getPackageType() != null && this.getPackageType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSize() != null) {
                return true;
            }
            if (this.getOriginatingEvent() != null && this.getOriginatingEvent().hasData()) {
                return true;
            }
            return this.getPackageInformation() != null && this.getPackageInformation().hasData();
        }

        public PackageHeaderBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PackageHeaderBuilder o = (PackageHeaderBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageIdentifier(), (RosettaModelObjectBuilder)o.getPackageIdentifier(), this::setPackageIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOrderIdentifier(), (RosettaModelObjectBuilder)o.getOrderIdentifier(), this::setOrderIdentifier);
            merger.mergeRosetta(this.getPackageType(), o.getPackageType(), this::getOrCreatePackageType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOriginatingEvent(), (RosettaModelObjectBuilder)o.getOriginatingEvent(), this::setOriginatingEvent);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageInformation(), (RosettaModelObjectBuilder)o.getPackageInformation(), this::setPackageInformation);
            merger.mergeBasic((Object)this.getSize(), (Object)o.getSize(), this::setSize, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PackageHeader _that = this.getType().cast(o);
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.orderIdentifier, _that.getOrderIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.packageType, _that.getPackageType())) {
                return false;
            }
            if (!Objects.equals(this.size, _that.getSize())) {
                return false;
            }
            if (!Objects.equals(this.originatingEvent, _that.getOriginatingEvent())) {
                return false;
            }
            return Objects.equals(this.packageInformation, _that.getPackageInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.orderIdentifier != null ? this.orderIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.packageType != null ? this.packageType.hashCode() : 0);
            _result = 31 * _result + (this.size != null ? this.size.hashCode() : 0);
            _result = 31 * _result + (this.originatingEvent != null ? this.originatingEvent.hashCode() : 0);
            _result = 31 * _result + (this.packageInformation != null ? this.packageInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PackageHeaderBuilder {packageIdentifier=" + this.packageIdentifier + ", orderIdentifier=" + this.orderIdentifier + ", packageType=" + this.packageType + ", size=" + this.size + ", originatingEvent=" + this.originatingEvent + ", packageInformation=" + this.packageInformation + '}';
        }
    }

    public static interface PackageHeaderBuilder
    extends PackageHeader,
    RosettaModelObjectBuilder {
        public IssuerTradeId.IssuerTradeIdBuilder getOrCreatePackageIdentifier();

        @Override
        public IssuerTradeId.IssuerTradeIdBuilder getPackageIdentifier();

        public OrderIdentifier.OrderIdentifierBuilder getOrCreateOrderIdentifier();

        @Override
        public OrderIdentifier.OrderIdentifierBuilder getOrderIdentifier();

        public PackageType.PackageTypeBuilder getOrCreatePackageType(int var1);

        public List<? extends PackageType.PackageTypeBuilder> getPackageType();

        public OriginatingEvent.OriginatingEventBuilder getOrCreateOriginatingEvent();

        @Override
        public OriginatingEvent.OriginatingEventBuilder getOriginatingEvent();

        public PackageInformation.PackageInformationBuilder getOrCreatePackageInformation();

        @Override
        public PackageInformation.PackageInformationBuilder getPackageInformation();

        public PackageHeaderBuilder setPackageIdentifier(IssuerTradeId var1);

        public PackageHeaderBuilder setOrderIdentifier(OrderIdentifier var1);

        public PackageHeaderBuilder addPackageType(PackageType var1);

        public PackageHeaderBuilder addPackageType(PackageType var1, int var2);

        public PackageHeaderBuilder addPackageType(List<? extends PackageType> var1);

        public PackageHeaderBuilder setPackageType(List<? extends PackageType> var1);

        public PackageHeaderBuilder setSize(BigDecimal var1);

        public PackageHeaderBuilder setOriginatingEvent(OriginatingEvent var1);

        public PackageHeaderBuilder setPackageInformation(PackageInformation var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("packageIdentifier"), processor, IssuerTradeId.IssuerTradeIdBuilder.class, this.getPackageIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("orderIdentifier"), processor, OrderIdentifier.OrderIdentifierBuilder.class, this.getOrderIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageType"), processor, PackageType.PackageTypeBuilder.class, this.getPackageType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("size"), BigDecimal.class, (Object)this.getSize(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("originatingEvent"), processor, OriginatingEvent.OriginatingEventBuilder.class, this.getOriginatingEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageInformation"), processor, PackageInformation.PackageInformationBuilder.class, this.getPackageInformation(), new AttributeMeta[0]);
        }

        public PackageHeaderBuilder prune();
    }

    public static class PackageHeaderImpl
    implements PackageHeader {
        private final IssuerTradeId packageIdentifier;
        private final OrderIdentifier orderIdentifier;
        private final List<? extends PackageType> packageType;
        private final BigDecimal size;
        private final OriginatingEvent originatingEvent;
        private final PackageInformation packageInformation;

        protected PackageHeaderImpl(PackageHeaderBuilder builder) {
            this.packageIdentifier = Optional.ofNullable(builder.getPackageIdentifier()).map(f -> f.build()).orElse(null);
            this.orderIdentifier = Optional.ofNullable(builder.getOrderIdentifier()).map(f -> f.build()).orElse(null);
            this.packageType = Optional.ofNullable(builder.getPackageType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.size = builder.getSize();
            this.originatingEvent = Optional.ofNullable(builder.getOriginatingEvent()).map(f -> f.build()).orElse(null);
            this.packageInformation = Optional.ofNullable(builder.getPackageInformation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public IssuerTradeId getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        @RosettaAttribute(value="orderIdentifier")
        @RuneAttribute(value="orderIdentifier")
        public OrderIdentifier getOrderIdentifier() {
            return this.orderIdentifier;
        }

        @Override
        @RosettaAttribute(value="packageType")
        @RuneAttribute(value="packageType")
        public List<? extends PackageType> getPackageType() {
            return this.packageType;
        }

        @Override
        @RosettaAttribute(value="size")
        @RuneAttribute(value="size")
        public BigDecimal getSize() {
            return this.size;
        }

        @Override
        @RosettaAttribute(value="originatingEvent")
        @RuneAttribute(value="originatingEvent")
        public OriginatingEvent getOriginatingEvent() {
            return this.originatingEvent;
        }

        @Override
        @RosettaAttribute(value="packageInformation")
        @RuneAttribute(value="packageInformation")
        public PackageInformation getPackageInformation() {
            return this.packageInformation;
        }

        @Override
        public PackageHeader build() {
            return this;
        }

        @Override
        public PackageHeaderBuilder toBuilder() {
            PackageHeaderBuilder builder = PackageHeader.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PackageHeaderBuilder builder) {
            Optional.ofNullable(this.getPackageIdentifier()).ifPresent(builder::setPackageIdentifier);
            Optional.ofNullable(this.getOrderIdentifier()).ifPresent(builder::setOrderIdentifier);
            Optional.ofNullable(this.getPackageType()).ifPresent(builder::setPackageType);
            Optional.ofNullable(this.getSize()).ifPresent(builder::setSize);
            Optional.ofNullable(this.getOriginatingEvent()).ifPresent(builder::setOriginatingEvent);
            Optional.ofNullable(this.getPackageInformation()).ifPresent(builder::setPackageInformation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PackageHeader _that = this.getType().cast(o);
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.orderIdentifier, _that.getOrderIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.packageType, _that.getPackageType())) {
                return false;
            }
            if (!Objects.equals(this.size, _that.getSize())) {
                return false;
            }
            if (!Objects.equals(this.originatingEvent, _that.getOriginatingEvent())) {
                return false;
            }
            return Objects.equals(this.packageInformation, _that.getPackageInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.orderIdentifier != null ? this.orderIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.packageType != null ? this.packageType.hashCode() : 0);
            _result = 31 * _result + (this.size != null ? this.size.hashCode() : 0);
            _result = 31 * _result + (this.originatingEvent != null ? this.originatingEvent.hashCode() : 0);
            _result = 31 * _result + (this.packageInformation != null ? this.packageInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PackageHeader {packageIdentifier=" + this.packageIdentifier + ", orderIdentifier=" + this.orderIdentifier + ", packageType=" + this.packageType + ", size=" + this.size + ", originatingEvent=" + this.originatingEvent + ", packageInformation=" + this.packageInformation + '}';
        }
    }
}

