/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.OptionEvent;
import fpml.consolidated.business.events.OptionExercise;
import fpml.consolidated.business.events.OptionExpiry;
import fpml.consolidated.business.events.meta.OptionsEventsBaseModelMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="OptionsEventsBaseModel", builder=OptionsEventsBaseModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="OptionsEventsBaseModel", model="fpml", builder=OptionsEventsBaseModelBuilderImpl.class, version="1.1.0")
public interface OptionsEventsBaseModel
extends RosettaModelObject {
    public static final OptionsEventsBaseModelMeta metaData = new OptionsEventsBaseModelMeta();

    public OptionExercise getOptionExercise();

    public List<? extends OptionExpiry> getOptionExpiry();

    public OptionEvent getOptionEvent();

    public OptionsEventsBaseModel build();

    public OptionsEventsBaseModelBuilder toBuilder();

    public static OptionsEventsBaseModelBuilder builder() {
        return new OptionsEventsBaseModelBuilderImpl();
    }

    default public RosettaMetaData<? extends OptionsEventsBaseModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OptionsEventsBaseModel> getType() {
        return OptionsEventsBaseModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("optionExercise"), processor, OptionExercise.class, this.getOptionExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionExpiry"), processor, OptionExpiry.class, this.getOptionExpiry(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionEvent"), processor, OptionEvent.class, this.getOptionEvent(), new AttributeMeta[0]);
    }

    public static class OptionsEventsBaseModelBuilderImpl
    implements OptionsEventsBaseModelBuilder {
        protected OptionExercise.OptionExerciseBuilder optionExercise;
        protected List<OptionExpiry.OptionExpiryBuilder> optionExpiry = new ArrayList<OptionExpiry.OptionExpiryBuilder>();
        protected OptionEvent.OptionEventBuilder optionEvent;

        @Override
        @RosettaAttribute(value="optionExercise")
        @RuneAttribute(value="optionExercise")
        public OptionExercise.OptionExerciseBuilder getOptionExercise() {
            return this.optionExercise;
        }

        @Override
        public OptionExercise.OptionExerciseBuilder getOrCreateOptionExercise() {
            OptionExercise.OptionExerciseBuilder result = this.optionExercise != null ? this.optionExercise : (this.optionExercise = OptionExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionExpiry")
        @RuneAttribute(value="optionExpiry")
        public List<? extends OptionExpiry.OptionExpiryBuilder> getOptionExpiry() {
            return this.optionExpiry;
        }

        @Override
        public OptionExpiry.OptionExpiryBuilder getOrCreateOptionExpiry(int index) {
            if (this.optionExpiry == null) {
                this.optionExpiry = new ArrayList<OptionExpiry.OptionExpiryBuilder>();
            }
            return (OptionExpiry.OptionExpiryBuilder)this.getIndex(this.optionExpiry, index, () -> {
                OptionExpiry.OptionExpiryBuilder newOptionExpiry = OptionExpiry.builder();
                return newOptionExpiry;
            });
        }

        @Override
        @RosettaAttribute(value="optionEvent")
        @RuneAttribute(value="optionEvent")
        public OptionEvent.OptionEventBuilder getOptionEvent() {
            return this.optionEvent;
        }

        @Override
        public OptionEvent.OptionEventBuilder getOrCreateOptionEvent() {
            OptionEvent.OptionEventBuilder result = this.optionEvent != null ? this.optionEvent : (this.optionEvent = OptionEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionExercise")
        @RuneAttribute(value="optionExercise")
        public OptionsEventsBaseModelBuilder setOptionExercise(OptionExercise _optionExercise) {
            this.optionExercise = _optionExercise == null ? null : _optionExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionExpiry")
        @RuneAttribute(value="optionExpiry")
        public OptionsEventsBaseModelBuilder addOptionExpiry(OptionExpiry _optionExpiry) {
            if (_optionExpiry != null) {
                this.optionExpiry.add(_optionExpiry.toBuilder());
            }
            return this;
        }

        @Override
        public OptionsEventsBaseModelBuilder addOptionExpiry(OptionExpiry _optionExpiry, int idx) {
            this.getIndex(this.optionExpiry, idx, () -> _optionExpiry.toBuilder());
            return this;
        }

        @Override
        public OptionsEventsBaseModelBuilder addOptionExpiry(List<? extends OptionExpiry> optionExpirys) {
            if (optionExpirys != null) {
                for (OptionExpiry optionExpiry : optionExpirys) {
                    this.optionExpiry.add(optionExpiry.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="optionExpiry")
        public OptionsEventsBaseModelBuilder setOptionExpiry(List<? extends OptionExpiry> optionExpirys) {
            this.optionExpiry = optionExpirys == null ? new ArrayList<OptionExpiry.OptionExpiryBuilder>() : (List)optionExpirys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="optionEvent")
        @RuneAttribute(value="optionEvent")
        public OptionsEventsBaseModelBuilder setOptionEvent(OptionEvent _optionEvent) {
            this.optionEvent = _optionEvent == null ? null : _optionEvent.toBuilder();
            return this;
        }

        @Override
        public OptionsEventsBaseModel build() {
            return new OptionsEventsBaseModelImpl(this);
        }

        @Override
        public OptionsEventsBaseModelBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionsEventsBaseModelBuilder prune() {
            if (this.optionExercise != null && !this.optionExercise.prune().hasData()) {
                this.optionExercise = null;
            }
            this.optionExpiry = this.optionExpiry.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.optionEvent != null && !this.optionEvent.prune().hasData()) {
                this.optionEvent = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getOptionExercise() != null && this.getOptionExercise().hasData()) {
                return true;
            }
            if (this.getOptionExpiry() != null && this.getOptionExpiry().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getOptionEvent() != null && this.getOptionEvent().hasData();
        }

        public OptionsEventsBaseModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            OptionsEventsBaseModelBuilder o = (OptionsEventsBaseModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionExercise(), (RosettaModelObjectBuilder)o.getOptionExercise(), this::setOptionExercise);
            merger.mergeRosetta(this.getOptionExpiry(), o.getOptionExpiry(), this::getOrCreateOptionExpiry);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionEvent(), (RosettaModelObjectBuilder)o.getOptionEvent(), this::setOptionEvent);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OptionsEventsBaseModel _that = this.getType().cast(o);
            if (!Objects.equals(this.optionExercise, _that.getOptionExercise())) {
                return false;
            }
            if (!ListEquals.listEquals(this.optionExpiry, _that.getOptionExpiry())) {
                return false;
            }
            return Objects.equals(this.optionEvent, _that.getOptionEvent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.optionExercise != null ? this.optionExercise.hashCode() : 0);
            _result = 31 * _result + (this.optionExpiry != null ? this.optionExpiry.hashCode() : 0);
            _result = 31 * _result + (this.optionEvent != null ? this.optionEvent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OptionsEventsBaseModelBuilder {optionExercise=" + this.optionExercise + ", optionExpiry=" + this.optionExpiry + ", optionEvent=" + this.optionEvent + '}';
        }
    }

    public static interface OptionsEventsBaseModelBuilder
    extends OptionsEventsBaseModel,
    RosettaModelObjectBuilder {
        public OptionExercise.OptionExerciseBuilder getOrCreateOptionExercise();

        @Override
        public OptionExercise.OptionExerciseBuilder getOptionExercise();

        public OptionExpiry.OptionExpiryBuilder getOrCreateOptionExpiry(int var1);

        public List<? extends OptionExpiry.OptionExpiryBuilder> getOptionExpiry();

        public OptionEvent.OptionEventBuilder getOrCreateOptionEvent();

        @Override
        public OptionEvent.OptionEventBuilder getOptionEvent();

        public OptionsEventsBaseModelBuilder setOptionExercise(OptionExercise var1);

        public OptionsEventsBaseModelBuilder addOptionExpiry(OptionExpiry var1);

        public OptionsEventsBaseModelBuilder addOptionExpiry(OptionExpiry var1, int var2);

        public OptionsEventsBaseModelBuilder addOptionExpiry(List<? extends OptionExpiry> var1);

        public OptionsEventsBaseModelBuilder setOptionExpiry(List<? extends OptionExpiry> var1);

        public OptionsEventsBaseModelBuilder setOptionEvent(OptionEvent var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("optionExercise"), processor, OptionExercise.OptionExerciseBuilder.class, this.getOptionExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionExpiry"), processor, OptionExpiry.OptionExpiryBuilder.class, this.getOptionExpiry(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionEvent"), processor, OptionEvent.OptionEventBuilder.class, this.getOptionEvent(), new AttributeMeta[0]);
        }

        public OptionsEventsBaseModelBuilder prune();
    }

    public static class OptionsEventsBaseModelImpl
    implements OptionsEventsBaseModel {
        private final OptionExercise optionExercise;
        private final List<? extends OptionExpiry> optionExpiry;
        private final OptionEvent optionEvent;

        protected OptionsEventsBaseModelImpl(OptionsEventsBaseModelBuilder builder) {
            this.optionExercise = Optional.ofNullable(builder.getOptionExercise()).map(f -> f.build()).orElse(null);
            this.optionExpiry = Optional.ofNullable(builder.getOptionExpiry()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.optionEvent = Optional.ofNullable(builder.getOptionEvent()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="optionExercise")
        @RuneAttribute(value="optionExercise")
        public OptionExercise getOptionExercise() {
            return this.optionExercise;
        }

        @Override
        @RosettaAttribute(value="optionExpiry")
        @RuneAttribute(value="optionExpiry")
        public List<? extends OptionExpiry> getOptionExpiry() {
            return this.optionExpiry;
        }

        @Override
        @RosettaAttribute(value="optionEvent")
        @RuneAttribute(value="optionEvent")
        public OptionEvent getOptionEvent() {
            return this.optionEvent;
        }

        @Override
        public OptionsEventsBaseModel build() {
            return this;
        }

        @Override
        public OptionsEventsBaseModelBuilder toBuilder() {
            OptionsEventsBaseModelBuilder builder = OptionsEventsBaseModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionsEventsBaseModelBuilder builder) {
            Optional.ofNullable(this.getOptionExercise()).ifPresent(builder::setOptionExercise);
            Optional.ofNullable(this.getOptionExpiry()).ifPresent(builder::setOptionExpiry);
            Optional.ofNullable(this.getOptionEvent()).ifPresent(builder::setOptionEvent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OptionsEventsBaseModel _that = this.getType().cast(o);
            if (!Objects.equals(this.optionExercise, _that.getOptionExercise())) {
                return false;
            }
            if (!ListEquals.listEquals(this.optionExpiry, _that.getOptionExpiry())) {
                return false;
            }
            return Objects.equals(this.optionEvent, _that.getOptionEvent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.optionExercise != null ? this.optionExercise.hashCode() : 0);
            _result = 31 * _result + (this.optionExpiry != null ? this.optionExpiry.hashCode() : 0);
            _result = 31 * _result + (this.optionEvent != null ? this.optionEvent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OptionsEventsBaseModel {optionExercise=" + this.optionExercise + ", optionExpiry=" + this.optionExpiry + ", optionEvent=" + this.optionEvent + '}';
        }
    }
}

