/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.business.events.CashOrPhysicalSettlementEnum;
import fpml.consolidated.business.events.CreditChangeEventBase;
import fpml.consolidated.business.events.CreditEventType;
import fpml.consolidated.business.events.meta.CreditChangeEventMeta;
import fpml.consolidated.cd.CreditEventIndexReferenceInformation;
import fpml.consolidated.cd.ReferenceInformation;
import fpml.consolidated.shared.Resource;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditChangeEvent", builder=CreditChangeEventBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CreditChangeEvent", model="fpml", builder=CreditChangeEventBuilderImpl.class, version="1.1.0")
public interface CreditChangeEvent
extends CreditChangeEventBase {
    public static final CreditChangeEventMeta metaData = new CreditChangeEventMeta();

    public CreditEventIndexReferenceInformation getIndexReferenceInformation();

    public ReferenceInformation getExcludedReferenceEntity();

    @Override
    public CreditChangeEvent build();

    @Override
    public CreditChangeEventBuilder toBuilder();

    public static CreditChangeEventBuilder builder() {
        return new CreditChangeEventBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditChangeEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditChangeEvent> getType() {
        return CreditChangeEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditEventType"), processor, CreditEventType.class, this.getCreditEventType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDeterminationDate"), ZonedDateTime.class, (Object)this.getEventDeterminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("auctionDate"), ZonedDateTime.class, (Object)this.getAuctionDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementMethod"), CashOrPhysicalSettlementEnum.class, (Object)this.getSettlementMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementDate"), ZonedDateTime.class, (Object)this.getSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalPrice"), BigDecimal.class, (Object)this.getFinalPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("recoveryPercent"), BigDecimal.class, (Object)this.getRecoveryPercent(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, Resource.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexReferenceInformation"), processor, CreditEventIndexReferenceInformation.class, this.getIndexReferenceInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("excludedReferenceEntity"), processor, ReferenceInformation.class, this.getExcludedReferenceEntity(), new AttributeMeta[0]);
    }

    public static class CreditChangeEventBuilderImpl
    extends CreditChangeEventBase.CreditChangeEventBaseBuilderImpl
    implements CreditChangeEventBuilder {
        protected CreditEventIndexReferenceInformation.CreditEventIndexReferenceInformationBuilder indexReferenceInformation;
        protected ReferenceInformation.ReferenceInformationBuilder excludedReferenceEntity;

        @Override
        @RosettaAttribute(value="indexReferenceInformation")
        @RuneAttribute(value="indexReferenceInformation")
        public CreditEventIndexReferenceInformation.CreditEventIndexReferenceInformationBuilder getIndexReferenceInformation() {
            return this.indexReferenceInformation;
        }

        @Override
        public CreditEventIndexReferenceInformation.CreditEventIndexReferenceInformationBuilder getOrCreateIndexReferenceInformation() {
            CreditEventIndexReferenceInformation.CreditEventIndexReferenceInformationBuilder result = this.indexReferenceInformation != null ? this.indexReferenceInformation : (this.indexReferenceInformation = CreditEventIndexReferenceInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="excludedReferenceEntity")
        @RuneAttribute(value="excludedReferenceEntity")
        public ReferenceInformation.ReferenceInformationBuilder getExcludedReferenceEntity() {
            return this.excludedReferenceEntity;
        }

        @Override
        public ReferenceInformation.ReferenceInformationBuilder getOrCreateExcludedReferenceEntity() {
            ReferenceInformation.ReferenceInformationBuilder result = this.excludedReferenceEntity != null ? this.excludedReferenceEntity : (this.excludedReferenceEntity = ReferenceInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public CreditChangeEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public CreditChangeEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public CreditChangeEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public CreditChangeEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="creditEventType")
        @RuneAttribute(value="creditEventType")
        public CreditChangeEventBuilder setCreditEventType(CreditEventType _creditEventType) {
            this.creditEventType = _creditEventType == null ? null : _creditEventType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDeterminationDate")
        @RuneAttribute(value="eventDeterminationDate")
        public CreditChangeEventBuilder setEventDeterminationDate(ZonedDateTime _eventDeterminationDate) {
            this.eventDeterminationDate = _eventDeterminationDate == null ? null : _eventDeterminationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="auctionDate")
        @RuneAttribute(value="auctionDate")
        public CreditChangeEventBuilder setAuctionDate(ZonedDateTime _auctionDate) {
            this.auctionDate = _auctionDate == null ? null : _auctionDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementMethod")
        @RuneAttribute(value="settlementMethod")
        public CreditChangeEventBuilder setSettlementMethod(CashOrPhysicalSettlementEnum _settlementMethod) {
            this.settlementMethod = _settlementMethod == null ? null : _settlementMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public CreditChangeEventBuilder setSettlementDate(ZonedDateTime _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalPrice")
        @RuneAttribute(value="finalPrice")
        public CreditChangeEventBuilder setFinalPrice(BigDecimal _finalPrice) {
            this.finalPrice = _finalPrice == null ? null : _finalPrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="recoveryPercent")
        @RuneAttribute(value="recoveryPercent")
        public CreditChangeEventBuilder setRecoveryPercent(BigDecimal _recoveryPercent) {
            this.recoveryPercent = _recoveryPercent == null ? null : _recoveryPercent;
            return this;
        }

        @Override
        @RosettaAttribute(value="publiclyAvailableInformation")
        @RuneAttribute(value="publiclyAvailableInformation")
        public CreditChangeEventBuilder addPubliclyAvailableInformation(Resource _publiclyAvailableInformation) {
            if (_publiclyAvailableInformation != null) {
                this.publiclyAvailableInformation.add(_publiclyAvailableInformation.toBuilder());
            }
            return this;
        }

        @Override
        public CreditChangeEventBuilder addPubliclyAvailableInformation(Resource _publiclyAvailableInformation, int idx) {
            this.getIndex(this.publiclyAvailableInformation, idx, () -> _publiclyAvailableInformation.toBuilder());
            return this;
        }

        @Override
        public CreditChangeEventBuilder addPubliclyAvailableInformation(List<? extends Resource> publiclyAvailableInformations) {
            if (publiclyAvailableInformations != null) {
                for (Resource resource : publiclyAvailableInformations) {
                    this.publiclyAvailableInformation.add(resource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="publiclyAvailableInformation")
        public CreditChangeEventBuilder setPubliclyAvailableInformation(List<? extends Resource> publiclyAvailableInformations) {
            this.publiclyAvailableInformation = publiclyAvailableInformations == null ? new ArrayList() : (List)publiclyAvailableInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="indexReferenceInformation")
        @RuneAttribute(value="indexReferenceInformation")
        public CreditChangeEventBuilder setIndexReferenceInformation(CreditEventIndexReferenceInformation _indexReferenceInformation) {
            this.indexReferenceInformation = _indexReferenceInformation == null ? null : _indexReferenceInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="excludedReferenceEntity")
        @RuneAttribute(value="excludedReferenceEntity")
        public CreditChangeEventBuilder setExcludedReferenceEntity(ReferenceInformation _excludedReferenceEntity) {
            this.excludedReferenceEntity = _excludedReferenceEntity == null ? null : _excludedReferenceEntity.toBuilder();
            return this;
        }

        @Override
        public CreditChangeEvent build() {
            return new CreditChangeEventImpl(this);
        }

        @Override
        public CreditChangeEventBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditChangeEventBuilder prune() {
            super.prune();
            if (this.indexReferenceInformation != null && !this.indexReferenceInformation.prune().hasData()) {
                this.indexReferenceInformation = null;
            }
            if (this.excludedReferenceEntity != null && !this.excludedReferenceEntity.prune().hasData()) {
                this.excludedReferenceEntity = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getIndexReferenceInformation() != null && this.getIndexReferenceInformation().hasData()) {
                return true;
            }
            return this.getExcludedReferenceEntity() != null && this.getExcludedReferenceEntity().hasData();
        }

        @Override
        public CreditChangeEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CreditChangeEventBuilder o = (CreditChangeEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndexReferenceInformation(), (RosettaModelObjectBuilder)o.getIndexReferenceInformation(), this::setIndexReferenceInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExcludedReferenceEntity(), (RosettaModelObjectBuilder)o.getExcludedReferenceEntity(), this::setExcludedReferenceEntity);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditChangeEvent _that = (CreditChangeEvent)this.getType().cast(o);
            if (!Objects.equals(this.indexReferenceInformation, _that.getIndexReferenceInformation())) {
                return false;
            }
            return Objects.equals(this.excludedReferenceEntity, _that.getExcludedReferenceEntity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.indexReferenceInformation != null ? this.indexReferenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.excludedReferenceEntity != null ? this.excludedReferenceEntity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditChangeEventBuilder {indexReferenceInformation=" + this.indexReferenceInformation + ", excludedReferenceEntity=" + this.excludedReferenceEntity + '}' + " " + super.toString();
        }
    }

    public static interface CreditChangeEventBuilder
    extends CreditChangeEvent,
    CreditChangeEventBase.CreditChangeEventBaseBuilder {
        public CreditEventIndexReferenceInformation.CreditEventIndexReferenceInformationBuilder getOrCreateIndexReferenceInformation();

        @Override
        public CreditEventIndexReferenceInformation.CreditEventIndexReferenceInformationBuilder getIndexReferenceInformation();

        public ReferenceInformation.ReferenceInformationBuilder getOrCreateExcludedReferenceEntity();

        @Override
        public ReferenceInformation.ReferenceInformationBuilder getExcludedReferenceEntity();

        @Override
        public CreditChangeEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public CreditChangeEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public CreditChangeEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public CreditChangeEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public CreditChangeEventBuilder setCreditEventType(CreditEventType var1);

        @Override
        public CreditChangeEventBuilder setEventDeterminationDate(ZonedDateTime var1);

        @Override
        public CreditChangeEventBuilder setAuctionDate(ZonedDateTime var1);

        @Override
        public CreditChangeEventBuilder setSettlementMethod(CashOrPhysicalSettlementEnum var1);

        @Override
        public CreditChangeEventBuilder setSettlementDate(ZonedDateTime var1);

        @Override
        public CreditChangeEventBuilder setFinalPrice(BigDecimal var1);

        @Override
        public CreditChangeEventBuilder setRecoveryPercent(BigDecimal var1);

        @Override
        public CreditChangeEventBuilder addPubliclyAvailableInformation(Resource var1);

        @Override
        public CreditChangeEventBuilder addPubliclyAvailableInformation(Resource var1, int var2);

        @Override
        public CreditChangeEventBuilder addPubliclyAvailableInformation(List<? extends Resource> var1);

        @Override
        public CreditChangeEventBuilder setPubliclyAvailableInformation(List<? extends Resource> var1);

        public CreditChangeEventBuilder setIndexReferenceInformation(CreditEventIndexReferenceInformation var1);

        public CreditChangeEventBuilder setExcludedReferenceEntity(ReferenceInformation var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditEventType"), processor, CreditEventType.CreditEventTypeBuilder.class, (RosettaModelObjectBuilder)this.getCreditEventType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDeterminationDate"), ZonedDateTime.class, (Object)this.getEventDeterminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("auctionDate"), ZonedDateTime.class, (Object)this.getAuctionDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementMethod"), CashOrPhysicalSettlementEnum.class, (Object)this.getSettlementMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementDate"), ZonedDateTime.class, (Object)this.getSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalPrice"), BigDecimal.class, (Object)this.getFinalPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("recoveryPercent"), BigDecimal.class, (Object)this.getRecoveryPercent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, Resource.ResourceBuilder.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexReferenceInformation"), processor, CreditEventIndexReferenceInformation.CreditEventIndexReferenceInformationBuilder.class, this.getIndexReferenceInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("excludedReferenceEntity"), processor, ReferenceInformation.ReferenceInformationBuilder.class, this.getExcludedReferenceEntity(), new AttributeMeta[0]);
        }

        @Override
        public CreditChangeEventBuilder prune();
    }

    public static class CreditChangeEventImpl
    extends CreditChangeEventBase.CreditChangeEventBaseImpl
    implements CreditChangeEvent {
        private final CreditEventIndexReferenceInformation indexReferenceInformation;
        private final ReferenceInformation excludedReferenceEntity;

        protected CreditChangeEventImpl(CreditChangeEventBuilder builder) {
            super(builder);
            this.indexReferenceInformation = Optional.ofNullable(builder.getIndexReferenceInformation()).map(f -> f.build()).orElse(null);
            this.excludedReferenceEntity = Optional.ofNullable(builder.getExcludedReferenceEntity()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="indexReferenceInformation")
        @RuneAttribute(value="indexReferenceInformation")
        public CreditEventIndexReferenceInformation getIndexReferenceInformation() {
            return this.indexReferenceInformation;
        }

        @Override
        @RosettaAttribute(value="excludedReferenceEntity")
        @RuneAttribute(value="excludedReferenceEntity")
        public ReferenceInformation getExcludedReferenceEntity() {
            return this.excludedReferenceEntity;
        }

        @Override
        public CreditChangeEvent build() {
            return this;
        }

        @Override
        public CreditChangeEventBuilder toBuilder() {
            CreditChangeEventBuilder builder = CreditChangeEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditChangeEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getIndexReferenceInformation()).ifPresent(builder::setIndexReferenceInformation);
            Optional.ofNullable(this.getExcludedReferenceEntity()).ifPresent(builder::setExcludedReferenceEntity);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditChangeEvent _that = (CreditChangeEvent)this.getType().cast(o);
            if (!Objects.equals(this.indexReferenceInformation, _that.getIndexReferenceInformation())) {
                return false;
            }
            return Objects.equals(this.excludedReferenceEntity, _that.getExcludedReferenceEntity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.indexReferenceInformation != null ? this.indexReferenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.excludedReferenceEntity != null ? this.excludedReferenceEntity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditChangeEvent {indexReferenceInformation=" + this.indexReferenceInformation + ", excludedReferenceEntity=" + this.excludedReferenceEntity + '}' + " " + super.toString();
        }
    }
}

