/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.IdentifiedAsset;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.meta.GenericAssetMeta;
import fpml.consolidated.shared.InstrumentId;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaDataType(value="GenericAsset", builder=GenericAssetBuilderImpl.class, version="1.1.0")
@RuneDataType(value="GenericAsset", model="fpml", builder=GenericAssetBuilderImpl.class, version="1.1.0")
public interface GenericAsset
extends IdentifiedAsset {
    public static final GenericAssetMeta metaData = new GenericAssetMeta();

    @Override
    public GenericAsset build();

    @Override
    public GenericAssetBuilder toBuilder();

    public static GenericAssetBuilder builder() {
        return new GenericAssetBuilderImpl();
    }

    default public RosettaMetaData<? extends GenericAsset> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends GenericAsset> getType() {
        return GenericAsset.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class GenericAssetBuilderImpl
    extends IdentifiedAsset.IdentifiedAssetBuilderImpl
    implements GenericAssetBuilder {
        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public GenericAssetBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public GenericAssetBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public GenericAssetBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public GenericAssetBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public GenericAssetBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public GenericAssetBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public GenericAssetBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public GenericAssetBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public GenericAssetBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public GenericAssetBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        public GenericAsset build() {
            return new GenericAssetImpl(this);
        }

        @Override
        public GenericAssetBuilder toBuilder() {
            return this;
        }

        @Override
        public GenericAssetBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public GenericAssetBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            GenericAssetBuilder o = (GenericAssetBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "GenericAssetBuilder {} " + super.toString();
        }
    }

    public static interface GenericAssetBuilder
    extends GenericAsset,
    IdentifiedAsset.IdentifiedAssetBuilder {
        @Override
        public GenericAssetBuilder setId(String var1);

        @Override
        public GenericAssetBuilder addInstrumentId(InstrumentId var1);

        @Override
        public GenericAssetBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public GenericAssetBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public GenericAssetBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public GenericAssetBuilder addInstrumentType(InstrumentType var1);

        @Override
        public GenericAssetBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public GenericAssetBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public GenericAssetBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public GenericAssetBuilder setDescription(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public GenericAssetBuilder prune();
    }

    public static class GenericAssetImpl
    extends IdentifiedAsset.IdentifiedAssetImpl
    implements GenericAsset {
        protected GenericAssetImpl(GenericAssetBuilder builder) {
            super(builder);
        }

        @Override
        public GenericAsset build() {
            return this;
        }

        @Override
        public GenericAssetBuilder toBuilder() {
            GenericAssetBuilder builder = GenericAsset.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(GenericAssetBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "GenericAsset {} " + super.toString();
        }
    }
}

