/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.meta.ExchangeIdentifierModelMeta;
import fpml.consolidated.shared.ExchangeId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExchangeIdentifierModel", builder=ExchangeIdentifierModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ExchangeIdentifierModel", model="fpml", builder=ExchangeIdentifierModelBuilderImpl.class, version="1.1.0")
public interface ExchangeIdentifierModel
extends RosettaModelObject {
    public static final ExchangeIdentifierModelMeta metaData = new ExchangeIdentifierModelMeta();

    public List<? extends ExchangeId> getRelatedExchangeId();

    public List<? extends ExchangeId> getOptionsExchangeId();

    public List<? extends ExchangeId> getSpecifiedExchangeId();

    public ExchangeIdentifierModel build();

    public ExchangeIdentifierModelBuilder toBuilder();

    public static ExchangeIdentifierModelBuilder builder() {
        return new ExchangeIdentifierModelBuilderImpl();
    }

    default public RosettaMetaData<? extends ExchangeIdentifierModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExchangeIdentifierModel> getType() {
        return ExchangeIdentifierModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("relatedExchangeId"), processor, ExchangeId.class, this.getRelatedExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionsExchangeId"), processor, ExchangeId.class, this.getOptionsExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("specifiedExchangeId"), processor, ExchangeId.class, this.getSpecifiedExchangeId(), new AttributeMeta[0]);
    }

    public static class ExchangeIdentifierModelBuilderImpl
    implements ExchangeIdentifierModelBuilder {
        protected List<ExchangeId.ExchangeIdBuilder> relatedExchangeId = new ArrayList<ExchangeId.ExchangeIdBuilder>();
        protected List<ExchangeId.ExchangeIdBuilder> optionsExchangeId = new ArrayList<ExchangeId.ExchangeIdBuilder>();
        protected List<ExchangeId.ExchangeIdBuilder> specifiedExchangeId = new ArrayList<ExchangeId.ExchangeIdBuilder>();

        @Override
        @RosettaAttribute(value="relatedExchangeId")
        @RuneAttribute(value="relatedExchangeId")
        public List<? extends ExchangeId.ExchangeIdBuilder> getRelatedExchangeId() {
            return this.relatedExchangeId;
        }

        @Override
        public ExchangeId.ExchangeIdBuilder getOrCreateRelatedExchangeId(int index) {
            if (this.relatedExchangeId == null) {
                this.relatedExchangeId = new ArrayList<ExchangeId.ExchangeIdBuilder>();
            }
            return (ExchangeId.ExchangeIdBuilder)this.getIndex(this.relatedExchangeId, index, () -> {
                ExchangeId.ExchangeIdBuilder newRelatedExchangeId = ExchangeId.builder();
                return newRelatedExchangeId;
            });
        }

        @Override
        @RosettaAttribute(value="optionsExchangeId")
        @RuneAttribute(value="optionsExchangeId")
        public List<? extends ExchangeId.ExchangeIdBuilder> getOptionsExchangeId() {
            return this.optionsExchangeId;
        }

        @Override
        public ExchangeId.ExchangeIdBuilder getOrCreateOptionsExchangeId(int index) {
            if (this.optionsExchangeId == null) {
                this.optionsExchangeId = new ArrayList<ExchangeId.ExchangeIdBuilder>();
            }
            return (ExchangeId.ExchangeIdBuilder)this.getIndex(this.optionsExchangeId, index, () -> {
                ExchangeId.ExchangeIdBuilder newOptionsExchangeId = ExchangeId.builder();
                return newOptionsExchangeId;
            });
        }

        @Override
        @RosettaAttribute(value="specifiedExchangeId")
        @RuneAttribute(value="specifiedExchangeId")
        public List<? extends ExchangeId.ExchangeIdBuilder> getSpecifiedExchangeId() {
            return this.specifiedExchangeId;
        }

        @Override
        public ExchangeId.ExchangeIdBuilder getOrCreateSpecifiedExchangeId(int index) {
            if (this.specifiedExchangeId == null) {
                this.specifiedExchangeId = new ArrayList<ExchangeId.ExchangeIdBuilder>();
            }
            return (ExchangeId.ExchangeIdBuilder)this.getIndex(this.specifiedExchangeId, index, () -> {
                ExchangeId.ExchangeIdBuilder newSpecifiedExchangeId = ExchangeId.builder();
                return newSpecifiedExchangeId;
            });
        }

        @Override
        @RosettaAttribute(value="relatedExchangeId")
        @RuneAttribute(value="relatedExchangeId")
        public ExchangeIdentifierModelBuilder addRelatedExchangeId(ExchangeId _relatedExchangeId) {
            if (_relatedExchangeId != null) {
                this.relatedExchangeId.add(_relatedExchangeId.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeIdentifierModelBuilder addRelatedExchangeId(ExchangeId _relatedExchangeId, int idx) {
            this.getIndex(this.relatedExchangeId, idx, () -> _relatedExchangeId.toBuilder());
            return this;
        }

        @Override
        public ExchangeIdentifierModelBuilder addRelatedExchangeId(List<? extends ExchangeId> relatedExchangeIds) {
            if (relatedExchangeIds != null) {
                for (ExchangeId exchangeId : relatedExchangeIds) {
                    this.relatedExchangeId.add(exchangeId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchangeId")
        public ExchangeIdentifierModelBuilder setRelatedExchangeId(List<? extends ExchangeId> relatedExchangeIds) {
            this.relatedExchangeId = relatedExchangeIds == null ? new ArrayList<ExchangeId.ExchangeIdBuilder>() : (List)relatedExchangeIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="optionsExchangeId")
        @RuneAttribute(value="optionsExchangeId")
        public ExchangeIdentifierModelBuilder addOptionsExchangeId(ExchangeId _optionsExchangeId) {
            if (_optionsExchangeId != null) {
                this.optionsExchangeId.add(_optionsExchangeId.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeIdentifierModelBuilder addOptionsExchangeId(ExchangeId _optionsExchangeId, int idx) {
            this.getIndex(this.optionsExchangeId, idx, () -> _optionsExchangeId.toBuilder());
            return this;
        }

        @Override
        public ExchangeIdentifierModelBuilder addOptionsExchangeId(List<? extends ExchangeId> optionsExchangeIds) {
            if (optionsExchangeIds != null) {
                for (ExchangeId exchangeId : optionsExchangeIds) {
                    this.optionsExchangeId.add(exchangeId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="optionsExchangeId")
        public ExchangeIdentifierModelBuilder setOptionsExchangeId(List<? extends ExchangeId> optionsExchangeIds) {
            this.optionsExchangeId = optionsExchangeIds == null ? new ArrayList<ExchangeId.ExchangeIdBuilder>() : (List)optionsExchangeIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="specifiedExchangeId")
        @RuneAttribute(value="specifiedExchangeId")
        public ExchangeIdentifierModelBuilder addSpecifiedExchangeId(ExchangeId _specifiedExchangeId) {
            if (_specifiedExchangeId != null) {
                this.specifiedExchangeId.add(_specifiedExchangeId.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeIdentifierModelBuilder addSpecifiedExchangeId(ExchangeId _specifiedExchangeId, int idx) {
            this.getIndex(this.specifiedExchangeId, idx, () -> _specifiedExchangeId.toBuilder());
            return this;
        }

        @Override
        public ExchangeIdentifierModelBuilder addSpecifiedExchangeId(List<? extends ExchangeId> specifiedExchangeIds) {
            if (specifiedExchangeIds != null) {
                for (ExchangeId exchangeId : specifiedExchangeIds) {
                    this.specifiedExchangeId.add(exchangeId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="specifiedExchangeId")
        public ExchangeIdentifierModelBuilder setSpecifiedExchangeId(List<? extends ExchangeId> specifiedExchangeIds) {
            this.specifiedExchangeId = specifiedExchangeIds == null ? new ArrayList<ExchangeId.ExchangeIdBuilder>() : (List)specifiedExchangeIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ExchangeIdentifierModel build() {
            return new ExchangeIdentifierModelImpl(this);
        }

        @Override
        public ExchangeIdentifierModelBuilder toBuilder() {
            return this;
        }

        @Override
        public ExchangeIdentifierModelBuilder prune() {
            this.relatedExchangeId = this.relatedExchangeId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.optionsExchangeId = this.optionsExchangeId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.specifiedExchangeId = this.specifiedExchangeId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getRelatedExchangeId() != null && this.getRelatedExchangeId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getOptionsExchangeId() != null && this.getOptionsExchangeId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getSpecifiedExchangeId() != null && this.getSpecifiedExchangeId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ExchangeIdentifierModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExchangeIdentifierModelBuilder o = (ExchangeIdentifierModelBuilder)other;
            merger.mergeRosetta(this.getRelatedExchangeId(), o.getRelatedExchangeId(), this::getOrCreateRelatedExchangeId);
            merger.mergeRosetta(this.getOptionsExchangeId(), o.getOptionsExchangeId(), this::getOrCreateOptionsExchangeId);
            merger.mergeRosetta(this.getSpecifiedExchangeId(), o.getSpecifiedExchangeId(), this::getOrCreateSpecifiedExchangeId);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExchangeIdentifierModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.relatedExchangeId, _that.getRelatedExchangeId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.optionsExchangeId, _that.getOptionsExchangeId())) {
                return false;
            }
            return ListEquals.listEquals(this.specifiedExchangeId, _that.getSpecifiedExchangeId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.relatedExchangeId != null ? this.relatedExchangeId.hashCode() : 0);
            _result = 31 * _result + (this.optionsExchangeId != null ? this.optionsExchangeId.hashCode() : 0);
            _result = 31 * _result + (this.specifiedExchangeId != null ? this.specifiedExchangeId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExchangeIdentifierModelBuilder {relatedExchangeId=" + this.relatedExchangeId + ", optionsExchangeId=" + this.optionsExchangeId + ", specifiedExchangeId=" + this.specifiedExchangeId + '}';
        }
    }

    public static interface ExchangeIdentifierModelBuilder
    extends ExchangeIdentifierModel,
    RosettaModelObjectBuilder {
        public ExchangeId.ExchangeIdBuilder getOrCreateRelatedExchangeId(int var1);

        public List<? extends ExchangeId.ExchangeIdBuilder> getRelatedExchangeId();

        public ExchangeId.ExchangeIdBuilder getOrCreateOptionsExchangeId(int var1);

        public List<? extends ExchangeId.ExchangeIdBuilder> getOptionsExchangeId();

        public ExchangeId.ExchangeIdBuilder getOrCreateSpecifiedExchangeId(int var1);

        public List<? extends ExchangeId.ExchangeIdBuilder> getSpecifiedExchangeId();

        public ExchangeIdentifierModelBuilder addRelatedExchangeId(ExchangeId var1);

        public ExchangeIdentifierModelBuilder addRelatedExchangeId(ExchangeId var1, int var2);

        public ExchangeIdentifierModelBuilder addRelatedExchangeId(List<? extends ExchangeId> var1);

        public ExchangeIdentifierModelBuilder setRelatedExchangeId(List<? extends ExchangeId> var1);

        public ExchangeIdentifierModelBuilder addOptionsExchangeId(ExchangeId var1);

        public ExchangeIdentifierModelBuilder addOptionsExchangeId(ExchangeId var1, int var2);

        public ExchangeIdentifierModelBuilder addOptionsExchangeId(List<? extends ExchangeId> var1);

        public ExchangeIdentifierModelBuilder setOptionsExchangeId(List<? extends ExchangeId> var1);

        public ExchangeIdentifierModelBuilder addSpecifiedExchangeId(ExchangeId var1);

        public ExchangeIdentifierModelBuilder addSpecifiedExchangeId(ExchangeId var1, int var2);

        public ExchangeIdentifierModelBuilder addSpecifiedExchangeId(List<? extends ExchangeId> var1);

        public ExchangeIdentifierModelBuilder setSpecifiedExchangeId(List<? extends ExchangeId> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("relatedExchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, this.getRelatedExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionsExchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, this.getOptionsExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("specifiedExchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, this.getSpecifiedExchangeId(), new AttributeMeta[0]);
        }

        public ExchangeIdentifierModelBuilder prune();
    }

    public static class ExchangeIdentifierModelImpl
    implements ExchangeIdentifierModel {
        private final List<? extends ExchangeId> relatedExchangeId;
        private final List<? extends ExchangeId> optionsExchangeId;
        private final List<? extends ExchangeId> specifiedExchangeId;

        protected ExchangeIdentifierModelImpl(ExchangeIdentifierModelBuilder builder) {
            this.relatedExchangeId = Optional.ofNullable(builder.getRelatedExchangeId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.optionsExchangeId = Optional.ofNullable(builder.getOptionsExchangeId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.specifiedExchangeId = Optional.ofNullable(builder.getSpecifiedExchangeId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="relatedExchangeId")
        @RuneAttribute(value="relatedExchangeId")
        public List<? extends ExchangeId> getRelatedExchangeId() {
            return this.relatedExchangeId;
        }

        @Override
        @RosettaAttribute(value="optionsExchangeId")
        @RuneAttribute(value="optionsExchangeId")
        public List<? extends ExchangeId> getOptionsExchangeId() {
            return this.optionsExchangeId;
        }

        @Override
        @RosettaAttribute(value="specifiedExchangeId")
        @RuneAttribute(value="specifiedExchangeId")
        public List<? extends ExchangeId> getSpecifiedExchangeId() {
            return this.specifiedExchangeId;
        }

        @Override
        public ExchangeIdentifierModel build() {
            return this;
        }

        @Override
        public ExchangeIdentifierModelBuilder toBuilder() {
            ExchangeIdentifierModelBuilder builder = ExchangeIdentifierModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExchangeIdentifierModelBuilder builder) {
            Optional.ofNullable(this.getRelatedExchangeId()).ifPresent(builder::setRelatedExchangeId);
            Optional.ofNullable(this.getOptionsExchangeId()).ifPresent(builder::setOptionsExchangeId);
            Optional.ofNullable(this.getSpecifiedExchangeId()).ifPresent(builder::setSpecifiedExchangeId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExchangeIdentifierModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.relatedExchangeId, _that.getRelatedExchangeId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.optionsExchangeId, _that.getOptionsExchangeId())) {
                return false;
            }
            return ListEquals.listEquals(this.specifiedExchangeId, _that.getSpecifiedExchangeId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.relatedExchangeId != null ? this.relatedExchangeId.hashCode() : 0);
            _result = 31 * _result + (this.optionsExchangeId != null ? this.optionsExchangeId.hashCode() : 0);
            _result = 31 * _result + (this.specifiedExchangeId != null ? this.specifiedExchangeId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExchangeIdentifierModel {relatedExchangeId=" + this.relatedExchangeId + ", optionsExchangeId=" + this.optionsExchangeId + ", specifiedExchangeId=" + this.specifiedExchangeId + '}';
        }
    }
}

