/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.KeyInfoType;
import fpml.consolidated.ObjectType;
import fpml.consolidated.SignatureValueType;
import fpml.consolidated.SignedInfoType;
import fpml.consolidated.meta.SignatureTypeMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SignatureType", builder=SignatureTypeBuilderImpl.class, version="1.1.0")
@RuneDataType(value="SignatureType", model="fpml", builder=SignatureTypeBuilderImpl.class, version="1.1.0")
public interface SignatureType
extends RosettaModelObject {
    public static final SignatureTypeMeta metaData = new SignatureTypeMeta();

    public SignedInfoType getSignedInfo();

    public SignatureValueType getSignatureValue();

    public KeyInfoType getKeyInfo();

    public List<? extends ObjectType> getObject();

    public String getId();

    public SignatureType build();

    public SignatureTypeBuilder toBuilder();

    public static SignatureTypeBuilder builder() {
        return new SignatureTypeBuilderImpl();
    }

    default public RosettaMetaData<? extends SignatureType> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SignatureType> getType() {
        return SignatureType.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("signedInfo"), processor, SignedInfoType.class, this.getSignedInfo(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("signatureValue"), processor, SignatureValueType.class, this.getSignatureValue(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("keyInfo"), processor, KeyInfoType.class, this.getKeyInfo(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("object"), processor, ObjectType.class, this.getObject(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SignatureTypeBuilderImpl
    implements SignatureTypeBuilder {
        protected SignedInfoType.SignedInfoTypeBuilder signedInfo;
        protected SignatureValueType.SignatureValueTypeBuilder signatureValue;
        protected KeyInfoType.KeyInfoTypeBuilder keyInfo;
        protected List<ObjectType.ObjectTypeBuilder> object = new ArrayList<ObjectType.ObjectTypeBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="signedInfo", isRequired=true)
        @RuneAttribute(value="signedInfo", isRequired=true)
        public SignedInfoType.SignedInfoTypeBuilder getSignedInfo() {
            return this.signedInfo;
        }

        @Override
        public SignedInfoType.SignedInfoTypeBuilder getOrCreateSignedInfo() {
            SignedInfoType.SignedInfoTypeBuilder result = this.signedInfo != null ? this.signedInfo : (this.signedInfo = SignedInfoType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="signatureValue", isRequired=true)
        @RuneAttribute(value="signatureValue", isRequired=true)
        public SignatureValueType.SignatureValueTypeBuilder getSignatureValue() {
            return this.signatureValue;
        }

        @Override
        public SignatureValueType.SignatureValueTypeBuilder getOrCreateSignatureValue() {
            SignatureValueType.SignatureValueTypeBuilder result = this.signatureValue != null ? this.signatureValue : (this.signatureValue = SignatureValueType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="keyInfo")
        @RuneAttribute(value="keyInfo")
        public KeyInfoType.KeyInfoTypeBuilder getKeyInfo() {
            return this.keyInfo;
        }

        @Override
        public KeyInfoType.KeyInfoTypeBuilder getOrCreateKeyInfo() {
            KeyInfoType.KeyInfoTypeBuilder result = this.keyInfo != null ? this.keyInfo : (this.keyInfo = KeyInfoType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="object")
        @RuneAttribute(value="object")
        public List<? extends ObjectType.ObjectTypeBuilder> getObject() {
            return this.object;
        }

        @Override
        public ObjectType.ObjectTypeBuilder getOrCreateObject(int index) {
            if (this.object == null) {
                this.object = new ArrayList<ObjectType.ObjectTypeBuilder>();
            }
            return (ObjectType.ObjectTypeBuilder)this.getIndex(this.object, index, () -> {
                ObjectType.ObjectTypeBuilder newObject = ObjectType.builder();
                return newObject;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="signedInfo", isRequired=true)
        @RuneAttribute(value="signedInfo", isRequired=true)
        public SignatureTypeBuilder setSignedInfo(SignedInfoType _signedInfo) {
            this.signedInfo = _signedInfo == null ? null : _signedInfo.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="signatureValue", isRequired=true)
        @RuneAttribute(value="signatureValue", isRequired=true)
        public SignatureTypeBuilder setSignatureValue(SignatureValueType _signatureValue) {
            this.signatureValue = _signatureValue == null ? null : _signatureValue.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="keyInfo")
        @RuneAttribute(value="keyInfo")
        public SignatureTypeBuilder setKeyInfo(KeyInfoType _keyInfo) {
            this.keyInfo = _keyInfo == null ? null : _keyInfo.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="object")
        @RuneAttribute(value="object")
        public SignatureTypeBuilder addObject(ObjectType _object) {
            if (_object != null) {
                this.object.add(_object.toBuilder());
            }
            return this;
        }

        @Override
        public SignatureTypeBuilder addObject(ObjectType _object, int idx) {
            this.getIndex(this.object, idx, () -> _object.toBuilder());
            return this;
        }

        @Override
        public SignatureTypeBuilder addObject(List<? extends ObjectType> objects) {
            if (objects != null) {
                for (ObjectType objectType : objects) {
                    this.object.add(objectType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="object")
        public SignatureTypeBuilder setObject(List<? extends ObjectType> objects) {
            this.object = objects == null ? new ArrayList<ObjectType.ObjectTypeBuilder>() : (List)objects.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public SignatureTypeBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public SignatureType build() {
            return new SignatureTypeImpl(this);
        }

        @Override
        public SignatureTypeBuilder toBuilder() {
            return this;
        }

        @Override
        public SignatureTypeBuilder prune() {
            if (this.signedInfo != null && !this.signedInfo.prune().hasData()) {
                this.signedInfo = null;
            }
            if (this.signatureValue != null && !this.signatureValue.prune().hasData()) {
                this.signatureValue = null;
            }
            if (this.keyInfo != null && !this.keyInfo.prune().hasData()) {
                this.keyInfo = null;
            }
            this.object = this.object.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getSignedInfo() != null && this.getSignedInfo().hasData()) {
                return true;
            }
            if (this.getSignatureValue() != null && this.getSignatureValue().hasData()) {
                return true;
            }
            if (this.getKeyInfo() != null && this.getKeyInfo().hasData()) {
                return true;
            }
            if (this.getObject() != null && this.getObject().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public SignatureTypeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SignatureTypeBuilder o = (SignatureTypeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSignedInfo(), (RosettaModelObjectBuilder)o.getSignedInfo(), this::setSignedInfo);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSignatureValue(), (RosettaModelObjectBuilder)o.getSignatureValue(), this::setSignatureValue);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getKeyInfo(), (RosettaModelObjectBuilder)o.getKeyInfo(), this::setKeyInfo);
            merger.mergeRosetta(this.getObject(), o.getObject(), this::getOrCreateObject);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SignatureType _that = this.getType().cast(o);
            if (!Objects.equals(this.signedInfo, _that.getSignedInfo())) {
                return false;
            }
            if (!Objects.equals(this.signatureValue, _that.getSignatureValue())) {
                return false;
            }
            if (!Objects.equals(this.keyInfo, _that.getKeyInfo())) {
                return false;
            }
            if (!ListEquals.listEquals(this.object, _that.getObject())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.signedInfo != null ? this.signedInfo.hashCode() : 0);
            _result = 31 * _result + (this.signatureValue != null ? this.signatureValue.hashCode() : 0);
            _result = 31 * _result + (this.keyInfo != null ? this.keyInfo.hashCode() : 0);
            _result = 31 * _result + (this.object != null ? this.object.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SignatureTypeBuilder {signedInfo=" + this.signedInfo + ", signatureValue=" + this.signatureValue + ", keyInfo=" + this.keyInfo + ", object=" + this.object + ", id=" + this.id + '}';
        }
    }

    public static interface SignatureTypeBuilder
    extends SignatureType,
    RosettaModelObjectBuilder {
        public SignedInfoType.SignedInfoTypeBuilder getOrCreateSignedInfo();

        @Override
        public SignedInfoType.SignedInfoTypeBuilder getSignedInfo();

        public SignatureValueType.SignatureValueTypeBuilder getOrCreateSignatureValue();

        @Override
        public SignatureValueType.SignatureValueTypeBuilder getSignatureValue();

        public KeyInfoType.KeyInfoTypeBuilder getOrCreateKeyInfo();

        @Override
        public KeyInfoType.KeyInfoTypeBuilder getKeyInfo();

        public ObjectType.ObjectTypeBuilder getOrCreateObject(int var1);

        public List<? extends ObjectType.ObjectTypeBuilder> getObject();

        public SignatureTypeBuilder setSignedInfo(SignedInfoType var1);

        public SignatureTypeBuilder setSignatureValue(SignatureValueType var1);

        public SignatureTypeBuilder setKeyInfo(KeyInfoType var1);

        public SignatureTypeBuilder addObject(ObjectType var1);

        public SignatureTypeBuilder addObject(ObjectType var1, int var2);

        public SignatureTypeBuilder addObject(List<? extends ObjectType> var1);

        public SignatureTypeBuilder setObject(List<? extends ObjectType> var1);

        public SignatureTypeBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("signedInfo"), processor, SignedInfoType.SignedInfoTypeBuilder.class, this.getSignedInfo(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("signatureValue"), processor, SignatureValueType.SignatureValueTypeBuilder.class, this.getSignatureValue(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("keyInfo"), processor, KeyInfoType.KeyInfoTypeBuilder.class, this.getKeyInfo(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("object"), processor, ObjectType.ObjectTypeBuilder.class, this.getObject(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public SignatureTypeBuilder prune();
    }

    public static class SignatureTypeImpl
    implements SignatureType {
        private final SignedInfoType signedInfo;
        private final SignatureValueType signatureValue;
        private final KeyInfoType keyInfo;
        private final List<? extends ObjectType> object;
        private final String id;

        protected SignatureTypeImpl(SignatureTypeBuilder builder) {
            this.signedInfo = Optional.ofNullable(builder.getSignedInfo()).map(f -> f.build()).orElse(null);
            this.signatureValue = Optional.ofNullable(builder.getSignatureValue()).map(f -> f.build()).orElse(null);
            this.keyInfo = Optional.ofNullable(builder.getKeyInfo()).map(f -> f.build()).orElse(null);
            this.object = Optional.ofNullable(builder.getObject()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="signedInfo", isRequired=true)
        @RuneAttribute(value="signedInfo", isRequired=true)
        public SignedInfoType getSignedInfo() {
            return this.signedInfo;
        }

        @Override
        @RosettaAttribute(value="signatureValue", isRequired=true)
        @RuneAttribute(value="signatureValue", isRequired=true)
        public SignatureValueType getSignatureValue() {
            return this.signatureValue;
        }

        @Override
        @RosettaAttribute(value="keyInfo")
        @RuneAttribute(value="keyInfo")
        public KeyInfoType getKeyInfo() {
            return this.keyInfo;
        }

        @Override
        @RosettaAttribute(value="object")
        @RuneAttribute(value="object")
        public List<? extends ObjectType> getObject() {
            return this.object;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public SignatureType build() {
            return this;
        }

        @Override
        public SignatureTypeBuilder toBuilder() {
            SignatureTypeBuilder builder = SignatureType.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SignatureTypeBuilder builder) {
            Optional.ofNullable(this.getSignedInfo()).ifPresent(builder::setSignedInfo);
            Optional.ofNullable(this.getSignatureValue()).ifPresent(builder::setSignatureValue);
            Optional.ofNullable(this.getKeyInfo()).ifPresent(builder::setKeyInfo);
            Optional.ofNullable(this.getObject()).ifPresent(builder::setObject);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SignatureType _that = this.getType().cast(o);
            if (!Objects.equals(this.signedInfo, _that.getSignedInfo())) {
                return false;
            }
            if (!Objects.equals(this.signatureValue, _that.getSignatureValue())) {
                return false;
            }
            if (!Objects.equals(this.keyInfo, _that.getKeyInfo())) {
                return false;
            }
            if (!ListEquals.listEquals(this.object, _that.getObject())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.signedInfo != null ? this.signedInfo.hashCode() : 0);
            _result = 31 * _result + (this.signatureValue != null ? this.signatureValue.hashCode() : 0);
            _result = 31 * _result + (this.keyInfo != null ? this.keyInfo.hashCode() : 0);
            _result = 31 * _result + (this.object != null ? this.object.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SignatureType {signedInfo=" + this.signedInfo + ", signatureValue=" + this.signatureValue + ", keyInfo=" + this.keyInfo + ", object=" + this.object + ", id=" + this.id + '}';
        }
    }
}

