/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.meta.DigestMethodTypeMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DigestMethodType", builder=DigestMethodTypeBuilderImpl.class, version="1.1.0")
@RuneDataType(value="DigestMethodType", model="fpml", builder=DigestMethodTypeBuilderImpl.class, version="1.1.0")
public interface DigestMethodType
extends RosettaModelObject {
    public static final DigestMethodTypeMeta metaData = new DigestMethodTypeMeta();

    public List<String> getAnyContents();

    public String getAlgorithm();

    public DigestMethodType build();

    public DigestMethodTypeBuilder toBuilder();

    public static DigestMethodTypeBuilder builder() {
        return new DigestMethodTypeBuilderImpl();
    }

    default public RosettaMetaData<? extends DigestMethodType> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DigestMethodType> getType() {
        return DigestMethodType.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("anyContents"), String.class, this.getAnyContents(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("algorithm"), String.class, (Object)this.getAlgorithm(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class DigestMethodTypeBuilderImpl
    implements DigestMethodTypeBuilder {
        protected List<String> anyContents = new ArrayList<String>();
        protected String algorithm;

        @Override
        @RosettaAttribute(value="anyContents")
        @RuneAttribute(value="anyContents")
        public List<String> getAnyContents() {
            return this.anyContents;
        }

        @Override
        @RosettaAttribute(value="algorithm", isRequired=true)
        @RuneAttribute(value="algorithm", isRequired=true)
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        @RosettaAttribute(value="anyContents")
        @RuneAttribute(value="anyContents")
        public DigestMethodTypeBuilder addAnyContents(String _anyContents) {
            if (_anyContents != null) {
                this.anyContents.add(_anyContents);
            }
            return this;
        }

        @Override
        public DigestMethodTypeBuilder addAnyContents(String _anyContents, int idx) {
            this.getIndex(this.anyContents, idx, () -> _anyContents);
            return this;
        }

        @Override
        public DigestMethodTypeBuilder addAnyContents(List<String> anyContentss) {
            if (anyContentss != null) {
                for (String toAdd : anyContentss) {
                    this.anyContents.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="anyContents")
        public DigestMethodTypeBuilder setAnyContents(List<String> anyContentss) {
            this.anyContents = anyContentss == null ? new ArrayList<String>() : (List)anyContentss.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="algorithm", isRequired=true)
        @RuneAttribute(value="algorithm", isRequired=true)
        public DigestMethodTypeBuilder setAlgorithm(String _algorithm) {
            this.algorithm = _algorithm == null ? null : _algorithm;
            return this;
        }

        @Override
        public DigestMethodType build() {
            return new DigestMethodTypeImpl(this);
        }

        @Override
        public DigestMethodTypeBuilder toBuilder() {
            return this;
        }

        @Override
        public DigestMethodTypeBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getAnyContents() != null && !this.getAnyContents().isEmpty()) {
                return true;
            }
            return this.getAlgorithm() != null;
        }

        public DigestMethodTypeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DigestMethodTypeBuilder o = (DigestMethodTypeBuilder)other;
            merger.mergeBasic(this.getAnyContents(), o.getAnyContents(), this::addAnyContents);
            merger.mergeBasic((Object)this.getAlgorithm(), (Object)o.getAlgorithm(), this::setAlgorithm, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DigestMethodType _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.anyContents, _that.getAnyContents())) {
                return false;
            }
            return Objects.equals(this.algorithm, _that.getAlgorithm());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.anyContents != null ? this.anyContents.hashCode() : 0);
            _result = 31 * _result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DigestMethodTypeBuilder {anyContents=" + this.anyContents + ", algorithm=" + this.algorithm + '}';
        }
    }

    public static interface DigestMethodTypeBuilder
    extends DigestMethodType,
    RosettaModelObjectBuilder {
        public DigestMethodTypeBuilder addAnyContents(String var1);

        public DigestMethodTypeBuilder addAnyContents(String var1, int var2);

        public DigestMethodTypeBuilder addAnyContents(List<String> var1);

        public DigestMethodTypeBuilder setAnyContents(List<String> var1);

        public DigestMethodTypeBuilder setAlgorithm(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("anyContents"), String.class, this.getAnyContents(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("algorithm"), String.class, (Object)this.getAlgorithm(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public DigestMethodTypeBuilder prune();
    }

    public static class DigestMethodTypeImpl
    implements DigestMethodType {
        private final List<String> anyContents;
        private final String algorithm;

        protected DigestMethodTypeImpl(DigestMethodTypeBuilder builder) {
            this.anyContents = Optional.ofNullable(builder.getAnyContents()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.algorithm = builder.getAlgorithm();
        }

        @Override
        @RosettaAttribute(value="anyContents")
        @RuneAttribute(value="anyContents")
        public List<String> getAnyContents() {
            return this.anyContents;
        }

        @Override
        @RosettaAttribute(value="algorithm", isRequired=true)
        @RuneAttribute(value="algorithm", isRequired=true)
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public DigestMethodType build() {
            return this;
        }

        @Override
        public DigestMethodTypeBuilder toBuilder() {
            DigestMethodTypeBuilder builder = DigestMethodType.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DigestMethodTypeBuilder builder) {
            Optional.ofNullable(this.getAnyContents()).ifPresent(builder::setAnyContents);
            Optional.ofNullable(this.getAlgorithm()).ifPresent(builder::setAlgorithm);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DigestMethodType _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.anyContents, _that.getAnyContents())) {
                return false;
            }
            return Objects.equals(this.algorithm, _that.getAlgorithm());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.anyContents != null ? this.anyContents.hashCode() : 0);
            _result = 31 * _result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DigestMethodType {anyContents=" + this.anyContents + ", algorithm=" + this.algorithm + '}';
        }
    }
}

