/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.MultipleExercise;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MultipleExerciseMaximumNumberOfOptions")
@ImplementedBy(value=Default.class)
public interface MultipleExerciseMaximumNumberOfOptions
extends Validator<MultipleExercise> {
    public static final String NAME = "MultipleExerciseMaximumNumberOfOptions";
    public static final String DEFINITION = "if maximumNumberOfOptions exists then maximumNotionalAmount >= 0";

    public static class NoOp
    implements MultipleExerciseMaximumNumberOfOptions {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MultipleExercise multipleExercise) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MultipleExerciseMaximumNumberOfOptions {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MultipleExercise multipleExercise) {
            ComparisonResult result = this.executeDataRule(multipleExercise);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MultipleExerciseMaximumNumberOfOptions.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MultipleExercise", (RosettaPath)path, (String)MultipleExerciseMaximumNumberOfOptions.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MultipleExerciseMaximumNumberOfOptions.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MultipleExercise", (RosettaPath)path, (String)MultipleExerciseMaximumNumberOfOptions.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(MultipleExercise multipleExercise) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)multipleExercise).map("getMaximumNumberOfOptions", _multipleExercise -> _multipleExercise.getMaximumNumberOfOptions())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)multipleExercise).map("getMaximumNotionalAmount", _multipleExercise -> _multipleExercise.getMaximumNotionalAmount()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

