/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.asset.common.Asset;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.observable.asset.Money;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.AssetLeg;
import cdm.product.template.AssetPayoutTradeTypeEnum;
import cdm.product.template.DividendTerms;
import cdm.product.template.meta.AssetPayoutMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AssetPayout", builder=AssetPayoutBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="AssetPayout", model="cdm", builder=AssetPayoutBuilderImpl.class, version="7.0.0-dev.52")
public interface AssetPayout
extends PayoutBase {
    public static final AssetPayoutMeta metaData = new AssetPayoutMeta();

    public List<? extends AssetLeg> getAssetLeg();

    public Asset getUnderlier();

    public Money getMinimumFee();

    public DividendTerms getDividendTerms();

    public AssetPayoutTradeTypeEnum getTradeType();

    @Override
    public AssetPayout build();

    @Override
    public AssetPayoutBuilder toBuilder();

    public static AssetPayoutBuilder builder() {
        return new AssetPayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetPayout> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetPayout> getType() {
        return AssetPayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.class, this.getPrincipalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.class, this.getSettlementTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assetLeg"), processor, AssetLeg.class, this.getAssetLeg(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlier"), processor, Asset.class, this.getUnderlier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minimumFee"), processor, Money.class, this.getMinimumFee(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendTerms"), processor, DividendTerms.class, this.getDividendTerms(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeType"), AssetPayoutTradeTypeEnum.class, (Object)this.getTradeType(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AssetPayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements AssetPayoutBuilder {
        protected List<AssetLeg.AssetLegBuilder> assetLeg = new ArrayList<AssetLeg.AssetLegBuilder>();
        protected Asset.AssetBuilder underlier;
        protected Money.MoneyBuilder minimumFee;
        protected DividendTerms.DividendTermsBuilder dividendTerms;
        protected AssetPayoutTradeTypeEnum tradeType;

        @Override
        @RosettaAttribute(value="assetLeg", isRequired=true)
        @RuneAttribute(value="assetLeg", isRequired=true)
        public List<? extends AssetLeg.AssetLegBuilder> getAssetLeg() {
            return this.assetLeg;
        }

        @Override
        public AssetLeg.AssetLegBuilder getOrCreateAssetLeg(int index) {
            if (this.assetLeg == null) {
                this.assetLeg = new ArrayList<AssetLeg.AssetLegBuilder>();
            }
            return (AssetLeg.AssetLegBuilder)this.getIndex(this.assetLeg, index, () -> {
                AssetLeg.AssetLegBuilder newAssetLeg = AssetLeg.builder();
                return newAssetLeg;
            });
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public Asset.AssetBuilder getUnderlier() {
            return this.underlier;
        }

        @Override
        public Asset.AssetBuilder getOrCreateUnderlier() {
            Asset.AssetBuilder result = this.underlier != null ? this.underlier : (this.underlier = Asset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="minimumFee")
        @RuneAttribute(value="minimumFee")
        public Money.MoneyBuilder getMinimumFee() {
            return this.minimumFee;
        }

        @Override
        public Money.MoneyBuilder getOrCreateMinimumFee() {
            Money.MoneyBuilder result = this.minimumFee != null ? this.minimumFee : (this.minimumFee = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dividendTerms")
        @RuneAttribute(value="dividendTerms")
        public DividendTerms.DividendTermsBuilder getDividendTerms() {
            return this.dividendTerms;
        }

        @Override
        public DividendTerms.DividendTermsBuilder getOrCreateDividendTerms() {
            DividendTerms.DividendTermsBuilder result = this.dividendTerms != null ? this.dividendTerms : (this.dividendTerms = DividendTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeType")
        @RuneAttribute(value="tradeType")
        public AssetPayoutTradeTypeEnum getTradeType() {
            return this.tradeType;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public AssetPayoutBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        @RuneAttribute(value="priceQuantity")
        public AssetPayoutBuilder setPriceQuantity(ResolvablePriceQuantity _priceQuantity) {
            this.priceQuantity = _priceQuantity == null ? null : _priceQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        @RuneAttribute(value="principalPayment")
        public AssetPayoutBuilder setPrincipalPayment(PrincipalPayments _principalPayment) {
            this.principalPayment = _principalPayment == null ? null : _principalPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public AssetPayoutBuilder setSettlementTerms(SettlementTerms _settlementTerms) {
            this.settlementTerms = _settlementTerms == null ? null : _settlementTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetLeg", isRequired=true)
        @RuneAttribute(value="assetLeg", isRequired=true)
        public AssetPayoutBuilder addAssetLeg(AssetLeg _assetLeg) {
            if (_assetLeg != null) {
                this.assetLeg.add(_assetLeg.toBuilder());
            }
            return this;
        }

        @Override
        public AssetPayoutBuilder addAssetLeg(AssetLeg _assetLeg, int idx) {
            this.getIndex(this.assetLeg, idx, () -> _assetLeg.toBuilder());
            return this;
        }

        @Override
        public AssetPayoutBuilder addAssetLeg(List<? extends AssetLeg> assetLegs) {
            if (assetLegs != null) {
                for (AssetLeg assetLeg : assetLegs) {
                    this.assetLeg.add(assetLeg.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="assetLeg")
        public AssetPayoutBuilder setAssetLeg(List<? extends AssetLeg> assetLegs) {
            this.assetLeg = assetLegs == null ? new ArrayList<AssetLeg.AssetLegBuilder>() : (List)assetLegs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public AssetPayoutBuilder setUnderlier(Asset _underlier) {
            this.underlier = _underlier == null ? null : _underlier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="minimumFee")
        @RuneAttribute(value="minimumFee")
        public AssetPayoutBuilder setMinimumFee(Money _minimumFee) {
            this.minimumFee = _minimumFee == null ? null : _minimumFee.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendTerms")
        @RuneAttribute(value="dividendTerms")
        public AssetPayoutBuilder setDividendTerms(DividendTerms _dividendTerms) {
            this.dividendTerms = _dividendTerms == null ? null : _dividendTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeType")
        @RuneAttribute(value="tradeType")
        public AssetPayoutBuilder setTradeType(AssetPayoutTradeTypeEnum _tradeType) {
            this.tradeType = _tradeType == null ? null : _tradeType;
            return this;
        }

        @Override
        public AssetPayout build() {
            return new AssetPayoutImpl(this);
        }

        @Override
        public AssetPayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetPayoutBuilder prune() {
            super.prune();
            this.assetLeg = this.assetLeg.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.underlier != null && !this.underlier.prune().hasData()) {
                this.underlier = null;
            }
            if (this.minimumFee != null && !this.minimumFee.prune().hasData()) {
                this.minimumFee = null;
            }
            if (this.dividendTerms != null && !this.dividendTerms.prune().hasData()) {
                this.dividendTerms = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAssetLeg() != null && this.getAssetLeg().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getUnderlier() != null && this.getUnderlier().hasData()) {
                return true;
            }
            if (this.getMinimumFee() != null && this.getMinimumFee().hasData()) {
                return true;
            }
            if (this.getDividendTerms() != null && this.getDividendTerms().hasData()) {
                return true;
            }
            return this.getTradeType() != null;
        }

        @Override
        public AssetPayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AssetPayoutBuilder o = (AssetPayoutBuilder)other;
            merger.mergeRosetta(this.getAssetLeg(), o.getAssetLeg(), this::getOrCreateAssetLeg);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlier(), (RosettaModelObjectBuilder)o.getUnderlier(), this::setUnderlier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinimumFee(), (RosettaModelObjectBuilder)o.getMinimumFee(), this::setMinimumFee);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividendTerms(), (RosettaModelObjectBuilder)o.getDividendTerms(), this::setDividendTerms);
            merger.mergeBasic((Object)this.getTradeType(), (Object)o.getTradeType(), this::setTradeType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AssetPayout _that = (AssetPayout)this.getType().cast(o);
            if (!ListEquals.listEquals(this.assetLeg, _that.getAssetLeg())) {
                return false;
            }
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!Objects.equals(this.minimumFee, _that.getMinimumFee())) {
                return false;
            }
            if (!Objects.equals(this.dividendTerms, _that.getDividendTerms())) {
                return false;
            }
            return Objects.equals((Object)this.tradeType, (Object)_that.getTradeType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.assetLeg != null ? this.assetLeg.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.minimumFee != null ? this.minimumFee.hashCode() : 0);
            _result = 31 * _result + (this.dividendTerms != null ? this.dividendTerms.hashCode() : 0);
            _result = 31 * _result + (this.tradeType != null ? ((Object)((Object)this.tradeType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AssetPayoutBuilder {assetLeg=" + this.assetLeg + ", underlier=" + this.underlier + ", minimumFee=" + this.minimumFee + ", dividendTerms=" + this.dividendTerms + ", tradeType=" + (Object)((Object)this.tradeType) + '}' + " " + super.toString();
        }
    }

    public static interface AssetPayoutBuilder
    extends AssetPayout,
    PayoutBase.PayoutBaseBuilder {
        public AssetLeg.AssetLegBuilder getOrCreateAssetLeg(int var1);

        public List<? extends AssetLeg.AssetLegBuilder> getAssetLeg();

        public Asset.AssetBuilder getOrCreateUnderlier();

        @Override
        public Asset.AssetBuilder getUnderlier();

        public Money.MoneyBuilder getOrCreateMinimumFee();

        @Override
        public Money.MoneyBuilder getMinimumFee();

        public DividendTerms.DividendTermsBuilder getOrCreateDividendTerms();

        @Override
        public DividendTerms.DividendTermsBuilder getDividendTerms();

        @Override
        public AssetPayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public AssetPayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public AssetPayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public AssetPayoutBuilder setSettlementTerms(SettlementTerms var1);

        public AssetPayoutBuilder addAssetLeg(AssetLeg var1);

        public AssetPayoutBuilder addAssetLeg(AssetLeg var1, int var2);

        public AssetPayoutBuilder addAssetLeg(List<? extends AssetLeg> var1);

        public AssetPayoutBuilder setAssetLeg(List<? extends AssetLeg> var1);

        public AssetPayoutBuilder setUnderlier(Asset var1);

        public AssetPayoutBuilder setMinimumFee(Money var1);

        public AssetPayoutBuilder setDividendTerms(DividendTerms var1);

        public AssetPayoutBuilder setTradeType(AssetPayoutTradeTypeEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.ResolvablePriceQuantityBuilder.class, (RosettaModelObjectBuilder)this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.PrincipalPaymentsBuilder.class, (RosettaModelObjectBuilder)this.getPrincipalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.SettlementTermsBuilder.class, (RosettaModelObjectBuilder)this.getSettlementTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assetLeg"), processor, AssetLeg.AssetLegBuilder.class, this.getAssetLeg(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlier"), processor, Asset.AssetBuilder.class, this.getUnderlier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minimumFee"), processor, Money.MoneyBuilder.class, this.getMinimumFee(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendTerms"), processor, DividendTerms.DividendTermsBuilder.class, this.getDividendTerms(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeType"), AssetPayoutTradeTypeEnum.class, (Object)this.getTradeType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public AssetPayoutBuilder prune();
    }

    public static class AssetPayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements AssetPayout {
        private final List<? extends AssetLeg> assetLeg;
        private final Asset underlier;
        private final Money minimumFee;
        private final DividendTerms dividendTerms;
        private final AssetPayoutTradeTypeEnum tradeType;

        protected AssetPayoutImpl(AssetPayoutBuilder builder) {
            super(builder);
            this.assetLeg = Optional.ofNullable(builder.getAssetLeg()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.underlier = Optional.ofNullable(builder.getUnderlier()).map(f -> f.build()).orElse(null);
            this.minimumFee = Optional.ofNullable(builder.getMinimumFee()).map(f -> f.build()).orElse(null);
            this.dividendTerms = Optional.ofNullable(builder.getDividendTerms()).map(f -> f.build()).orElse(null);
            this.tradeType = builder.getTradeType();
        }

        @Override
        @RosettaAttribute(value="assetLeg", isRequired=true)
        @RuneAttribute(value="assetLeg", isRequired=true)
        public List<? extends AssetLeg> getAssetLeg() {
            return this.assetLeg;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public Asset getUnderlier() {
            return this.underlier;
        }

        @Override
        @RosettaAttribute(value="minimumFee")
        @RuneAttribute(value="minimumFee")
        public Money getMinimumFee() {
            return this.minimumFee;
        }

        @Override
        @RosettaAttribute(value="dividendTerms")
        @RuneAttribute(value="dividendTerms")
        public DividendTerms getDividendTerms() {
            return this.dividendTerms;
        }

        @Override
        @RosettaAttribute(value="tradeType")
        @RuneAttribute(value="tradeType")
        public AssetPayoutTradeTypeEnum getTradeType() {
            return this.tradeType;
        }

        @Override
        public AssetPayout build() {
            return this;
        }

        @Override
        public AssetPayoutBuilder toBuilder() {
            AssetPayoutBuilder builder = AssetPayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetPayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAssetLeg()).ifPresent(builder::setAssetLeg);
            Optional.ofNullable(this.getUnderlier()).ifPresent(builder::setUnderlier);
            Optional.ofNullable(this.getMinimumFee()).ifPresent(builder::setMinimumFee);
            Optional.ofNullable(this.getDividendTerms()).ifPresent(builder::setDividendTerms);
            Optional.ofNullable(this.getTradeType()).ifPresent(builder::setTradeType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AssetPayout _that = (AssetPayout)this.getType().cast(o);
            if (!ListEquals.listEquals(this.assetLeg, _that.getAssetLeg())) {
                return false;
            }
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!Objects.equals(this.minimumFee, _that.getMinimumFee())) {
                return false;
            }
            if (!Objects.equals(this.dividendTerms, _that.getDividendTerms())) {
                return false;
            }
            return Objects.equals((Object)this.tradeType, (Object)_that.getTradeType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.assetLeg != null ? this.assetLeg.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.minimumFee != null ? this.minimumFee.hashCode() : 0);
            _result = 31 * _result + (this.dividendTerms != null ? this.dividendTerms.hashCode() : 0);
            _result = 31 * _result + (this.tradeType != null ? ((Object)((Object)this.tradeType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AssetPayout {assetLeg=" + this.assetLeg + ", underlier=" + this.underlier + ", minimumFee=" + this.minimumFee + ", dividendTerms=" + this.dividendTerms + ", tradeType=" + (Object)((Object)this.tradeType) + '}' + " " + super.toString();
        }
    }
}

