/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.functions;

import cdm.event.common.functions.AdjustedValuationDates;
import cdm.observable.asset.Observable;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.ValuationDates;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.asset.functions.ResolveEquityInitialPrice;
import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolvePerformancePeriodStartPriceDefault.class)
public abstract class ResolvePerformancePeriodStartPrice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected AdjustedValuationDates adjustedValuationDates0;
    @Inject
    protected ResolveEquityInitialPrice resolveEquityInitialPrice;

    public PriceSchedule evaluate(PerformancePayout performancePayout, List<? extends PriceSchedule> price, Observable observable, Date adjustedDate) {
        PriceSchedule startPrice;
        PriceSchedule.PriceScheduleBuilder startPriceBuilder = this.doEvaluate(performancePayout, price, observable, adjustedDate);
        if (startPriceBuilder == null) {
            startPrice = null;
        } else {
            startPrice = startPriceBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)startPrice);
        }
        return startPrice;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(PerformancePayout var1, List<? extends PriceSchedule> var2, Observable var3, Date var4);

    protected abstract MapperC<Date> adjustedValuationDates1(PerformancePayout var1, List<? extends PriceSchedule> var2, Observable var3, Date var4);

    public static class ResolvePerformancePeriodStartPriceDefault
    extends ResolvePerformancePeriodStartPrice {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(PerformancePayout performancePayout, List<? extends PriceSchedule> price, Observable observable, Date adjustedDate) {
            if (price == null) {
                price = Collections.emptyList();
            }
            PriceSchedule.PriceScheduleBuilder startPrice = PriceSchedule.builder();
            return this.assignOutput(startPrice, performancePayout, price, observable, adjustedDate);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder startPrice, PerformancePayout performancePayout, List<? extends PriceSchedule> price, Observable observable, Date adjustedDate) {
            ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule;
            startPrice = ExpressionOperators.lessThan((Mapper)MapperS.of((Object)adjustedDate), (Mapper)this.adjustedValuationDates1(performancePayout, price, observable, adjustedDate).first(), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((referenceWithMetaPriceSchedule = (ReferenceWithMetaPriceSchedule)MapperS.of((Object)performancePayout).mapC("getInitialValuationPrice", _performancePayout -> _performancePayout.getInitialValuationPrice()).get()) == null ? null : (PriceSchedule.PriceScheduleBuilder)this.toBuilder(referenceWithMetaPriceSchedule.getValue())) : (PriceSchedule.PriceScheduleBuilder)this.toBuilder(this.resolveEquityInitialPrice.evaluate(price));
            return Optional.ofNullable(startPrice).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<Date> adjustedValuationDates1(PerformancePayout performancePayout, List<? extends PriceSchedule> price, Observable observable, Date adjustedDate) {
            return MapperC.of(this.adjustedValuationDates0.evaluate((ValuationDates)MapperS.of((Object)performancePayout).map("getValuationDates", _performancePayout -> _performancePayout.getValuationDates()).get()));
        }
    }
}

