/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.observable.asset.TransactedPrice;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.ProtectionTerms;
import cdm.product.asset.meta.CreditDefaultPayoutMeta;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditDefaultPayout", builder=CreditDefaultPayoutBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="CreditDefaultPayout", model="cdm", builder=CreditDefaultPayoutBuilderImpl.class, version="7.0.0-dev.52")
public interface CreditDefaultPayout
extends PayoutBase {
    public static final CreditDefaultPayoutMeta metaData = new CreditDefaultPayoutMeta();

    public GeneralTerms getGeneralTerms();

    public List<? extends ProtectionTerms> getProtectionTerms();

    public TransactedPrice getTransactedPrice();

    @Override
    public CreditDefaultPayout build();

    @Override
    public CreditDefaultPayoutBuilder toBuilder();

    public static CreditDefaultPayoutBuilder builder() {
        return new CreditDefaultPayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditDefaultPayout> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditDefaultPayout> getType() {
        return CreditDefaultPayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.class, this.getPrincipalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.class, this.getSettlementTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("generalTerms"), processor, GeneralTerms.class, this.getGeneralTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("protectionTerms"), processor, ProtectionTerms.class, this.getProtectionTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("transactedPrice"), processor, TransactedPrice.class, this.getTransactedPrice(), new AttributeMeta[0]);
    }

    public static class CreditDefaultPayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements CreditDefaultPayoutBuilder {
        protected GeneralTerms.GeneralTermsBuilder generalTerms;
        protected List<ProtectionTerms.ProtectionTermsBuilder> protectionTerms = new ArrayList<ProtectionTerms.ProtectionTermsBuilder>();
        protected TransactedPrice.TransactedPriceBuilder transactedPrice;

        @Override
        @RosettaAttribute(value="generalTerms", isRequired=true)
        @RuneAttribute(value="generalTerms", isRequired=true)
        public GeneralTerms.GeneralTermsBuilder getGeneralTerms() {
            return this.generalTerms;
        }

        @Override
        public GeneralTerms.GeneralTermsBuilder getOrCreateGeneralTerms() {
            GeneralTerms.GeneralTermsBuilder result = this.generalTerms != null ? this.generalTerms : (this.generalTerms = GeneralTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="protectionTerms")
        @RuneAttribute(value="protectionTerms")
        public List<? extends ProtectionTerms.ProtectionTermsBuilder> getProtectionTerms() {
            return this.protectionTerms;
        }

        @Override
        public ProtectionTerms.ProtectionTermsBuilder getOrCreateProtectionTerms(int index) {
            if (this.protectionTerms == null) {
                this.protectionTerms = new ArrayList<ProtectionTerms.ProtectionTermsBuilder>();
            }
            return (ProtectionTerms.ProtectionTermsBuilder)this.getIndex(this.protectionTerms, index, () -> {
                ProtectionTerms.ProtectionTermsBuilder newProtectionTerms = ProtectionTerms.builder();
                return newProtectionTerms;
            });
        }

        @Override
        @RosettaAttribute(value="transactedPrice")
        @RuneAttribute(value="transactedPrice")
        public TransactedPrice.TransactedPriceBuilder getTransactedPrice() {
            return this.transactedPrice;
        }

        @Override
        public TransactedPrice.TransactedPriceBuilder getOrCreateTransactedPrice() {
            TransactedPrice.TransactedPriceBuilder result = this.transactedPrice != null ? this.transactedPrice : (this.transactedPrice = TransactedPrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public CreditDefaultPayoutBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        @RuneAttribute(value="priceQuantity")
        public CreditDefaultPayoutBuilder setPriceQuantity(ResolvablePriceQuantity _priceQuantity) {
            this.priceQuantity = _priceQuantity == null ? null : _priceQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        @RuneAttribute(value="principalPayment")
        public CreditDefaultPayoutBuilder setPrincipalPayment(PrincipalPayments _principalPayment) {
            this.principalPayment = _principalPayment == null ? null : _principalPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public CreditDefaultPayoutBuilder setSettlementTerms(SettlementTerms _settlementTerms) {
            this.settlementTerms = _settlementTerms == null ? null : _settlementTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="generalTerms", isRequired=true)
        @RuneAttribute(value="generalTerms", isRequired=true)
        public CreditDefaultPayoutBuilder setGeneralTerms(GeneralTerms _generalTerms) {
            this.generalTerms = _generalTerms == null ? null : _generalTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="protectionTerms")
        @RuneAttribute(value="protectionTerms")
        public CreditDefaultPayoutBuilder addProtectionTerms(ProtectionTerms _protectionTerms) {
            if (_protectionTerms != null) {
                this.protectionTerms.add(_protectionTerms.toBuilder());
            }
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder addProtectionTerms(ProtectionTerms _protectionTerms, int idx) {
            this.getIndex(this.protectionTerms, idx, () -> _protectionTerms.toBuilder());
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder addProtectionTerms(List<? extends ProtectionTerms> protectionTermss) {
            if (protectionTermss != null) {
                for (ProtectionTerms protectionTerms : protectionTermss) {
                    this.protectionTerms.add(protectionTerms.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="protectionTerms")
        public CreditDefaultPayoutBuilder setProtectionTerms(List<? extends ProtectionTerms> protectionTermss) {
            this.protectionTerms = protectionTermss == null ? new ArrayList<ProtectionTerms.ProtectionTermsBuilder>() : (List)protectionTermss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="transactedPrice")
        @RuneAttribute(value="transactedPrice")
        public CreditDefaultPayoutBuilder setTransactedPrice(TransactedPrice _transactedPrice) {
            this.transactedPrice = _transactedPrice == null ? null : _transactedPrice.toBuilder();
            return this;
        }

        @Override
        public CreditDefaultPayout build() {
            return new CreditDefaultPayoutImpl(this);
        }

        @Override
        public CreditDefaultPayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder prune() {
            super.prune();
            if (this.generalTerms != null && !this.generalTerms.prune().hasData()) {
                this.generalTerms = null;
            }
            this.protectionTerms = this.protectionTerms.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.transactedPrice != null && !this.transactedPrice.prune().hasData()) {
                this.transactedPrice = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getGeneralTerms() != null && this.getGeneralTerms().hasData()) {
                return true;
            }
            if (this.getProtectionTerms() != null && this.getProtectionTerms().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getTransactedPrice() != null && this.getTransactedPrice().hasData();
        }

        @Override
        public CreditDefaultPayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CreditDefaultPayoutBuilder o = (CreditDefaultPayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGeneralTerms(), (RosettaModelObjectBuilder)o.getGeneralTerms(), this::setGeneralTerms);
            merger.mergeRosetta(this.getProtectionTerms(), o.getProtectionTerms(), this::getOrCreateProtectionTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTransactedPrice(), (RosettaModelObjectBuilder)o.getTransactedPrice(), this::setTransactedPrice);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditDefaultPayout _that = (CreditDefaultPayout)this.getType().cast(o);
            if (!Objects.equals(this.generalTerms, _that.getGeneralTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.protectionTerms, _that.getProtectionTerms())) {
                return false;
            }
            return Objects.equals(this.transactedPrice, _that.getTransactedPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.generalTerms != null ? this.generalTerms.hashCode() : 0);
            _result = 31 * _result + (this.protectionTerms != null ? this.protectionTerms.hashCode() : 0);
            _result = 31 * _result + (this.transactedPrice != null ? this.transactedPrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditDefaultPayoutBuilder {generalTerms=" + this.generalTerms + ", protectionTerms=" + this.protectionTerms + ", transactedPrice=" + this.transactedPrice + '}' + " " + super.toString();
        }
    }

    public static interface CreditDefaultPayoutBuilder
    extends CreditDefaultPayout,
    PayoutBase.PayoutBaseBuilder {
        public GeneralTerms.GeneralTermsBuilder getOrCreateGeneralTerms();

        @Override
        public GeneralTerms.GeneralTermsBuilder getGeneralTerms();

        public ProtectionTerms.ProtectionTermsBuilder getOrCreateProtectionTerms(int var1);

        public List<? extends ProtectionTerms.ProtectionTermsBuilder> getProtectionTerms();

        public TransactedPrice.TransactedPriceBuilder getOrCreateTransactedPrice();

        @Override
        public TransactedPrice.TransactedPriceBuilder getTransactedPrice();

        @Override
        public CreditDefaultPayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public CreditDefaultPayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public CreditDefaultPayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public CreditDefaultPayoutBuilder setSettlementTerms(SettlementTerms var1);

        public CreditDefaultPayoutBuilder setGeneralTerms(GeneralTerms var1);

        public CreditDefaultPayoutBuilder addProtectionTerms(ProtectionTerms var1);

        public CreditDefaultPayoutBuilder addProtectionTerms(ProtectionTerms var1, int var2);

        public CreditDefaultPayoutBuilder addProtectionTerms(List<? extends ProtectionTerms> var1);

        public CreditDefaultPayoutBuilder setProtectionTerms(List<? extends ProtectionTerms> var1);

        public CreditDefaultPayoutBuilder setTransactedPrice(TransactedPrice var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.ResolvablePriceQuantityBuilder.class, (RosettaModelObjectBuilder)this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.PrincipalPaymentsBuilder.class, (RosettaModelObjectBuilder)this.getPrincipalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.SettlementTermsBuilder.class, (RosettaModelObjectBuilder)this.getSettlementTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("generalTerms"), processor, GeneralTerms.GeneralTermsBuilder.class, this.getGeneralTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("protectionTerms"), processor, ProtectionTerms.ProtectionTermsBuilder.class, this.getProtectionTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("transactedPrice"), processor, TransactedPrice.TransactedPriceBuilder.class, this.getTransactedPrice(), new AttributeMeta[0]);
        }

        @Override
        public CreditDefaultPayoutBuilder prune();
    }

    public static class CreditDefaultPayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements CreditDefaultPayout {
        private final GeneralTerms generalTerms;
        private final List<? extends ProtectionTerms> protectionTerms;
        private final TransactedPrice transactedPrice;

        protected CreditDefaultPayoutImpl(CreditDefaultPayoutBuilder builder) {
            super(builder);
            this.generalTerms = Optional.ofNullable(builder.getGeneralTerms()).map(f -> f.build()).orElse(null);
            this.protectionTerms = Optional.ofNullable(builder.getProtectionTerms()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.transactedPrice = Optional.ofNullable(builder.getTransactedPrice()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="generalTerms", isRequired=true)
        @RuneAttribute(value="generalTerms", isRequired=true)
        public GeneralTerms getGeneralTerms() {
            return this.generalTerms;
        }

        @Override
        @RosettaAttribute(value="protectionTerms")
        @RuneAttribute(value="protectionTerms")
        public List<? extends ProtectionTerms> getProtectionTerms() {
            return this.protectionTerms;
        }

        @Override
        @RosettaAttribute(value="transactedPrice")
        @RuneAttribute(value="transactedPrice")
        public TransactedPrice getTransactedPrice() {
            return this.transactedPrice;
        }

        @Override
        public CreditDefaultPayout build() {
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder toBuilder() {
            CreditDefaultPayoutBuilder builder = CreditDefaultPayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditDefaultPayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getGeneralTerms()).ifPresent(builder::setGeneralTerms);
            Optional.ofNullable(this.getProtectionTerms()).ifPresent(builder::setProtectionTerms);
            Optional.ofNullable(this.getTransactedPrice()).ifPresent(builder::setTransactedPrice);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditDefaultPayout _that = (CreditDefaultPayout)this.getType().cast(o);
            if (!Objects.equals(this.generalTerms, _that.getGeneralTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.protectionTerms, _that.getProtectionTerms())) {
                return false;
            }
            return Objects.equals(this.transactedPrice, _that.getTransactedPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.generalTerms != null ? this.generalTerms.hashCode() : 0);
            _result = 31 * _result + (this.protectionTerms != null ? this.protectionTerms.hashCode() : 0);
            _result = 31 * _result + (this.transactedPrice != null ? this.transactedPrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditDefaultPayout {generalTerms=" + this.generalTerms + ", protectionTerms=" + this.protectionTerms + ", transactedPrice=" + this.transactedPrice + '}' + " " + super.toString();
        }
    }
}

