/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.staticdata.party.Account;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.LegalEntity;
import cdm.legaldocumentation.csa.LegacyVMCustodianEnum;
import cdm.legaldocumentation.csa.meta.CustodianElectionMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CustodianElection", builder=CustodianElectionBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="CustodianElection", model="cdm", builder=CustodianElectionBuilderImpl.class, version="7.0.0-dev.52")
public interface CustodianElection
extends RosettaModelObject {
    public static final CustodianElectionMeta metaData = new CustodianElectionMeta();

    public CounterpartyRoleEnum getParty();

    public LegalEntity getCustodian();

    public Account getSegregatedCashAccount();

    public Account getSegregatedSecurityAccount();

    public LegacyVMCustodianEnum getLegacyVMCustodian();

    public LegalEntity getLegacyNamedEntity();

    public String getAdditionalLanguage();

    public CustodianElection build();

    public CustodianElectionBuilder toBuilder();

    public static CustodianElectionBuilder builder() {
        return new CustodianElectionBuilderImpl();
    }

    default public RosettaMetaData<? extends CustodianElection> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CustodianElection> getType() {
        return CustodianElection.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("custodian"), processor, LegalEntity.class, this.getCustodian(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("segregatedCashAccount"), processor, Account.class, this.getSegregatedCashAccount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("segregatedSecurityAccount"), processor, Account.class, this.getSegregatedSecurityAccount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("legacyVMCustodian"), LegacyVMCustodianEnum.class, (Object)this.getLegacyVMCustodian(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legacyNamedEntity"), processor, LegalEntity.class, this.getLegacyNamedEntity(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("additionalLanguage"), String.class, (Object)this.getAdditionalLanguage(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CustodianElectionBuilderImpl
    implements CustodianElectionBuilder {
        protected CounterpartyRoleEnum party;
        protected LegalEntity.LegalEntityBuilder custodian;
        protected Account.AccountBuilder segregatedCashAccount;
        protected Account.AccountBuilder segregatedSecurityAccount;
        protected LegacyVMCustodianEnum legacyVMCustodian;
        protected LegalEntity.LegalEntityBuilder legacyNamedEntity;
        protected String additionalLanguage;

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="custodian")
        @RuneAttribute(value="custodian")
        public LegalEntity.LegalEntityBuilder getCustodian() {
            return this.custodian;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateCustodian() {
            LegalEntity.LegalEntityBuilder result = this.custodian != null ? this.custodian : (this.custodian = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="segregatedCashAccount")
        @RuneAttribute(value="segregatedCashAccount")
        public Account.AccountBuilder getSegregatedCashAccount() {
            return this.segregatedCashAccount;
        }

        @Override
        public Account.AccountBuilder getOrCreateSegregatedCashAccount() {
            Account.AccountBuilder result = this.segregatedCashAccount != null ? this.segregatedCashAccount : (this.segregatedCashAccount = Account.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="segregatedSecurityAccount")
        @RuneAttribute(value="segregatedSecurityAccount")
        public Account.AccountBuilder getSegregatedSecurityAccount() {
            return this.segregatedSecurityAccount;
        }

        @Override
        public Account.AccountBuilder getOrCreateSegregatedSecurityAccount() {
            Account.AccountBuilder result = this.segregatedSecurityAccount != null ? this.segregatedSecurityAccount : (this.segregatedSecurityAccount = Account.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="legacyVMCustodian")
        @RuneAttribute(value="legacyVMCustodian")
        public LegacyVMCustodianEnum getLegacyVMCustodian() {
            return this.legacyVMCustodian;
        }

        @Override
        @RosettaAttribute(value="legacyNamedEntity")
        @RuneAttribute(value="legacyNamedEntity")
        public LegalEntity.LegalEntityBuilder getLegacyNamedEntity() {
            return this.legacyNamedEntity;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateLegacyNamedEntity() {
            LegalEntity.LegalEntityBuilder result = this.legacyNamedEntity != null ? this.legacyNamedEntity : (this.legacyNamedEntity = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="additionalLanguage")
        @RuneAttribute(value="additionalLanguage")
        public String getAdditionalLanguage() {
            return this.additionalLanguage;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CustodianElectionBuilder setParty(CounterpartyRoleEnum _party) {
            this.party = _party == null ? null : _party;
            return this;
        }

        @Override
        @RosettaAttribute(value="custodian")
        @RuneAttribute(value="custodian")
        public CustodianElectionBuilder setCustodian(LegalEntity _custodian) {
            this.custodian = _custodian == null ? null : _custodian.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="segregatedCashAccount")
        @RuneAttribute(value="segregatedCashAccount")
        public CustodianElectionBuilder setSegregatedCashAccount(Account _segregatedCashAccount) {
            this.segregatedCashAccount = _segregatedCashAccount == null ? null : _segregatedCashAccount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="segregatedSecurityAccount")
        @RuneAttribute(value="segregatedSecurityAccount")
        public CustodianElectionBuilder setSegregatedSecurityAccount(Account _segregatedSecurityAccount) {
            this.segregatedSecurityAccount = _segregatedSecurityAccount == null ? null : _segregatedSecurityAccount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legacyVMCustodian")
        @RuneAttribute(value="legacyVMCustodian")
        public CustodianElectionBuilder setLegacyVMCustodian(LegacyVMCustodianEnum _legacyVMCustodian) {
            this.legacyVMCustodian = _legacyVMCustodian == null ? null : _legacyVMCustodian;
            return this;
        }

        @Override
        @RosettaAttribute(value="legacyNamedEntity")
        @RuneAttribute(value="legacyNamedEntity")
        public CustodianElectionBuilder setLegacyNamedEntity(LegalEntity _legacyNamedEntity) {
            this.legacyNamedEntity = _legacyNamedEntity == null ? null : _legacyNamedEntity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalLanguage")
        @RuneAttribute(value="additionalLanguage")
        public CustodianElectionBuilder setAdditionalLanguage(String _additionalLanguage) {
            this.additionalLanguage = _additionalLanguage == null ? null : _additionalLanguage;
            return this;
        }

        @Override
        public CustodianElection build() {
            return new CustodianElectionImpl(this);
        }

        @Override
        public CustodianElectionBuilder toBuilder() {
            return this;
        }

        @Override
        public CustodianElectionBuilder prune() {
            if (this.custodian != null && !this.custodian.prune().hasData()) {
                this.custodian = null;
            }
            if (this.segregatedCashAccount != null && !this.segregatedCashAccount.prune().hasData()) {
                this.segregatedCashAccount = null;
            }
            if (this.segregatedSecurityAccount != null && !this.segregatedSecurityAccount.prune().hasData()) {
                this.segregatedSecurityAccount = null;
            }
            if (this.legacyNamedEntity != null && !this.legacyNamedEntity.prune().hasData()) {
                this.legacyNamedEntity = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getParty() != null) {
                return true;
            }
            if (this.getCustodian() != null && this.getCustodian().hasData()) {
                return true;
            }
            if (this.getSegregatedCashAccount() != null && this.getSegregatedCashAccount().hasData()) {
                return true;
            }
            if (this.getSegregatedSecurityAccount() != null && this.getSegregatedSecurityAccount().hasData()) {
                return true;
            }
            if (this.getLegacyVMCustodian() != null) {
                return true;
            }
            if (this.getLegacyNamedEntity() != null && this.getLegacyNamedEntity().hasData()) {
                return true;
            }
            return this.getAdditionalLanguage() != null;
        }

        public CustodianElectionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CustodianElectionBuilder o = (CustodianElectionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCustodian(), (RosettaModelObjectBuilder)o.getCustodian(), this::setCustodian);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSegregatedCashAccount(), (RosettaModelObjectBuilder)o.getSegregatedCashAccount(), this::setSegregatedCashAccount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSegregatedSecurityAccount(), (RosettaModelObjectBuilder)o.getSegregatedSecurityAccount(), this::setSegregatedSecurityAccount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegacyNamedEntity(), (RosettaModelObjectBuilder)o.getLegacyNamedEntity(), this::setLegacyNamedEntity);
            merger.mergeBasic((Object)this.getParty(), (Object)o.getParty(), this::setParty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLegacyVMCustodian(), (Object)o.getLegacyVMCustodian(), this::setLegacyVMCustodian, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdditionalLanguage(), (Object)o.getAdditionalLanguage(), this::setAdditionalLanguage, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CustodianElection _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!Objects.equals(this.custodian, _that.getCustodian())) {
                return false;
            }
            if (!Objects.equals(this.segregatedCashAccount, _that.getSegregatedCashAccount())) {
                return false;
            }
            if (!Objects.equals(this.segregatedSecurityAccount, _that.getSegregatedSecurityAccount())) {
                return false;
            }
            if (!Objects.equals((Object)this.legacyVMCustodian, (Object)_that.getLegacyVMCustodian())) {
                return false;
            }
            if (!Objects.equals(this.legacyNamedEntity, _that.getLegacyNamedEntity())) {
                return false;
            }
            return Objects.equals(this.additionalLanguage, _that.getAdditionalLanguage());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.custodian != null ? this.custodian.hashCode() : 0);
            _result = 31 * _result + (this.segregatedCashAccount != null ? this.segregatedCashAccount.hashCode() : 0);
            _result = 31 * _result + (this.segregatedSecurityAccount != null ? this.segregatedSecurityAccount.hashCode() : 0);
            _result = 31 * _result + (this.legacyVMCustodian != null ? ((Object)((Object)this.legacyVMCustodian)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.legacyNamedEntity != null ? this.legacyNamedEntity.hashCode() : 0);
            _result = 31 * _result + (this.additionalLanguage != null ? this.additionalLanguage.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CustodianElectionBuilder {party=" + (Object)((Object)this.party) + ", custodian=" + this.custodian + ", segregatedCashAccount=" + this.segregatedCashAccount + ", segregatedSecurityAccount=" + this.segregatedSecurityAccount + ", legacyVMCustodian=" + (Object)((Object)this.legacyVMCustodian) + ", legacyNamedEntity=" + this.legacyNamedEntity + ", additionalLanguage=" + this.additionalLanguage + '}';
        }
    }

    public static interface CustodianElectionBuilder
    extends CustodianElection,
    RosettaModelObjectBuilder {
        public LegalEntity.LegalEntityBuilder getOrCreateCustodian();

        @Override
        public LegalEntity.LegalEntityBuilder getCustodian();

        public Account.AccountBuilder getOrCreateSegregatedCashAccount();

        @Override
        public Account.AccountBuilder getSegregatedCashAccount();

        public Account.AccountBuilder getOrCreateSegregatedSecurityAccount();

        @Override
        public Account.AccountBuilder getSegregatedSecurityAccount();

        public LegalEntity.LegalEntityBuilder getOrCreateLegacyNamedEntity();

        @Override
        public LegalEntity.LegalEntityBuilder getLegacyNamedEntity();

        public CustodianElectionBuilder setParty(CounterpartyRoleEnum var1);

        public CustodianElectionBuilder setCustodian(LegalEntity var1);

        public CustodianElectionBuilder setSegregatedCashAccount(Account var1);

        public CustodianElectionBuilder setSegregatedSecurityAccount(Account var1);

        public CustodianElectionBuilder setLegacyVMCustodian(LegacyVMCustodianEnum var1);

        public CustodianElectionBuilder setLegacyNamedEntity(LegalEntity var1);

        public CustodianElectionBuilder setAdditionalLanguage(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("custodian"), processor, LegalEntity.LegalEntityBuilder.class, this.getCustodian(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("segregatedCashAccount"), processor, Account.AccountBuilder.class, this.getSegregatedCashAccount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("segregatedSecurityAccount"), processor, Account.AccountBuilder.class, this.getSegregatedSecurityAccount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("legacyVMCustodian"), LegacyVMCustodianEnum.class, (Object)this.getLegacyVMCustodian(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legacyNamedEntity"), processor, LegalEntity.LegalEntityBuilder.class, this.getLegacyNamedEntity(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("additionalLanguage"), String.class, (Object)this.getAdditionalLanguage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CustodianElectionBuilder prune();
    }

    public static class CustodianElectionImpl
    implements CustodianElection {
        private final CounterpartyRoleEnum party;
        private final LegalEntity custodian;
        private final Account segregatedCashAccount;
        private final Account segregatedSecurityAccount;
        private final LegacyVMCustodianEnum legacyVMCustodian;
        private final LegalEntity legacyNamedEntity;
        private final String additionalLanguage;

        protected CustodianElectionImpl(CustodianElectionBuilder builder) {
            this.party = builder.getParty();
            this.custodian = Optional.ofNullable(builder.getCustodian()).map(f -> f.build()).orElse(null);
            this.segregatedCashAccount = Optional.ofNullable(builder.getSegregatedCashAccount()).map(f -> f.build()).orElse(null);
            this.segregatedSecurityAccount = Optional.ofNullable(builder.getSegregatedSecurityAccount()).map(f -> f.build()).orElse(null);
            this.legacyVMCustodian = builder.getLegacyVMCustodian();
            this.legacyNamedEntity = Optional.ofNullable(builder.getLegacyNamedEntity()).map(f -> f.build()).orElse(null);
            this.additionalLanguage = builder.getAdditionalLanguage();
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="custodian")
        @RuneAttribute(value="custodian")
        public LegalEntity getCustodian() {
            return this.custodian;
        }

        @Override
        @RosettaAttribute(value="segregatedCashAccount")
        @RuneAttribute(value="segregatedCashAccount")
        public Account getSegregatedCashAccount() {
            return this.segregatedCashAccount;
        }

        @Override
        @RosettaAttribute(value="segregatedSecurityAccount")
        @RuneAttribute(value="segregatedSecurityAccount")
        public Account getSegregatedSecurityAccount() {
            return this.segregatedSecurityAccount;
        }

        @Override
        @RosettaAttribute(value="legacyVMCustodian")
        @RuneAttribute(value="legacyVMCustodian")
        public LegacyVMCustodianEnum getLegacyVMCustodian() {
            return this.legacyVMCustodian;
        }

        @Override
        @RosettaAttribute(value="legacyNamedEntity")
        @RuneAttribute(value="legacyNamedEntity")
        public LegalEntity getLegacyNamedEntity() {
            return this.legacyNamedEntity;
        }

        @Override
        @RosettaAttribute(value="additionalLanguage")
        @RuneAttribute(value="additionalLanguage")
        public String getAdditionalLanguage() {
            return this.additionalLanguage;
        }

        @Override
        public CustodianElection build() {
            return this;
        }

        @Override
        public CustodianElectionBuilder toBuilder() {
            CustodianElectionBuilder builder = CustodianElection.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CustodianElectionBuilder builder) {
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getCustodian()).ifPresent(builder::setCustodian);
            Optional.ofNullable(this.getSegregatedCashAccount()).ifPresent(builder::setSegregatedCashAccount);
            Optional.ofNullable(this.getSegregatedSecurityAccount()).ifPresent(builder::setSegregatedSecurityAccount);
            Optional.ofNullable(this.getLegacyVMCustodian()).ifPresent(builder::setLegacyVMCustodian);
            Optional.ofNullable(this.getLegacyNamedEntity()).ifPresent(builder::setLegacyNamedEntity);
            Optional.ofNullable(this.getAdditionalLanguage()).ifPresent(builder::setAdditionalLanguage);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CustodianElection _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!Objects.equals(this.custodian, _that.getCustodian())) {
                return false;
            }
            if (!Objects.equals(this.segregatedCashAccount, _that.getSegregatedCashAccount())) {
                return false;
            }
            if (!Objects.equals(this.segregatedSecurityAccount, _that.getSegregatedSecurityAccount())) {
                return false;
            }
            if (!Objects.equals((Object)this.legacyVMCustodian, (Object)_that.getLegacyVMCustodian())) {
                return false;
            }
            if (!Objects.equals(this.legacyNamedEntity, _that.getLegacyNamedEntity())) {
                return false;
            }
            return Objects.equals(this.additionalLanguage, _that.getAdditionalLanguage());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.custodian != null ? this.custodian.hashCode() : 0);
            _result = 31 * _result + (this.segregatedCashAccount != null ? this.segregatedCashAccount.hashCode() : 0);
            _result = 31 * _result + (this.segregatedSecurityAccount != null ? this.segregatedSecurityAccount.hashCode() : 0);
            _result = 31 * _result + (this.legacyVMCustodian != null ? ((Object)((Object)this.legacyVMCustodian)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.legacyNamedEntity != null ? this.legacyNamedEntity.hashCode() : 0);
            _result = 31 * _result + (this.additionalLanguage != null ? this.additionalLanguage.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CustodianElection {party=" + (Object)((Object)this.party) + ", custodian=" + this.custodian + ", segregatedCashAccount=" + this.segregatedCashAccount + ", segregatedSecurityAccount=" + this.segregatedSecurityAccount + ", legacyVMCustodian=" + (Object)((Object)this.legacyVMCustodian) + ", legacyNamedEntity=" + this.legacyNamedEntity + ", additionalLanguage=" + this.additionalLanguage + '}';
        }
    }
}

