/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.settlement.functions;

import cdm.ingest.fpml.confirmation.common.functions.MapCurrency;
import cdm.ingest.fpml.confirmation.common.functions.MapStringWithScheme;
import cdm.ingest.fpml.confirmation.datetime.functions.MapFxFixingDate;
import cdm.observable.asset.SettlementRateOption;
import cdm.observable.asset.SettlementRateOptionEnum;
import cdm.observable.asset.ValuationMethod;
import cdm.observable.asset.ValuationSource;
import cdm.product.common.settlement.CashSettlementTerms;
import cdm.product.common.settlement.FxFixingDate;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.SettlementTypeEnum;
import cdm.product.common.settlement.ValuationDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import fpml.consolidated.ird.PaymentDates;
import fpml.consolidated.ird.SettlementProvision;
import fpml.consolidated.shared.Currency;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapSettlementProvisionToSettlementTermsDefault.class)
public abstract class MapSettlementProvisionToSettlementTerms
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapCurrency mapCurrency;
    @Inject
    protected MapFxFixingDate mapFxFixingDate;
    @Inject
    protected MapStringWithScheme mapStringWithScheme;

    public SettlementTerms evaluate(SettlementProvision settlementProvision, PaymentDates paymentDates) {
        SettlementTerms settlementTerms;
        SettlementTerms.SettlementTermsBuilder settlementTermsBuilder = this.doEvaluate(settlementProvision, paymentDates);
        if (settlementTermsBuilder == null) {
            settlementTerms = null;
        } else {
            settlementTerms = settlementTermsBuilder.build();
            this.objectValidator.validate(SettlementTerms.class, (RosettaModelObject)settlementTerms);
        }
        return settlementTerms;
    }

    protected abstract SettlementTerms.SettlementTermsBuilder doEvaluate(SettlementProvision var1, PaymentDates var2);

    protected abstract MapperS<SettlementTypeEnum> settlementType(SettlementProvision var1, PaymentDates var2);

    public static class MapSettlementProvisionToSettlementTermsDefault
    extends MapSettlementProvisionToSettlementTerms {
        @Override
        protected SettlementTerms.SettlementTermsBuilder doEvaluate(SettlementProvision settlementProvision, PaymentDates paymentDates) {
            SettlementTerms.SettlementTermsBuilder settlementTerms = SettlementTerms.builder();
            return this.assignOutput(settlementTerms, settlementProvision, paymentDates);
        }

        protected SettlementTerms.SettlementTermsBuilder assignOutput(SettlementTerms.SettlementTermsBuilder settlementTerms, SettlementProvision settlementProvision, PaymentDates paymentDates) {
            FieldWithMetaString fieldWithMetaString = this.mapStringWithScheme.evaluate((String)MapperS.of((Object)settlementProvision).map("getNonDeliverableSettlement", _settlementProvision -> _settlementProvision.getNonDeliverableSettlement()).map("getSettlementRateOption", nonDeliverableSettlement -> nonDeliverableSettlement.getSettlementRateOption()).map("getValue", settlementRateOption -> settlementRateOption.getValue()).get(), (String)MapperS.of((Object)settlementProvision).map("getNonDeliverableSettlement", _settlementProvision -> _settlementProvision.getNonDeliverableSettlement()).map("getSettlementRateOption", nonDeliverableSettlement -> nonDeliverableSettlement.getSettlementRateOption()).map("getSettlementRateOptionScheme", settlementRateOption -> settlementRateOption.getSettlementRateOptionScheme()).get());
            FxFixingDate ifThenElseResult = null;
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)settlementProvision).map("getNonDeliverableSettlement", _settlementProvision -> _settlementProvision.getNonDeliverableSettlement()).map("getFxFixingDate", nonDeliverableSettlement -> nonDeliverableSettlement.getFxFixingDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult = this.mapFxFixingDate.evaluate((fpml.consolidated.ird.FxFixingDate)MapperS.of((Object)settlementProvision).map("getNonDeliverableSettlement", _settlementProvision -> _settlementProvision.getNonDeliverableSettlement()).map("getFxFixingDate", nonDeliverableSettlement -> nonDeliverableSettlement.getFxFixingDate()).get(), paymentDates);
            }
            CashSettlementTerms cashSettlementTerms = CashSettlementTerms.builder().setValuationMethod(ValuationMethod.builder().setValuationSource(ValuationSource.builder().setSettlementRateOption(SettlementRateOption.builder().setSettlementRateOptionValue((SettlementRateOptionEnum)((Object)(fieldWithMetaString == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaString.getValue())).checkedMap("to-enum", SettlementRateOptionEnum::fromDisplayName, IllegalArgumentException.class).get())).build()).build()).build()).setValuationDate(ValuationDate.builder().setFxFixingDate(ifThenElseResult).build()).build();
            settlementTerms = (SettlementTerms.SettlementTermsBuilder)this.toBuilder(SettlementTerms.builder().setSettlementType((SettlementTypeEnum)((Object)this.settlementType(settlementProvision, paymentDates).get())).setSettlementCurrency(this.mapCurrency.evaluate((Currency)MapperS.of((Object)settlementProvision).map("getSettlementCurrency", _settlementProvision -> _settlementProvision.getSettlementCurrency()).get())).setCashSettlementTerms(cashSettlementTerms == null ? Collections.emptyList() : Collections.singletonList(cashSettlementTerms)).build());
            return Optional.ofNullable(settlementTerms).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<SettlementTypeEnum> settlementType(SettlementProvision settlementProvision, PaymentDates paymentDates) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)settlementProvision).map("getNonDeliverableSettlement", _settlementProvision -> _settlementProvision.getNonDeliverableSettlement())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((Object)SettlementTypeEnum.CASH));
            }
            return MapperS.ofNull();
        }
    }
}

