/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.capfloor.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.ingest.fpml.confirmation.product.swap.functions.MapSwapPayout;
import cdm.ingest.fpml.confirmation.product.swap.functions.MapTerminationProvision;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.ird.CapFloor;
import fpml.consolidated.ird.EarlyTerminationProvision;
import fpml.consolidated.ird.InterestRateStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapCapFloorEconomicTermsDefault.class)
public abstract class MapCapFloorEconomicTerms
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapSwapPayout mapSwapPayout;
    @Inject
    protected MapTerminationProvision mapTerminationProvision;

    public EconomicTerms evaluate(CapFloor fpmlCapFloor, List<? extends Counterparty> cdmCounterpartyList) {
        EconomicTerms economicTerms;
        EconomicTerms.EconomicTermsBuilder economicTermsBuilder = this.doEvaluate(fpmlCapFloor, cdmCounterpartyList);
        if (economicTermsBuilder == null) {
            economicTerms = null;
        } else {
            economicTerms = economicTermsBuilder.build();
            this.objectValidator.validate(EconomicTerms.class, (RosettaModelObject)economicTerms);
        }
        return economicTerms;
    }

    protected abstract EconomicTerms.EconomicTermsBuilder doEvaluate(CapFloor var1, List<? extends Counterparty> var2);

    public static class MapCapFloorEconomicTermsDefault
    extends MapCapFloorEconomicTerms {
        @Override
        protected EconomicTerms.EconomicTermsBuilder doEvaluate(CapFloor fpmlCapFloor, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            EconomicTerms.EconomicTermsBuilder economicTerms = EconomicTerms.builder();
            return this.assignOutput(economicTerms, fpmlCapFloor, cdmCounterpartyList);
        }

        protected EconomicTerms.EconomicTermsBuilder assignOutput(EconomicTerms.EconomicTermsBuilder economicTerms, CapFloor fpmlCapFloor, List<? extends Counterparty> cdmCounterpartyList) {
            Payout payout = this.mapSwapPayout.evaluate((InterestRateStream)MapperS.of((Object)fpmlCapFloor).map("getCapFloorStream", capFloor -> capFloor.getCapFloorStream()).get(), cdmCounterpartyList);
            economicTerms = (EconomicTerms.EconomicTermsBuilder)this.toBuilder(EconomicTerms.builder().setPayout(payout == null ? Collections.emptyList() : Collections.singletonList(payout)).setTerminationProvision(this.mapTerminationProvision.evaluate((EarlyTerminationProvision)MapperS.of((Object)fpmlCapFloor).map("getEarlyTerminationProvision", capFloor -> capFloor.getEarlyTerminationProvision()).get(), null, null, cdmCounterpartyList)).build());
            return Optional.ofNullable(economicTerms).map(o -> o.prune()).orElse(null);
        }
    }
}

