/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.UnitType;
import cdm.ingest.fpml.confirmation.common.functions.MapCurrency;
import cdm.ingest.fpml.confirmation.pricequantity.functions.CreatePriceKey;
import cdm.ingest.fpml.confirmation.pricequantity.functions.CreatePriceWithLocation;
import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.asset.ActualPrice;
import fpml.consolidated.asset.Price;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.Leg;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=MapNetPriceToPriceListWithLocationDefault.class)
public abstract class MapNetPriceToPriceListWithLocation
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CreatePriceKey createPriceKey;
    @Inject
    protected CreatePriceWithLocation createPriceWithLocation;
    @Inject
    protected MapCurrency mapCurrency;

    public List<? extends FieldWithMetaPriceSchedule> evaluate(Price fpmlPrice, Leg fpmlLeg) {
        List priceSchedules;
        List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> priceSchedulesBuilder = this.doEvaluate(fpmlPrice, fpmlLeg);
        if (priceSchedulesBuilder == null) {
            priceSchedules = null;
        } else {
            priceSchedules = priceSchedulesBuilder.stream().map(FieldWithMetaPriceSchedule::build).collect(Collectors.toList());
            this.objectValidator.validate(FieldWithMetaPriceSchedule.class, priceSchedules);
        }
        return priceSchedules;
    }

    protected abstract List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> doEvaluate(Price var1, Leg var2);

    protected abstract MapperS<? extends ActualPrice> fpmlNetPrice(Price var1, Leg var2);

    public static class MapNetPriceToPriceListWithLocationDefault
    extends MapNetPriceToPriceListWithLocation {
        @Override
        protected List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> doEvaluate(Price fpmlPrice, Leg fpmlLeg) {
            ArrayList<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> priceSchedules = new ArrayList<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder>();
            return this.assignOutput(priceSchedules, fpmlPrice, fpmlLeg);
        }

        protected List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> assignOutput(List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> priceSchedules, Price fpmlPrice, Leg fpmlLeg) {
            if (ExpressionOperators.exists(this.fpmlNetPrice(fpmlPrice, fpmlLeg)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                FieldWithMetaPriceSchedule fieldWithMetaPriceSchedule = this.createPriceWithLocation.evaluate(PriceSchedule.builder().setValue((BigDecimal)this.fpmlNetPrice(fpmlPrice, fpmlLeg).map("getAmount", actualPrice -> actualPrice.getAmount()).get()).setUnit(UnitType.builder().setCurrency(this.mapCurrency.evaluate((Currency)this.fpmlNetPrice(fpmlPrice, fpmlLeg).map("getCurrency", actualPrice -> actualPrice.getCurrency()).get())).build()).setPerUnitOf(UnitType.builder().setFinancialUnit(FinancialUnitEnum.SHARE).build()).setPriceExpression((PriceExpressionEnum)((Object)this.fpmlNetPrice(fpmlPrice, fpmlLeg).map("getPriceExpression", actualPrice -> actualPrice.getPriceExpression()).checkedMap("to-enum", e -> PriceExpressionEnum.valueOf(e.name()), IllegalArgumentException.class).get())).setPriceType(PriceTypeEnum.ASSET_PRICE).build(), this.createPriceKey.evaluate("netPrice", fpmlLeg));
                if (fieldWithMetaPriceSchedule == null) {
                    priceSchedules.addAll(this.toBuilder(Collections.emptyList()));
                } else {
                    priceSchedules.addAll(this.toBuilder(Collections.singletonList(fieldWithMetaPriceSchedule)));
                }
            } else {
                priceSchedules.addAll(this.toBuilder(Collections.emptyList()));
            }
            return Optional.ofNullable(priceSchedules).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends ActualPrice> fpmlNetPrice(Price fpmlPrice, Leg fpmlLeg) {
            return MapperS.of((Object)fpmlPrice).map("getEquityPriceModel", price -> price.getEquityPriceModel()).map("getNetPrice", equityPriceModel -> equityPriceModel.getNetPrice());
        }
    }
}

