/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.common.functions;

import cdm.base.datetime.metafields.FieldWithMetaFrequency;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapCommodityFrequencyWithSchemeDefault.class)
public abstract class MapCommodityFrequencyWithScheme
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public FieldWithMetaFrequency evaluate(String value, String scheme) {
        FieldWithMetaFrequency frequency;
        FieldWithMetaFrequency.FieldWithMetaFrequencyBuilder frequencyBuilder = this.doEvaluate(value, scheme);
        if (frequencyBuilder == null) {
            frequency = null;
        } else {
            frequency = frequencyBuilder.build();
            this.objectValidator.validate(FieldWithMetaFrequency.class, (RosettaModelObject)frequency);
        }
        return frequency;
    }

    protected abstract FieldWithMetaFrequency.FieldWithMetaFrequencyBuilder doEvaluate(String var1, String var2);

    public static class MapCommodityFrequencyWithSchemeDefault
    extends MapCommodityFrequencyWithScheme {
        @Override
        protected FieldWithMetaFrequency.FieldWithMetaFrequencyBuilder doEvaluate(String value, String scheme) {
            FieldWithMetaFrequency.FieldWithMetaFrequencyBuilder frequency = FieldWithMetaFrequency.builder();
            return this.assignOutput(frequency, value, scheme);
        }

        protected FieldWithMetaFrequency.FieldWithMetaFrequencyBuilder assignOutput(FieldWithMetaFrequency.FieldWithMetaFrequencyBuilder frequency, String value, String scheme) {
            frequency.getOrCreateMeta().setExternalKey(value);
            frequency.getOrCreateMeta().setScheme(scheme);
            return Optional.ofNullable(frequency).map(o -> o.prune()).orElse(null);
        }
    }
}

