/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.AssetType;
import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="AssetTypeFundSubType")
@ImplementedBy(value=Default.class)
public interface AssetTypeFundSubType
extends Validator<AssetType> {
    public static final String NAME = "AssetTypeFundSubType";
    public static final String DEFINITION = "if securityType <> InstrumentTypeEnum -> Fund then fundType is absent";

    public static class NoOp
    implements AssetTypeFundSubType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetType assetType) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements AssetTypeFundSubType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetType assetType) {
            ComparisonResult result = this.executeDataRule(assetType);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)AssetTypeFundSubType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetType", (RosettaPath)path, (String)AssetTypeFundSubType.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)AssetTypeFundSubType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetType", (RosettaPath)path, (String)AssetTypeFundSubType.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(AssetType assetType) {
            try {
                if (ExpressionOperators.notEqual((Mapper)MapperS.of((Object)assetType).map("getSecurityType", _assetType -> _assetType.getSecurityType()), (Mapper)MapperS.of((Object)((Object)InstrumentTypeEnum.FUND)), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)assetType).map("getFundType", _assetType -> _assetType.getFundType()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

