/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.ServiceNotification;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ServiceNotificationChoice")
@ImplementedBy(value=Default.class)
public interface ServiceNotificationChoice
extends Validator<ServiceNotification> {
    public static final String NAME = "ServiceNotificationChoice";
    public static final String DEFINITION = "required choice status, processingStatus , advisory";

    public static class NoOp
    implements ServiceNotificationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ServiceNotification serviceNotification) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ServiceNotificationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ServiceNotification serviceNotification) {
            ComparisonResult result = this.executeDataRule(serviceNotification);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ServiceNotificationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ServiceNotification", (RosettaPath)path, (String)ServiceNotificationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ServiceNotificationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ServiceNotification", (RosettaPath)path, (String)ServiceNotificationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ServiceNotification serviceNotification) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)serviceNotification), Arrays.asList("status", "processingStatus", "advisory"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

