/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.RoutingIdentificationModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="RoutingIdentificationModelChoice")
@ImplementedBy(value=Default.class)
public interface RoutingIdentificationModelChoice
extends Validator<RoutingIdentificationModel> {
    public static final String NAME = "RoutingIdentificationModelChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements RoutingIdentificationModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, RoutingIdentificationModel routingIdentificationModel) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements RoutingIdentificationModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, RoutingIdentificationModel routingIdentificationModel) {
            ComparisonResult result = this.executeDataRule(routingIdentificationModel);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)RoutingIdentificationModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"RoutingIdentificationModel", (RosettaPath)path, (String)RoutingIdentificationModelChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)RoutingIdentificationModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"RoutingIdentificationModel", (RosettaPath)path, (String)RoutingIdentificationModelChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(RoutingIdentificationModel routingIdentificationModel) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)routingIdentificationModel), Arrays.asList("routingIds", "routingExplicitDetails", "routingIdsAndExplicitDetails"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

