/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.PhysicalSettlement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PhysicalSettlementChoice")
@ImplementedBy(value=Default.class)
public interface PhysicalSettlementChoice
extends Validator<PhysicalSettlement> {
    public static final String NAME = "PhysicalSettlementChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements PhysicalSettlementChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PhysicalSettlement physicalSettlement) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PhysicalSettlementChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PhysicalSettlement physicalSettlement) {
            ComparisonResult result = this.executeDataRule(physicalSettlement);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PhysicalSettlementChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PhysicalSettlement", (RosettaPath)path, (String)PhysicalSettlementChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PhysicalSettlementChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PhysicalSettlement", (RosettaPath)path, (String)PhysicalSettlementChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PhysicalSettlement physicalSettlement) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)physicalSettlement), Arrays.asList("resultingTradeIdentifier", "resultingTrade", "product"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

