/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.PartyTradeIdentifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PartyTradeIdentifierChoice")
@ImplementedBy(value=Default.class)
public interface PartyTradeIdentifierChoice
extends Validator<PartyTradeIdentifier> {
    public static final String NAME = "PartyTradeIdentifierChoice";
    public static final String DEFINITION = "required choice allocationTradeId, resultingTradeId";

    public static class NoOp
    implements PartyTradeIdentifierChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PartyTradeIdentifier partyTradeIdentifier) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PartyTradeIdentifierChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PartyTradeIdentifier partyTradeIdentifier) {
            ComparisonResult result = this.executeDataRule(partyTradeIdentifier);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PartyTradeIdentifierChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PartyTradeIdentifier", (RosettaPath)path, (String)PartyTradeIdentifierChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PartyTradeIdentifierChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PartyTradeIdentifier", (RosettaPath)path, (String)PartyTradeIdentifierChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PartyTradeIdentifier partyTradeIdentifier) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)partyTradeIdentifier), Arrays.asList("allocationTradeId", "resultingTradeId"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

