/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.Mortgage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MortgageChoice")
@ImplementedBy(value=Default.class)
public interface MortgageChoice
extends Validator<Mortgage> {
    public static final String NAME = "MortgageChoice";
    public static final String DEFINITION = "optional choice insurer, insurerReference";

    public static class NoOp
    implements MortgageChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Mortgage mortgage) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MortgageChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Mortgage mortgage) {
            ComparisonResult result = this.executeDataRule(mortgage);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MortgageChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Mortgage", (RosettaPath)path, (String)MortgageChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MortgageChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Mortgage", (RosettaPath)path, (String)MortgageChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Mortgage mortgage) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)mortgage), Arrays.asList("insurer", "insurerReference"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

