/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.LoanContract;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="LoanContractChoice")
@ImplementedBy(value=Default.class)
public interface LoanContractChoice
extends Validator<LoanContract> {
    public static final String NAME = "LoanContractChoice";
    public static final String DEFINITION = "required choice fixedRateAccrual, floatingRateAccrual , legacyFloatingRateAccrual";

    public static class NoOp
    implements LoanContractChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LoanContract loanContract) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements LoanContractChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LoanContract loanContract) {
            ComparisonResult result = this.executeDataRule(loanContract);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)LoanContractChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LoanContract", (RosettaPath)path, (String)LoanContractChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)LoanContractChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LoanContract", (RosettaPath)path, (String)LoanContractChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(LoanContract loanContract) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)loanContract), Arrays.asList("fixedRateAccrual", "floatingRateAccrual", "legacyFloatingRateAccrual"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

