/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.ContractIdentifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ContractIdentifierChoice")
@ImplementedBy(value=Default.class)
public interface ContractIdentifierChoice
extends Validator<ContractIdentifier> {
    public static final String NAME = "ContractIdentifierChoice";
    public static final String DEFINITION = "required choice contractId, versionedContractId";

    public static class NoOp
    implements ContractIdentifierChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ContractIdentifier contractIdentifier) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ContractIdentifierChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ContractIdentifier contractIdentifier) {
            ComparisonResult result = this.executeDataRule(contractIdentifier);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ContractIdentifierChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ContractIdentifier", (RosettaPath)path, (String)ContractIdentifierChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ContractIdentifierChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ContractIdentifier", (RosettaPath)path, (String)ContractIdentifierChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ContractIdentifier contractIdentifier) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)contractIdentifier), Arrays.asList("contractId", "versionedContractId"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

