/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.CompressionActivity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CompressionActivityChoice")
@ImplementedBy(value=Default.class)
public interface CompressionActivityChoice
extends Validator<CompressionActivity> {
    public static final String NAME = "CompressionActivityChoice";
    public static final String DEFINITION = "required choice compressionActivitySequence0, compressionActivitySequence1";

    public static class NoOp
    implements CompressionActivityChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CompressionActivity compressionActivity) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CompressionActivityChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CompressionActivity compressionActivity) {
            ComparisonResult result = this.executeDataRule(compressionActivity);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CompressionActivityChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CompressionActivity", (RosettaPath)path, (String)CompressionActivityChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CompressionActivityChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CompressionActivity", (RosettaPath)path, (String)CompressionActivityChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CompressionActivity compressionActivity) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)compressionActivity), Arrays.asList("compressionActivitySequence0", "compressionActivitySequence1"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

