/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.CompoundingRate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CompoundingRateChoice")
@ImplementedBy(value=Default.class)
public interface CompoundingRateChoice
extends Validator<CompoundingRate> {
    public static final String NAME = "CompoundingRateChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements CompoundingRateChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CompoundingRate compoundingRate) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CompoundingRateChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CompoundingRate compoundingRate) {
            ComparisonResult result = this.executeDataRule(compoundingRate);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CompoundingRateChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CompoundingRate", (RosettaPath)path, (String)CompoundingRateChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CompoundingRateChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CompoundingRate", (RosettaPath)path, (String)CompoundingRateChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CompoundingRate compoundingRate) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)compoundingRate), Arrays.asList("interestLegRate", "specificRate"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

