/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.BondOptionStrike;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="BondOptionStrikeChoice")
@ImplementedBy(value=Default.class)
public interface BondOptionStrikeChoice
extends Validator<BondOptionStrike> {
    public static final String NAME = "BondOptionStrikeChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements BondOptionStrikeChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BondOptionStrike bondOptionStrike) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements BondOptionStrikeChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BondOptionStrike bondOptionStrike) {
            ComparisonResult result = this.executeDataRule(bondOptionStrike);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)BondOptionStrikeChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BondOptionStrike", (RosettaPath)path, (String)BondOptionStrikeChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)BondOptionStrikeChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BondOptionStrike", (RosettaPath)path, (String)BondOptionStrikeChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(BondOptionStrike bondOptionStrike) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)bondOptionStrike), Arrays.asList("referenceSwapCurve", "price"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

