/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.custom.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.custom.LegChoice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="LegChoiceChoice")
@ImplementedBy(value=Default.class)
public interface LegChoiceChoice
extends Validator<LegChoice> {
    public static final String NAME = "LegChoiceChoice";
    public static final String DEFINITION = "";

    public static class NoOp
    implements LegChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegChoice legChoice) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements LegChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegChoice legChoice) {
            ComparisonResult result = this.executeDataRule(legChoice);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)LegChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegChoice", (RosettaPath)path, (String)LegChoiceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == LegChoiceChoice.DEFINITION) {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)LegChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegChoice", (RosettaPath)path, (String)LegChoiceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(LegChoice legChoice) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)legChoice), Arrays.asList("RepoNearLeg", "RepoFarLeg", "ReturnLeg", "InterestLeg", "FixedPaymentLeg", "UnderlyerInterestLeg", "DividendLeg", "VolatilityLeg", "CorrelationLeg", "VarianceLeg", "FeeLeg", "FxSwapLeg", "InterestRateStream", "AveragePriceLeg", "FixedLeg", "WeatherLeg", "FloatingLeg", "NonPeriodicFixedPriceLeg", "MetalPhysicalLeg", "BullionPhysicalLeg", "GasPhysicalLeg", "OilPhysicalLeg", "ElectricityPhysicalLeg", "EnvironmentalPhysicalLeg", "CoalPhysicalLeg", "CommodityVarianceLeg", "CommodityInterestLeg", "CommodityReturnLeg"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

