/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.ReportingRegimeIdentifier;
import fpml.confirmation.RequestedWithdrawalAction;
import fpml.confirmation.Trade;
import fpml.confirmation.WithdrawalReason;
import fpml.confirmation.WithdrawalSequence;
import fpml.confirmation.meta.WithdrawalMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Withdrawal", builder=WithdrawalBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Withdrawal", model="fpml", builder=WithdrawalBuilderImpl.class, version="0.17.2")
public interface Withdrawal
extends RosettaModelObject {
    public static final WithdrawalMeta metaData = new WithdrawalMeta();

    public WithdrawalSequence getWithdrawalSequence();

    public Trade getTrade();

    public ZonedDateTime getEffectiveDate();

    public RequestedWithdrawalAction getRequestedAction();

    public List<? extends WithdrawalReason> getReason();

    public List<? extends ReportingRegimeIdentifier> getReportingRegime();

    public Withdrawal build();

    public WithdrawalBuilder toBuilder();

    public static WithdrawalBuilder builder() {
        return new WithdrawalBuilderImpl();
    }

    default public RosettaMetaData<? extends Withdrawal> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Withdrawal> getType() {
        return Withdrawal.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("withdrawalSequence"), processor, WithdrawalSequence.class, this.getWithdrawalSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trade"), processor, Trade.class, this.getTrade(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("requestedAction"), processor, RequestedWithdrawalAction.class, this.getRequestedAction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reason"), processor, WithdrawalReason.class, this.getReason(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingRegime"), processor, ReportingRegimeIdentifier.class, this.getReportingRegime(), new AttributeMeta[0]);
    }

    public static class WithdrawalBuilderImpl
    implements WithdrawalBuilder {
        protected WithdrawalSequence.WithdrawalSequenceBuilder withdrawalSequence;
        protected Trade.TradeBuilder trade;
        protected ZonedDateTime effectiveDate;
        protected RequestedWithdrawalAction.RequestedWithdrawalActionBuilder requestedAction;
        protected List<WithdrawalReason.WithdrawalReasonBuilder> reason = new ArrayList<WithdrawalReason.WithdrawalReasonBuilder>();
        protected List<ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder> reportingRegime = new ArrayList<ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder>();

        @Override
        @RosettaAttribute(value="withdrawalSequence")
        @RuneAttribute(value="withdrawalSequence")
        public WithdrawalSequence.WithdrawalSequenceBuilder getWithdrawalSequence() {
            return this.withdrawalSequence;
        }

        @Override
        public WithdrawalSequence.WithdrawalSequenceBuilder getOrCreateWithdrawalSequence() {
            WithdrawalSequence.WithdrawalSequenceBuilder result = this.withdrawalSequence != null ? this.withdrawalSequence : (this.withdrawalSequence = WithdrawalSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public Trade.TradeBuilder getTrade() {
            return this.trade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateTrade() {
            Trade.TradeBuilder result = this.trade != null ? this.trade : (this.trade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="requestedAction")
        @RuneAttribute(value="requestedAction")
        public RequestedWithdrawalAction.RequestedWithdrawalActionBuilder getRequestedAction() {
            return this.requestedAction;
        }

        @Override
        public RequestedWithdrawalAction.RequestedWithdrawalActionBuilder getOrCreateRequestedAction() {
            RequestedWithdrawalAction.RequestedWithdrawalActionBuilder result = this.requestedAction != null ? this.requestedAction : (this.requestedAction = RequestedWithdrawalAction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends WithdrawalReason.WithdrawalReasonBuilder> getReason() {
            return this.reason;
        }

        @Override
        public WithdrawalReason.WithdrawalReasonBuilder getOrCreateReason(int index) {
            if (this.reason == null) {
                this.reason = new ArrayList<WithdrawalReason.WithdrawalReasonBuilder>();
            }
            return (WithdrawalReason.WithdrawalReasonBuilder)this.getIndex(this.reason, index, () -> {
                WithdrawalReason.WithdrawalReasonBuilder newReason = WithdrawalReason.builder();
                return newReason;
            });
        }

        @Override
        @RosettaAttribute(value="reportingRegime")
        @RuneAttribute(value="reportingRegime")
        public List<? extends ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder> getReportingRegime() {
            return this.reportingRegime;
        }

        @Override
        public ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder getOrCreateReportingRegime(int index) {
            if (this.reportingRegime == null) {
                this.reportingRegime = new ArrayList<ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder>();
            }
            return (ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder)this.getIndex(this.reportingRegime, index, () -> {
                ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder newReportingRegime = ReportingRegimeIdentifier.builder();
                return newReportingRegime;
            });
        }

        @Override
        @RosettaAttribute(value="withdrawalSequence")
        @RuneAttribute(value="withdrawalSequence")
        public WithdrawalBuilder setWithdrawalSequence(WithdrawalSequence _withdrawalSequence) {
            this.withdrawalSequence = _withdrawalSequence == null ? null : _withdrawalSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public WithdrawalBuilder setTrade(Trade _trade) {
            this.trade = _trade == null ? null : _trade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public WithdrawalBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="requestedAction")
        @RuneAttribute(value="requestedAction")
        public WithdrawalBuilder setRequestedAction(RequestedWithdrawalAction _requestedAction) {
            this.requestedAction = _requestedAction == null ? null : _requestedAction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public WithdrawalBuilder addReason(WithdrawalReason _reason) {
            if (_reason != null) {
                this.reason.add(_reason.toBuilder());
            }
            return this;
        }

        @Override
        public WithdrawalBuilder addReason(WithdrawalReason _reason, int idx) {
            this.getIndex(this.reason, idx, () -> _reason.toBuilder());
            return this;
        }

        @Override
        public WithdrawalBuilder addReason(List<? extends WithdrawalReason> reasons) {
            if (reasons != null) {
                for (WithdrawalReason withdrawalReason : reasons) {
                    this.reason.add(withdrawalReason.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reason")
        public WithdrawalBuilder setReason(List<? extends WithdrawalReason> reasons) {
            this.reason = reasons == null ? new ArrayList<WithdrawalReason.WithdrawalReasonBuilder>() : (List)reasons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingRegime")
        @RuneAttribute(value="reportingRegime")
        public WithdrawalBuilder addReportingRegime(ReportingRegimeIdentifier _reportingRegime) {
            if (_reportingRegime != null) {
                this.reportingRegime.add(_reportingRegime.toBuilder());
            }
            return this;
        }

        @Override
        public WithdrawalBuilder addReportingRegime(ReportingRegimeIdentifier _reportingRegime, int idx) {
            this.getIndex(this.reportingRegime, idx, () -> _reportingRegime.toBuilder());
            return this;
        }

        @Override
        public WithdrawalBuilder addReportingRegime(List<? extends ReportingRegimeIdentifier> reportingRegimes) {
            if (reportingRegimes != null) {
                for (ReportingRegimeIdentifier reportingRegimeIdentifier : reportingRegimes) {
                    this.reportingRegime.add(reportingRegimeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reportingRegime")
        public WithdrawalBuilder setReportingRegime(List<? extends ReportingRegimeIdentifier> reportingRegimes) {
            this.reportingRegime = reportingRegimes == null ? new ArrayList<ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder>() : (List)reportingRegimes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Withdrawal build() {
            return new WithdrawalImpl(this);
        }

        @Override
        public WithdrawalBuilder toBuilder() {
            return this;
        }

        @Override
        public WithdrawalBuilder prune() {
            if (this.withdrawalSequence != null && !this.withdrawalSequence.prune().hasData()) {
                this.withdrawalSequence = null;
            }
            if (this.trade != null && !this.trade.prune().hasData()) {
                this.trade = null;
            }
            if (this.requestedAction != null && !this.requestedAction.prune().hasData()) {
                this.requestedAction = null;
            }
            this.reason = this.reason.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.reportingRegime = this.reportingRegime.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getWithdrawalSequence() != null && this.getWithdrawalSequence().hasData()) {
                return true;
            }
            if (this.getTrade() != null && this.getTrade().hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getRequestedAction() != null && this.getRequestedAction().hasData()) {
                return true;
            }
            if (this.getReason() != null && this.getReason().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getReportingRegime() != null && this.getReportingRegime().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public WithdrawalBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            WithdrawalBuilder o = (WithdrawalBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getWithdrawalSequence(), (RosettaModelObjectBuilder)o.getWithdrawalSequence(), this::setWithdrawalSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTrade(), (RosettaModelObjectBuilder)o.getTrade(), this::setTrade);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRequestedAction(), (RosettaModelObjectBuilder)o.getRequestedAction(), this::setRequestedAction);
            merger.mergeRosetta(this.getReason(), o.getReason(), this::getOrCreateReason);
            merger.mergeRosetta(this.getReportingRegime(), o.getReportingRegime(), this::getOrCreateReportingRegime);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Withdrawal _that = this.getType().cast(o);
            if (!Objects.equals(this.withdrawalSequence, _that.getWithdrawalSequence())) {
                return false;
            }
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.requestedAction, _that.getRequestedAction())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reason, _that.getReason())) {
                return false;
            }
            return ListEquals.listEquals(this.reportingRegime, _that.getReportingRegime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.withdrawalSequence != null ? this.withdrawalSequence.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.requestedAction != null ? this.requestedAction.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            _result = 31 * _result + (this.reportingRegime != null ? this.reportingRegime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "WithdrawalBuilder {withdrawalSequence=" + this.withdrawalSequence + ", trade=" + this.trade + ", effectiveDate=" + this.effectiveDate + ", requestedAction=" + this.requestedAction + ", reason=" + this.reason + ", reportingRegime=" + this.reportingRegime + '}';
        }
    }

    public static interface WithdrawalBuilder
    extends Withdrawal,
    RosettaModelObjectBuilder {
        public WithdrawalSequence.WithdrawalSequenceBuilder getOrCreateWithdrawalSequence();

        @Override
        public WithdrawalSequence.WithdrawalSequenceBuilder getWithdrawalSequence();

        public Trade.TradeBuilder getOrCreateTrade();

        @Override
        public Trade.TradeBuilder getTrade();

        public RequestedWithdrawalAction.RequestedWithdrawalActionBuilder getOrCreateRequestedAction();

        @Override
        public RequestedWithdrawalAction.RequestedWithdrawalActionBuilder getRequestedAction();

        public WithdrawalReason.WithdrawalReasonBuilder getOrCreateReason(int var1);

        public List<? extends WithdrawalReason.WithdrawalReasonBuilder> getReason();

        public ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder getOrCreateReportingRegime(int var1);

        public List<? extends ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder> getReportingRegime();

        public WithdrawalBuilder setWithdrawalSequence(WithdrawalSequence var1);

        public WithdrawalBuilder setTrade(Trade var1);

        public WithdrawalBuilder setEffectiveDate(ZonedDateTime var1);

        public WithdrawalBuilder setRequestedAction(RequestedWithdrawalAction var1);

        public WithdrawalBuilder addReason(WithdrawalReason var1);

        public WithdrawalBuilder addReason(WithdrawalReason var1, int var2);

        public WithdrawalBuilder addReason(List<? extends WithdrawalReason> var1);

        public WithdrawalBuilder setReason(List<? extends WithdrawalReason> var1);

        public WithdrawalBuilder addReportingRegime(ReportingRegimeIdentifier var1);

        public WithdrawalBuilder addReportingRegime(ReportingRegimeIdentifier var1, int var2);

        public WithdrawalBuilder addReportingRegime(List<? extends ReportingRegimeIdentifier> var1);

        public WithdrawalBuilder setReportingRegime(List<? extends ReportingRegimeIdentifier> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("withdrawalSequence"), processor, WithdrawalSequence.WithdrawalSequenceBuilder.class, this.getWithdrawalSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trade"), processor, Trade.TradeBuilder.class, this.getTrade(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("requestedAction"), processor, RequestedWithdrawalAction.RequestedWithdrawalActionBuilder.class, this.getRequestedAction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reason"), processor, WithdrawalReason.WithdrawalReasonBuilder.class, this.getReason(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingRegime"), processor, ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder.class, this.getReportingRegime(), new AttributeMeta[0]);
        }

        public WithdrawalBuilder prune();
    }

    public static class WithdrawalImpl
    implements Withdrawal {
        private final WithdrawalSequence withdrawalSequence;
        private final Trade trade;
        private final ZonedDateTime effectiveDate;
        private final RequestedWithdrawalAction requestedAction;
        private final List<? extends WithdrawalReason> reason;
        private final List<? extends ReportingRegimeIdentifier> reportingRegime;

        protected WithdrawalImpl(WithdrawalBuilder builder) {
            this.withdrawalSequence = Optional.ofNullable(builder.getWithdrawalSequence()).map(f -> f.build()).orElse(null);
            this.trade = Optional.ofNullable(builder.getTrade()).map(f -> f.build()).orElse(null);
            this.effectiveDate = builder.getEffectiveDate();
            this.requestedAction = Optional.ofNullable(builder.getRequestedAction()).map(f -> f.build()).orElse(null);
            this.reason = Optional.ofNullable(builder.getReason()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.reportingRegime = Optional.ofNullable(builder.getReportingRegime()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="withdrawalSequence")
        @RuneAttribute(value="withdrawalSequence")
        public WithdrawalSequence getWithdrawalSequence() {
            return this.withdrawalSequence;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public Trade getTrade() {
            return this.trade;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="requestedAction")
        @RuneAttribute(value="requestedAction")
        public RequestedWithdrawalAction getRequestedAction() {
            return this.requestedAction;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends WithdrawalReason> getReason() {
            return this.reason;
        }

        @Override
        @RosettaAttribute(value="reportingRegime")
        @RuneAttribute(value="reportingRegime")
        public List<? extends ReportingRegimeIdentifier> getReportingRegime() {
            return this.reportingRegime;
        }

        @Override
        public Withdrawal build() {
            return this;
        }

        @Override
        public WithdrawalBuilder toBuilder() {
            WithdrawalBuilder builder = Withdrawal.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(WithdrawalBuilder builder) {
            Optional.ofNullable(this.getWithdrawalSequence()).ifPresent(builder::setWithdrawalSequence);
            Optional.ofNullable(this.getTrade()).ifPresent(builder::setTrade);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getRequestedAction()).ifPresent(builder::setRequestedAction);
            Optional.ofNullable(this.getReason()).ifPresent(builder::setReason);
            Optional.ofNullable(this.getReportingRegime()).ifPresent(builder::setReportingRegime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Withdrawal _that = this.getType().cast(o);
            if (!Objects.equals(this.withdrawalSequence, _that.getWithdrawalSequence())) {
                return false;
            }
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.requestedAction, _that.getRequestedAction())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reason, _that.getReason())) {
                return false;
            }
            return ListEquals.listEquals(this.reportingRegime, _that.getReportingRegime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.withdrawalSequence != null ? this.withdrawalSequence.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.requestedAction != null ? this.requestedAction.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            _result = 31 * _result + (this.reportingRegime != null ? this.reportingRegime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Withdrawal {withdrawalSequence=" + this.withdrawalSequence + ", trade=" + this.trade + ", effectiveDate=" + this.effectiveDate + ", requestedAction=" + this.requestedAction + ", reason=" + this.reason + ", reportingRegime=" + this.reportingRegime + '}';
        }
    }
}

