/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AssetValuation;
import fpml.confirmation.PartyReference;
import fpml.confirmation.QuotationCharacteristics;
import fpml.confirmation.SensitivitySetDefinition;
import fpml.confirmation.ValuationScenario;
import fpml.confirmation.ValuationScenarioReference;
import fpml.confirmation.ValuationSetDetail;
import fpml.confirmation.meta.ValuationSetMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ValuationSet", builder=ValuationSetBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ValuationSet", model="fpml", builder=ValuationSetBuilderImpl.class, version="0.17.2")
public interface ValuationSet
extends RosettaModelObject {
    public static final ValuationSetMeta metaData = new ValuationSetMeta();

    public String getName();

    public List<? extends ValuationScenario> getValuationScenario();

    public List<? extends ValuationScenarioReference> getValuationScenarioReference();

    public PartyReference getBaseParty();

    public List<? extends QuotationCharacteristics> getQuotationCharacteristics();

    public List<? extends SensitivitySetDefinition> getSensitivitySetDefinition();

    public ValuationSetDetail getDetail();

    public List<? extends AssetValuation> getAssetValuation();

    public String getId();

    public ValuationSet build();

    public ValuationSetBuilder toBuilder();

    public static ValuationSetBuilder builder() {
        return new ValuationSetBuilderImpl();
    }

    default public RosettaMetaData<? extends ValuationSet> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ValuationSet> getType() {
        return ValuationSet.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationScenario"), processor, ValuationScenario.class, this.getValuationScenario(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationScenarioReference"), processor, ValuationScenarioReference.class, this.getValuationScenarioReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("baseParty"), processor, PartyReference.class, this.getBaseParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotationCharacteristics"), processor, QuotationCharacteristics.class, this.getQuotationCharacteristics(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sensitivitySetDefinition"), processor, SensitivitySetDefinition.class, this.getSensitivitySetDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("detail"), processor, ValuationSetDetail.class, this.getDetail(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assetValuation"), processor, AssetValuation.class, this.getAssetValuation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ValuationSetBuilderImpl
    implements ValuationSetBuilder {
        protected String name;
        protected List<ValuationScenario.ValuationScenarioBuilder> valuationScenario = new ArrayList<ValuationScenario.ValuationScenarioBuilder>();
        protected List<ValuationScenarioReference.ValuationScenarioReferenceBuilder> valuationScenarioReference = new ArrayList<ValuationScenarioReference.ValuationScenarioReferenceBuilder>();
        protected PartyReference.PartyReferenceBuilder baseParty;
        protected List<QuotationCharacteristics.QuotationCharacteristicsBuilder> quotationCharacteristics = new ArrayList<QuotationCharacteristics.QuotationCharacteristicsBuilder>();
        protected List<SensitivitySetDefinition.SensitivitySetDefinitionBuilder> sensitivitySetDefinition = new ArrayList<SensitivitySetDefinition.SensitivitySetDefinitionBuilder>();
        protected ValuationSetDetail.ValuationSetDetailBuilder detail;
        protected List<AssetValuation.AssetValuationBuilder> assetValuation = new ArrayList<AssetValuation.AssetValuationBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="valuationScenario")
        @RuneAttribute(value="valuationScenario")
        public List<? extends ValuationScenario.ValuationScenarioBuilder> getValuationScenario() {
            return this.valuationScenario;
        }

        @Override
        public ValuationScenario.ValuationScenarioBuilder getOrCreateValuationScenario(int index) {
            if (this.valuationScenario == null) {
                this.valuationScenario = new ArrayList<ValuationScenario.ValuationScenarioBuilder>();
            }
            return (ValuationScenario.ValuationScenarioBuilder)this.getIndex(this.valuationScenario, index, () -> {
                ValuationScenario.ValuationScenarioBuilder newValuationScenario = ValuationScenario.builder();
                return newValuationScenario;
            });
        }

        @Override
        @RosettaAttribute(value="valuationScenarioReference")
        @RuneAttribute(value="valuationScenarioReference")
        public List<? extends ValuationScenarioReference.ValuationScenarioReferenceBuilder> getValuationScenarioReference() {
            return this.valuationScenarioReference;
        }

        @Override
        public ValuationScenarioReference.ValuationScenarioReferenceBuilder getOrCreateValuationScenarioReference(int index) {
            if (this.valuationScenarioReference == null) {
                this.valuationScenarioReference = new ArrayList<ValuationScenarioReference.ValuationScenarioReferenceBuilder>();
            }
            return (ValuationScenarioReference.ValuationScenarioReferenceBuilder)this.getIndex(this.valuationScenarioReference, index, () -> {
                ValuationScenarioReference.ValuationScenarioReferenceBuilder newValuationScenarioReference = ValuationScenarioReference.builder();
                return newValuationScenarioReference;
            });
        }

        @Override
        @RosettaAttribute(value="baseParty")
        @RuneAttribute(value="baseParty")
        public PartyReference.PartyReferenceBuilder getBaseParty() {
            return this.baseParty;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateBaseParty() {
            PartyReference.PartyReferenceBuilder result = this.baseParty != null ? this.baseParty : (this.baseParty = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quotationCharacteristics")
        @RuneAttribute(value="quotationCharacteristics")
        public List<? extends QuotationCharacteristics.QuotationCharacteristicsBuilder> getQuotationCharacteristics() {
            return this.quotationCharacteristics;
        }

        @Override
        public QuotationCharacteristics.QuotationCharacteristicsBuilder getOrCreateQuotationCharacteristics(int index) {
            if (this.quotationCharacteristics == null) {
                this.quotationCharacteristics = new ArrayList<QuotationCharacteristics.QuotationCharacteristicsBuilder>();
            }
            return (QuotationCharacteristics.QuotationCharacteristicsBuilder)this.getIndex(this.quotationCharacteristics, index, () -> {
                QuotationCharacteristics.QuotationCharacteristicsBuilder newQuotationCharacteristics = QuotationCharacteristics.builder();
                return newQuotationCharacteristics;
            });
        }

        @Override
        @RosettaAttribute(value="sensitivitySetDefinition")
        @RuneAttribute(value="sensitivitySetDefinition")
        public List<? extends SensitivitySetDefinition.SensitivitySetDefinitionBuilder> getSensitivitySetDefinition() {
            return this.sensitivitySetDefinition;
        }

        @Override
        public SensitivitySetDefinition.SensitivitySetDefinitionBuilder getOrCreateSensitivitySetDefinition(int index) {
            if (this.sensitivitySetDefinition == null) {
                this.sensitivitySetDefinition = new ArrayList<SensitivitySetDefinition.SensitivitySetDefinitionBuilder>();
            }
            return (SensitivitySetDefinition.SensitivitySetDefinitionBuilder)this.getIndex(this.sensitivitySetDefinition, index, () -> {
                SensitivitySetDefinition.SensitivitySetDefinitionBuilder newSensitivitySetDefinition = SensitivitySetDefinition.builder();
                return newSensitivitySetDefinition;
            });
        }

        @Override
        @RosettaAttribute(value="detail")
        @RuneAttribute(value="detail")
        public ValuationSetDetail.ValuationSetDetailBuilder getDetail() {
            return this.detail;
        }

        @Override
        public ValuationSetDetail.ValuationSetDetailBuilder getOrCreateDetail() {
            ValuationSetDetail.ValuationSetDetailBuilder result = this.detail != null ? this.detail : (this.detail = ValuationSetDetail.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="assetValuation")
        @RuneAttribute(value="assetValuation")
        public List<? extends AssetValuation.AssetValuationBuilder> getAssetValuation() {
            return this.assetValuation;
        }

        @Override
        public AssetValuation.AssetValuationBuilder getOrCreateAssetValuation(int index) {
            if (this.assetValuation == null) {
                this.assetValuation = new ArrayList<AssetValuation.AssetValuationBuilder>();
            }
            return (AssetValuation.AssetValuationBuilder)this.getIndex(this.assetValuation, index, () -> {
                AssetValuation.AssetValuationBuilder newAssetValuation = AssetValuation.builder();
                return newAssetValuation;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public ValuationSetBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationScenario")
        @RuneAttribute(value="valuationScenario")
        public ValuationSetBuilder addValuationScenario(ValuationScenario _valuationScenario) {
            if (_valuationScenario != null) {
                this.valuationScenario.add(_valuationScenario.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationSetBuilder addValuationScenario(ValuationScenario _valuationScenario, int idx) {
            this.getIndex(this.valuationScenario, idx, () -> _valuationScenario.toBuilder());
            return this;
        }

        @Override
        public ValuationSetBuilder addValuationScenario(List<? extends ValuationScenario> valuationScenarios) {
            if (valuationScenarios != null) {
                for (ValuationScenario valuationScenario : valuationScenarios) {
                    this.valuationScenario.add(valuationScenario.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="valuationScenario")
        public ValuationSetBuilder setValuationScenario(List<? extends ValuationScenario> valuationScenarios) {
            this.valuationScenario = valuationScenarios == null ? new ArrayList<ValuationScenario.ValuationScenarioBuilder>() : (List)valuationScenarios.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationScenarioReference")
        @RuneAttribute(value="valuationScenarioReference")
        public ValuationSetBuilder addValuationScenarioReference(ValuationScenarioReference _valuationScenarioReference) {
            if (_valuationScenarioReference != null) {
                this.valuationScenarioReference.add(_valuationScenarioReference.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationSetBuilder addValuationScenarioReference(ValuationScenarioReference _valuationScenarioReference, int idx) {
            this.getIndex(this.valuationScenarioReference, idx, () -> _valuationScenarioReference.toBuilder());
            return this;
        }

        @Override
        public ValuationSetBuilder addValuationScenarioReference(List<? extends ValuationScenarioReference> valuationScenarioReferences) {
            if (valuationScenarioReferences != null) {
                for (ValuationScenarioReference valuationScenarioReference : valuationScenarioReferences) {
                    this.valuationScenarioReference.add(valuationScenarioReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="valuationScenarioReference")
        public ValuationSetBuilder setValuationScenarioReference(List<? extends ValuationScenarioReference> valuationScenarioReferences) {
            this.valuationScenarioReference = valuationScenarioReferences == null ? new ArrayList<ValuationScenarioReference.ValuationScenarioReferenceBuilder>() : (List)valuationScenarioReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="baseParty")
        @RuneAttribute(value="baseParty")
        public ValuationSetBuilder setBaseParty(PartyReference _baseParty) {
            this.baseParty = _baseParty == null ? null : _baseParty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quotationCharacteristics")
        @RuneAttribute(value="quotationCharacteristics")
        public ValuationSetBuilder addQuotationCharacteristics(QuotationCharacteristics _quotationCharacteristics) {
            if (_quotationCharacteristics != null) {
                this.quotationCharacteristics.add(_quotationCharacteristics.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationSetBuilder addQuotationCharacteristics(QuotationCharacteristics _quotationCharacteristics, int idx) {
            this.getIndex(this.quotationCharacteristics, idx, () -> _quotationCharacteristics.toBuilder());
            return this;
        }

        @Override
        public ValuationSetBuilder addQuotationCharacteristics(List<? extends QuotationCharacteristics> quotationCharacteristicss) {
            if (quotationCharacteristicss != null) {
                for (QuotationCharacteristics quotationCharacteristics : quotationCharacteristicss) {
                    this.quotationCharacteristics.add(quotationCharacteristics.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="quotationCharacteristics")
        public ValuationSetBuilder setQuotationCharacteristics(List<? extends QuotationCharacteristics> quotationCharacteristicss) {
            this.quotationCharacteristics = quotationCharacteristicss == null ? new ArrayList<QuotationCharacteristics.QuotationCharacteristicsBuilder>() : (List)quotationCharacteristicss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="sensitivitySetDefinition")
        @RuneAttribute(value="sensitivitySetDefinition")
        public ValuationSetBuilder addSensitivitySetDefinition(SensitivitySetDefinition _sensitivitySetDefinition) {
            if (_sensitivitySetDefinition != null) {
                this.sensitivitySetDefinition.add(_sensitivitySetDefinition.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationSetBuilder addSensitivitySetDefinition(SensitivitySetDefinition _sensitivitySetDefinition, int idx) {
            this.getIndex(this.sensitivitySetDefinition, idx, () -> _sensitivitySetDefinition.toBuilder());
            return this;
        }

        @Override
        public ValuationSetBuilder addSensitivitySetDefinition(List<? extends SensitivitySetDefinition> sensitivitySetDefinitions) {
            if (sensitivitySetDefinitions != null) {
                for (SensitivitySetDefinition sensitivitySetDefinition : sensitivitySetDefinitions) {
                    this.sensitivitySetDefinition.add(sensitivitySetDefinition.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="sensitivitySetDefinition")
        public ValuationSetBuilder setSensitivitySetDefinition(List<? extends SensitivitySetDefinition> sensitivitySetDefinitions) {
            this.sensitivitySetDefinition = sensitivitySetDefinitions == null ? new ArrayList<SensitivitySetDefinition.SensitivitySetDefinitionBuilder>() : (List)sensitivitySetDefinitions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="detail")
        @RuneAttribute(value="detail")
        public ValuationSetBuilder setDetail(ValuationSetDetail _detail) {
            this.detail = _detail == null ? null : _detail.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetValuation")
        @RuneAttribute(value="assetValuation")
        public ValuationSetBuilder addAssetValuation(AssetValuation _assetValuation) {
            if (_assetValuation != null) {
                this.assetValuation.add(_assetValuation.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationSetBuilder addAssetValuation(AssetValuation _assetValuation, int idx) {
            this.getIndex(this.assetValuation, idx, () -> _assetValuation.toBuilder());
            return this;
        }

        @Override
        public ValuationSetBuilder addAssetValuation(List<? extends AssetValuation> assetValuations) {
            if (assetValuations != null) {
                for (AssetValuation assetValuation : assetValuations) {
                    this.assetValuation.add(assetValuation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="assetValuation")
        public ValuationSetBuilder setAssetValuation(List<? extends AssetValuation> assetValuations) {
            this.assetValuation = assetValuations == null ? new ArrayList<AssetValuation.AssetValuationBuilder>() : (List)assetValuations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ValuationSetBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public ValuationSet build() {
            return new ValuationSetImpl(this);
        }

        @Override
        public ValuationSetBuilder toBuilder() {
            return this;
        }

        @Override
        public ValuationSetBuilder prune() {
            this.valuationScenario = this.valuationScenario.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.valuationScenarioReference = this.valuationScenarioReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.baseParty != null && !this.baseParty.prune().hasData()) {
                this.baseParty = null;
            }
            this.quotationCharacteristics = this.quotationCharacteristics.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.sensitivitySetDefinition = this.sensitivitySetDefinition.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.detail != null && !this.detail.prune().hasData()) {
                this.detail = null;
            }
            this.assetValuation = this.assetValuation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            if (this.getValuationScenario() != null && this.getValuationScenario().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getValuationScenarioReference() != null && this.getValuationScenarioReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBaseParty() != null && this.getBaseParty().hasData()) {
                return true;
            }
            if (this.getQuotationCharacteristics() != null && this.getQuotationCharacteristics().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSensitivitySetDefinition() != null && this.getSensitivitySetDefinition().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDetail() != null && this.getDetail().hasData()) {
                return true;
            }
            if (this.getAssetValuation() != null && this.getAssetValuation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public ValuationSetBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ValuationSetBuilder o = (ValuationSetBuilder)other;
            merger.mergeRosetta(this.getValuationScenario(), o.getValuationScenario(), this::getOrCreateValuationScenario);
            merger.mergeRosetta(this.getValuationScenarioReference(), o.getValuationScenarioReference(), this::getOrCreateValuationScenarioReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBaseParty(), (RosettaModelObjectBuilder)o.getBaseParty(), this::setBaseParty);
            merger.mergeRosetta(this.getQuotationCharacteristics(), o.getQuotationCharacteristics(), this::getOrCreateQuotationCharacteristics);
            merger.mergeRosetta(this.getSensitivitySetDefinition(), o.getSensitivitySetDefinition(), this::getOrCreateSensitivitySetDefinition);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDetail(), (RosettaModelObjectBuilder)o.getDetail(), this::setDetail);
            merger.mergeRosetta(this.getAssetValuation(), o.getAssetValuation(), this::getOrCreateAssetValuation);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationSet _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.valuationScenario, _that.getValuationScenario())) {
                return false;
            }
            if (!ListEquals.listEquals(this.valuationScenarioReference, _that.getValuationScenarioReference())) {
                return false;
            }
            if (!Objects.equals(this.baseParty, _that.getBaseParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.quotationCharacteristics, _that.getQuotationCharacteristics())) {
                return false;
            }
            if (!ListEquals.listEquals(this.sensitivitySetDefinition, _that.getSensitivitySetDefinition())) {
                return false;
            }
            if (!Objects.equals(this.detail, _that.getDetail())) {
                return false;
            }
            if (!ListEquals.listEquals(this.assetValuation, _that.getAssetValuation())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.valuationScenario != null ? this.valuationScenario.hashCode() : 0);
            _result = 31 * _result + (this.valuationScenarioReference != null ? this.valuationScenarioReference.hashCode() : 0);
            _result = 31 * _result + (this.baseParty != null ? this.baseParty.hashCode() : 0);
            _result = 31 * _result + (this.quotationCharacteristics != null ? this.quotationCharacteristics.hashCode() : 0);
            _result = 31 * _result + (this.sensitivitySetDefinition != null ? this.sensitivitySetDefinition.hashCode() : 0);
            _result = 31 * _result + (this.detail != null ? this.detail.hashCode() : 0);
            _result = 31 * _result + (this.assetValuation != null ? this.assetValuation.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationSetBuilder {name=" + this.name + ", valuationScenario=" + this.valuationScenario + ", valuationScenarioReference=" + this.valuationScenarioReference + ", baseParty=" + this.baseParty + ", quotationCharacteristics=" + this.quotationCharacteristics + ", sensitivitySetDefinition=" + this.sensitivitySetDefinition + ", detail=" + this.detail + ", assetValuation=" + this.assetValuation + ", id=" + this.id + '}';
        }
    }

    public static interface ValuationSetBuilder
    extends ValuationSet,
    RosettaModelObjectBuilder {
        public ValuationScenario.ValuationScenarioBuilder getOrCreateValuationScenario(int var1);

        public List<? extends ValuationScenario.ValuationScenarioBuilder> getValuationScenario();

        public ValuationScenarioReference.ValuationScenarioReferenceBuilder getOrCreateValuationScenarioReference(int var1);

        public List<? extends ValuationScenarioReference.ValuationScenarioReferenceBuilder> getValuationScenarioReference();

        public PartyReference.PartyReferenceBuilder getOrCreateBaseParty();

        @Override
        public PartyReference.PartyReferenceBuilder getBaseParty();

        public QuotationCharacteristics.QuotationCharacteristicsBuilder getOrCreateQuotationCharacteristics(int var1);

        public List<? extends QuotationCharacteristics.QuotationCharacteristicsBuilder> getQuotationCharacteristics();

        public SensitivitySetDefinition.SensitivitySetDefinitionBuilder getOrCreateSensitivitySetDefinition(int var1);

        public List<? extends SensitivitySetDefinition.SensitivitySetDefinitionBuilder> getSensitivitySetDefinition();

        public ValuationSetDetail.ValuationSetDetailBuilder getOrCreateDetail();

        @Override
        public ValuationSetDetail.ValuationSetDetailBuilder getDetail();

        public AssetValuation.AssetValuationBuilder getOrCreateAssetValuation(int var1);

        public List<? extends AssetValuation.AssetValuationBuilder> getAssetValuation();

        public ValuationSetBuilder setName(String var1);

        public ValuationSetBuilder addValuationScenario(ValuationScenario var1);

        public ValuationSetBuilder addValuationScenario(ValuationScenario var1, int var2);

        public ValuationSetBuilder addValuationScenario(List<? extends ValuationScenario> var1);

        public ValuationSetBuilder setValuationScenario(List<? extends ValuationScenario> var1);

        public ValuationSetBuilder addValuationScenarioReference(ValuationScenarioReference var1);

        public ValuationSetBuilder addValuationScenarioReference(ValuationScenarioReference var1, int var2);

        public ValuationSetBuilder addValuationScenarioReference(List<? extends ValuationScenarioReference> var1);

        public ValuationSetBuilder setValuationScenarioReference(List<? extends ValuationScenarioReference> var1);

        public ValuationSetBuilder setBaseParty(PartyReference var1);

        public ValuationSetBuilder addQuotationCharacteristics(QuotationCharacteristics var1);

        public ValuationSetBuilder addQuotationCharacteristics(QuotationCharacteristics var1, int var2);

        public ValuationSetBuilder addQuotationCharacteristics(List<? extends QuotationCharacteristics> var1);

        public ValuationSetBuilder setQuotationCharacteristics(List<? extends QuotationCharacteristics> var1);

        public ValuationSetBuilder addSensitivitySetDefinition(SensitivitySetDefinition var1);

        public ValuationSetBuilder addSensitivitySetDefinition(SensitivitySetDefinition var1, int var2);

        public ValuationSetBuilder addSensitivitySetDefinition(List<? extends SensitivitySetDefinition> var1);

        public ValuationSetBuilder setSensitivitySetDefinition(List<? extends SensitivitySetDefinition> var1);

        public ValuationSetBuilder setDetail(ValuationSetDetail var1);

        public ValuationSetBuilder addAssetValuation(AssetValuation var1);

        public ValuationSetBuilder addAssetValuation(AssetValuation var1, int var2);

        public ValuationSetBuilder addAssetValuation(List<? extends AssetValuation> var1);

        public ValuationSetBuilder setAssetValuation(List<? extends AssetValuation> var1);

        public ValuationSetBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationScenario"), processor, ValuationScenario.ValuationScenarioBuilder.class, this.getValuationScenario(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationScenarioReference"), processor, ValuationScenarioReference.ValuationScenarioReferenceBuilder.class, this.getValuationScenarioReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("baseParty"), processor, PartyReference.PartyReferenceBuilder.class, this.getBaseParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotationCharacteristics"), processor, QuotationCharacteristics.QuotationCharacteristicsBuilder.class, this.getQuotationCharacteristics(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sensitivitySetDefinition"), processor, SensitivitySetDefinition.SensitivitySetDefinitionBuilder.class, this.getSensitivitySetDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("detail"), processor, ValuationSetDetail.ValuationSetDetailBuilder.class, this.getDetail(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assetValuation"), processor, AssetValuation.AssetValuationBuilder.class, this.getAssetValuation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ValuationSetBuilder prune();
    }

    public static class ValuationSetImpl
    implements ValuationSet {
        private final String name;
        private final List<? extends ValuationScenario> valuationScenario;
        private final List<? extends ValuationScenarioReference> valuationScenarioReference;
        private final PartyReference baseParty;
        private final List<? extends QuotationCharacteristics> quotationCharacteristics;
        private final List<? extends SensitivitySetDefinition> sensitivitySetDefinition;
        private final ValuationSetDetail detail;
        private final List<? extends AssetValuation> assetValuation;
        private final String id;

        protected ValuationSetImpl(ValuationSetBuilder builder) {
            this.name = builder.getName();
            this.valuationScenario = Optional.ofNullable(builder.getValuationScenario()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.valuationScenarioReference = Optional.ofNullable(builder.getValuationScenarioReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.baseParty = Optional.ofNullable(builder.getBaseParty()).map(f -> f.build()).orElse(null);
            this.quotationCharacteristics = Optional.ofNullable(builder.getQuotationCharacteristics()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.sensitivitySetDefinition = Optional.ofNullable(builder.getSensitivitySetDefinition()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.detail = Optional.ofNullable(builder.getDetail()).map(f -> f.build()).orElse(null);
            this.assetValuation = Optional.ofNullable(builder.getAssetValuation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="valuationScenario")
        @RuneAttribute(value="valuationScenario")
        public List<? extends ValuationScenario> getValuationScenario() {
            return this.valuationScenario;
        }

        @Override
        @RosettaAttribute(value="valuationScenarioReference")
        @RuneAttribute(value="valuationScenarioReference")
        public List<? extends ValuationScenarioReference> getValuationScenarioReference() {
            return this.valuationScenarioReference;
        }

        @Override
        @RosettaAttribute(value="baseParty")
        @RuneAttribute(value="baseParty")
        public PartyReference getBaseParty() {
            return this.baseParty;
        }

        @Override
        @RosettaAttribute(value="quotationCharacteristics")
        @RuneAttribute(value="quotationCharacteristics")
        public List<? extends QuotationCharacteristics> getQuotationCharacteristics() {
            return this.quotationCharacteristics;
        }

        @Override
        @RosettaAttribute(value="sensitivitySetDefinition")
        @RuneAttribute(value="sensitivitySetDefinition")
        public List<? extends SensitivitySetDefinition> getSensitivitySetDefinition() {
            return this.sensitivitySetDefinition;
        }

        @Override
        @RosettaAttribute(value="detail")
        @RuneAttribute(value="detail")
        public ValuationSetDetail getDetail() {
            return this.detail;
        }

        @Override
        @RosettaAttribute(value="assetValuation")
        @RuneAttribute(value="assetValuation")
        public List<? extends AssetValuation> getAssetValuation() {
            return this.assetValuation;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public ValuationSet build() {
            return this;
        }

        @Override
        public ValuationSetBuilder toBuilder() {
            ValuationSetBuilder builder = ValuationSet.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ValuationSetBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getValuationScenario()).ifPresent(builder::setValuationScenario);
            Optional.ofNullable(this.getValuationScenarioReference()).ifPresent(builder::setValuationScenarioReference);
            Optional.ofNullable(this.getBaseParty()).ifPresent(builder::setBaseParty);
            Optional.ofNullable(this.getQuotationCharacteristics()).ifPresent(builder::setQuotationCharacteristics);
            Optional.ofNullable(this.getSensitivitySetDefinition()).ifPresent(builder::setSensitivitySetDefinition);
            Optional.ofNullable(this.getDetail()).ifPresent(builder::setDetail);
            Optional.ofNullable(this.getAssetValuation()).ifPresent(builder::setAssetValuation);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationSet _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.valuationScenario, _that.getValuationScenario())) {
                return false;
            }
            if (!ListEquals.listEquals(this.valuationScenarioReference, _that.getValuationScenarioReference())) {
                return false;
            }
            if (!Objects.equals(this.baseParty, _that.getBaseParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.quotationCharacteristics, _that.getQuotationCharacteristics())) {
                return false;
            }
            if (!ListEquals.listEquals(this.sensitivitySetDefinition, _that.getSensitivitySetDefinition())) {
                return false;
            }
            if (!Objects.equals(this.detail, _that.getDetail())) {
                return false;
            }
            if (!ListEquals.listEquals(this.assetValuation, _that.getAssetValuation())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.valuationScenario != null ? this.valuationScenario.hashCode() : 0);
            _result = 31 * _result + (this.valuationScenarioReference != null ? this.valuationScenarioReference.hashCode() : 0);
            _result = 31 * _result + (this.baseParty != null ? this.baseParty.hashCode() : 0);
            _result = 31 * _result + (this.quotationCharacteristics != null ? this.quotationCharacteristics.hashCode() : 0);
            _result = 31 * _result + (this.sensitivitySetDefinition != null ? this.sensitivitySetDefinition.hashCode() : 0);
            _result = 31 * _result + (this.detail != null ? this.detail.hashCode() : 0);
            _result = 31 * _result + (this.assetValuation != null ? this.assetValuation.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationSet {name=" + this.name + ", valuationScenario=" + this.valuationScenario + ", valuationScenarioReference=" + this.valuationScenarioReference + ", baseParty=" + this.baseParty + ", quotationCharacteristics=" + this.quotationCharacteristics + ", sensitivitySetDefinition=" + this.sensitivitySetDefinition + ", detail=" + this.detail + ", assetValuation=" + this.assetValuation + ", id=" + this.id + '}';
        }
    }
}

