/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.CorrectableRequestMessage;
import fpml.confirmation.CorrelationAndSequenceModel;
import fpml.confirmation.EventValuationModel;
import fpml.confirmation.OnBehalfOfModel;
import fpml.confirmation.PartiesAndAccountsModel;
import fpml.confirmation.PaymentDetails;
import fpml.confirmation.RequestMessageHeader;
import fpml.confirmation.TradeChangeContent;
import fpml.confirmation.ValidationModel;
import fpml.confirmation.meta.TradeChangeAdviceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradeChangeAdvice", builder=TradeChangeAdviceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="TradeChangeAdvice", model="fpml", builder=TradeChangeAdviceBuilderImpl.class, version="0.17.2")
public interface TradeChangeAdvice
extends CorrectableRequestMessage {
    public static final TradeChangeAdviceMeta metaData = new TradeChangeAdviceMeta();

    public TradeChangeContent getChange();

    public EventValuationModel getEventValuationModel();

    public List<? extends PaymentDetails> getPaymentDetails();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public TradeChangeAdvice build();

    @Override
    public TradeChangeAdviceBuilder toBuilder();

    public static TradeChangeAdviceBuilder builder() {
        return new TradeChangeAdviceBuilderImpl();
    }

    default public RosettaMetaData<? extends TradeChangeAdvice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradeChangeAdvice> getType() {
        return TradeChangeAdvice.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("change"), processor, TradeChangeContent.class, this.getChange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.class, this.getEventValuationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDetails"), processor, PaymentDetails.class, this.getPaymentDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class TradeChangeAdviceBuilderImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageBuilderImpl
    implements TradeChangeAdviceBuilder {
        protected TradeChangeContent.TradeChangeContentBuilder change;
        protected EventValuationModel.EventValuationModelBuilder eventValuationModel;
        protected List<PaymentDetails.PaymentDetailsBuilder> paymentDetails = new ArrayList<PaymentDetails.PaymentDetailsBuilder>();
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="change", isRequired=true)
        @RuneAttribute(value="change", isRequired=true)
        public TradeChangeContent.TradeChangeContentBuilder getChange() {
            return this.change;
        }

        @Override
        public TradeChangeContent.TradeChangeContentBuilder getOrCreateChange() {
            TradeChangeContent.TradeChangeContentBuilder result = this.change != null ? this.change : (this.change = TradeChangeContent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel() {
            EventValuationModel.EventValuationModelBuilder result = this.eventValuationModel != null ? this.eventValuationModel : (this.eventValuationModel = EventValuationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDetails")
        @RuneAttribute(value="paymentDetails")
        public List<? extends PaymentDetails.PaymentDetailsBuilder> getPaymentDetails() {
            return this.paymentDetails;
        }

        @Override
        public PaymentDetails.PaymentDetailsBuilder getOrCreatePaymentDetails(int index) {
            if (this.paymentDetails == null) {
                this.paymentDetails = new ArrayList<PaymentDetails.PaymentDetailsBuilder>();
            }
            return (PaymentDetails.PaymentDetailsBuilder)this.getIndex(this.paymentDetails, index, () -> {
                PaymentDetails.PaymentDetailsBuilder newPaymentDetails = PaymentDetails.builder();
                return newPaymentDetails;
            });
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public TradeChangeAdviceBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public TradeChangeAdviceBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public TradeChangeAdviceBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header", isRequired=true)
        @RuneAttribute(value="header", isRequired=true)
        public TradeChangeAdviceBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public TradeChangeAdviceBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection", isRequired=true)
        @RuneAttribute(value="isCorrection", isRequired=true)
        public TradeChangeAdviceBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public TradeChangeAdviceBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public TradeChangeAdviceBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="change", isRequired=true)
        @RuneAttribute(value="change", isRequired=true)
        public TradeChangeAdviceBuilder setChange(TradeChangeContent _change) {
            this.change = _change == null ? null : _change.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public TradeChangeAdviceBuilder setEventValuationModel(EventValuationModel _eventValuationModel) {
            this.eventValuationModel = _eventValuationModel == null ? null : _eventValuationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDetails")
        @RuneAttribute(value="paymentDetails")
        public TradeChangeAdviceBuilder addPaymentDetails(PaymentDetails _paymentDetails) {
            if (_paymentDetails != null) {
                this.paymentDetails.add(_paymentDetails.toBuilder());
            }
            return this;
        }

        @Override
        public TradeChangeAdviceBuilder addPaymentDetails(PaymentDetails _paymentDetails, int idx) {
            this.getIndex(this.paymentDetails, idx, () -> _paymentDetails.toBuilder());
            return this;
        }

        @Override
        public TradeChangeAdviceBuilder addPaymentDetails(List<? extends PaymentDetails> paymentDetailss) {
            if (paymentDetailss != null) {
                for (PaymentDetails paymentDetails : paymentDetailss) {
                    this.paymentDetails.add(paymentDetails.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="paymentDetails")
        public TradeChangeAdviceBuilder setPaymentDetails(List<? extends PaymentDetails> paymentDetailss) {
            this.paymentDetails = paymentDetailss == null ? new ArrayList<PaymentDetails.PaymentDetailsBuilder>() : (List)paymentDetailss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public TradeChangeAdviceBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public TradeChangeAdvice build() {
            return new TradeChangeAdviceImpl(this);
        }

        @Override
        public TradeChangeAdviceBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeChangeAdviceBuilder prune() {
            super.prune();
            if (this.change != null && !this.change.prune().hasData()) {
                this.change = null;
            }
            if (this.eventValuationModel != null && !this.eventValuationModel.prune().hasData()) {
                this.eventValuationModel = null;
            }
            this.paymentDetails = this.paymentDetails.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getChange() != null && this.getChange().hasData()) {
                return true;
            }
            if (this.getEventValuationModel() != null && this.getEventValuationModel().hasData()) {
                return true;
            }
            if (this.getPaymentDetails() != null && this.getPaymentDetails().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public TradeChangeAdviceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            TradeChangeAdviceBuilder o = (TradeChangeAdviceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getChange(), (RosettaModelObjectBuilder)o.getChange(), this::setChange);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventValuationModel(), (RosettaModelObjectBuilder)o.getEventValuationModel(), this::setEventValuationModel);
            merger.mergeRosetta(this.getPaymentDetails(), o.getPaymentDetails(), this::getOrCreatePaymentDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TradeChangeAdvice _that = (TradeChangeAdvice)this.getType().cast(o);
            if (!Objects.equals(this.change, _that.getChange())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.paymentDetails, _that.getPaymentDetails())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.change != null ? this.change.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.paymentDetails != null ? this.paymentDetails.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TradeChangeAdviceBuilder {change=" + this.change + ", eventValuationModel=" + this.eventValuationModel + ", paymentDetails=" + this.paymentDetails + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }

    public static interface TradeChangeAdviceBuilder
    extends TradeChangeAdvice,
    CorrectableRequestMessage.CorrectableRequestMessageBuilder {
        public TradeChangeContent.TradeChangeContentBuilder getOrCreateChange();

        @Override
        public TradeChangeContent.TradeChangeContentBuilder getChange();

        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel();

        @Override
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel();

        public PaymentDetails.PaymentDetailsBuilder getOrCreatePaymentDetails(int var1);

        public List<? extends PaymentDetails.PaymentDetailsBuilder> getPaymentDetails();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public TradeChangeAdviceBuilder setFpmlVersion(String var1);

        @Override
        public TradeChangeAdviceBuilder setExpectedBuild(Integer var1);

        @Override
        public TradeChangeAdviceBuilder setActualBuild(Integer var1);

        @Override
        public TradeChangeAdviceBuilder setHeader(RequestMessageHeader var1);

        @Override
        public TradeChangeAdviceBuilder setValidationModel(ValidationModel var1);

        @Override
        public TradeChangeAdviceBuilder setIsCorrection(Boolean var1);

        @Override
        public TradeChangeAdviceBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public TradeChangeAdviceBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public TradeChangeAdviceBuilder setChange(TradeChangeContent var1);

        public TradeChangeAdviceBuilder setEventValuationModel(EventValuationModel var1);

        public TradeChangeAdviceBuilder addPaymentDetails(PaymentDetails var1);

        public TradeChangeAdviceBuilder addPaymentDetails(PaymentDetails var1, int var2);

        public TradeChangeAdviceBuilder addPaymentDetails(List<? extends PaymentDetails> var1);

        public TradeChangeAdviceBuilder setPaymentDetails(List<? extends PaymentDetails> var1);

        public TradeChangeAdviceBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("change"), processor, TradeChangeContent.TradeChangeContentBuilder.class, this.getChange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.EventValuationModelBuilder.class, this.getEventValuationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDetails"), processor, PaymentDetails.PaymentDetailsBuilder.class, this.getPaymentDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public TradeChangeAdviceBuilder prune();
    }

    public static class TradeChangeAdviceImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageImpl
    implements TradeChangeAdvice {
        private final TradeChangeContent change;
        private final EventValuationModel eventValuationModel;
        private final List<? extends PaymentDetails> paymentDetails;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected TradeChangeAdviceImpl(TradeChangeAdviceBuilder builder) {
            super(builder);
            this.change = Optional.ofNullable(builder.getChange()).map(f -> f.build()).orElse(null);
            this.eventValuationModel = Optional.ofNullable(builder.getEventValuationModel()).map(f -> f.build()).orElse(null);
            this.paymentDetails = Optional.ofNullable(builder.getPaymentDetails()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="change", isRequired=true)
        @RuneAttribute(value="change", isRequired=true)
        public TradeChangeContent getChange() {
            return this.change;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        @RosettaAttribute(value="paymentDetails")
        @RuneAttribute(value="paymentDetails")
        public List<? extends PaymentDetails> getPaymentDetails() {
            return this.paymentDetails;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public TradeChangeAdvice build() {
            return this;
        }

        @Override
        public TradeChangeAdviceBuilder toBuilder() {
            TradeChangeAdviceBuilder builder = TradeChangeAdvice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeChangeAdviceBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getChange()).ifPresent(builder::setChange);
            Optional.ofNullable(this.getEventValuationModel()).ifPresent(builder::setEventValuationModel);
            Optional.ofNullable(this.getPaymentDetails()).ifPresent(builder::setPaymentDetails);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TradeChangeAdvice _that = (TradeChangeAdvice)this.getType().cast(o);
            if (!Objects.equals(this.change, _that.getChange())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.paymentDetails, _that.getPaymentDetails())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.change != null ? this.change.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.paymentDetails != null ? this.paymentDetails.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TradeChangeAdvice {change=" + this.change + ", eventValuationModel=" + this.eventValuationModel + ", paymentDetails=" + this.paymentDetails + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }
}

