/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.Money;
import fpml.confirmation.PaymentBase;
import fpml.confirmation.meta.SinglePaymentMeta;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="SinglePayment", builder=SinglePaymentBuilderImpl.class, version="0.17.2")
@RuneDataType(value="SinglePayment", model="fpml", builder=SinglePaymentBuilderImpl.class, version="0.17.2")
public interface SinglePayment
extends PaymentBase {
    public static final SinglePaymentMeta metaData = new SinglePaymentMeta();

    public ZonedDateTime getAdjustablePaymentDate();

    public ZonedDateTime getAdjustedPaymentDate();

    public Money getFixedAmount();

    @Override
    public SinglePayment build();

    @Override
    public SinglePaymentBuilder toBuilder();

    public static SinglePaymentBuilder builder() {
        return new SinglePaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends SinglePayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SinglePayment> getType() {
        return SinglePayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustablePaymentDate"), ZonedDateTime.class, (Object)this.getAdjustablePaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedPaymentDate"), ZonedDateTime.class, (Object)this.getAdjustedPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedAmount"), processor, Money.class, this.getFixedAmount(), new AttributeMeta[0]);
    }

    public static class SinglePaymentBuilderImpl
    extends PaymentBase.PaymentBaseBuilderImpl
    implements SinglePaymentBuilder {
        protected ZonedDateTime adjustablePaymentDate;
        protected ZonedDateTime adjustedPaymentDate;
        protected Money.MoneyBuilder fixedAmount;

        @Override
        @RosettaAttribute(value="adjustablePaymentDate", isRequired=true)
        @RuneAttribute(value="adjustablePaymentDate", isRequired=true)
        public ZonedDateTime getAdjustablePaymentDate() {
            return this.adjustablePaymentDate;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate")
        @RuneAttribute(value="adjustedPaymentDate")
        public ZonedDateTime getAdjustedPaymentDate() {
            return this.adjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="fixedAmount", isRequired=true)
        @RuneAttribute(value="fixedAmount", isRequired=true)
        public Money.MoneyBuilder getFixedAmount() {
            return this.fixedAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateFixedAmount() {
            Money.MoneyBuilder result = this.fixedAmount != null ? this.fixedAmount : (this.fixedAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public SinglePaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustablePaymentDate", isRequired=true)
        @RuneAttribute(value="adjustablePaymentDate", isRequired=true)
        public SinglePaymentBuilder setAdjustablePaymentDate(ZonedDateTime _adjustablePaymentDate) {
            this.adjustablePaymentDate = _adjustablePaymentDate == null ? null : _adjustablePaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate")
        @RuneAttribute(value="adjustedPaymentDate")
        public SinglePaymentBuilder setAdjustedPaymentDate(ZonedDateTime _adjustedPaymentDate) {
            this.adjustedPaymentDate = _adjustedPaymentDate == null ? null : _adjustedPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedAmount", isRequired=true)
        @RuneAttribute(value="fixedAmount", isRequired=true)
        public SinglePaymentBuilder setFixedAmount(Money _fixedAmount) {
            this.fixedAmount = _fixedAmount == null ? null : _fixedAmount.toBuilder();
            return this;
        }

        @Override
        public SinglePayment build() {
            return new SinglePaymentImpl(this);
        }

        @Override
        public SinglePaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public SinglePaymentBuilder prune() {
            super.prune();
            if (this.fixedAmount != null && !this.fixedAmount.prune().hasData()) {
                this.fixedAmount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAdjustablePaymentDate() != null) {
                return true;
            }
            if (this.getAdjustedPaymentDate() != null) {
                return true;
            }
            return this.getFixedAmount() != null && this.getFixedAmount().hasData();
        }

        @Override
        public SinglePaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SinglePaymentBuilder o = (SinglePaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedAmount(), (RosettaModelObjectBuilder)o.getFixedAmount(), this::setFixedAmount);
            merger.mergeBasic((Object)this.getAdjustablePaymentDate(), (Object)o.getAdjustablePaymentDate(), this::setAdjustablePaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedPaymentDate(), (Object)o.getAdjustedPaymentDate(), this::setAdjustedPaymentDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SinglePayment _that = (SinglePayment)this.getType().cast(o);
            if (!Objects.equals(this.adjustablePaymentDate, _that.getAdjustablePaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedPaymentDate, _that.getAdjustedPaymentDate())) {
                return false;
            }
            return Objects.equals(this.fixedAmount, _that.getFixedAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.adjustablePaymentDate != null ? this.adjustablePaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedPaymentDate != null ? this.adjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.fixedAmount != null ? this.fixedAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SinglePaymentBuilder {adjustablePaymentDate=" + this.adjustablePaymentDate + ", adjustedPaymentDate=" + this.adjustedPaymentDate + ", fixedAmount=" + this.fixedAmount + '}' + " " + super.toString();
        }
    }

    public static interface SinglePaymentBuilder
    extends SinglePayment,
    PaymentBase.PaymentBaseBuilder {
        public Money.MoneyBuilder getOrCreateFixedAmount();

        @Override
        public Money.MoneyBuilder getFixedAmount();

        @Override
        public SinglePaymentBuilder setId(String var1);

        public SinglePaymentBuilder setAdjustablePaymentDate(ZonedDateTime var1);

        public SinglePaymentBuilder setAdjustedPaymentDate(ZonedDateTime var1);

        public SinglePaymentBuilder setFixedAmount(Money var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustablePaymentDate"), ZonedDateTime.class, (Object)this.getAdjustablePaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedPaymentDate"), ZonedDateTime.class, (Object)this.getAdjustedPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedAmount"), processor, Money.MoneyBuilder.class, this.getFixedAmount(), new AttributeMeta[0]);
        }

        @Override
        public SinglePaymentBuilder prune();
    }

    public static class SinglePaymentImpl
    extends PaymentBase.PaymentBaseImpl
    implements SinglePayment {
        private final ZonedDateTime adjustablePaymentDate;
        private final ZonedDateTime adjustedPaymentDate;
        private final Money fixedAmount;

        protected SinglePaymentImpl(SinglePaymentBuilder builder) {
            super(builder);
            this.adjustablePaymentDate = builder.getAdjustablePaymentDate();
            this.adjustedPaymentDate = builder.getAdjustedPaymentDate();
            this.fixedAmount = Optional.ofNullable(builder.getFixedAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="adjustablePaymentDate", isRequired=true)
        @RuneAttribute(value="adjustablePaymentDate", isRequired=true)
        public ZonedDateTime getAdjustablePaymentDate() {
            return this.adjustablePaymentDate;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate")
        @RuneAttribute(value="adjustedPaymentDate")
        public ZonedDateTime getAdjustedPaymentDate() {
            return this.adjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="fixedAmount", isRequired=true)
        @RuneAttribute(value="fixedAmount", isRequired=true)
        public Money getFixedAmount() {
            return this.fixedAmount;
        }

        @Override
        public SinglePayment build() {
            return this;
        }

        @Override
        public SinglePaymentBuilder toBuilder() {
            SinglePaymentBuilder builder = SinglePayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SinglePaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAdjustablePaymentDate()).ifPresent(builder::setAdjustablePaymentDate);
            Optional.ofNullable(this.getAdjustedPaymentDate()).ifPresent(builder::setAdjustedPaymentDate);
            Optional.ofNullable(this.getFixedAmount()).ifPresent(builder::setFixedAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SinglePayment _that = (SinglePayment)this.getType().cast(o);
            if (!Objects.equals(this.adjustablePaymentDate, _that.getAdjustablePaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedPaymentDate, _that.getAdjustedPaymentDate())) {
                return false;
            }
            return Objects.equals(this.fixedAmount, _that.getFixedAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.adjustablePaymentDate != null ? this.adjustablePaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedPaymentDate != null ? this.adjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.fixedAmount != null ? this.fixedAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SinglePayment {adjustablePaymentDate=" + this.adjustablePaymentDate + ", adjustedPaymentDate=" + this.adjustedPaymentDate + ", fixedAmount=" + this.fixedAmount + '}' + " " + super.toString();
        }
    }
}

