/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.MatchId;
import fpml.confirmation.TradeDifference;
import fpml.confirmation.meta.ProposedMatchModelMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ProposedMatchModel", builder=ProposedMatchModelBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ProposedMatchModel", model="fpml", builder=ProposedMatchModelBuilderImpl.class, version="0.17.2")
public interface ProposedMatchModel
extends RosettaModelObject {
    public static final ProposedMatchModelMeta metaData = new ProposedMatchModelMeta();

    public MatchId getMatchId();

    public List<? extends TradeDifference> getDifference();

    public BigDecimal getMatchScore();

    public ProposedMatchModel build();

    public ProposedMatchModelBuilder toBuilder();

    public static ProposedMatchModelBuilder builder() {
        return new ProposedMatchModelBuilderImpl();
    }

    default public RosettaMetaData<? extends ProposedMatchModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ProposedMatchModel> getType() {
        return ProposedMatchModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("matchId"), processor, MatchId.class, this.getMatchId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("difference"), processor, TradeDifference.class, this.getDifference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("matchScore"), BigDecimal.class, (Object)this.getMatchScore(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ProposedMatchModelBuilderImpl
    implements ProposedMatchModelBuilder {
        protected MatchId.MatchIdBuilder matchId;
        protected List<TradeDifference.TradeDifferenceBuilder> difference = new ArrayList<TradeDifference.TradeDifferenceBuilder>();
        protected BigDecimal matchScore;

        @Override
        @RosettaAttribute(value="matchId")
        @RuneAttribute(value="matchId")
        public MatchId.MatchIdBuilder getMatchId() {
            return this.matchId;
        }

        @Override
        public MatchId.MatchIdBuilder getOrCreateMatchId() {
            MatchId.MatchIdBuilder result = this.matchId != null ? this.matchId : (this.matchId = MatchId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="difference")
        @RuneAttribute(value="difference")
        public List<? extends TradeDifference.TradeDifferenceBuilder> getDifference() {
            return this.difference;
        }

        @Override
        public TradeDifference.TradeDifferenceBuilder getOrCreateDifference(int index) {
            if (this.difference == null) {
                this.difference = new ArrayList<TradeDifference.TradeDifferenceBuilder>();
            }
            return (TradeDifference.TradeDifferenceBuilder)this.getIndex(this.difference, index, () -> {
                TradeDifference.TradeDifferenceBuilder newDifference = TradeDifference.builder();
                return newDifference;
            });
        }

        @Override
        @RosettaAttribute(value="matchScore")
        @RuneAttribute(value="matchScore")
        public BigDecimal getMatchScore() {
            return this.matchScore;
        }

        @Override
        @RosettaAttribute(value="matchId")
        @RuneAttribute(value="matchId")
        public ProposedMatchModelBuilder setMatchId(MatchId _matchId) {
            this.matchId = _matchId == null ? null : _matchId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="difference")
        @RuneAttribute(value="difference")
        public ProposedMatchModelBuilder addDifference(TradeDifference _difference) {
            if (_difference != null) {
                this.difference.add(_difference.toBuilder());
            }
            return this;
        }

        @Override
        public ProposedMatchModelBuilder addDifference(TradeDifference _difference, int idx) {
            this.getIndex(this.difference, idx, () -> _difference.toBuilder());
            return this;
        }

        @Override
        public ProposedMatchModelBuilder addDifference(List<? extends TradeDifference> differences) {
            if (differences != null) {
                for (TradeDifference tradeDifference : differences) {
                    this.difference.add(tradeDifference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="difference")
        public ProposedMatchModelBuilder setDifference(List<? extends TradeDifference> differences) {
            this.difference = differences == null ? new ArrayList<TradeDifference.TradeDifferenceBuilder>() : (List)differences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="matchScore")
        @RuneAttribute(value="matchScore")
        public ProposedMatchModelBuilder setMatchScore(BigDecimal _matchScore) {
            this.matchScore = _matchScore == null ? null : _matchScore;
            return this;
        }

        @Override
        public ProposedMatchModel build() {
            return new ProposedMatchModelImpl(this);
        }

        @Override
        public ProposedMatchModelBuilder toBuilder() {
            return this;
        }

        @Override
        public ProposedMatchModelBuilder prune() {
            if (this.matchId != null && !this.matchId.prune().hasData()) {
                this.matchId = null;
            }
            this.difference = this.difference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getMatchId() != null && this.getMatchId().hasData()) {
                return true;
            }
            if (this.getDifference() != null && this.getDifference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getMatchScore() != null;
        }

        public ProposedMatchModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ProposedMatchModelBuilder o = (ProposedMatchModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMatchId(), (RosettaModelObjectBuilder)o.getMatchId(), this::setMatchId);
            merger.mergeRosetta(this.getDifference(), o.getDifference(), this::getOrCreateDifference);
            merger.mergeBasic((Object)this.getMatchScore(), (Object)o.getMatchScore(), this::setMatchScore, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProposedMatchModel _that = this.getType().cast(o);
            if (!Objects.equals(this.matchId, _that.getMatchId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.difference, _that.getDifference())) {
                return false;
            }
            return Objects.equals(this.matchScore, _that.getMatchScore());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.matchId != null ? this.matchId.hashCode() : 0);
            _result = 31 * _result + (this.difference != null ? this.difference.hashCode() : 0);
            _result = 31 * _result + (this.matchScore != null ? this.matchScore.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProposedMatchModelBuilder {matchId=" + this.matchId + ", difference=" + this.difference + ", matchScore=" + this.matchScore + '}';
        }
    }

    public static interface ProposedMatchModelBuilder
    extends ProposedMatchModel,
    RosettaModelObjectBuilder {
        public MatchId.MatchIdBuilder getOrCreateMatchId();

        @Override
        public MatchId.MatchIdBuilder getMatchId();

        public TradeDifference.TradeDifferenceBuilder getOrCreateDifference(int var1);

        public List<? extends TradeDifference.TradeDifferenceBuilder> getDifference();

        public ProposedMatchModelBuilder setMatchId(MatchId var1);

        public ProposedMatchModelBuilder addDifference(TradeDifference var1);

        public ProposedMatchModelBuilder addDifference(TradeDifference var1, int var2);

        public ProposedMatchModelBuilder addDifference(List<? extends TradeDifference> var1);

        public ProposedMatchModelBuilder setDifference(List<? extends TradeDifference> var1);

        public ProposedMatchModelBuilder setMatchScore(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("matchId"), processor, MatchId.MatchIdBuilder.class, this.getMatchId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("difference"), processor, TradeDifference.TradeDifferenceBuilder.class, this.getDifference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("matchScore"), BigDecimal.class, (Object)this.getMatchScore(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ProposedMatchModelBuilder prune();
    }

    public static class ProposedMatchModelImpl
    implements ProposedMatchModel {
        private final MatchId matchId;
        private final List<? extends TradeDifference> difference;
        private final BigDecimal matchScore;

        protected ProposedMatchModelImpl(ProposedMatchModelBuilder builder) {
            this.matchId = Optional.ofNullable(builder.getMatchId()).map(f -> f.build()).orElse(null);
            this.difference = Optional.ofNullable(builder.getDifference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.matchScore = builder.getMatchScore();
        }

        @Override
        @RosettaAttribute(value="matchId")
        @RuneAttribute(value="matchId")
        public MatchId getMatchId() {
            return this.matchId;
        }

        @Override
        @RosettaAttribute(value="difference")
        @RuneAttribute(value="difference")
        public List<? extends TradeDifference> getDifference() {
            return this.difference;
        }

        @Override
        @RosettaAttribute(value="matchScore")
        @RuneAttribute(value="matchScore")
        public BigDecimal getMatchScore() {
            return this.matchScore;
        }

        @Override
        public ProposedMatchModel build() {
            return this;
        }

        @Override
        public ProposedMatchModelBuilder toBuilder() {
            ProposedMatchModelBuilder builder = ProposedMatchModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ProposedMatchModelBuilder builder) {
            Optional.ofNullable(this.getMatchId()).ifPresent(builder::setMatchId);
            Optional.ofNullable(this.getDifference()).ifPresent(builder::setDifference);
            Optional.ofNullable(this.getMatchScore()).ifPresent(builder::setMatchScore);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProposedMatchModel _that = this.getType().cast(o);
            if (!Objects.equals(this.matchId, _that.getMatchId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.difference, _that.getDifference())) {
                return false;
            }
            return Objects.equals(this.matchScore, _that.getMatchScore());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.matchId != null ? this.matchId.hashCode() : 0);
            _result = 31 * _result + (this.difference != null ? this.difference.hashCode() : 0);
            _result = 31 * _result + (this.matchScore != null ? this.matchScore.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProposedMatchModel {matchId=" + this.matchId + ", difference=" + this.difference + ", matchScore=" + this.matchScore + '}';
        }
    }
}

