/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.Account;
import fpml.confirmation.Party;
import fpml.confirmation.meta.PartiesAndAccountsModelMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PartiesAndAccountsModel", builder=PartiesAndAccountsModelBuilderImpl.class, version="0.17.2")
@RuneDataType(value="PartiesAndAccountsModel", model="fpml", builder=PartiesAndAccountsModelBuilderImpl.class, version="0.17.2")
public interface PartiesAndAccountsModel
extends RosettaModelObject {
    public static final PartiesAndAccountsModelMeta metaData = new PartiesAndAccountsModelMeta();

    public List<? extends Party> getParty();

    public List<? extends Account> getAccount();

    public PartiesAndAccountsModel build();

    public PartiesAndAccountsModelBuilder toBuilder();

    public static PartiesAndAccountsModelBuilder builder() {
        return new PartiesAndAccountsModelBuilderImpl();
    }

    default public RosettaMetaData<? extends PartiesAndAccountsModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PartiesAndAccountsModel> getType() {
        return PartiesAndAccountsModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("account"), processor, Account.class, this.getAccount(), new AttributeMeta[0]);
    }

    public static class PartiesAndAccountsModelBuilderImpl
    implements PartiesAndAccountsModelBuilder {
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();
        protected List<Account.AccountBuilder> account = new ArrayList<Account.AccountBuilder>();

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="account")
        @RuneAttribute(value="account")
        public List<? extends Account.AccountBuilder> getAccount() {
            return this.account;
        }

        @Override
        public Account.AccountBuilder getOrCreateAccount(int index) {
            if (this.account == null) {
                this.account = new ArrayList<Account.AccountBuilder>();
            }
            return (Account.AccountBuilder)this.getIndex(this.account, index, () -> {
                Account.AccountBuilder newAccount = Account.builder();
                return newAccount;
            });
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public PartiesAndAccountsModelBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public PartiesAndAccountsModelBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public PartiesAndAccountsModelBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public PartiesAndAccountsModelBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="account")
        @RuneAttribute(value="account")
        public PartiesAndAccountsModelBuilder addAccount(Account _account) {
            if (_account != null) {
                this.account.add(_account.toBuilder());
            }
            return this;
        }

        @Override
        public PartiesAndAccountsModelBuilder addAccount(Account _account, int idx) {
            this.getIndex(this.account, idx, () -> _account.toBuilder());
            return this;
        }

        @Override
        public PartiesAndAccountsModelBuilder addAccount(List<? extends Account> accounts) {
            if (accounts != null) {
                for (Account account : accounts) {
                    this.account.add(account.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="account")
        public PartiesAndAccountsModelBuilder setAccount(List<? extends Account> accounts) {
            this.account = accounts == null ? new ArrayList<Account.AccountBuilder>() : (List)accounts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PartiesAndAccountsModel build() {
            return new PartiesAndAccountsModelImpl(this);
        }

        @Override
        public PartiesAndAccountsModelBuilder toBuilder() {
            return this;
        }

        @Override
        public PartiesAndAccountsModelBuilder prune() {
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.account = this.account.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getAccount() != null && this.getAccount().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public PartiesAndAccountsModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PartiesAndAccountsModelBuilder o = (PartiesAndAccountsModelBuilder)other;
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            merger.mergeRosetta(this.getAccount(), o.getAccount(), this::getOrCreateAccount);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartiesAndAccountsModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            return ListEquals.listEquals(this.account, _that.getAccount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.account != null ? this.account.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartiesAndAccountsModelBuilder {party=" + this.party + ", account=" + this.account + '}';
        }
    }

    public static interface PartiesAndAccountsModelBuilder
    extends PartiesAndAccountsModel,
    RosettaModelObjectBuilder {
        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        public Account.AccountBuilder getOrCreateAccount(int var1);

        public List<? extends Account.AccountBuilder> getAccount();

        public PartiesAndAccountsModelBuilder addParty(Party var1);

        public PartiesAndAccountsModelBuilder addParty(Party var1, int var2);

        public PartiesAndAccountsModelBuilder addParty(List<? extends Party> var1);

        public PartiesAndAccountsModelBuilder setParty(List<? extends Party> var1);

        public PartiesAndAccountsModelBuilder addAccount(Account var1);

        public PartiesAndAccountsModelBuilder addAccount(Account var1, int var2);

        public PartiesAndAccountsModelBuilder addAccount(List<? extends Account> var1);

        public PartiesAndAccountsModelBuilder setAccount(List<? extends Account> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("account"), processor, Account.AccountBuilder.class, this.getAccount(), new AttributeMeta[0]);
        }

        public PartiesAndAccountsModelBuilder prune();
    }

    public static class PartiesAndAccountsModelImpl
    implements PartiesAndAccountsModel {
        private final List<? extends Party> party;
        private final List<? extends Account> account;

        protected PartiesAndAccountsModelImpl(PartiesAndAccountsModelBuilder builder) {
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.account = Optional.ofNullable(builder.getAccount()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="account")
        @RuneAttribute(value="account")
        public List<? extends Account> getAccount() {
            return this.account;
        }

        @Override
        public PartiesAndAccountsModel build() {
            return this;
        }

        @Override
        public PartiesAndAccountsModelBuilder toBuilder() {
            PartiesAndAccountsModelBuilder builder = PartiesAndAccountsModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PartiesAndAccountsModelBuilder builder) {
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getAccount()).ifPresent(builder::setAccount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartiesAndAccountsModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            return ListEquals.listEquals(this.account, _that.getAccount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.account != null ? this.account.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartiesAndAccountsModel {party=" + this.party + ", account=" + this.account + '}';
        }
    }
}

